/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.coderule.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.coderule.api.CodeRuleEntryInfo;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.coderule.api.ConditionEntryInfo;
import kd.bos.coderule.api.OrgEntryInfo;
import kd.bos.coderule.constant.CodeRuleConstant;
import kd.bos.coderule.enums.CodeRuleEntryTypeEnum;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.formula.FormulaEngine;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.org.OrgViewServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class CodeRuleInfoUtil
implements CodeRuleConstant {
    private static final Log logger = LogFactory.getLog(CodeRuleInfoUtil.class);
    private static final String BOS_CODERULE = "bos-coderule";
    private Map<Long, Set<Long>> superiorOrgMap = new HashMap<Long, Set<Long>>();

    public static CodeRuleInfo getUsableCodeRuleId(List<CodeRuleInfo> codeRuleList, String entityId, Long orgID, DynamicObject dataInfo) {
        CodeRuleInfo codeRuleInfo = null;
        codeRuleInfo = CodeRuleInfoUtil.getCodeRuleByOrg(codeRuleList, orgID, dataInfo);
        if (codeRuleInfo != null) {
            return codeRuleInfo;
        }
        codeRuleInfo = CodeRuleInfoUtil.getCodeRuleBySuperiorOrg(codeRuleList, orgID, dataInfo);
        if (codeRuleInfo != null) {
            return codeRuleInfo;
        }
        codeRuleInfo = CodeRuleInfoUtil.getDefaultCodeRule(codeRuleList, dataInfo);
        return codeRuleInfo;
    }

    public CodeRuleInfo getUsableCodeRuleIdCache(List<CodeRuleInfo> codeRuleList, Long orgID, DynamicObject dataInfo) {
        CodeRuleInfo codeRuleInfo = null;
        codeRuleInfo = CodeRuleInfoUtil.getCodeRuleByOrg(codeRuleList, orgID, dataInfo);
        if (codeRuleInfo != null) {
            return codeRuleInfo;
        }
        codeRuleInfo = this.getCodeRuleBySuperiorOrgCache(codeRuleList, orgID, dataInfo);
        if (codeRuleInfo != null) {
            return codeRuleInfo;
        }
        codeRuleInfo = CodeRuleInfoUtil.getDefaultCodeRule(codeRuleList, dataInfo);
        return codeRuleInfo;
    }

    public static Long getUserOrgId(DynamicObject dataInfo, String orgID) {
        Long userOrgId = 0L;
        if (StringUtils.isBlank((CharSequence)orgID)) {
            BillEntityType dt = (BillEntityType)dataInfo.getDataEntityType();
            if (dt.getMainOrgProperty() != null) {
                Object obj = dataInfo.get((IDataEntityProperty)dt.getMainOrgProperty());
                if (obj instanceof DynamicObject) {
                    DynamicObject dynamicObject = (DynamicObject)obj;
                    userOrgId = (Long)dynamicObject.getPkValue();
                } else if (obj instanceof Long) {
                    userOrgId = (Long)obj;
                }
            }
            if (userOrgId == 0L) {
                userOrgId = RequestContext.get().getOrgId();
            }
        } else {
            userOrgId = Long.valueOf(orgID);
        }
        return userOrgId;
    }

    public static CodeRuleInfo getDefaultCodeRule(List<CodeRuleInfo> codeRuleList, DynamicObject dataInfo) {
        if (CollectionUtils.isEmpty(codeRuleList)) {
            return null;
        }
        CodeRuleInfo codeRuleInfo = null;
        List orgEntry = null;
        List conditionEntry = null;
        for (CodeRuleInfo codeRule : codeRuleList) {
            orgEntry = codeRule.getOrgEntry();
            conditionEntry = codeRule.getConditionEntry();
            if (orgEntry != null && !orgEntry.isEmpty()) continue;
            if (CollectionUtils.isEmpty((Collection)conditionEntry) && !CodeRuleInfoUtil.isEnableCondition(codeRule.getEnableCondition())) {
                codeRuleInfo = codeRule;
                continue;
            }
            if (!CodeRuleInfoUtil.isMatchConditions(codeRule, dataInfo)) continue;
            return codeRule;
        }
        return codeRuleInfo;
    }

    private static boolean isEnableCondition(String enableCondition) {
        FilterCondition condition;
        return StringUtils.isNotBlank((CharSequence)enableCondition) && (condition = (FilterCondition)SerializationUtils.fromJsonString((String)enableCondition, FilterCondition.class)) != null && !condition.getFilterRow().isEmpty();
    }

    public static boolean isMatchConditions(CodeRuleInfo codeRuleInfo, DynamicObject dataInfo) {
        FilterCondition condition;
        if (codeRuleInfo == null || dataInfo == null) {
            return false;
        }
        String enableCondition = codeRuleInfo.getEnableCondition();
        if (StringUtils.isNotBlank((CharSequence)enableCondition) && (condition = (FilterCondition)SerializationUtils.fromJsonString((String)enableCondition, FilterCondition.class)) != null && !condition.getFilterRow().isEmpty()) {
            return CodeRuleInfoUtil.isMatchFilterConditions(condition, dataInfo);
        }
        List conditionEntry = codeRuleInfo.getConditionEntry();
        if (conditionEntry != null && !conditionEntry.isEmpty()) {
            return CodeRuleInfoUtil.isMatchApplicationCondition(dataInfo, conditionEntry);
        }
        return false;
    }

    private static boolean isMatchApplicationCondition(DynamicObject dataInfo, List<ConditionEntryInfo> conditionEntry) {
        if (CollectionUtils.isEmpty(conditionEntry)) {
            return true;
        }
        for (ConditionEntryInfo conditionEntryInfo : conditionEntry) {
            if (conditionEntryInfo == null) continue;
            String propertyName = conditionEntryInfo.getProperty();
            String[] propertyNames = propertyName.split("\\.");
            IDataEntityProperty dataEntityProperty = (IDataEntityProperty)dataInfo.getDataEntityType().getProperties().get((Object)propertyNames[0]);
            if (dataEntityProperty == null) {
                logger.error("\u9002\u7528\u5c5e\u6027\u5728\u5b9e\u4f53\u7c7b\u578b\u4e2d\u627e\u4e0d\u5230,\u5b9e\u4f53\u7c7b\u578b\u4e3a:" + dataInfo.getDataEntityType().getName() + ",\u9002\u7528\u5c5e\u6027\u4e3a:" + propertyNames[0]);
                continue;
            }
            if (StringUtils.isBlank((CharSequence)conditionEntryInfo.getPropertyValue()) && (null == dataInfo.get(propertyName) || StringUtils.isBlank((CharSequence)dataInfo.get(propertyName).toString()))) {
                return true;
            }
            if (null == dataInfo.get(propertyName) || !conditionEntryInfo.getPropertyValue().equals(dataInfo.get(propertyName).toString())) continue;
            return true;
        }
        return false;
    }

    private static boolean isMatchFilterConditions(FilterCondition filterCondition, DynamicObject dataInfo) {
        try {
            FilterBuilder filterBuilder = new FilterBuilder((MainEntityType)dataInfo.getDataEntityType(), filterCondition);
            filterBuilder.buildFilter();
            Map allFilterFields = filterBuilder.getFilterObject().getAllFilterFields();
            Map<String, String> allFullFieldName = CodeRuleInfoUtil.getAllFullFieldNameMap(allFilterFields);
            String[] filterScript = filterBuilder.buildFilterScript();
            String expression = filterScript[0];
            List<Map<String, Object>> variableList = CodeRuleInfoUtil.getVariableList(allFullFieldName, dataInfo);
            if (CollectionUtils.isEmpty(variableList)) {
                return false;
            }
            for (Map<String, Object> variableMap : variableList) {
                Boolean execResult = (Boolean)FormulaEngine.execExcelFormula((String)expression, variableMap);
                if (!execResult.booleanValue()) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            if (e instanceof KDBizException && ((KDBizException)((Object)e)).getErrorCode() != null && StringUtils.equals((CharSequence)((KDBizException)((Object)e)).getErrorCode().getCode(), (CharSequence)"bos.fieldNotExist")) {
                throw new KDBizException(new ErrorCode("CODERULE_VALID_CONDITION_ERROR", "An error occurred in the validation encoding rule enabling condition" + e.getMessage()), new Object[0]);
            }
            throw new KDBizException(new ErrorCode("CODERULE_VALID_CONDITION_ERROR", ResManager.loadKDString((String)"\u6821\u9a8c\u7f16\u7801\u89c4\u5219\u542f\u7528\u6761\u4ef6\u51fa\u73b0\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u6761\u4ef6\u662f\u5426\u6b63\u786e\u3002", (String)"CodeRuleInfoUtil_1", (String)BOS_CODERULE, (Object[])new Object[0])), new Object[0]);
        }
    }

    private static Map<String, String> getAllFullFieldNameMap(Map<String, FilterField> allFilterFields) {
        if (allFilterFields == null || allFilterFields.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> allFullField = new HashMap<String, String>(allFilterFields.size());
        for (Map.Entry<String, FilterField> fieldEntry : allFilterFields.entrySet()) {
            FilterField filterField = fieldEntry.getValue();
            allFullField.put(fieldEntry.getKey(), filterField.getFullFieldName());
        }
        return allFullField;
    }

    private static List<Map<String, Object>> getVariableList(Map<String, String> allFullFieldName, DynamicObject dataInfo) {
        if (allFullFieldName == null || allFullFieldName.isEmpty()) {
            return null;
        }
        HashMap<String, List<Object>> fieldValuesMap = new HashMap<String, List<Object>>(allFullFieldName.size());
        for (Map.Entry<String, String> stringEntry : allFullFieldName.entrySet()) {
            String filterField = stringEntry.getKey();
            String fullField = stringEntry.getValue();
            if (StringUtils.isBlank((CharSequence)fullField)) continue;
            String[] splitField = StringUtils.split((String)fullField, (String)".");
            fieldValuesMap.put(filterField, CodeRuleInfoUtil.getFieldValues(splitField, 0, dataInfo));
        }
        return CodeRuleInfoUtil.buildVariableList(fieldValuesMap);
    }

    private static List<Map<String, Object>> buildVariableList(Map<String, List<Object>> fieldValuesMap) {
        if (fieldValuesMap == null || fieldValuesMap.isEmpty()) {
            return null;
        }
        ArrayList<Map<String, Object>> variableList = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> variableMap = new HashMap<String, Object>(fieldValuesMap.size());
        ArrayList<Map.Entry<String, List<Object>>> fieldValuesEntry = new ArrayList<Map.Entry<String, List<Object>>>(fieldValuesMap.entrySet());
        CodeRuleInfoUtil.assembleVariableList(fieldValuesEntry, 0, variableMap, variableList);
        return variableList;
    }

    private static void assembleVariableList(List<Map.Entry<String, List<Object>>> fieldValuesEntry, int pos, Map<String, Object> variableMap, List<Map<String, Object>> variableList) {
        if (pos < 0 || pos >= fieldValuesEntry.size()) {
            return;
        }
        Map.Entry<String, List<Object>> fieldListEntry = fieldValuesEntry.get(pos);
        List<Object> valueList = fieldListEntry.getValue();
        if (CollectionUtils.isEmpty(valueList)) {
            variableMap.put(fieldListEntry.getKey(), null);
            if (pos == fieldValuesEntry.size() - 1) {
                variableList.add(new HashMap<String, Object>(variableMap));
                return;
            }
            CodeRuleInfoUtil.assembleVariableList(fieldValuesEntry, pos + 1, variableMap, variableList);
            return;
        }
        if (pos == fieldValuesEntry.size() - 1) {
            for (Object fieldValue : valueList) {
                variableMap.put(fieldListEntry.getKey(), fieldValue);
                variableList.add(new HashMap<String, Object>(variableMap));
            }
        } else {
            for (Object fieldValue : valueList) {
                variableMap.put(fieldListEntry.getKey(), fieldValue);
                CodeRuleInfoUtil.assembleVariableList(fieldValuesEntry, pos + 1, variableMap, variableList);
            }
        }
    }

    private static List<Object> getFieldValues(String[] splitField, int pos, DynamicObject dataInfo) {
        if (splitField == null || pos < 0 || pos >= splitField.length) {
            return null;
        }
        IDataEntityProperty property = (IDataEntityProperty)dataInfo.getDynamicObjectType().getProperties().get((Object)splitField[pos]);
        if (property == null) {
            return null;
        }
        ArrayList<Object> fieldValues = new ArrayList<Object>();
        Object fieldValue = dataInfo.get(splitField[pos]);
        if (pos == splitField.length - 1) {
            fieldValues.addAll(CodeRuleInfoUtil.getLastFieldValues(fieldValue));
            return fieldValues;
        }
        if (fieldValue instanceof DynamicObject) {
            List<Object> values = CodeRuleInfoUtil.getFieldValues(splitField, pos + 1, (DynamicObject)fieldValue);
            fieldValues.addAll(values);
        } else if (fieldValue instanceof ILocaleString) {
            ILocaleString localeString = (ILocaleString)fieldValue;
            fieldValues.addAll(localeString.values());
        } else if (fieldValue instanceof DynamicObjectCollection) {
            DynamicObjectCollection collection = (DynamicObjectCollection)fieldValue;
            int index = pos + 1;
            for (DynamicObject dynamicObject : collection) {
                List<Object> values = CodeRuleInfoUtil.getFieldValues(splitField, index, dynamicObject);
                fieldValues.addAll(values);
            }
        }
        return fieldValues;
    }

    private static List<Object> getLastFieldValues(Object fieldValue) {
        ArrayList<Object> values = new ArrayList<Object>();
        if (fieldValue instanceof ILocaleString) {
            values.addAll(((ILocaleString)fieldValue).values());
            return values;
        }
        values.add(fieldValue);
        return values;
    }

    public static Set<String> getFilterConditionFields(CodeRuleInfo codeRuleInfo) {
        if (codeRuleInfo == null) {
            return null;
        }
        String enableCondition = codeRuleInfo.getEnableCondition();
        if (StringUtils.isBlank((CharSequence)enableCondition)) {
            return null;
        }
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)enableCondition, FilterCondition.class);
        if (filterCondition == null || filterCondition.getFilterRow().isEmpty()) {
            return null;
        }
        List filterRows = filterCondition.getFilterRow();
        HashSet<String> fields = new HashSet<String>(filterRows.size());
        for (SimpleFilterRow filterRow : filterRows) {
            String rowFieldName = filterRow.getFieldName();
            if (StringUtils.isBlank((CharSequence)rowFieldName)) continue;
            String[] splitName = StringUtils.split((String)rowFieldName, (String)".");
            fields.add(splitName[0]);
        }
        return fields;
    }

    private static CodeRuleInfo getCodeRuleBySuperiorOrg(List<CodeRuleInfo> codeRuleList, Long orgID, DynamicObject dataInfo) {
        CodeRuleInfo codeRuleInfo = null;
        List orgEntry = null;
        List conditionEntry = null;
        HashSet<Long> allSuperiorOrgs = new HashSet<Long>();
        for (CodeRuleInfo codeRule : codeRuleList) {
            orgEntry = codeRule.getOrgEntry();
            conditionEntry = codeRule.getConditionEntry();
            if (orgEntry == null || orgEntry.isEmpty()) continue;
            for (OrgEntryInfo orgEntryInfo : orgEntry) {
                String bizobjectid;
                String orgFunction;
                if (orgEntryInfo.getOrgId().equals(orgID) || !orgEntryInfo.getIsIncludeSubOrg().booleanValue() || !CodeRuleInfoUtil.isSubOrgFromCache(orgFunction = CodeRuleInfoUtil.getOrgFuncId(bizobjectid = dataInfo.getDataEntityType().getName()), orgID, orgEntryInfo.getOrgId(), allSuperiorOrgs)) continue;
                if (CollectionUtils.isEmpty((Collection)conditionEntry) && !CodeRuleInfoUtil.isEnableCondition(codeRule.getEnableCondition())) {
                    codeRuleInfo = codeRule;
                    continue;
                }
                if (!CodeRuleInfoUtil.isMatchConditions(codeRule, dataInfo)) continue;
                return codeRule;
            }
        }
        return codeRuleInfo;
    }

    private CodeRuleInfo getCodeRuleBySuperiorOrgCache(List<CodeRuleInfo> codeRuleList, Long orgID, DynamicObject dataInfo) {
        CodeRuleInfo codeRuleInfo = null;
        List orgEntry = null;
        List conditionEntry = null;
        for (CodeRuleInfo codeRule : codeRuleList) {
            orgEntry = codeRule.getOrgEntry();
            conditionEntry = codeRule.getConditionEntry();
            if (orgEntry == null || orgEntry.isEmpty()) continue;
            for (OrgEntryInfo orgEntryInfo : orgEntry) {
                String bizobjectid;
                String orgFunction;
                if (orgEntryInfo.getOrgId().equals(orgID) || !orgEntryInfo.getIsIncludeSubOrg().booleanValue() || !this.isSubOrgFromCache(orgFunction = CodeRuleInfoUtil.getOrgFuncId(bizobjectid = dataInfo.getDataEntityType().getName()), orgID, orgEntryInfo.getOrgId())) continue;
                if (CollectionUtils.isEmpty((Collection)conditionEntry) && !CodeRuleInfoUtil.isEnableCondition(codeRule.getEnableCondition())) {
                    codeRuleInfo = codeRule;
                    continue;
                }
                if (!CodeRuleInfoUtil.isMatchConditions(codeRule, dataInfo)) continue;
                return codeRule;
            }
        }
        return codeRuleInfo;
    }

    private static String getOrgFuncId(Object bizObject) {
        String DEFAULT_ORGFUNCID = "15";
        if (StringUtils.isBlank((Object)bizObject)) {
            return "15";
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)bizObject.toString());
        if (dataEntityType == null) {
            return "15";
        }
        String mainOrg = dataEntityType.getMainOrg();
        if (StringUtils.isBlank((CharSequence)mainOrg)) {
            return "15";
        }
        MainOrgProp org = (MainOrgProp)dataEntityType.getProperty(mainOrg);
        if (org == null) {
            return "15";
        }
        String orgfuncid = org.getOrgFunc();
        return StringUtils.isBlank((CharSequence)orgfuncid) ? "15" : orgfuncid;
    }

    private static CodeRuleInfo getCodeRuleByOrg(List<CodeRuleInfo> codeRuleList, Long orgID, DynamicObject dataInfo) {
        CodeRuleInfo codeRuleInfo = null;
        List orgEntry = null;
        List conditionEntry = null;
        for (CodeRuleInfo codeRule : codeRuleList) {
            orgEntry = codeRule.getOrgEntry();
            conditionEntry = codeRule.getConditionEntry();
            if (orgEntry == null || orgEntry.isEmpty()) continue;
            for (OrgEntryInfo orgEntryInfo : orgEntry) {
                if (!orgEntryInfo.getOrgId().equals(orgID)) continue;
                if (CollectionUtils.isEmpty((Collection)conditionEntry) && !CodeRuleInfoUtil.isEnableCondition(codeRule.getEnableCondition())) {
                    codeRuleInfo = codeRule;
                    continue;
                }
                if (!CodeRuleInfoUtil.isMatchConditions(codeRule, dataInfo)) continue;
                return codeRule;
            }
        }
        return codeRuleInfo;
    }

    public static boolean isSubOrg(String orgFunction, Long subOrgID, Long superiorOrgId) {
        return OrgViewServiceHelper.isSubOrg((String)orgFunction, (Long)subOrgID, (Long)superiorOrgId);
    }

    public static boolean isSubOrgFromCache(String orgFunction, Long currentOrgId, Long superiorOrgId, Set<Long> allSuperiorOrgs) {
        if (allSuperiorOrgs.size() == 0) {
            List superiorOrgs = OrgUnitServiceHelper.getAllSuperiorOrgs((String)orgFunction, (long)currentOrgId);
            if (CollectionUtils.isNotEmpty((Collection)superiorOrgs)) {
                allSuperiorOrgs.addAll(superiorOrgs);
            } else {
                allSuperiorOrgs.add(-1L);
            }
        }
        return allSuperiorOrgs.contains(superiorOrgId);
    }

    private boolean isSubOrgFromCache(String orgFunction, Long currentOrgId, Long superiorOrgId) {
        Set<Long> superiorOrgIds;
        if (this.superiorOrgMap == null) {
            this.superiorOrgMap = new HashMap<Long, Set<Long>>();
        }
        if ((superiorOrgIds = this.superiorOrgMap.get(currentOrgId)) == null) {
            superiorOrgIds = new HashSet<Long>();
            List allSuperiorOrgs = OrgUnitServiceHelper.getAllSuperiorOrgs((String)orgFunction, (long)currentOrgId);
            if (CollectionUtils.isNotEmpty((Collection)allSuperiorOrgs)) {
                superiorOrgIds.addAll(allSuperiorOrgs);
            } else {
                superiorOrgIds.add(-1L);
            }
            this.superiorOrgMap.put(currentOrgId, superiorOrgIds);
        }
        return superiorOrgIds.contains(superiorOrgId);
    }

    public static boolean validateCodeRuleContainSerialNum(CodeRuleInfo codeRuleInfo) {
        if (codeRuleInfo != null) {
            for (CodeRuleEntryInfo codeRuleEntryInfo : codeRuleInfo.getRuleEntry()) {
                if (!CodeRuleEntryTypeEnum.TYPE_SEQ.getTypeStr().equals(codeRuleEntryInfo.getAttributeType())) continue;
                return true;
            }
        }
        return false;
    }
}

