/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.coderule.util;

import kd.bos.coderule.api.CodeRuleEntryInfo;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.coderule.enums.CodeRuleEntryTypeEnum;
import kd.bos.coderule.service.CodeRuleServiceImp;
import kd.bos.coderule.util.CodeRuleInfoUtil;
import kd.bos.coderule.util.NumberComponents;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class CodeRuleNumberCheckUtil {
    private static final Log log = LogFactory.getLog(CodeRuleNumberCheckUtil.class);

    public static boolean checkNumberFormat(CodeRuleInfo codeRuleInfo, DynamicObject dataInfo, String billNo) {
        boolean isContainSerial = CodeRuleInfoUtil.validateCodeRuleContainSerialNum(codeRuleInfo);
        if (isContainSerial) {
            return new CodeRuleServiceImp().checkNumber(dataInfo, billNo, codeRuleInfo);
        }
        boolean containRandomNumber = CodeRuleNumberCheckUtil.isContainRandomNumber(codeRuleInfo);
        if (containRandomNumber) {
            return CodeRuleNumberCheckUtil.checkRandomNumberFormat(codeRuleInfo, dataInfo, billNo);
        }
        return true;
    }

    private static boolean checkRandomNumberFormat(CodeRuleInfo codeRuleInfo, DynamicObject dataInfo, String billNo) {
        log.info("[CodeRule]\u968f\u673a\u7801\u683c\u5f0f\u6821\u9a8c\uff0cbillNo\uff1a" + billNo + "\uff0ccodeRuleInfo\uff1a" + codeRuleInfo.getId());
        if (StringUtils.isBlank((CharSequence)billNo)) {
            return false;
        }
        NumberComponents numberComponents = new NumberComponents(codeRuleInfo, dataInfo, CodeRuleEntryTypeEnum.TYPE_RANDOM_NUMBER);
        String frontPart = numberComponents.getFrontPart();
        String latterPart = numberComponents.getLatterPart();
        log.info("[CodeRule]\u7f16\u53f7\u622a\u53d6\u968f\u673a\u7801\u524d\u540e\u7f16\u53f7\u7ec4\u6210\u90e8\u5206\uff0c\u524d\u90e8\u5206\uff1a" + frontPart + "\uff0c\u540e\u90e8\u5206\uff1a" + latterPart);
        if (!CodeRuleNumberCheckUtil.checkNumberComponents(billNo, frontPart, latterPart)) {
            return false;
        }
        String cutFirstPart = billNo.substring(frontPart.length());
        String randomString = cutFirstPart.substring(0, cutFirstPart.length() - latterPart.length());
        log.info("[CodeRule]\u7f16\u53f7\u622a\u53d6\u968f\u673a\u7801\uff1a" + randomString);
        return randomString.length() == 8;
    }

    public static boolean checkNumberComponents(String billNo, String frontPart, String latterPart) {
        if (billNo.length() < frontPart.length() + latterPart.length()) {
            return false;
        }
        if (StringUtils.isNotBlank((CharSequence)frontPart) && !StringUtils.equals((CharSequence)frontPart, (CharSequence)billNo.substring(0, frontPart.length()))) {
            return false;
        }
        return !StringUtils.isNotBlank((CharSequence)latterPart) || StringUtils.equals((CharSequence)latterPart, (CharSequence)billNo.substring(billNo.length() - latterPart.length()));
    }

    private static boolean isContainRandomNumber(CodeRuleInfo codeRuleInfo) {
        if (codeRuleInfo != null) {
            for (CodeRuleEntryInfo codeRuleEntryInfo : codeRuleInfo.getRuleEntry()) {
                if (!CodeRuleEntryTypeEnum.TYPE_RANDOM_NUMBER.getTypeStr().equals(codeRuleEntryInfo.getAttributeType())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isCodeRuleUsed(String codeRuleId) {
        boolean isExistMaxSerial = QueryServiceHelper.exists((String)"bos_coderule_maxserial", (QFilter[])new QFilter("coderuleid", "=", (Object)codeRuleId).toArray());
        if (isExistMaxSerial) {
            return true;
        }
        return QueryServiceHelper.exists((String)"bos_coderule_intermitno", (QFilter[])new QFilter("coderuleid", "=", (Object)codeRuleId).toArray());
    }
}

