/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.coderule.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import kd.bos.coderule.api.CodeRuleEntryInfo;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.coderule.enums.CodeRuleEntryTypeEnum;
import kd.bos.coderule.util.CodeRuleNumberCheckUtil;
import kd.bos.coderule.util.CodeRuleNumberDTO;
import kd.bos.coderule.util.CodeRuleSystemParam;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class CodeRuleSerialNumUtil {
    private static final String TYPE_FIX_TEXT = "1";
    private static final String TYPE_DATE_FIELD = "2";
    private static final String TYPE_ITEM_FIELD = "8";
    private static final String TYPE_SYSTEM_TIME_FIELD = "9";
    private static final String TYPE_RANDOM_NUMBER = "10";
    private static final String TYPE_SEQ = "16";
    private static final String TYPE_LIST_FIELD = "64";
    private static final String CHECK_CODE = "128";
    private static final String ATT_USING_MODE_CUT = "4";
    private static final String ERRCODE_CODERULE = "ErrCode_CodeRule";
    private static final String BAS_CODERULE = "bas/coderule/";
    private static final Log logger = LogFactory.getLog(CodeRuleSerialNumUtil.class);

    public static CodeRuleNumberDTO getSerialNumberWithoutSplitSign(CodeRuleInfo codeRuleInfo, DynamicObject dataInfo, String number) {
        String serialNumber = "-1";
        String[] valueStrings = CodeRuleSerialNumUtil.getValueStrings(codeRuleInfo, dataInfo, number);
        String sortItemValue = CodeRuleSerialNumUtil.getStringFromArray(valueStrings, 0);
        String beforeSNNumber = CodeRuleSerialNumUtil.getStringFromArray(valueStrings, 1);
        String afterSNNumber = CodeRuleSerialNumUtil.getStringFromArray(valueStrings, 2);
        logger.info("[CodeRule]\u83b7\u53d6\u6d41\u6c34\u53f7\u7f16\u7801\u89c4\u5219\uff1a" + codeRuleInfo.getId() + "\uff0c\u4f9d\u636e\uff1a" + sortItemValue + "\uff0c\u7f16\u53f7\u524d\u534a\u6bb5\uff1a" + beforeSNNumber + "\uff0c\u7f16\u53f7\u540e\u534a\u6bb5\uff1a" + afterSNNumber);
        serialNumber = CodeRuleSerialNumUtil.getRecycleNumber(number, beforeSNNumber, afterSNNumber, codeRuleInfo, dataInfo.getDataEntityType().getName());
        return new CodeRuleNumberDTO(serialNumber, sortItemValue);
    }

    private static String getStringFromArray(String[] valueStrings, int index) {
        if (index < valueStrings.length) {
            return valueStrings[index];
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static String getRecycleNumber(String number, String beforeSNNumber, String afterSNNumber, CodeRuleInfo codeRuleInfo, String entityNum) {
        CodeRuleSerialNumUtil.logger.info("[CodeRule]\u89e3\u6790\u7684\u7f16\u53f7\uff1a" + number + "\uff0c\u7f16\u53f7\u524d\u534a\u6bb5\uff1a" + beforeSNNumber + "\uff0c\u7f16\u53f7\u540e\u534a\u6bb5\uff1a" + afterSNNumber);
        serialNumber = "-1";
        dateIsBefore = false;
        dateIsAfter = false;
        creIndex = CodeRuleSerialNumUtil.getSerialNumberIndex(codeRuleInfo);
        dateIndex = CodeRuleSerialNumUtil.getDateIndex(codeRuleInfo);
        beforeSNNumber = beforeSNNumber == null ? "" : beforeSNNumber;
        v0 = afterSNNumber = afterSNNumber == null ? "" : afterSNNumber;
        if (creIndex > 0 && dateIndex >= 0) {
            try {
                if (creIndex > dateIndex) {
                    dateIsBefore = true;
                } else {
                    dateIsAfter = true;
                }
                modelNumber = null;
                if (dateIsBefore) {
                    if (number.length() > beforeSNNumber.length()) {
                        modelNumber = number.substring(beforeSNNumber.length());
                    } else {
                        return serialNumber;
                    }
                }
                if (dateIsAfter) {
                    if (number.length() > afterSNNumber.length()) {
                        modelNumber = number.substring(number.length() - afterSNNumber.length());
                    } else {
                        return serialNumber;
                    }
                }
                if (!number.contains(modelNumber)) {
                    return serialNumber;
                }
            }
            catch (StringIndexOutOfBoundsException e) {
                return serialNumber;
            }
            daterecycletype = CodeRuleSystemParam.getBillParam(entityNum, "daterecycletype");
            if (daterecycletype.isPresent() && ((Boolean)daterecycletype.get()).booleanValue()) {
                CodeRuleSerialNumUtil.logger.info("[CodeRule]\u5355\u636e\u53c2\u6570\u5df2\u5f00\u542f\u7f16\u7801\u56de\u6536\u65f6\u65e5\u671f\u5b57\u6bb5\u6309\u503c\u5339\u914d\uff1a" + entityNum);
                if (!CodeRuleNumberCheckUtil.checkNumberComponents(number, beforeSNNumber, afterSNNumber)) {
                    return serialNumber;
                }
            }
        } else if (!CodeRuleNumberCheckUtil.checkNumberComponents(number, beforeSNNumber, afterSNNumber)) {
            return serialNumber;
        }
        if (number.indexOf(92) != -1) {
            number = number.replaceAll("\\\\", "");
        }
        if (beforeSNNumber.indexOf(92) != -1) {
            beforeSNNumber = beforeSNNumber.replaceAll("\\\\", "");
        }
        if (afterSNNumber.indexOf(92) != -1) {
            afterSNNumber = afterSNNumber.replaceAll("\\\\", "");
        }
        if (dateIsBefore || dateIsAfter) {
            try {
                if (dateIsBefore) {
                    number = number.substring(beforeSNNumber.length());
                    if (afterSNNumber.length() > 0) {
                        number = number.substring(0, number.length() - afterSNNumber.length());
                    }
                }
                if (!dateIsAfter) ** GOTO lbl60
                number = number.substring(0, number.length() - afterSNNumber.length());
                if (beforeSNNumber.length() <= 0) ** GOTO lbl60
                number = number.substring(beforeSNNumber.length());
            }
            catch (StringIndexOutOfBoundsException e) {
                return serialNumber;
            }
        } else {
            number = number.substring(beforeSNNumber.length());
            number = number.substring(0, number.length() - afterSNNumber.length());
        }
lbl60:
        // 4 sources

        CodeRuleSerialNumUtil.logger.info("[CodeRule]\u7f16\u53f7\u622a\u53d6\u524d\u540e\u90e8\u5206\u540e\u7684\u6d41\u6c34\u53f7\u90e8\u5206\uff1a" + number);
        tempstr = "";
        for (i = 0; i < codeRuleInfo.getRuleEntry().size(); ++i) {
            if (!"16".equals(((CodeRuleEntryInfo)codeRuleInfo.getRuleEntry().get(i)).getAttributeType())) continue;
            length = ((CodeRuleEntryInfo)codeRuleInfo.getRuleEntry().get(i)).getLength();
            try {
                longNumber = Long.parseLong(number);
                longNumberLength = String.valueOf(longNumber).length();
                if (codeRuleInfo.isFillWithZero().booleanValue()) {
                    v1 = isCheckAutoIncrLength = codeRuleInfo.getAutoIncrLength() != false && number.length() > length;
                    if ((!isCheckAutoIncrLength || number.length() == longNumberLength) && (isCheckAutoIncrLength || length == number.length())) continue;
                    CodeRuleSerialNumUtil.logger.info("[CodeRule]\u6d41\u6c34\u53f7\u4e0d\u7b26\u5408\u7f16\u7801\u89c4\u5219\u6d41\u6c34\u53f7\u957f\u5ea6\uff1a" + length + "\uff0c\u6d41\u6c34\u53f7\uff1a" + number + "\uff0c\u81ea\u52a8\u8865\u4f4d\uff1a" + codeRuleInfo.getAutoIncrLength());
                    return "-1";
                }
                if (number.length() == longNumberLength && (number.length() <= length || codeRuleInfo.getAutoIncrLength().booleanValue())) continue;
                CodeRuleSerialNumUtil.logger.info("[CodeRule]\u7f16\u7801\u89c4\u5219\u5df2\u5173\u95ed\u75280\u8865\u4f4d\uff0c\u6d41\u6c34\u53f7\u683c\u5f0f\u4e0d\u7b26\u5408\uff1a" + number + "\uff0c\u8f6c\u6362\u540e\u6d41\u6c34\u53f7\uff1a" + longNumber + "\uff0c\u81ea\u52a8\u8865\u4f4d\uff1a" + codeRuleInfo.getAutoIncrLength());
                return "-1";
            }
            catch (NumberFormatException e) {
                CodeRuleSerialNumUtil.logger.info("[CodeRule]\u6d41\u6c34\u53f7\u8f6c\u6362\u5f02\u5e38\uff1a" + number);
                return "-1";
            }
        }
        serialNumber = number = (tempstr = tempstr + number);
        return serialNumber;
    }

    /*
     * Unable to fully structure code
     */
    public static String getRecycleNumber(String number, String beforeSNNumber, String afterSNNumber, CodeRuleInfo codeRuleInfo) {
        serialNumber = "-1";
        dateIsBefore = false;
        dateIsAfter = false;
        creIndex = CodeRuleSerialNumUtil.getSerialNumberIndex(codeRuleInfo);
        dateIndex = CodeRuleSerialNumUtil.getDateIndex(codeRuleInfo);
        if (creIndex > 0 && dateIndex >= 0) {
            try {
                if (creIndex > dateIndex) {
                    dateIsBefore = true;
                } else {
                    dateIsAfter = true;
                }
                if (dateIsBefore || dateIsAfter) {
                    modelnumber = null;
                    if (dateIsBefore) {
                        if (number.length() > beforeSNNumber.length()) {
                            modelnumber = number.substring(beforeSNNumber.length(), number.length());
                        } else {
                            return serialNumber;
                        }
                    }
                    if (dateIsAfter) {
                        if (number.length() > afterSNNumber.length()) {
                            modelnumber = number.substring(number.length() - afterSNNumber.length(), number.length());
                        } else {
                            return serialNumber;
                        }
                    }
                    if (number.indexOf(modelnumber) < 0) {
                        return serialNumber;
                    }
                }
            }
            catch (StringIndexOutOfBoundsException e) {
                return serialNumber;
            }
            beforeSNNumber = beforeSNNumber == null ? "" : beforeSNNumber;
            afterSNNumber = afterSNNumber == null ? "" : afterSNNumber;
        } else {
            beforeSNNumber = beforeSNNumber == null ? "" : beforeSNNumber;
            v0 = afterSNNumber = afterSNNumber == null ? "" : afterSNNumber;
            if (number.indexOf(beforeSNNumber) < 0 || number.indexOf(afterSNNumber) < 0) {
                return serialNumber;
            }
        }
        if (number.indexOf(92) != -1) {
            number = number.replaceAll("\\\\", "");
        }
        if (beforeSNNumber.indexOf(92) != -1) {
            beforeSNNumber = beforeSNNumber.replaceAll("\\\\", "");
        }
        if (afterSNNumber.indexOf(92) != -1) {
            afterSNNumber = afterSNNumber.replaceAll("\\\\", "");
        }
        if (dateIsBefore || dateIsAfter) {
            try {
                if (dateIsBefore) {
                    CodeRuleSerialNumUtil.logger.info("CodeRuleServiceImp: dateIsBefore: beforeSNNumber is:" + beforeSNNumber + " number is:" + number);
                    number = number.substring(beforeSNNumber.length(), number.length());
                    if (afterSNNumber != null && afterSNNumber.length() > 0) {
                        CodeRuleSerialNumUtil.logger.info("CodeRuleServiceImp: number is:" + number + " afterSNNumber is:" + afterSNNumber);
                        number = number.substring(0, number.length() - afterSNNumber.length());
                    }
                }
                if (!dateIsAfter) ** GOTO lbl63
                CodeRuleSerialNumUtil.logger.info("CodeRuleServiceImp: dateIsAfter: number is:" + number + " afterSNNumber is:" + afterSNNumber);
                number = number.substring(0, number.length() - afterSNNumber.length());
                if (beforeSNNumber == null || beforeSNNumber.length() <= 0) ** GOTO lbl63
                CodeRuleSerialNumUtil.logger.info("CodeRuleServiceImp: number is:" + number + " beforeSNNumber is:" + beforeSNNumber);
                number = number.substring(beforeSNNumber.length());
            }
            catch (StringIndexOutOfBoundsException e) {
                return serialNumber;
            }
        } else {
            CodeRuleSerialNumUtil.logger.info("CodeRuleServiceImp: else beforeSNNumber is:" + beforeSNNumber);
            number = number.substring(beforeSNNumber.length());
            CodeRuleSerialNumUtil.logger.info("CodeRuleServiceImp: else number is: " + number + " else afterSNNumber is:" + afterSNNumber);
            number = number.substring(0, number.length() - afterSNNumber.length());
        }
lbl63:
        // 4 sources

        tempstr = "";
        for (i = 0; i < codeRuleInfo.getRuleEntry().size(); ++i) {
            if (!"16".equals(((CodeRuleEntryInfo)codeRuleInfo.getRuleEntry().get(i)).getAttributeType())) continue;
            length = ((CodeRuleEntryInfo)codeRuleInfo.getRuleEntry().get(i)).getLength();
            try {
                longNumber = Long.parseLong(number);
                longNumberLength = String.valueOf(longNumber).length();
                if (codeRuleInfo.isFillWithZero().booleanValue()) {
                    v1 = isCheckAutoIncrLength = codeRuleInfo.getAutoIncrLength() != false && number.length() > length;
                    if ((!isCheckAutoIncrLength || number.length() == longNumberLength) && (isCheckAutoIncrLength || length == number.length())) continue;
                    CodeRuleSerialNumUtil.logger.info("[CodeRule.getRecycleNumber]\u6d41\u6c34\u53f7\u4e0d\u7b26\u5408\u7f16\u7801\u89c4\u5219\u6d41\u6c34\u53f7\u957f\u5ea6\uff1a" + length + "\uff0c\u6d41\u6c34\u53f7\uff1a" + number + "\uff0c\u81ea\u52a8\u8865\u4f4d\uff1a" + codeRuleInfo.getAutoIncrLength());
                    return "-1";
                }
                if (number.length() == longNumberLength && (number.length() <= length || codeRuleInfo.getAutoIncrLength().booleanValue())) continue;
                CodeRuleSerialNumUtil.logger.info("[CodeRule.getRecycleNumber]\u7f16\u7801\u89c4\u5219\u5df2\u5173\u95ed\u75280\u8865\u4f4d\uff0c\u6d41\u6c34\u53f7\u683c\u5f0f\u4e0d\u7b26\u5408\uff1a" + number + "\uff0c\u8f6c\u6362\u540e\u6d41\u6c34\u53f7\uff1a" + longNumber + "\uff0c\u81ea\u52a8\u8865\u4f4d\uff1a" + codeRuleInfo.getAutoIncrLength());
                return "-1";
            }
            catch (NumberFormatException e) {
                CodeRuleSerialNumUtil.logger.info("getRecycleNumber.NumberFormatException:number -> " + number);
                return "-1";
            }
        }
        serialNumber = number = (tempstr = tempstr + number);
        return serialNumber;
    }

    private static int getSerialNumberIndex(CodeRuleInfo codeRuleInfo) {
        int index = -1;
        for (CodeRuleEntryInfo entry : codeRuleInfo.getRuleEntry()) {
            if (!TYPE_SEQ.equals(entry.getAttributeType())) continue;
            index = entry.getSeq();
            return index;
        }
        return index;
    }

    private static int getDateIndex(CodeRuleInfo codeRuleInfo) {
        int index = -1;
        for (CodeRuleEntryInfo entry : codeRuleInfo.getRuleEntry()) {
            if (!TYPE_DATE_FIELD.equals(entry.getAttributeType())) continue;
            index = entry.getSeq();
            return index;
        }
        return index;
    }

    public static String getSortItemValue(CodeRuleInfo codeRuleInfo, DynamicObject dataInfo, String number) {
        String[] valueStrings = CodeRuleSerialNumUtil.getValueStrings(codeRuleInfo, dataInfo, number);
        return CodeRuleSerialNumUtil.getStringFromArray(valueStrings, 0);
    }

    private static String[] getValueStrings(CodeRuleInfo codeRuleInfo, DynamicObject dataInfo, String number) {
        StringBuilder sortValue = new StringBuilder();
        StringBuilder sbCodeRuleBefore = new StringBuilder();
        StringBuilder sbCodeRuleAfter = new StringBuilder();
        boolean before = true;
        String entryValue = "";
        for (CodeRuleEntryInfo codeRuleEntry : codeRuleInfo.getRuleEntry()) {
            boolean isVisable = codeRuleEntry.getVisable();
            codeRuleEntry.setCodeRuleInfo(codeRuleInfo);
            if (isVisable) {
                if (before) {
                    if (codeRuleEntry.getIsSplitSign().booleanValue()) {
                        sbCodeRuleBefore.append(codeRuleEntry.getSplitSign());
                    }
                } else if (codeRuleEntry.getIsSplitSign().booleanValue()) {
                    sbCodeRuleAfter.append(codeRuleEntry.getSplitSign());
                }
            }
            entryValue = "";
            switch (codeRuleEntry.getAttributeType()) {
                case "1": {
                    entryValue = codeRuleEntry.getFormat();
                    break;
                }
                case "9": {
                    entryValue = CodeRuleSerialNumUtil.getSystemDateEntry(codeRuleEntry);
                    break;
                }
                case "16": {
                    entryValue = "";
                    before = false;
                    break;
                }
                case "2": {
                    entryValue = CodeRuleSerialNumUtil.getDateEntry(codeRuleEntry, dataInfo);
                    break;
                }
                case "8": {
                    entryValue = CodeRuleSerialNumUtil.getItemEntry(codeRuleEntry, dataInfo);
                    break;
                }
                case "64": {
                    break;
                }
                case "128": {
                    if (!StringUtils.isNotBlank((CharSequence)number)) break;
                    entryValue = number.substring(number.length() - 1);
                    break;
                }
            }
            entryValue = CodeRuleSerialNumUtil.formatString(codeRuleEntry, entryValue);
            if (!TYPE_SEQ.equals(codeRuleEntry.getAttributeType()) && codeRuleEntry.getIsSortItem().booleanValue()) {
                sortValue.append(entryValue);
                sortValue.append("_split_");
            }
            if (!isVisable) continue;
            if (before) {
                sbCodeRuleBefore.append(entryValue);
                continue;
            }
            sbCodeRuleAfter.append(entryValue);
        }
        String sortValueItem = sortValue.toString();
        if (sortValueItem.endsWith("_split_")) {
            sortValueItem = sortValueItem.substring(0, sortValueItem.lastIndexOf("_split_"));
        }
        return new String[]{sortValueItem, sbCodeRuleBefore.toString(), sbCodeRuleAfter.toString()};
    }

    public static String getDateEntry(CodeRuleEntryInfo codeRuleEntry, DynamicObject dataInfo) {
        String dateTimeFormat = codeRuleEntry.getFormat();
        SimpleDateFormat formatter = new SimpleDateFormat(dateTimeFormat);
        try {
            String date = CodeRuleSerialNumUtil.getDate(codeRuleEntry, dataInfo);
            return formatter.format(Long.valueOf(date));
        }
        catch (Exception e) {
            logger.info("[\u7f16\u7801\u89c4\u5219]\u4f20\u5165\u7684\u4e1a\u52a1\u65e5\u671f\u6709\u8bef, \u68c0\u67e5\u662f\u5426\u6b63\u786e\u4f20\u5165. " + e.getMessage());
            return formatter.format(new Date());
        }
    }

    public static String getSystemDateEntry(CodeRuleEntryInfo codeRuleEntry) {
        String dateTimeFormat = codeRuleEntry.getFormat();
        SimpleDateFormat formatter = new SimpleDateFormat(dateTimeFormat);
        return formatter.format(new Date());
    }

    public static String getRandomNumber(int length) {
        try {
            return CodeRuleSerialNumUtil.getSimpleRandomString(length);
        }
        catch (Exception e) {
            logger.info("[CodeRuleUtil][getRandomNumber]\u968f\u673a\u7801\u751f\u6210\u5f02\u5e38");
            throw new KDException(new ErrorCode(ERRCODE_CODERULE, e.getMessage()), new Object[0]);
        }
    }

    private static String getSimpleRandomString(int length) {
        String str = UUID.randomUUID().toString().replaceAll("-", "");
        str = str.substring(0, length).toUpperCase();
        return str;
    }

    private static String getDate(CodeRuleEntryInfo codeRuleEntry, DynamicObject dataInfo) {
        String propertyName = codeRuleEntry.getValueAtribute();
        if (propertyName.contains(".")) {
            String basedataName = codeRuleEntry.getValueAtribute().split("\\.")[0];
            DynamicObject baseDataInfo = null;
            Object baseDataInfoObj = CodeRuleSerialNumUtil.getAttributeObject(dataInfo, basedataName);
            if (!(baseDataInfoObj instanceof DynamicObject)) {
                return null;
            }
            baseDataInfo = (DynamicObject)baseDataInfoObj;
            String baseDataString = null;
            String subBasedataName = codeRuleEntry.getValueAtribute().split("\\.")[1];
            if ("name".equals(subBasedataName)) {
                ILocaleString name = (ILocaleString)baseDataInfo.get(subBasedataName);
                baseDataString = (String)name.get((Object)Lang.get().toString());
            } else {
                Object subBaseDataInfoObj = CodeRuleSerialNumUtil.getAttributeObject(baseDataInfo, subBasedataName);
                if (!(subBaseDataInfoObj instanceof Date)) {
                    logger.info("CodeRuleUtil[subBaseDataInfoObj]\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u4e3a\u7a7a,\u6216\u83b7\u53d6\u5230\u7684\u4e0d\u662f\u65e5\u671f\u5bf9\u8c61");
                    return null;
                }
                baseDataString = String.valueOf(((Date)subBaseDataInfoObj).getTime());
            }
            return baseDataString;
        }
        Object baseDataObj = CodeRuleSerialNumUtil.getAttributeObject(dataInfo, propertyName);
        if (!(baseDataObj instanceof Date)) {
            logger.info("CodeRuleUtil[baseDataObj]\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u4e3a\u7a7a,\u6216\u83b7\u53d6\u5230\u7684\u4e0d\u662f\u65e5\u671f\u5bf9\u8c61");
            return null;
        }
        return String.valueOf(((Date)baseDataObj).getTime());
    }

    public static String getItemEntry(CodeRuleEntryInfo codeRuleEntry, DynamicObject dataInfo) {
        String baseDataString;
        block24: {
            if (dataInfo == null) {
                return "";
            }
            baseDataString = null;
            String valueAttribute = codeRuleEntry.getValueAtribute();
            try {
                String[] arrAttributeKey = valueAttribute.split("\\.");
                if (arrAttributeKey.length == 1) {
                    String basedataName = valueAttribute;
                    Object attributeObject = CodeRuleSerialNumUtil.getAttributeObject(dataInfo, basedataName);
                    if (attributeObject != null) {
                        if (attributeObject instanceof ILocaleString) {
                            ILocaleString name = (ILocaleString)attributeObject;
                            baseDataString = (String)name.get((Object)Lang.get().toString());
                        } else if (attributeObject instanceof Date) {
                            Date date = (Date)attributeObject;
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
                            baseDataString = sdf.format(date);
                        } else {
                            baseDataString = attributeObject.toString();
                        }
                    }
                    break block24;
                }
                if (arrAttributeKey.length == 2) {
                    String basedataName = valueAttribute.split("\\.")[0];
                    DynamicObject baseDataInfo = null;
                    Object attributeObject = CodeRuleSerialNumUtil.getAttributeObject(dataInfo, basedataName);
                    Object pkId = null;
                    if (attributeObject != null) {
                        if (attributeObject instanceof DynamicObject) {
                            baseDataInfo = (DynamicObject)attributeObject;
                        } else {
                            pkId = attributeObject;
                        }
                    } else {
                        return "";
                    }
                    String subBasedataName = valueAttribute.split("\\.")[1];
                    Object subAttributeObject = null;
                    if (baseDataInfo != null) {
                        subAttributeObject = CodeRuleSerialNumUtil.getAttributeObject(baseDataInfo, subBasedataName);
                    } else {
                        IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)dataInfo.getDataEntityType().getProperties().get((Object)basedataName);
                        if (iDataEntityProperty instanceof BasedataProp) {
                            String entityNum = ((BasedataProp)iDataEntityProperty).getBaseEntityId();
                            DynamicObject dot = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)entityNum, (String)subBasedataName);
                            subAttributeObject = dot.get(subBasedataName);
                        } else {
                            return "";
                        }
                    }
                    if (subAttributeObject != null) {
                        if (subAttributeObject instanceof ILocaleString) {
                            ILocaleString name = (ILocaleString)subAttributeObject;
                            baseDataString = (String)name.get((Object)Lang.get().toString());
                        } else if (subAttributeObject instanceof Date) {
                            Date date = (Date)subAttributeObject;
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
                            baseDataString = sdf.format(date);
                        } else {
                            baseDataString = subAttributeObject.toString();
                        }
                    }
                    break block24;
                }
                throw new KDException(new ErrorCode(ERRCODE_CODERULE, ResManager.loadKDString((String)"\u5224\u65ad\u903b\u8f91\u5b58\u5728\u95ee\u9898...", (String)"CodeRuleSerialNumUtil_0", (String)"bos-coderule", (Object[])new Object[0])), new Object[0]);
            }
            catch (Exception e) {
                logger.info("getItemEntry \u53d1\u751f\u5f02\u5e38:", (Object)e);
            }
        }
        if (baseDataString == null) {
            return "";
        }
        return baseDataString;
    }

    public static String formatString(CodeRuleEntryInfo codeRuleEntry, String initStr) {
        if (TYPE_FIX_TEXT.equals(codeRuleEntry.getAttributeType()) || TYPE_DATE_FIELD.equals(codeRuleEntry.getAttributeType()) || TYPE_SEQ.equals(codeRuleEntry.getAttributeType()) || CHECK_CODE.equals(codeRuleEntry.getAttributeType()) || TYPE_SYSTEM_TIME_FIELD.equals(codeRuleEntry.getAttributeType()) || TYPE_RANDOM_NUMBER.equals(codeRuleEntry.getAttributeType()) || !ATT_USING_MODE_CUT.equals(codeRuleEntry.getAttUsingMode())) {
            return initStr;
        }
        if (StringUtils.isBlank((CharSequence)initStr)) {
            initStr = "";
        }
        if (codeRuleEntry.getLength() > 0 && codeRuleEntry.getLength() > initStr.length()) {
            if (codeRuleEntry.getAddchar() != null && codeRuleEntry.getAddchar().length() > 0) {
                int fillNumber = codeRuleEntry.getLength() - initStr.length();
                if (codeRuleEntry.getAddstyle().booleanValue()) {
                    int fillSignLength = codeRuleEntry.getAddchar().length();
                    StringBuilder sbInitStr = new StringBuilder(initStr);
                    for (int i = 0; i < fillNumber / fillSignLength; ++i) {
                        sbInitStr.append(codeRuleEntry.getAddchar());
                    }
                    initStr = sbInitStr.toString();
                    if (fillNumber % fillSignLength > 0) {
                        initStr = initStr + codeRuleEntry.getAddchar().substring(0, fillNumber % fillSignLength);
                    }
                } else {
                    int fillSignLength = codeRuleEntry.getAddchar().length();
                    int fillCount = fillNumber / fillSignLength;
                    StringBuilder sbInitStr = new StringBuilder(fillCount);
                    for (int i = 0; i < fillCount; ++i) {
                        sbInitStr.append(codeRuleEntry.getAddchar());
                    }
                    initStr = sbInitStr.append(initStr).toString();
                    if (fillNumber % fillSignLength > 0) {
                        initStr = codeRuleEntry.getAddchar().substring(0, fillNumber % fillSignLength) + initStr;
                    }
                }
            }
        } else if (codeRuleEntry.getLength() > 0 && codeRuleEntry.getLength() < initStr.length() && codeRuleEntry.getAddchar() != null && codeRuleEntry.getAddchar().length() > 0) {
            initStr = codeRuleEntry.getCutstyle() != false ? initStr.substring(0, codeRuleEntry.getLength()) : initStr.substring(initStr.length() - codeRuleEntry.getLength(), initStr.length());
        }
        return initStr;
    }

    public static Object getAttributeObject(DynamicObject dataInfo, String basedataFieldKey) {
        if (dataInfo == null) {
            return null;
        }
        String entityNum = dataInfo.getDataEntityType().getName();
        Object attribute = null;
        if (dataInfo.getDataEntityType().getProperties().get((Object)basedataFieldKey) == null) {
            DynamicObject dot = BusinessDataServiceHelper.loadSingle((Object)dataInfo.getPkValue(), (String)entityNum, (String)basedataFieldKey);
            attribute = dot.get(basedataFieldKey);
        } else if (dataInfo.get(basedataFieldKey) != null) {
            attribute = dataInfo.get(basedataFieldKey);
        }
        return attribute;
    }

    public static String addChar(CodeRuleEntryInfo codeRuleEntry, String serialNumber, String name) {
        return CodeRuleSerialNumUtil.addChar(codeRuleEntry, serialNumber, name, true);
    }

    public static String addChar(CodeRuleEntryInfo codeRuleEntry, String serialNumber, String name, boolean isFillWithZero) {
        return CodeRuleSerialNumUtil.addChar(codeRuleEntry, serialNumber, name, isFillWithZero, false);
    }

    public static String addChar(CodeRuleEntryInfo codeRuleEntry, String serialNumber, String name, boolean isFillWithZero, boolean isAutoIncrLength) {
        int addLength = codeRuleEntry.getLength() - serialNumber.length();
        if (addLength < 0 && !isAutoIncrLength) {
            throw new KDException(new ErrorCode(ERRCODE_CODERULE, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u89c4\u5219\u201c%s\u201d\u7684\u6d41\u6c34\u53f7\u5df2\u7ecf\u7528\u5b8c\uff0c\u8bf7\u524d\u5f80\u7f16\u7801\u89c4\u5219\u4fee\u6539\u6d41\u6c34\u53f7\u957f\u5ea6\u6216\u8005\u5f00\u542f\u6d41\u6c34\u53f7\u7684\u201c\u8d85\u8fc7\u8bbe\u7f6e\u957f\u5ea6\u65f6\u81ea\u52a8\u5347\u4f4d\u201d\u53c2\u6570\u3002", (String)"CodeRuleSerialNumUtil_1", (String)"bos-coderule", (Object[])new Object[0]), name)), new Object[0]);
        }
        if (addLength <= 0 || !isFillWithZero) {
            return serialNumber;
        }
        String addChar = codeRuleEntry.getAddchar().trim().length() == 0 ? "0" : codeRuleEntry.getAddchar();
        StringBuilder sb = new StringBuilder();
        if (codeRuleEntry.getAddstyle().booleanValue()) {
            for (int i = 0; i < addLength; ++i) {
                sb.append(addChar);
            }
            sb.append(serialNumber);
        } else {
            sb.append(serialNumber);
            for (int i = 0; i < addLength; ++i) {
                sb.append(addChar);
            }
        }
        return sb.toString();
    }

    public static String generateExampleSerialNumber(CodeRuleInfo codeRuleInfo, String serialNumber) {
        String exampleSerialNumber = "";
        if (null == codeRuleInfo) {
            return exampleSerialNumber;
        }
        for (CodeRuleEntryInfo codeRuleEntryInfo : codeRuleInfo.getRuleEntry()) {
            if (!CodeRuleEntryTypeEnum.TYPE_SEQ.getTypeStr().equals(codeRuleEntryInfo.getAttributeType())) continue;
            return CodeRuleSerialNumUtil.addChar(codeRuleEntryInfo, serialNumber, codeRuleInfo.getName(), codeRuleInfo.isFillWithZero(), codeRuleInfo.isAutoIncrLength());
        }
        return exampleSerialNumber;
    }

    public static String getDLockKey(CodeRuleInfo codeRuleInfo, String sortItemValue) {
        String codeRuleID = codeRuleInfo.getId();
        String seqSegmentEntryID = "";
        String key = (codeRuleID + seqSegmentEntryID + sortItemValue).intern();
        String dLockKey = key;
        if (dLockKey.endsWith("/")) {
            dLockKey = dLockKey.replace("/", "").intern();
        }
        dLockKey = BAS_CODERULE + dLockKey;
        return dLockKey;
    }

    public static String fillSortItem(String sortItem) {
        String newSortItem = sortItem;
        if (sortItem.endsWith("_split_")) {
            newSortItem = sortItem.substring(0, sortItem.lastIndexOf("_split_"));
        }
        return newSortItem;
    }

    public static String getMainOrgId(DynamicObject obj) {
        String orgId = null;
        IDataEntityType dataEntityType = obj.getDataEntityType();
        if (dataEntityType instanceof BillEntityType) {
            String mainOrg = ((BillEntityType)dataEntityType).getMainOrg();
            if (mainOrg == null) {
                return orgId;
            }
            try {
                Object orgObj = obj.get(mainOrg);
                if (orgObj == null) {
                    return orgId;
                }
                if (orgObj instanceof DynamicObject) {
                    orgId = String.valueOf(((DynamicObject)orgObj).getPkValue());
                } else if (orgObj instanceof Long) {
                    orgId = String.valueOf(orgObj);
                }
            }
            catch (Exception e) {
                logger.info(e.getMessage());
            }
        }
        return orgId;
    }

    public void testJUnit() {
    }
}

