/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.coderule.util;

import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.param.CustomParam;
import kd.bos.mservice.sysparam.SystemParamService;
import kd.bos.param.ParameterReader;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.util.StringUtils;

public class CodeRuleSystemParam {
    public static boolean getUpgradeParam() {
        SystemParamService systemParamService = (SystemParamService)ServiceFactory.getService(SystemParamService.class);
        Object upgradeStatusObj = systemParamService.loadPublicParameterFromCache("coderule_upgrade_status");
        if (upgradeStatusObj == null) {
            return true;
        }
        String upgradeStatus = upgradeStatusObj.toString();
        if (StringUtils.isEmpty((String)upgradeStatus)) {
            return true;
        }
        return StringUtils.isNotEmpty((String)upgradeStatus) && String.valueOf(true).equals(upgradeStatus);
    }

    public static boolean getMcParam(String param) {
        String property = System.getProperty("coderule_" + param);
        if (property == null) {
            return true;
        }
        if (StringUtils.isEmpty((String)property)) {
            return true;
        }
        return StringUtils.isNotEmpty((String)property) && String.valueOf(true).equals(property);
    }

    public static Optional<Object> getBillParam(String entityNum, String key) {
        DynamicObject obj = ParameterReader.getBillParameter((String)entityNum);
        if (obj == null || obj.getDataEntityType() == null) {
            return Optional.empty();
        }
        boolean haveCodeRuleBillParams = obj.getDataEntityType().getProperties().containsKey((Object)key);
        if (haveCodeRuleBillParams) {
            return Optional.of(obj.get(key));
        }
        return Optional.empty();
    }

    public static boolean getCustomParameter(String customKey, boolean defaultValue) {
        if (StringUtils.isBlank((String)customKey)) {
            return false;
        }
        Map customParameter = SystemParamServiceHelper.loadCustomParameterFromCache((CustomParam)new CustomParam());
        return Boolean.parseBoolean(customParameter.getOrDefault(customKey, Boolean.toString(defaultValue)));
    }
}

