/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.coderule.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.coderule.constant.CodeRuleConstant;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;

public class CommonUtil
implements CodeRuleConstant {
    public static final String SPLIT_OF_SORT_ITEM = "_split_";

    public static boolean validateNumLen(String string) {
        String str = "^\\d{12}$";
        Pattern p = Pattern.compile(str);
        Matcher m = p.matcher(string);
        return m.matches();
    }

    public static int getCheckNumber(String num) {
        int i;
        num = num + "0";
        int numSect1 = 1;
        int numSect2 = 2;
        int length = num.length();
        int len = 6;
        try {
            numSect1 = Integer.parseInt(num.substring(length - len, length));
            numSect2 = Integer.parseInt(num.substring(0, length - len));
        }
        catch (NumberFormatException e) {
            throw new KDException((Throwable)e, new ErrorCode("ErrCode_CodeRule", CodeRuleConstant.getCODELENGTHERROR()), new Object[0]);
        }
        int sum1 = 0;
        int sum2 = 0;
        int dec = 10;
        for (i = 1; i <= len; ++i) {
            if (i % 2 == 0) {
                sum2 += numSect1 % dec;
            } else {
                sum1 += numSect1 % dec;
            }
            numSect1 /= dec;
        }
        for (i = 7; i <= length; ++i) {
            if (i % 2 == 0) {
                sum2 += numSect2 % dec;
            } else {
                sum1 += numSect2 % dec;
            }
            numSect2 /= dec;
        }
        int sum = sum2 * 3 + sum1;
        return (dec - sum % dec) % dec;
    }

    public static String convertSortItem(String sortItem) {
        if (sortItem == null) {
            return "";
        }
        if ("".equals(sortItem)) {
            return SPLIT_OF_SORT_ITEM;
        }
        return sortItem;
    }

    public static Object getDynamicObjProperties(DynamicObject dynamicObject, String property) {
        if (dynamicObject == null) {
            return "";
        }
        if (!dynamicObject.getDataEntityType().getProperties().containsKey((Object)property)) {
            return "";
        }
        return dynamicObject.get(property) == null ? "" : dynamicObject.get(property);
    }
}

