/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.coderule.util;

import kd.bos.coderule.api.CodeRuleEntryInfo;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.coderule.enums.CodeRuleEntryTypeEnum;
import kd.bos.coderule.util.CodeRuleSerialNumUtil;
import kd.bos.dataentity.entity.DynamicObject;

public class NumberComponents {
    private String frontPart;
    private String latterPart;
    private static final String TYPE_FIX_TEXT = "1";
    private static final String TYPE_DATE_FIELD = "2";
    private static final String TYPE_ITEM_FIELD = "8";
    private static final String TYPE_SYSTEM_TIME_FIELD = "9";
    private static final String TYPE_RANDOM_NUMBER = "10";
    private static final String TYPE_SEQ = "16";
    private static final String TYPE_LIST_FIELD = "64";
    private static final String CHECK_CODE = "128";

    public NumberComponents() {
    }

    public NumberComponents(CodeRuleInfo codeRuleInfo, DynamicObject dataInfo, CodeRuleEntryTypeEnum entryType) {
        if (CodeRuleEntryTypeEnum.TYPE_RANDOM_NUMBER == entryType) {
            this.getNumberedComponents(codeRuleInfo, dataInfo);
        }
    }

    public String getFrontPart() {
        return this.frontPart;
    }

    public void setFrontPart(String frontPart) {
        this.frontPart = frontPart;
    }

    public String getLatterPart() {
        return this.latterPart;
    }

    public void setLatterPart(String latterPart) {
        this.latterPart = latterPart;
    }

    private void getNumberedComponents(CodeRuleInfo codeRuleInfo, DynamicObject dataInfo) {
        if (null == codeRuleInfo || null == dataInfo) {
            return;
        }
        StringBuilder beforePart = new StringBuilder();
        StringBuilder afterPart = new StringBuilder();
        boolean before = true;
        String entryValue = "";
        for (CodeRuleEntryInfo codeRuleEntry : codeRuleInfo.getRuleEntry()) {
            codeRuleEntry.setCodeRuleInfo(codeRuleInfo);
            if (!codeRuleEntry.getVisable()) continue;
            if (codeRuleEntry.getIsSplitSign().booleanValue()) {
                if (before) {
                    beforePart.append(codeRuleEntry.getSplitSign());
                } else {
                    afterPart.append(codeRuleEntry.getSplitSign());
                }
            }
            entryValue = "";
            switch (codeRuleEntry.getAttributeType()) {
                case "1": {
                    entryValue = codeRuleEntry.getFormat();
                    break;
                }
                case "9": {
                    entryValue = CodeRuleSerialNumUtil.getSystemDateEntry(codeRuleEntry);
                    break;
                }
                case "10": {
                    entryValue = "";
                    before = false;
                    break;
                }
                case "2": {
                    entryValue = CodeRuleSerialNumUtil.getDateEntry(codeRuleEntry, dataInfo);
                    break;
                }
                case "8": {
                    entryValue = CodeRuleSerialNumUtil.getItemEntry(codeRuleEntry, dataInfo);
                    break;
                }
                case "64": {
                    break;
                }
                case "128": {
                    break;
                }
            }
            entryValue = CodeRuleSerialNumUtil.formatString(codeRuleEntry, entryValue);
            if (before) {
                beforePart.append(entryValue);
                continue;
            }
            afterPart.append(entryValue);
        }
        this.frontPart = beforePart.toString();
        this.latterPart = afterPart.toString();
    }
}

