/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.coderule.util;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kd.bos.coderule.util.StandradSettingUtil;
import kd.bos.coderule.util.TreeListUtil;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.form.IPageCache;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.svc.util.TreeNodeFilter;

public class TreeListQueryUtil {
    private static final String SQL_FIELD_BIZOBJECTID = "bizobjectid";

    public static void afterTreeNodeClick(IPageCache pageCache, BillList billList, String filterString) {
        pageCache.put("curbizobjectid", filterString);
        FilterParameter fParameter = new FilterParameter();
        fParameter.setQFilter(filterString);
        billList.setQueryFilterParameter(fParameter);
        if (pageCache.get("able") == null) {
            billList.clearSelection();
        }
        billList.setOrderBy("id");
        billList.refresh();
    }

    public static String getFilterByCloud(BillList billList, String trueId) {
        String sql = "select a.fnumber from t_meta_entitydesign a left join t_meta_bizunitrelform b on a.fid = b.fformid  left join t_meta_bizapp c on b.fbizappid = c.fid where c.fbizcloudid = ?\tand  c.fvisible = '1' and a.fistemplate = '0' ";
        String appBlacklist = StandradSettingUtil.getBlackListIdsAtApp();
        if (StringUtils.isNotBlank((CharSequence)appBlacklist)) {
            sql = "select a.fnumber from t_meta_entitydesign a left join t_meta_bizunitrelform b on a.fid = b.fformid  left join t_meta_bizapp c on b.fbizappid = c.fid where c.fbizcloudid = ?\tand  c.fvisible = '1' and a.fistemplate = '0' and c.fid not in (" + appBlacklist + ")";
        }
        Object[] filters = new String[]{trueId};
        TreeNodeFilter treeNodeFilter = new TreeNodeFilter(TreeNodeFilter.FilterTypeEnum.ONLY_APP);
        QFilter appId = treeNodeFilter.getAppFilter("c.fid");
        if (appId != null && StringUtils.isNotBlank((CharSequence)appId.toString())) {
            sql = sql + " and " + appId.toString();
        }
        List formIdList = (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])filters, (ResultSetHandler)new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws SQLException {
                ArrayList<String> result = new ArrayList<String>(10000);
                while (rs.next()) {
                    result.add(rs.getString("fnumber"));
                }
                return result;
            }
        });
        QFilter f1 = new QFilter(SQL_FIELD_BIZOBJECTID, "in", (Object)formIdList);
        String filterString = f1.toSerializedString();
        billList.setListFilter(f1.toSerializedString());
        return filterString;
    }

    public static String getFilterByApp(BillList billList, String trueId) {
        StringBuilder sql = new StringBuilder("select a.fnumber from t_meta_entitydesign a left join t_meta_bizunitrelform b on a.fid = b.fformid where a.fistemplate = '0' and b.fbizappid in (?");
        List<String> allExtAppId = TreeListUtil.getAllExtAppId(trueId);
        Object[] filters = new String[allExtAppId.size() + 1];
        for (int i = 0; i < allExtAppId.size() + 1; ++i) {
            if (i == 0) {
                filters[0] = trueId;
                continue;
            }
            sql.append(" ,? ");
            filters[i] = allExtAppId.get(i - 1);
        }
        sql.append(" ) ");
        String entityNumBlacklist = StandradSettingUtil.getBlackListNumbersAtEntity(trueId);
        if (StringUtils.isNotBlank((CharSequence)entityNumBlacklist)) {
            sql.append(" and a.fnumber not in (").append(entityNumBlacklist).append(')');
        }
        List formIdList = (List)DB.query((DBRoute)DBRoute.meta, (String)sql.toString(), (Object[])filters, (ResultSetHandler)new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws SQLException {
                ArrayList<String> result = new ArrayList<String>(10000);
                while (rs.next()) {
                    result.add(rs.getString("fnumber"));
                }
                return result;
            }
        });
        QFilter f1 = new QFilter(SQL_FIELD_BIZOBJECTID, "in", (Object)formIdList);
        String filterString = f1.toSerializedString();
        billList.setListFilter(f1.toSerializedString());
        return filterString;
    }

    public static String getFilterByForm(BillList billList, String trueId) {
        Map<String, String> map = TreeListUtil.getBizObjectById(trueId);
        QFilter f1 = new QFilter(SQL_FIELD_BIZOBJECTID, "=", (Object)map.get("number"));
        String filterString = f1.toSerializedString();
        billList.setListFilter(f1.toSerializedString());
        return filterString;
    }

    public static List<String> searchCloudByName(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return new ArrayList<String>(0);
        }
        name = name.replaceAll("_", "/_");
        String localeid = RequestContext.get().getLang().name();
        StringBuilder sql = new StringBuilder();
        sql.append("select a.fid, al.fname ");
        sql.append(" from t_meta_bizcloud a ");
        sql.append(" inner join t_meta_bizcloud_l al ");
        sql.append(" on a.fid = al.fid ");
        sql.append(" where al.flocaleid = '").append(localeid).append("' ");
        sql.append(" and al.fname like ? escape '/'");
        sql.append(" order by a.fid asc");
        Object[] params = new SqlParameter[]{new SqlParameter(":fname", 12, (Object)("%" + name + "%"))};
        return (List)DB.query((DBRoute)DBRoute.meta, (String)sql.toString(), (Object[])params, rs -> {
            ArrayList<String> result = new ArrayList<String>(8);
            while (rs.next()) {
                String id = rs.getString(1);
                if (StringUtils.isBlank((CharSequence)id)) continue;
                result.add("1_split_" + id);
            }
            return result;
        });
    }

    public static List<String> searchBizappByName(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return new ArrayList<String>(0);
        }
        name = name.replaceAll("_", "/_");
        String localeid = RequestContext.get().getLang().name();
        StringBuilder sql = new StringBuilder();
        sql.append("select a.fid, A.FMASTERID, al.fname ");
        sql.append(" from t_meta_bizapp a ");
        sql.append(" inner join t_meta_bizapp_l al ");
        sql.append(" on a.fid = al.fid ");
        sql.append(" where al.flocaleid = '").append(localeid).append("' ");
        sql.append(" and al.fname like ? escape '/'");
        sql.append(" order by a.fbizcloudid, a.fid asc");
        Object[] params = new SqlParameter[]{new SqlParameter(":fname", 12, (Object)("%" + name + "%"))};
        return (List)DB.query((DBRoute)DBRoute.meta, (String)sql.toString(), (Object[])params, rs -> {
            LinkedHashSet<String> result = new LinkedHashSet<String>(8);
            while (rs.next()) {
                String id = rs.getString(1);
                if (StringUtils.isBlank((CharSequence)id)) continue;
                String masterid = rs.getString(2);
                if (StringUtils.isNotBlank((CharSequence)masterid)) {
                    result.add("2_split_" + masterid);
                    continue;
                }
                result.add("2_split_" + id);
            }
            return new ArrayList(result);
        });
    }

    public static List<String> searchEntityByName(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return new ArrayList<String>(0);
        }
        name = name.replaceAll("_", "/_");
        String localeid = RequestContext.get().getLang().name();
        StringBuilder sql = new StringBuilder();
        sql.append("select a.fid, a.fdentityid, al.fname ");
        sql.append(" from t_meta_mainentityinfo a ");
        sql.append(" inner join t_meta_mainentityinfo_l al ");
        sql.append(" on a.fid = al.fid ");
        sql.append(" where al.flocaleid = '").append(localeid).append("' ");
        sql.append(" and al.fname like ? escape '/'");
        sql.append(" order by a.fbizappid, a.fid asc");
        Object[] params = new SqlParameter[]{new SqlParameter(":fname", 12, (Object)("%" + name + "%"))};
        return (List)DB.query((DBRoute)DBRoute.meta, (String)sql.toString(), (Object[])params, rs -> {
            ArrayList<String> result = new ArrayList<String>(8);
            while (rs.next()) {
                String id = rs.getString(2);
                if (StringUtils.isBlank((CharSequence)id)) continue;
                result.add("3_split_" + id);
            }
            return result;
        });
    }

    public static String searchCloudIdByAppId(String appId) {
        if (StringUtils.isBlank((CharSequence)appId)) {
            return "";
        }
        StringBuilder sql = new StringBuilder();
        sql.append("select fid, fbizcloudid");
        sql.append(" from t_meta_bizapp");
        sql.append(" where fid = '").append(appId).append("' ");
        return (String)DB.query((DBRoute)DBRoute.meta, (String)sql.toString(), null, rs -> {
            String result = "";
            while (rs.next()) {
                String bizcloudid = rs.getString(2);
                if (StringUtils.isBlank((CharSequence)bizcloudid)) continue;
                result = "1_split_" + bizcloudid;
            }
            return result;
        });
    }

    public static String searchAppIdByEntityId(String entityId) {
        if (StringUtils.isBlank((CharSequence)entityId)) {
            return "";
        }
        StringBuilder sql = new StringBuilder();
        sql.append("select fformid, fbizappid");
        sql.append(" from t_meta_bizunitrelform");
        sql.append(" where fformid = '").append(entityId).append("' ");
        String query = (String)DB.query((DBRoute)DBRoute.meta, (String)sql.toString(), null, rs -> {
            String result = "";
            while (rs.next()) {
                String bizappid = rs.getString(2);
                if (StringUtils.isBlank((CharSequence)bizappid)) continue;
                result = bizappid;
            }
            return result;
        });
        if (StringUtils.isNotBlank((CharSequence)query)) {
            return TreeListQueryUtil.searchAppIdOriginal(query);
        }
        return "";
    }

    private static String searchAppIdOriginal(String appId) {
        StringBuilder sql = new StringBuilder();
        sql.append("select a.fid, A.FMASTERID ");
        sql.append(" from t_meta_bizapp a ");
        sql.append(" where a.fid = ?");
        Object[] params = new SqlParameter[]{new SqlParameter(":fid", 12, (Object)appId)};
        return (String)DB.query((DBRoute)DBRoute.meta, (String)sql.toString(), (Object[])params, rs -> {
            String result = "";
            while (rs.next()) {
                String id = rs.getString(1);
                if (StringUtils.isBlank((CharSequence)id)) continue;
                String masterid = rs.getString(2);
                if (StringUtils.isNotBlank((CharSequence)masterid)) {
                    result = "2_split_" + masterid;
                    continue;
                }
                result = "2_split_" + id;
            }
            return result;
        });
    }
}

