/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.coderule.util.intermitno.filter;

import com.google.common.hash.BloomFilter;
import com.google.common.hash.Funnel;
import com.google.common.hash.Funnels;
import java.nio.charset.Charset;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.coderule.util.intermitno.IntermitNoDetectUtil;
import kd.bos.coderule.util.intermitno.filter.Filter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class MyBoolmFilter
implements Filter {
    private BloomFilter<String> bloomFilter;

    public MyBoolmFilter(int size, CodeRuleInfo codeRuleInfo) {
        this.bloomFilter = BloomFilter.create((Funnel)Funnels.stringFunnel((Charset)Charset.forName("utf-8")), (int)size);
        QFilter qfilter = new QFilter("coderuleid", "=", (Object)codeRuleInfo.getId());
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)MyBoolmFilter.class.getName(), (String)"bos_coderule_intermitno", (String)"sortitemvalue,serial", (QFilter[])new QFilter[]{qfilter}, (String)"");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                this.bloomFilter.put((Object)IntermitNoDetectUtil.buildNumber(row.getString("sortitemvalue"), row.getInteger("serial").intValue()));
            }
        }
    }

    @Override
    public boolean contains(DynamicObject codeRule, String sortItemValue, Long serial) {
        if (this.bloomFilter.mightContain((Object)IntermitNoDetectUtil.buildNumber(sortItemValue, serial))) {
            QFilter qFilter = new QFilter("sortitemvalue", "=", (Object)sortItemValue);
            qFilter.and("serial", "=", (Object)serial);
            qFilter.and("coderuleid", "=", (Object)((String)codeRule.getPkValue()));
            return QueryServiceHelper.exists((String)"bos_coderule_intermitno", (QFilter[])new QFilter[]{qFilter});
        }
        return false;
    }
}

