/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.coderule.util.intermitno.task;

import com.alibaba.fastjson.JSON;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashMap;
import java.util.TimeZone;
import kd.bos.coderule.util.intermitno.task.IntermitNoDetectTask;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class CreateDetectTaskUtil {
    public static final String NUMBER = "number";

    public static void createTask(String[] ids) {
        Arrays.sort(ids);
        DynamicObject job = CreateDetectTaskUtil.createJob(ids);
        DynamicObject schedule = CreateDetectTaskUtil.createSchedule(ids, job);
        ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        scheduleManager.enableJob((String)job.getPkValue());
        scheduleManager.enableSchedule((String)schedule.getPkValue());
    }

    private static DynamicObject createJob(String[] ids) {
        String number = "bos-coderule-" + StringUtils.join((Object[])ids, (String)"-");
        DynamicObject obj = CreateDetectTaskUtil.getExitObject("sch_job", number);
        obj.set(NUMBER, (Object)number);
        obj.set("jobtype", (Object)"BIZ");
        obj.set("taskclassname", CreateDetectTaskUtil.getIntermitDetectTaskDefine());
        obj.set("classname", (Object)IntermitNoDetectTask.class.getName());
        obj.set("runbyuser", (Object)RequestContext.get().getUserId());
        obj.set("status", (Object)"1");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("codeRuleIds", StringUtils.join((Object[])ids, (String)","));
        obj.set("params", (Object)JSON.toJSONString(params));
        DynamicObjectCollection entries = obj.getDynamicObjectCollection("entryentity");
        entries.clear();
        DynamicObject param = new DynamicObject(entries.getDynamicObjectType());
        param.set("paramname", (Object)"codeRuleIds");
        param.set("paramvalue", (Object)StringUtils.join((Object[])ids, (String)","));
        entries.add((Object)param);
        obj.set("name", (Object)ResManager.loadKDString((String)"\u65ad\u53f7\u68c0\u6d4b\u4f5c\u4e1a", (String)"CreateDetectTaskUtil_0", (String)"bos-coderule", (Object[])new Object[0]));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
        return obj;
    }

    public static Object getIntermitDetectTaskDefine() {
        QFilter filter = new QFilter(NUMBER, "=", (Object)"BOS_CODERULE_INTERMITNO_DETECT_TASK");
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"sch_taskdefine", (String)"id", (QFilter[])new QFilter[]{filter});
        if (obj != null) {
            return obj.getPkValue();
        }
        return CreateDetectTaskUtil.innerIntermitNoTaskDefine("BOS_CODERULE_INTERMITNO_DETECT_TASK");
    }

    public static Object innerIntermitNoTaskDefine(String number) {
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"sch_taskdefine");
        obj.set(NUMBER, (Object)number);
        obj.set("name", (Object)ResManager.loadKDString((String)"\u65ad\u53f7\u68c0\u6d4b\u4efb\u52a1", (String)"CreateDetectTaskUtil_1", (String)"bos-coderule", (Object[])new Object[0]));
        obj.set("classname", (Object)IntermitNoDetectTask.class.getName());
        obj.set("appid", (Object)"bos");
        DynamicObjectCollection params = obj.getDynamicObjectCollection("paramentry");
        DynamicObject param = new DynamicObject(params.getDynamicObjectType());
        param.set("paramname", (Object)"codeRuleIds");
        param.set("paramtype", (Object)"1");
        params.add((Object)param);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
        return obj.getPkValue();
    }

    private static DynamicObject createSchedule(String[] ids, DynamicObject job) {
        String number = "bos-coderule-" + StringUtils.join((Object[])ids, (String)"-");
        DynamicObject obj = CreateDetectTaskUtil.getExitObject("sch_schedule", number);
        obj.set(NUMBER, (Object)number);
        obj.set("job", job.getPkValue());
        obj.set("starttime", (Object)CreateDetectTaskUtil.getStartTime());
        obj.set("endtime", (Object)new Timestamp(System.currentTimeMillis() + 315360000000L));
        obj.set("plan", (Object)"0 0 0 * * ?");
        obj.set("repeatmode", (Object)"d");
        obj.set("cyclenum", (Object)1);
        obj.set("txtdesc", (Object)ResManager.loadKDString((String)"\u4e8b\u4ef6\u5c06\u4e8e\u6bcf\u592900:00:00\u91cd\u590d", (String)"CreateDetectTaskUtil_2", (String)"bos-coderule", (Object[])new Object[0]));
        obj.set("combdorw", (Object)"d");
        obj.set("status", (Object)"1");
        obj.set("name", (Object)ResManager.loadKDString((String)"\u65ad\u53f7\u68c0\u6d4b\u4efb\u52a1", (String)"CreateDetectTaskUtil_1", (String)"bos-coderule", (Object[])new Object[0]));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
        return obj;
    }

    private static Timestamp getStartTime() {
        long current = System.currentTimeMillis();
        long zero = current / 86400000L * 86400000L - (long)TimeZone.getDefault().getRawOffset();
        long twelve = zero + 86400000L;
        return new Timestamp(twelve);
    }

    private static DynamicObject getExitObject(String entityId, String number) {
        QFilter qf = new QFilter(NUMBER, "=", (Object)number);
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)entityId, (String)"id", (QFilter[])new QFilter[]{qf});
        if (obj == null) {
            return BusinessDataServiceHelper.newDynamicObject((String)entityId);
        }
        return BusinessDataServiceHelper.loadSingle((Object)obj.get("id"), (String)entityId);
    }
}

