/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.coderule.util.unittest;

import kd.bos.coderule.api.CodeRuleEntryInfo;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.coderule.enums.CodeRuleEntryTypeEnum;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;

public class CodeRuleUtil {
    public static final int TYPE_OF_ADD = 1;
    public static final int TYPE_OF_MODIFY = 2;
    public static final int TYPE_OF_NONBREAK = 3;

    public static CodeRuleInfo buildCustomCodeRuleInfo(String ruleId, int codeRuleType, CustomCodeRuleEntity ... customCodeRules) {
        CodeRuleInfo codeRuleInfo = new CodeRuleInfo();
        codeRuleInfo.setId(ruleId);
        codeRuleInfo.setName("test");
        codeRuleInfo.setIsdefault(Boolean.FALSE);
        codeRuleInfo.setIsAddView(Boolean.FALSE);
        codeRuleInfo.setIsModifiable(Boolean.FALSE);
        codeRuleInfo.setIsNonBreak(Boolean.FALSE);
        switch (codeRuleType) {
            case 1: {
                codeRuleInfo.setIsAddView(Boolean.TRUE);
                break;
            }
            case 2: {
                codeRuleInfo.setIsModifiable(Boolean.TRUE);
                break;
            }
            case 3: {
                codeRuleInfo.setIsNonBreak(Boolean.TRUE);
                break;
            }
        }
        int seq = 0;
        for (CustomCodeRuleEntity customCodeRule : customCodeRules) {
            switch (customCodeRule.getCodeRuleEntryTypeEnum()) {
                case TYPE_FIX_TEXT: {
                    codeRuleInfo.getRuleEntry().add(CodeRuleUtil.buildEntryForFixText(seq, customCodeRule.getFieldValue()));
                    break;
                }
                case TYPE_DATE_FIELD: {
                    codeRuleInfo.getRuleEntry().add(CodeRuleUtil.buildEntryForDateField(seq, customCodeRule.getFieldValue(), customCodeRule.isSortItem()));
                    break;
                }
                case TYPE_ITEM_FIELD: {
                    codeRuleInfo.getRuleEntry().add(CodeRuleUtil.buildEntryForItemField(seq, customCodeRule.getFieldValue(), customCodeRule.isSortItem()));
                    break;
                }
                case TYPE_SEQ: {
                    codeRuleInfo.getRuleEntry().add(CodeRuleUtil.buildEntryForSeq(seq));
                    break;
                }
                case CHECK_CODE: {
                    codeRuleInfo.getRuleEntry().add(CodeRuleUtil.buildEntryForCheckCode(seq));
                    break;
                }
                case TYPE_RANDOM_NUMBER: {
                    codeRuleInfo.getRuleEntry().add(CodeRuleUtil.buildEntryForRandom(seq));
                    break;
                }
                case TYPE_SYSTEM_TIME_FIELD: {
                    codeRuleInfo.getRuleEntry().add(CodeRuleUtil.buildEntryForSystemTime(seq));
                    break;
                }
            }
            ++seq;
        }
        return codeRuleInfo;
    }

    private static CodeRuleEntryInfo buildEntryForFixText(int seq, String fieldValue) {
        CodeRuleEntryInfo ruleEntryInfo = new CodeRuleEntryInfo();
        ruleEntryInfo.setSeq(seq);
        ruleEntryInfo.setAttributeType(CodeRuleEntryTypeEnum.TYPE_FIX_TEXT.getTypeStr());
        ruleEntryInfo.setFormat(fieldValue);
        ruleEntryInfo.setIsSortItem(Boolean.FALSE);
        ruleEntryInfo.setValueAtribute("");
        ruleEntryInfo.setAttUsingMode("1");
        ruleEntryInfo.setLength(8);
        ruleEntryInfo.setCutstyle(Boolean.TRUE);
        ruleEntryInfo.setAddchar("");
        ruleEntryInfo.setAddstyle(Boolean.TRUE);
        ruleEntryInfo.setInitial(1L);
        ruleEntryInfo.setStep(1L);
        ruleEntryInfo.setCodeelement(Boolean.FALSE);
        ruleEntryInfo.setIsSplitSign(Boolean.FALSE);
        ruleEntryInfo.setSplitSign("");
        ruleEntryInfo.setVisable(true);
        return ruleEntryInfo;
    }

    private static CodeRuleEntryInfo buildEntryForDateField(int seq, String fieldValue, boolean isSortItem) {
        CodeRuleEntryInfo ruleEntryInfo = new CodeRuleEntryInfo();
        ruleEntryInfo.setSeq(seq);
        ruleEntryInfo.setAttributeType(CodeRuleEntryTypeEnum.TYPE_DATE_FIELD.getTypeStr());
        ruleEntryInfo.setIsSortItem(Boolean.valueOf(isSortItem));
        ruleEntryInfo.setValueAtribute(fieldValue);
        ruleEntryInfo.setAttUsingMode("1");
        ruleEntryInfo.setLength(8);
        ruleEntryInfo.setCutstyle(Boolean.TRUE);
        ruleEntryInfo.setFormat("yyyyMMdd");
        ruleEntryInfo.setAddchar("");
        ruleEntryInfo.setAddstyle(Boolean.TRUE);
        ruleEntryInfo.setInitial(1L);
        ruleEntryInfo.setStep(1L);
        ruleEntryInfo.setCodeelement(Boolean.FALSE);
        ruleEntryInfo.setIsSplitSign(Boolean.TRUE);
        ruleEntryInfo.setSplitSign("");
        ruleEntryInfo.setVisable(true);
        return ruleEntryInfo;
    }

    private static CodeRuleEntryInfo buildEntryForItemField(int seq, String fieldValue, boolean isSortItem) {
        CodeRuleEntryInfo ruleEntryInfo = new CodeRuleEntryInfo();
        ruleEntryInfo.setSeq(seq);
        ruleEntryInfo.setAttributeType(CodeRuleEntryTypeEnum.TYPE_ITEM_FIELD.getTypeStr());
        ruleEntryInfo.setValueAtribute(fieldValue);
        ruleEntryInfo.setIsSortItem(Boolean.valueOf(isSortItem));
        ruleEntryInfo.setAttUsingMode("3");
        ruleEntryInfo.setLength(8);
        ruleEntryInfo.setCutstyle(Boolean.TRUE);
        ruleEntryInfo.setFormat("");
        ruleEntryInfo.setAddchar("");
        ruleEntryInfo.setAddstyle(Boolean.TRUE);
        ruleEntryInfo.setInitial(1L);
        ruleEntryInfo.setStep(1L);
        ruleEntryInfo.setCodeelement(Boolean.FALSE);
        ruleEntryInfo.setIsSplitSign(Boolean.TRUE);
        ruleEntryInfo.setSplitSign("");
        ruleEntryInfo.setVisable(true);
        return ruleEntryInfo;
    }

    private static CodeRuleEntryInfo buildEntryForSeq(int seq) {
        CodeRuleEntryInfo ruleEntryInfo = new CodeRuleEntryInfo();
        ruleEntryInfo.setSeq(seq);
        ruleEntryInfo.setAttributeType(CodeRuleEntryTypeEnum.TYPE_SEQ.getTypeStr());
        ruleEntryInfo.setValueAtribute("");
        ruleEntryInfo.setAttUsingMode("1");
        ruleEntryInfo.setLength(8);
        ruleEntryInfo.setCutstyle(Boolean.TRUE);
        ruleEntryInfo.setFormat("");
        ruleEntryInfo.setAddchar("");
        ruleEntryInfo.setAddstyle(Boolean.TRUE);
        ruleEntryInfo.setInitial(1L);
        ruleEntryInfo.setStep(1L);
        ruleEntryInfo.setIsSortItem(Boolean.FALSE);
        ruleEntryInfo.setCodeelement(Boolean.FALSE);
        ruleEntryInfo.setIsSplitSign(Boolean.TRUE);
        ruleEntryInfo.setSplitSign("");
        ruleEntryInfo.setVisable(true);
        return ruleEntryInfo;
    }

    private static CodeRuleEntryInfo buildEntryForCheckCode(int seq) {
        CodeRuleEntryInfo ruleEntryInfo = new CodeRuleEntryInfo();
        ruleEntryInfo.setSeq(seq);
        ruleEntryInfo.setAttributeType(CodeRuleEntryTypeEnum.CHECK_CODE.getTypeStr());
        ruleEntryInfo.setValueAtribute("");
        ruleEntryInfo.setAttUsingMode("1");
        ruleEntryInfo.setLength(8);
        ruleEntryInfo.setCutstyle(Boolean.TRUE);
        ruleEntryInfo.setFormat("");
        ruleEntryInfo.setAddchar("");
        ruleEntryInfo.setAddstyle(Boolean.TRUE);
        ruleEntryInfo.setInitial(1L);
        ruleEntryInfo.setStep(1L);
        ruleEntryInfo.setIsSortItem(Boolean.FALSE);
        ruleEntryInfo.setCodeelement(Boolean.FALSE);
        ruleEntryInfo.setVisable(true);
        return ruleEntryInfo;
    }

    private static CodeRuleEntryInfo buildEntryForRandom(int seq) {
        CodeRuleEntryInfo ruleEntryInfo = new CodeRuleEntryInfo();
        ruleEntryInfo.setSeq(seq);
        ruleEntryInfo.setAttributeType(CodeRuleEntryTypeEnum.TYPE_RANDOM_NUMBER.getTypeStr());
        ruleEntryInfo.setValueAtribute("");
        ruleEntryInfo.setAttUsingMode("1");
        ruleEntryInfo.setLength(8);
        ruleEntryInfo.setCutstyle(Boolean.TRUE);
        ruleEntryInfo.setFormat("");
        ruleEntryInfo.setAddchar("");
        ruleEntryInfo.setAddstyle(Boolean.TRUE);
        ruleEntryInfo.setInitial(1L);
        ruleEntryInfo.setStep(1L);
        ruleEntryInfo.setIsSortItem(Boolean.FALSE);
        ruleEntryInfo.setCodeelement(Boolean.FALSE);
        ruleEntryInfo.setVisable(true);
        return ruleEntryInfo;
    }

    private static CodeRuleEntryInfo buildEntryForSystemTime(int seq) {
        CodeRuleEntryInfo ruleEntryInfo = new CodeRuleEntryInfo();
        ruleEntryInfo.setSeq(seq);
        ruleEntryInfo.setAttributeType(CodeRuleEntryTypeEnum.TYPE_DATE_FIELD.getTypeStr());
        ruleEntryInfo.setValueAtribute("");
        ruleEntryInfo.setAttUsingMode("1");
        ruleEntryInfo.setLength(8);
        ruleEntryInfo.setCutstyle(Boolean.TRUE);
        ruleEntryInfo.setFormat("yyyyMMdd");
        ruleEntryInfo.setAddchar("");
        ruleEntryInfo.setAddstyle(Boolean.TRUE);
        ruleEntryInfo.setInitial(1L);
        ruleEntryInfo.setStep(1L);
        ruleEntryInfo.setCodeelement(Boolean.FALSE);
        ruleEntryInfo.setIsSplitSign(Boolean.TRUE);
        ruleEntryInfo.setSplitSign("");
        ruleEntryInfo.setVisable(true);
        return ruleEntryInfo;
    }

    public static void clearNonbreakDB(String codeRuleId) {
        String sql = "delete from T_CR_INTERMITNO where FCODERULEID = '" + codeRuleId + "'";
        DB.execute((DBRoute)DBRoute.base, (String)sql);
    }

    public static class CustomCodeRuleEntity {
        private String fieldValue;
        private boolean sortItem;
        private CodeRuleEntryTypeEnum codeRuleEntryTypeEnum;

        public CustomCodeRuleEntity(String fieldName, CodeRuleEntryTypeEnum codeRuleEntryTypeEnum, boolean sortItem) {
            this.fieldValue = fieldName;
            this.codeRuleEntryTypeEnum = codeRuleEntryTypeEnum;
            this.sortItem = sortItem;
        }

        public CustomCodeRuleEntity(String fieldValue, CodeRuleEntryTypeEnum codeRuleEntryTypeEnum) {
            this.fieldValue = fieldValue;
            this.codeRuleEntryTypeEnum = codeRuleEntryTypeEnum;
        }

        public CustomCodeRuleEntity(CodeRuleEntryTypeEnum codeRuleEntryTypeEnum) {
            this.codeRuleEntryTypeEnum = codeRuleEntryTypeEnum;
        }

        public String getFieldValue() {
            return this.fieldValue;
        }

        public CodeRuleEntryTypeEnum getCodeRuleEntryTypeEnum() {
            return this.codeRuleEntryTypeEnum;
        }

        public boolean isSortItem() {
            return this.sortItem;
        }
    }
}

