/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.generator;

import kd.bos.generator.Config;
import kd.bos.generator.IDGen;
import kd.bos.generator.Signer;
import kd.bos.generator.common.GeneratorException;
import kd.bos.generator.common.Result;
import kd.bos.generator.segment.SegmentSigner;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class IDGenImpl
implements IDGen {
    private static final Log logger = LogFactory.getLog(IDGenImpl.class);
    private Config config;
    private Signer signer;
    private String key;

    public IDGenImpl(String key, Config config) {
        this.key = key;
        this.config = config;
        this.signer = new SegmentSigner.Buidler().build();
    }

    public IDGenImpl(String key, Config config, Signer signer) {
        this.key = key;
        this.config = config;
        this.signer = signer;
    }

    @Override
    public Result read() {
        if (!this.config.isExist()) {
            this.config.init();
        }
        return this.signer.read(this.key);
    }

    @Override
    public Result get() {
        return this.getBy(0);
    }

    @Override
    public Result getBy(int reqSequence) {
        if (!this.config.isExist()) {
            this.config.init();
        }
        return this.signer.getBy(this.key, reqSequence);
    }

    @Override
    @Deprecated
    public void setSigner(Signer signer) {
        throw new GeneratorException(GeneratorException.ErrorCode.ERRCODE_USE_OBSOLETE_METHOD.getCode(), "this is a obsolete method !");
    }
}

