/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.generator.openapi;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.coderule.util.MultiLangEnumBridge;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.api.ApiResult;
import kd.bos.generator.Config;
import kd.bos.generator.ConfigFactory;
import kd.bos.generator.common.GeneratorException;
import kd.bos.generator.openapi.IDGenApi;
import kd.bos.generator.segment.SignerCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

class IDGenApiForSearch {
    IDGenApiForSearch() {
    }

    static ApiResult searchByParam(Map<String, Object> params) {
        Object key = params.get("key");
        if (key == null) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u5fc5\u586b\u53c2\u6570\u672a\u4f20\u9012: key", (String)"IDGenApiForSigner_4", (String)"bos-coderule", (Object[])new Object[0]));
        }
        Object searchEnum = params.get("searchEnum");
        if (searchEnum == null) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u5fc5\u586b\u53c2\u6570\u672a\u4f20\u9012: searchEnum", (String)"IDGenApiForSearch_5", (String)"bos-coderule", (Object[])new Object[0]));
        }
        if (IDGenApi.validateSegmentInDBByKey(key.toString())) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u5173\u952e\u5b57\u5bf9\u5e94\u7684\u53f7\u6bb5\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"IDGenApiForSearch_6", (String)"bos-coderule", (Object[])new Object[0]));
        }
        switch (Objects.requireNonNull(SearchEnum.getEnum(searchEnum.toString()))) {
            case CONFIG_CACHE: {
                return IDGenApiForSearch.searchFromConfigCache(key.toString());
            }
            case SIGNER_CACHE: {
                return IDGenApiForSearch.searchFromSignerCache(key.toString());
            }
            case SEGMENT_INFO: {
                return IDGenApiForSearch.searchFromSegmentInfo(key.toString());
            }
            case RECORD_INFO: {
                return IDGenApiForSearch.searchFromRecordInfo(key.toString());
            }
        }
        return ApiResult.success(null);
    }

    private static ApiResult searchFromConfigCache(String key) {
        LinkedHashMap<String, Number> data = new LinkedHashMap<String, Number>();
        Config searchConfig = ConfigFactory.getInstanceForSearch(key);
        data.put("initNumber", searchConfig.getInitNumber());
        data.put("step", searchConfig.getStep());
        data.put("segmentLength", searchConfig.getSegmentLength());
        return ApiResult.success(data);
    }

    private static ApiResult searchFromSignerCache(String key) {
        LinkedHashMap<String, Long> data = new LinkedHashMap<String, Long>();
        SignerCache cache = SignerCache.getInstance();
        data.put("curSeq", cache.getCurSeq(key));
        data.put("maxSeq", cache.getMaxSeq(key));
        data.put("segmentLength", cache.getSegmentLength(key));
        data.put("version", cache.getVersion(key));
        return ApiResult.success(data);
    }

    private static ApiResult searchFromSegmentInfo(String key) {
        LinkedHashMap<String, Long> data = new LinkedHashMap<String, Long>();
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bos_signer_segment", (String)"curseq,maxseq,segmentlength,version", (QFilter[])new QFilter("key", "=", (Object)key).toArray());
        if (dynamicObjects == null || dynamicObjects.length <= 0) {
            throw new GeneratorException(GeneratorException.ErrorCode.ERRCODE_CHECK_DB_WITHOUT_INIT.getCode(), ResManager.loadKDString((String)"\u6301\u4e45\u5c42\u4e2d\u65e0\u5bf9\u5e94\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u521d\u59cb\u5316\u8fc7\u914d\u7f6e\u3002", (String)"IDGenApiForSearch_7", (String)"bos-coderule", (Object[])new Object[0]));
        }
        data.put("curSeq", dynamicObjects[0].getLong("curseq"));
        data.put("maxSeq", dynamicObjects[0].getLong("maxseq"));
        data.put("segmentLength", dynamicObjects[0].getLong("segmentlength"));
        data.put("version", dynamicObjects[0].getLong("version"));
        return ApiResult.success(data);
    }

    private static ApiResult searchFromRecordInfo(String key) {
        LinkedHashMap datasByVersion = new LinkedHashMap();
        String sql = "select fversion, fconsumeseq from t_signer_record where fkey = ? order by fversion, fconsumeseq asc";
        DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[]{key}, rs -> {
            while (rs.next()) {
                List datas = datasByVersion.computeIfAbsent(rs.getLong("fversion"), r -> new ArrayList());
                LinkedHashMap<String, Long> data = new LinkedHashMap<String, Long>();
                data.put("fversion", rs.getLong("fversion"));
                data.put("fconsumeseq", rs.getLong("fconsumeseq"));
                datas.add(data);
            }
            return null;
        });
        return ApiResult.success(datasByVersion);
    }

    static enum SearchEnum {
        CONFIG_CACHE("config_cache", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u914d\u7f6e\u7f13\u5b58", (String)"IDGenApiForSearch_0", (String)"bos-coderule", (Object[])new Object[0]), "IDGenApiForSearch_0", "bos-coderule")),
        SIGNER_CACHE("signer_cache", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u53d1\u53f7\u7f13\u5b58", (String)"IDGenApiForSearch_1", (String)"bos-coderule", (Object[])new Object[0]), "IDGenApiForSearch_1", "bos-coderule")),
        SEGMENT_INFO("segment_info", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u53f7\u6bb5\u4fe1\u606f", (String)"IDGenApiForSearch_2", (String)"bos-coderule", (Object[])new Object[0]), "IDGenApiForSearch_2", "bos-coderule")),
        RECORD_INFO("record_info", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u6d88\u8d39\u8bb0\u5f55\u4fe1\u606f", (String)"IDGenApiForSearch_3", (String)"bos-coderule", (Object[])new Object[0]), "IDGenApiForSearch_3", "bos-coderule"));

        String value;
        MultiLangEnumBridge bridge;

        private SearchEnum(String value, MultiLangEnumBridge bridge) {
            this.value = value;
            this.bridge = bridge;
        }

        static SearchEnum getEnum(String value) {
            for (SearchEnum searchEnum : SearchEnum.values()) {
                if (!searchEnum.value.equals(value)) continue;
                return searchEnum;
            }
            return null;
        }
    }
}

