/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.generator.segment;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.coderule.handler.TransactionHandler;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDException;
import kd.bos.generator.common.CommonUtil;
import kd.bos.generator.common.SegmentEntryInfo;
import kd.bos.generator.constants.Constants;
import kd.bos.generator.constants.TableConstants;
import kd.bos.generator.segment.CompensatorCache;
import kd.bos.generator.segment.SegmentSigner;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

@Deprecated
public class CompensatorTask
extends AbstractTask
implements Constants,
TableConstants {
    private static final Log logger = LogFactory.getLog(SegmentSigner.class);
    private CompensatorCache compensatorCache = new CompensatorCache();

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
    }

    private void doExecute() {
        String sql = "select fid, fentryid, fkey, fcurseq, fmaxseq, fupdatetime from t_signer_segmententry where fdeletetag = 0";
        List segmentEntryInfos = (List)DB.query((DBRoute)DBRoute.basedata, (String)sql, null, rs -> {
            ArrayList<SegmentEntryInfo> segmentEntryInfosTmp = new ArrayList<SegmentEntryInfo>(8);
            while (rs.next()) {
                long id = rs.getLong("fid");
                long entryid = rs.getLong("fentryid");
                String key = rs.getString("fkey");
                Long curseq = rs.getLong("fcurseq");
                Long maxseq = rs.getLong("fmaxseq");
                Date updatetime = rs.getDate("fupdatetime");
                segmentEntryInfosTmp.add(new SegmentEntryInfo(id, entryid, key, curseq, maxseq, updatetime));
            }
            return segmentEntryInfosTmp;
        });
        Map<String, List<SegmentEntryInfo>> segmentEntryInfosMap = Optional.ofNullable(segmentEntryInfos).map(Collection::stream).orElseGet(Stream::empty).collect(Collectors.groupingBy(SegmentEntryInfo::getKey));
        for (Map.Entry<String, List<SegmentEntryInfo>> entry : segmentEntryInfosMap.entrySet()) {
            this.excuteGroup(entry.getKey(), entry.getValue());
        }
    }

    private void excuteGroup(final String key, List<SegmentEntryInfo> segmentEntryInfos) {
        if (CollectionUtils.isEmpty(segmentEntryInfos) || segmentEntryInfos.size() == 1) {
            return;
        }
        segmentEntryInfos.sort(Comparator.comparing(SegmentEntryInfo::getMaxseq).reversed());
        final ArrayList<SegmentEntryInfo> errorSegmentEntryInfos = new ArrayList<SegmentEntryInfo>(1);
        final ArrayList<SegmentEntryInfo> normalSegmentEntryInfos = new ArrayList<SegmentEntryInfo>(segmentEntryInfos.size());
        for (int i = 0; i < segmentEntryInfos.size(); ++i) {
            SegmentEntryInfo segmentEntryInfo = segmentEntryInfos.get(i);
            if (i == 0) {
                if (!segmentEntryInfo.getCurseq().equals(segmentEntryInfo.getMaxseq())) continue;
                normalSegmentEntryInfos.add(segmentEntryInfo);
                continue;
            }
            if (segmentEntryInfo.getCurseq() < segmentEntryInfo.getMaxseq()) {
                errorSegmentEntryInfos.add(segmentEntryInfo);
                continue;
            }
            normalSegmentEntryInfos.add(segmentEntryInfo);
        }
        Iterator iterator = errorSegmentEntryInfos.iterator();
        java.util.Date date = new java.util.Date();
        while (iterator.hasNext()) {
            SegmentEntryInfo segmentEntryInfo = (SegmentEntryInfo)iterator.next();
            long lastTime = segmentEntryInfo.getUpdatetime().getTime();
            long nowTime = date.getTime();
            if (nowTime - lastTime >= 60000L) continue;
            iterator.remove();
        }
        if (CollectionUtils.isNotEmpty(errorSegmentEntryInfos)) {
            new TransactionHandler(ResManager.loadKDString((String)"[CompensatorTask][excuteGroup]\u4e8b\u52a1\u9519\u8bef", (String)"CompensatorTask_1", (String)"bos-coderule", (Object[])new Object[0])){

                @Override
                protected void transactionProcess() {
                    CompensatorTask.this.updateDeleteTag(errorSegmentEntryInfos);
                    CompensatorTask.this.insertCompensator(errorSegmentEntryInfos);
                    CompensatorTask.this.compensatorCache.put(key, String.valueOf(true));
                }
            }.process();
        }
        if (CollectionUtils.isNotEmpty(normalSegmentEntryInfos)) {
            new TransactionHandler(ResManager.loadKDString((String)"[CompensatorTask][excuteGroup]\u9ad8\u6027\u80fd\u4fee\u6539\u6807\u8bb0\u4f4d\u5931\u8d25", (String)"CompensatorTask_2", (String)"bos-coderule", (Object[])new Object[0])){

                @Override
                protected void transactionProcess() {
                    CompensatorTask.this.updateDeleteTag(normalSegmentEntryInfos);
                }
            }.process();
        }
    }

    private void updateDeleteTag(List<SegmentEntryInfo> segmentEntryInfos) {
        StringBuilder sqlStrb = new StringBuilder();
        String sql = "update t_signer_segmententry set fdeletetag = 1 where fentryid in (";
        sqlStrb.append(sql);
        for (SegmentEntryInfo segmentEntryInfo : segmentEntryInfos) {
            sqlStrb.append('\'').append(segmentEntryInfo.getEntryid()).append('\'').append(',');
        }
        sqlStrb.deleteCharAt(sqlStrb.length() - 1);
        sqlStrb.append(')');
        boolean execute = DB.execute((DBRoute)DBRoute.basedata, (String)sqlStrb.toString(), null);
        if (!execute) {
            logger.warn("[CompensatorTask][\u66f4\u65b0\u53f7\u6bb5\u5206\u5f55\u6807\u8bc6\u5931\u8d25]SQL:" + sql);
        }
    }

    private void insertCompensator(List<SegmentEntryInfo> errorSegmentEntryInfos) {
        for (SegmentEntryInfo errorSegmentEntryInfo : errorSegmentEntryInfos) {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"bos_signer_compensator");
            DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)dataEntityType);
            CommonUtil.buildCommonParam(dynamicObject);
            dynamicObject.set("key", (Object)errorSegmentEntryInfo.getKey());
            dynamicObject.set("startseq", (Object)(errorSegmentEntryInfo.getCurseq() + 1L));
            dynamicObject.set("endseq", (Object)errorSegmentEntryInfo.getMaxseq());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
    }
}

