/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.generator.segment;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.generator.common.cache.Cache;
import kd.bos.generator.common.cache.DistributeCache;
import kd.bos.generator.constants.RedisConstants;

public class ConfigCache
implements RedisConstants {
    private Cache cache = new DistributeCache();
    private static final int TIMEOUT_SECONDS = 1800;
    private static ConfigCache configCache = new ConfigCache();

    private ConfigCache() {
    }

    public static ConfigCache getInstance() {
        return configCache;
    }

    public void put(String key, String value) {
        this.cache.put("IDGEN_SIGNER_CONFIG_" + key, value);
    }

    public String get(String key) {
        return this.cache.get("IDGEN_SIGNER_CONFIG_" + key);
    }

    public void put(String key, DynamicObject dynamicObject, String ... mapKeys) {
        HashMap<String, String> map = new HashMap<String, String>(mapKeys.length);
        for (String mapKey : mapKeys) {
            map.put(mapKey, dynamicObject.getString(mapKey));
        }
        this.cache.putMap("IDGEN_SIGNER_CONFIG_" + key, map, 1800);
    }

    public String getMapValue(String key, String mapKey) {
        return this.cache.getMapValue("IDGEN_SIGNER_CONFIG_" + key, mapKey);
    }

    public Map<String, String> getAll(String key) {
        return this.cache.getMap("IDGEN_SIGNER_CONFIG_" + key);
    }

    public void remove(String key) {
        this.cache.remove("IDGEN_SIGNER_CONFIG_" + key);
    }

    public void expireAfter(String key) {
        this.cache.expireAfter("IDGEN_SIGNER_CONFIG_" + key, 1800);
    }
}

