/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.generator.segment;

import java.util.Optional;
import java.util.function.Supplier;
import kd.bos.coderule.handler.SyncHandler;
import kd.bos.coderule.handler.TransactionHandler;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.generator.Config;
import kd.bos.generator.common.CommonUtil;
import kd.bos.generator.common.GeneratorException;
import kd.bos.generator.constants.TableConstants;
import kd.bos.generator.constants.field.ConfigFieldConstants;
import kd.bos.generator.segment.ConfigCache;
import kd.bos.generator.segment.SignerCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class SegmentConfig
implements Config,
ConfigFieldConstants,
TableConstants {
    private static final Log logger = LogFactory.getLog(SegmentConfig.class);
    private String key;
    private long initNumber;
    private int step;
    private long segmentLength;
    private long version;
    private ConfigCache configCache;
    private SignerCache segmentCache;
    private Supplier<Optional<Long>> getMaxNumberForInit;
    private static final String LOCK_PREFIX = "SIGNER_CONFIG_INIT_DB_PREFIX_";

    public SegmentConfig(Buidler buidler) {
        this.configCache = buidler.configCache;
        this.segmentCache = buidler.segmentCache;
        this.key = buidler.key;
        this.initNumber = buidler.initNumber;
        this.step = buidler.step;
        this.segmentLength = buidler.segmentLength;
        this.version = buidler.version;
        this.getMaxNumberForInit = buidler.getMaxNumberForInit;
    }

    @Override
    public boolean isExist() {
        if (CollectionUtils.isEmpty(this.configCache.getAll(this.key))) {
            logger.info("[isExist]\u7f13\u5b58\u4e2d\u4e0d\u5b58\u5728\u5bf9\u5e94key\u7684\u914d\u7f6e,key:" + this.key);
            this.reloadToCache();
            if (CollectionUtils.isEmpty(this.configCache.getAll(this.key))) {
                return false;
            }
        }
        this.configCache.expireAfter(this.key);
        return true;
    }

    private void reloadToCache() {
        DynamicObject[] dynamicObjects = this.getSignerConfigFromDB();
        if (dynamicObjects == null || dynamicObjects.length <= 0) {
            logger.info("[isExist]\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728\u5bf9\u5e94key\u7684\u914d\u7f6e,key:" + this.key);
            return;
        }
        this.saveCache(this.key, dynamicObjects[0]);
    }

    private DynamicObject[] getSignerConfigFromDB() {
        return BusinessDataServiceHelper.load((String)"bos_signer_config", (String)"initnumber, step, segmentlength", (QFilter[])new QFilter("key", "=", (Object)this.key).toArray());
    }

    @Override
    public long getInitNumber() {
        String result = this.configCache.getMapValue(this.key, "initnumber");
        return Long.parseLong(result);
    }

    @Override
    public int getStep() {
        String result = this.configCache.getMapValue(this.key, "step");
        return Integer.parseInt(result);
    }

    @Override
    public void setStep(final int step) {
        this.step = step;
        final String sql = "update t_signer_config set fstep = ? where fkey = ?";
        new TransactionHandler(ResManager.loadKDString((String)"[SegmentConfig][setStep]\u53d1\u53f7\u5668\u4fee\u6539\u6b65\u957f\u5931\u8d25", (String)"SegmentConfig_0", (String)"bos-coderule", (Object[])new Object[0])){

            @Override
            protected void transactionProcess() {
                DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[]{step, SegmentConfig.this.key});
            }
        };
        this.configCache.remove(this.key);
    }

    @Override
    public long getSegmentLength() {
        String result = this.configCache.getMapValue(this.key, "segmentlength");
        return Long.parseLong(result);
    }

    @Override
    public void init() {
        if (StringUtils.isEmpty((CharSequence)this.key)) {
            throw new GeneratorException(GeneratorException.ErrorCode.ERRCODE_INIT_WITHOUT_KEY.getCode(), ResManager.loadKDString((String)"\u6784\u9020\u914d\u7f6e\u4fe1\u606f\u5bf9\u8c61\u65f6, \u672a\u4f20\u5165key, \u65e0\u6cd5\u521d\u59cb\u5316\u3002", (String)"SegmentConfig_1", (String)"bos-coderule", (Object[])new Object[0]));
        }
        DynamicObject[] configs = this.getSignerConfigFromDB();
        if (configs != null && configs.length > 0) {
            logger.info("[CodeRuleSegmentConfig#init]db\u5b58\u5728\u914d\u7f6e\u4fe1\u606f\uff0c\u540c\u6b65\u5230reids\uff1a" + this.key);
            this.saveCache(this.key, configs[0]);
            return;
        }
        final String dLockKey = LOCK_PREFIX + this.key;
        new SyncHandler(dLockKey){

            @Override
            protected void syncProcess() {
                DynamicObject[] configs = SegmentConfig.this.getSignerConfigFromDB();
                if (configs != null && configs.length > 0) {
                    return;
                }
                SegmentConfig.this.initToDB();
            }

            @Override
            protected void beforeSyncProcess() {
                logger.info("[SegmentConfig#init]\u5f00\u59cb\u521d\u59cb\u5316\u914d\u7f6e\u5230\u6570\u636e\u5e93-dLockKey:" + dLockKey);
            }

            @Override
            protected void afterSyncProcess() {
                logger.info("[SegmentConfig#init]\u7ed3\u675f\u521d\u59cb\u5316\u914d\u7f6e\u5230\u6570\u636e\u5e93-dLockKey:" + dLockKey);
            }
        }.process();
    }

    public void initToDB() {
        new TransactionHandler(String.format(ResManager.loadKDString((String)"[SegmentConfig][insertSegment]\u65b0\u589e\u53f7\u6bb5\u5931\u8d25,key:%s", (String)"SegmentConfig_3", (String)"bos-coderule", (Object[])new Object[0]), this.key)){

            @Override
            protected void transactionProcess() {
                SegmentConfig.this.persistenceConfig();
                SegmentConfig.this.insertSegment();
            }

            @Override
            protected void afterSucess() {
                SegmentConfig.this.reloadToCache();
            }

            @Override
            protected void doError(Exception e) {
                throw new GeneratorException(GeneratorException.ErrorCode.ERRCODE_INIT_PERSISTENCE.getCode(), e.getMessage(), e);
            }
        };
    }

    private DynamicObject persistenceConfig() {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"bos_signer_config");
        DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)dataEntityType);
        CommonUtil.buildCommonParam(dynamicObject);
        dynamicObject.set("key", (Object)this.key);
        Long initNum = this.getMaxNumberForInit.get().orElse(this.initNumber);
        dynamicObject.set("initnumber", (Object)initNum);
        dynamicObject.set("segmentlength", (Object)this.segmentLength);
        dynamicObject.set("step", (Object)this.step);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        logger.info("[init]\u914d\u7f6e\u6301\u4e45\u5316\u5230DB,key:" + this.key);
        return dynamicObject;
    }

    private void insertSegment() {
        boolean exists = QueryServiceHelper.exists((String)"bos_signer_segment", (QFilter[])new QFilter("key", "=", (Object)this.key).toArray());
        if (exists) {
            return;
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"bos_signer_segment");
        DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)dataEntityType);
        CommonUtil.buildCommonParam(dynamicObject);
        dynamicObject.set("key", (Object)this.key);
        long initNum = this.getMaxNumberForInit.get().orElse(this.initNumber);
        dynamicObject.set("curseq", (Object)(initNum / this.segmentLength * this.segmentLength));
        dynamicObject.set("segmentlength", (Object)this.segmentLength);
        dynamicObject.set("maxseq", (Object)(initNum / this.segmentLength * this.segmentLength + this.segmentLength));
        dynamicObject.set("version", (Object)0);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        logger.info("[init]\u65b0\u5efa\u5bf9\u5e94key\u7684\u53f7\u6bb5\u8868\u4fe1\u606f,key:" + this.key);
    }

    private void saveCache(String key, DynamicObject dynamicObject) {
        this.configCache.put(key, dynamicObject, "initnumber", "step", "segmentlength");
    }

    @Override
    public boolean clear() {
        if (StringUtils.isEmpty((CharSequence)this.key)) {
            throw new GeneratorException(GeneratorException.ErrorCode.ERRCODE_INIT_WITHOUT_KEY.getCode(), ResManager.loadKDString((String)"\u6784\u9020\u914d\u7f6e\u4fe1\u606f\u5bf9\u8c61\u65f6, \u672a\u4f20\u5165key, \u65e0\u6cd5\u521d\u59cb\u5316\u3002", (String)"SegmentConfig_1", (String)"bos-coderule", (Object[])new Object[0]));
        }
        new TransactionHandler(String.format(ResManager.loadKDString((String)"[SegmentConfig][clear]\u6e05\u9664\u914d\u7f6e\u5931\u8d25,key:%s", (String)"SegmentConfig_4", (String)"bos-coderule", (Object[])new Object[0]), this.key)){

            @Override
            protected void transactionProcess() {
                int deleteSignerConfig = DeleteServiceHelper.delete((String)"bos_signer_config", (QFilter[])new QFilter("key", "=", (Object)SegmentConfig.this.key).toArray());
                int deleteSignerSegment = DeleteServiceHelper.delete((String)"bos_signer_segment", (QFilter[])new QFilter("key", "=", (Object)SegmentConfig.this.key).toArray());
                String sql = "delete from t_signer_record where fkey = ?";
                boolean execute = DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[]{SegmentConfig.this.key});
                logger.info(String.format("[SegmentConfig][clear]\u6e05\u9664\u914d\u7f6e\u7ed3\u679c,key:%s,\u914d\u7f6e\u8868\u72b6\u6001:%s,\u53f7\u6bb5\u8868\u72b6\u6001:%s,\u6d88\u8d39\u8868\u72b6\u6001:%s", SegmentConfig.this.key, deleteSignerConfig, deleteSignerSegment, execute));
            }
        };
        this.configCache.remove(this.key);
        this.segmentCache.clearAll(this.key);
        return true;
    }

    @Override
    public void rebuild() {
        this.clear();
        this.init();
    }

    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public boolean updateCurseq(String key, long number) {
        return this.segmentCache.updateCurseqIfCompare(key, number);
    }

    @Deprecated
    public SegmentConfig(String key, long initNumber, int step, long segmentLength, boolean isCompensate) {
        throw new GeneratorException(GeneratorException.ErrorCode.ERRCODE_USE_OBSOLETE_METHOD.getCode(), "this is a obsolete method !");
    }

    @Deprecated
    public SegmentConfig(String key) {
        throw new GeneratorException(GeneratorException.ErrorCode.ERRCODE_USE_OBSOLETE_METHOD.getCode(), "this is a obsolete method !");
    }

    @Deprecated
    public SegmentConfig(String key, long initNumber, int step, long segmentLength) {
        throw new GeneratorException(GeneratorException.ErrorCode.ERRCODE_USE_OBSOLETE_METHOD.getCode(), "this is a obsolete method !");
    }

    @Override
    @Deprecated
    public boolean isCompensate() {
        throw new GeneratorException(GeneratorException.ErrorCode.ERRCODE_USE_OBSOLETE_METHOD.getCode(), "this is a obsolete method !");
    }

    @Override
    public long getVersion(String key) {
        return this.segmentCache.getVersion(key);
    }

    public static class Buidler {
        private String key = "";
        private long initNumber = 0L;
        private int step = 0;
        private long segmentLength = 0L;
        private long version = 0L;
        private ConfigCache configCache = ConfigCache.getInstance();
        private SignerCache segmentCache = SignerCache.getInstance();
        private Supplier<Optional<Long>> getMaxNumberForInit = Optional::empty;

        public SegmentConfig build() {
            if (StringUtils.isBlank((CharSequence)this.key)) {
                throw new GeneratorException(GeneratorException.ErrorCode.ERRCODE_INIT_WITHOUT_KEY.getCode(), ResManager.loadKDString((String)"\u6784\u5efa SegmentConfig \u5bf9\u8c61\u5931\u8d25\uff0c\u8bf7\u586b\u5199 key", (String)"SegmentConfig_5", (String)"bos-coderule", (Object[])new Object[0]));
            }
            return new SegmentConfig(this);
        }

        public Buidler setKey(String key) {
            this.key = key;
            return this;
        }

        public Buidler setInitNumber(long initNumber) {
            this.initNumber = initNumber;
            return this;
        }

        public Buidler setStep(int step) {
            this.step = step;
            return this;
        }

        public Buidler setSegmentLength(long segmentLength) {
            this.segmentLength = segmentLength;
            return this;
        }

        public Buidler setGetMaxNumberForInit(Supplier<Optional<Long>> getMaxNumberForInit) {
            this.getMaxNumberForInit = getMaxNumberForInit;
            return this;
        }

        public Buidler setVersion(long version) {
            this.version = version;
            return this;
        }
    }
}

