/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.generator.segment;

import java.util.function.Consumer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.generator.common.GeneratorException;
import kd.bos.generator.segment.AbstractSegmentSigner;
import kd.bos.generator.segment.ReleaseTypeEnum;
import kd.bos.generator.segment.SignerCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPools;

public class SegmentSigner
extends AbstractSegmentSigner {
    private static final Log logger = LogFactory.getLog(SegmentSigner.class);

    public SegmentSigner(Buidler buidler) {
        super(buidler.signerCache, buidler.callbackAtRelease);
    }

    @Override
    protected void rebuildSegmentCacheByReleaseType(ReleaseTypeEnum releaseTypeEnum, String key, int reqSequence) {
        this.releaseSegment(key, releaseTypeEnum, reqSequence);
    }

    private boolean preheatHandler(ReleaseTypeEnum releaseTypeEnum, String key, int reqSequence) {
        if (ReleaseTypeEnum.PREHEAT == releaseTypeEnum) {
            if (this.signerCache.validatePreheatTag(key)) {
                logger.debug("[preheatHandler]\u9884\u70ed\u6807\u8bb0\u5df2\u5f00, \u66f4\u65b0\u53f7\u6bb5\u7a0b\u5e8f\u5728\u5f02\u6b65\u6267\u884c\u4e2d, \u6b64\u5904\u62e6\u622a\u4e0d\u505a\u9884\u70ed");
                return true;
            }
            this.signerCache.putPreheatTag(key);
            ThreadPools.executeOnce((String)ResManager.loadKDString((String)"\u6267\u884c\u53d1\u53f7\u6bb5\u7ebf\u7a0b", (String)"SegmentSigner_0", (String)"bos-coderule", (Object[])new Object[0]), () -> {
                try {
                    this.releaseSegment(key, releaseTypeEnum, reqSequence);
                }
                finally {
                    this.signerCache.removePreheatTag(key);
                }
            });
            return true;
        }
        return false;
    }

    @Deprecated
    public SegmentSigner() {
        throw new GeneratorException(GeneratorException.ErrorCode.ERRCODE_USE_OBSOLETE_METHOD.getCode(), "this is a obsolete method !");
    }

    public static class Buidler {
        private SignerCache signerCache = SignerCache.getInstance();
        private Consumer<ReleaseTypeEnum> callbackAtRelease = releaseTypeEnum -> {};

        public SegmentSigner build() {
            return new SegmentSigner(this);
        }

        public Buidler setCallbackAtRelease(Consumer<ReleaseTypeEnum> callbackAtRelease) {
            this.callbackAtRelease = callbackAtRelease;
            return this;
        }
    }
}

