/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.generator.segment;

import kd.bos.generator.common.cache.Cache;
import kd.bos.generator.common.cache.DistributeCache;
import kd.bos.generator.constants.RedisConstants;
import org.apache.commons.lang3.StringUtils;

public class SignerCache
implements RedisConstants {
    private Cache cache = new DistributeCache();
    private static SignerCache signerCache = new SignerCache();

    private SignerCache() {
    }

    public static SignerCache getInstance() {
        return signerCache;
    }

    public void clearAll(String key) {
        this.cache.remove("IDGEN_SIGNER_CURSEQ_" + key);
        this.cache.remove("IDGEN_SIGNER_MAXSEQ_" + key);
        this.cache.remove("IDGEN_SIGNER_SEGMENTLENGTH_" + key);
        this.cache.remove("IDGEN_SIGNER_VERSION_" + key);
    }

    public long incr(String key) {
        return this.cache.incr("IDGEN_SIGNER_CURSEQ_" + key);
    }

    public long incrStep(String key, int step) {
        return this.cache.incrStep("IDGEN_SIGNER_CURSEQ_" + key, step);
    }

    public Long getMaxSeq(String key) {
        String str = this.cache.get("IDGEN_SIGNER_MAXSEQ_" + key);
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        return Long.valueOf(str);
    }

    public Long getCurSeq(String key) {
        String str = this.cache.get("IDGEN_SIGNER_CURSEQ_" + key);
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        return Long.valueOf(str);
    }

    public Long getSegmentLength(String key) {
        String str = this.cache.get("IDGEN_SIGNER_SEGMENTLENGTH_" + key);
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        return Long.valueOf(str);
    }

    public Long getVersion(String key) {
        String str = this.cache.get("IDGEN_SIGNER_VERSION_" + key);
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        return Long.valueOf(str);
    }

    public boolean isExistAtomatic(String key) {
        Long maxSeq = this.getMaxSeq(key);
        Long curSeq = this.getCurSeq(key);
        Long segmentLength = this.getSegmentLength(key);
        Long version = this.getVersion(key);
        return maxSeq != null && curSeq != null && segmentLength != null && version != null;
    }

    public void putAll(String key, long curSeq, long maxSeq, long segmentLength, long version) {
        this.cache.put("IDGEN_SIGNER_CURSEQ_" + key, String.valueOf(curSeq), 0);
        this.cache.put("IDGEN_SIGNER_MAXSEQ_" + key, String.valueOf(maxSeq), 0);
        this.cache.put("IDGEN_SIGNER_SEGMENTLENGTH_" + key, String.valueOf(segmentLength), 0);
        this.cache.put("IDGEN_SIGNER_VERSION_" + key, String.valueOf(version), 0);
    }

    public void putAllWithoutCurseq(String key, long maxSeq, long segmentLength, long version) {
        this.cache.put("IDGEN_SIGNER_MAXSEQ_" + key, String.valueOf(maxSeq), 0);
        this.cache.put("IDGEN_SIGNER_SEGMENTLENGTH_" + key, String.valueOf(segmentLength), 0);
        this.cache.put("IDGEN_SIGNER_VERSION_" + key, String.valueOf(version), 0);
    }

    public void putWithPreHeat(String key, long maxSeq, long version) {
        this.cache.put("IDGEN_SIGNER_MAXSEQ_" + key, String.valueOf(maxSeq), 0);
        this.cache.put("IDGEN_SIGNER_VERSION_" + key, String.valueOf(version), 0);
    }

    public void putPreheatTag(String key) {
        this.cache.put("IDGEN_SIGNER_PERHEAT_" + key, String.valueOf(true), 0);
    }

    public void removePreheatTag(String key) {
        this.cache.remove("IDGEN_SIGNER_PERHEAT_" + key);
    }

    public boolean validatePreheatTag(String key) {
        String str = this.cache.get("IDGEN_SIGNER_PERHEAT_" + key);
        return StringUtils.isNotBlank((CharSequence)str) && str.equals(String.valueOf(true));
    }

    public boolean updateCurseqIfCompare(String key, long number) {
        return this.cache.compareAndSet("IDGEN_SIGNER_CURSEQ_" + key, number);
    }
}

