/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.generator.segment.db;

import java.util.Date;
import kd.bos.atomicincr.AtomicIncrement;
import kd.bos.coderule.handler.TransactionHandler;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.generator.common.CommonUtil;
import kd.bos.generator.common.GeneratorException;
import kd.bos.generator.segment.db.ConfigDAO;
import kd.bos.generator.segment.db.DBConfig;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class ConfigDAOImpl
implements ConfigDAO {
    private static final Log log = LogFactory.getLog(ConfigDAOImpl.class);
    private static final String BOS_SIGNER_CONFIG = "bos_signer_config";
    private static final String BOS_SIGNER_CONFIG_TABLE = "t_signer_config";
    private static final String KEY = "key";
    private static final String STEP = "step";
    private static final String INIT_NUMBER = "initnumber";
    private static final String SEGMENT_LENGTH = "segmentlength";
    private static final String LOCK_PREFIX = "SIGNER_CONFIG_INIT_DB_PREFIX_";
    private static final AtomicIncrement atomicIncrement = AtomicIncrement.getInstance((String)"coderule");

    @Override
    public int getStep(String key) {
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)BOS_SIGNER_CONFIG, (String)STEP, (QFilter[])new QFilter(KEY, "=", (Object)key).toArray());
        return dynamicObject.getInt(STEP);
    }

    @Override
    public void setStep(final String key, final int step) {
        final String sql = "update t_signer_config set fstep = ? where fkey = ?";
        new TransactionHandler(ResManager.loadKDString((String)"[SegmentConfig][setStep]\u53d1\u53f7\u5668\u4fee\u6539\u6b65\u957f\u5931\u8d25", (String)"SegmentConfig_0", (String)"bos-coderule", (Object[])new Object[0])){

            @Override
            protected void transactionProcess() {
                DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[]{step, key});
            }
        };
    }

    @Override
    public boolean isExist(String key) {
        return QueryServiceHelper.exists((String)BOS_SIGNER_CONFIG, (QFilter[])new QFilter(KEY, "=", (Object)key).toArray());
    }

    @Override
    public void initConfig(final DBConfig config) {
        new TransactionHandler(String.format(ResManager.loadKDString((String)"[ConfigDAOImpl]\u65b0\u589e\u53f7\u6bb5\u5931\u8d25\uff0ckey:%s", (String)"BOS_CODERULE_2", (String)"bos-coderule", (Object[])new Object[0]), config.key)){

            @Override
            protected void transactionProcess() {
                Long initNum = ConfigDAOImpl.this.persistenceConfig(config);
                atomicIncrement.setnx(config.key, initNum.longValue());
                ConfigDAOImpl.this.insertMaxSerialInfo(config);
                log.info("[CodeRule]\u521d\u59cb\u5316\u914d\u7f6e\u4fe1\u606f\u3002");
            }

            @Override
            protected void doError(Exception e) {
                throw new GeneratorException(GeneratorException.ErrorCode.ERRCODE_INIT_PERSISTENCE.getCode(), e.getMessage(), e);
            }
        };
    }

    private void insertMaxSerialInfo(DBConfig config) {
        QFilter qFilter = new QFilter("codeRuleID", "=", (Object)config.codeRuleId).and(new QFilter("sortitemvalue", "=", (Object)config.sortItem));
        boolean isExist = QueryServiceHelper.exists((String)"bos_coderule_maxserial", (QFilter[])qFilter.toArray());
        if (isExist) {
            return;
        }
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"bos_coderule_maxserial");
        DynamicObject dynaObj = new DynamicObject((DynamicObjectType)dt);
        dynaObj.set("codeRuleID", (Object)config.codeRuleId);
        dynaObj.set("seqsegmententryid", (Object)"");
        dynaObj.set("sortitemvalue", (Object)config.sortItem);
        dynaObj.set("maxserial", (Object)0);
        dynaObj.set("initserial", (Object)0);
        Date date = new Date();
        dynaObj.set("createdate", (Object)date);
        dynaObj.set("modifydate", (Object)date);
        dynaObj.set("creater_id", (Object)RequestContext.get().getCurrUserId());
        SaveServiceHelper.save((IDataEntityType)dt, (Object[])new DynamicObject[]{dynaObj});
    }

    private Long persistenceConfig(DBConfig config) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)BOS_SIGNER_CONFIG);
        DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)dataEntityType);
        CommonUtil.buildCommonParam(dynamicObject);
        dynamicObject.set(KEY, (Object)config.key);
        Long initNum = config.getMaxNumberForInit.get().orElse(config.initNumber);
        dynamicObject.set(INIT_NUMBER, (Object)initNum);
        dynamicObject.set(SEGMENT_LENGTH, (Object)config.segmentLength);
        dynamicObject.set(STEP, (Object)config.step);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        log.info("[init]\u521d\u59cb\u5316\u914d\u7f6e\uff0ckey:" + config.key);
        return initNum;
    }

    @Override
    public boolean clear(final String key) {
        if (StringUtils.isEmpty((CharSequence)key)) {
            throw new GeneratorException(GeneratorException.ErrorCode.ERRCODE_INIT_WITHOUT_KEY.getCode(), ResManager.loadKDString((String)"\u6784\u9020\u914d\u7f6e\u4fe1\u606f\u5bf9\u8c61\u65f6, \u672a\u4f20\u5165key, \u65e0\u6cd5\u521d\u59cb\u5316\u3002", (String)"SegmentConfig_1", (String)"bos-coderule", (Object[])new Object[0]));
        }
        new TransactionHandler(String.format(ResManager.loadKDString((String)"[ConfigDAOImpl][clear]\u6e05\u9664\u914d\u7f6e\u5931\u8d25,key:%s", (String)"BOS_CODERULE_3", (String)"bos-coderule", (Object[])new Object[0]), key)){

            @Override
            protected void transactionProcess() {
                int deleteSignerConfig = DeleteServiceHelper.delete((String)ConfigDAOImpl.BOS_SIGNER_CONFIG, (QFilter[])new QFilter(ConfigDAOImpl.KEY, "=", (Object)key).toArray());
                atomicIncrement.del(key);
                log.info(String.format("[ConfigDAOImpl][clear]\u6e05\u9664\u914d\u7f6e\u7ed3\u679c,key:%s,\u914d\u7f6e\u8868\u72b6\u6001:%s,\u53f7\u6bb5\u8868", key, deleteSignerConfig));
            }
        };
        return false;
    }

    @Override
    public long getInitNumber(String key) {
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)BOS_SIGNER_CONFIG, (String)INIT_NUMBER, (QFilter[])new QFilter(KEY, "=", (Object)key).toArray());
        return dynamicObject.getLong(INIT_NUMBER);
    }

    @Override
    public boolean updateCurSeq(String key, long curSeq) {
        return atomicIncrement.compareAndSet(key, curSeq);
    }

    @Override
    @Deprecated
    public long getVersion(String key) {
        throw new KDException(new ErrorCode("Deprecated_method", ResManager.loadKDString((String)"\u65b9\u6cd5\u5df2\u5e9f\u5f03\uff0c\u8bf7\u52ff\u4f7f\u7528\u3002", (String)"BOS_CODERULE_1", (String)"bos-coderule", (Object[])new Object[0])), new Object[0]);
    }

    @Override
    @Deprecated
    public long getSegmentLength(String key) {
        throw new KDException(new ErrorCode("Deprecated_method", ResManager.loadKDString((String)"\u65b9\u6cd5\u5df2\u5e9f\u5f03\uff0c\u8bf7\u52ff\u4f7f\u7528\u3002", (String)"BOS_CODERULE_1", (String)"bos-coderule", (Object[])new Object[0])), new Object[0]);
    }
}

