/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.generator.segment.db;

import java.util.Optional;
import java.util.function.Supplier;
import kd.bos.coderule.handler.SyncHandler;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.generator.Config;
import kd.bos.generator.common.CommonUtil;
import kd.bos.generator.common.GeneratorException;
import kd.bos.generator.segment.db.ConfigDAO;
import kd.bos.generator.segment.db.ConfigDAOImpl;
import kd.bos.generator.segment.db.SignerDAO;
import kd.bos.generator.segment.db.SignerDAOImpl;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang3.StringUtils;

public class DBConfig
implements Config {
    private static final Log logger = LogFactory.getLog(DBConfig.class);
    protected String key;
    protected String codeRuleId;
    protected String sortItem;
    protected long initNumber;
    protected int step;
    protected long segmentLength;
    protected long version;
    private static ConfigDAO configDAO = new ConfigDAOImpl();
    private static SignerDAO signerDAO = new SignerDAOImpl();
    protected Supplier<Optional<Long>> getMaxNumberForInit;
    private static final String LOCK_PREFIX = "SIGNER_CONFIG_INIT_DB_PREFIX_";

    public DBConfig(String codeRuleId, String sortItem) {
        this.key = CommonUtil.getGeneratorKey(codeRuleId, sortItem);
        this.codeRuleId = codeRuleId;
        this.sortItem = sortItem;
    }

    public DBConfig(String codeRuleId, String sortItem, long initNumber, int step, long segmentLength) {
        this(codeRuleId, sortItem);
        this.initNumber = initNumber;
        this.step = step;
        this.segmentLength = segmentLength;
        this.getMaxNumberForInit = Optional::empty;
    }

    public DBConfig(String codeRuleId, String sortItem, long initNumber, int step, long segmentLength, Supplier<Optional<Long>> getMaxNumberForInit) {
        this(codeRuleId, sortItem, initNumber, step, segmentLength);
        this.getMaxNumberForInit = getMaxNumberForInit;
    }

    @Override
    public void init() {
        if (StringUtils.isEmpty((CharSequence)this.key)) {
            throw new GeneratorException(GeneratorException.ErrorCode.ERRCODE_INIT_WITHOUT_KEY.getCode(), ResManager.loadKDString((String)"\u6784\u9020\u914d\u7f6e\u4fe1\u606f\u5bf9\u8c61\u65f6, \u672a\u4f20\u5165key, \u65e0\u6cd5\u521d\u59cb\u5316\u3002", (String)"SegmentConfig_1", (String)"bos-coderule", (Object[])new Object[0]));
        }
        if (this.isExist()) {
            return;
        }
        final String dLockKey = LOCK_PREFIX + this.key;
        final DBConfig config = this;
        new SyncHandler(dLockKey){

            @Override
            protected void syncProcess() {
                if (DBConfig.this.isExist()) {
                    return;
                }
                configDAO.initConfig(config);
            }

            @Override
            protected void beforeSyncProcess() {
                logger.info("[DBConfig#init]\u5f00\u59cb\u521d\u59cb\u5316\u914d\u7f6e\u5230\u6570\u636e\u5e93-dLockKey:" + dLockKey);
            }

            @Override
            protected void afterSyncProcess() {
                logger.info("[DBConfig#init]\u7ed3\u675f\u521d\u59cb\u5316\u914d\u7f6e\u5230\u6570\u636e\u5e93-dLockKey:" + dLockKey);
            }
        }.process();
    }

    @Override
    public boolean clear() {
        return configDAO.clear(this.key);
    }

    @Override
    public void rebuild() {
        this.clear();
        this.init();
    }

    @Override
    public boolean isExist() {
        return configDAO.isExist(this.key);
    }

    @Override
    public long getInitNumber() {
        return configDAO.getInitNumber(this.key);
    }

    @Override
    public int getStep() {
        return configDAO.getStep(this.key);
    }

    @Override
    public void setStep(int step) {
        this.step = step;
        configDAO.setStep(this.key, step);
    }

    @Override
    @Deprecated
    public long getSegmentLength() {
        throw new KDException(new ErrorCode("Deprecated_method", ResManager.loadKDString((String)"\u65b9\u6cd5\u5df2\u5e9f\u5f03\uff0c\u8bf7\u52ff\u4f7f\u7528\u3002", (String)"BOS_CODERULE_1", (String)"bos-coderule", (Object[])new Object[0])), new Object[0]);
    }

    @Override
    public boolean updateCurseq(String key, long number) {
        return configDAO.updateCurSeq(key, number);
    }

    @Override
    @Deprecated
    public long getVersion(String key) {
        throw new KDException(new ErrorCode("Deprecated_method", ResManager.loadKDString((String)"\u65b9\u6cd5\u5df2\u5e9f\u5f03\uff0c\u8bf7\u52ff\u4f7f\u7528\u3002", (String)"BOS_CODERULE_1", (String)"bos-coderule", (Object[])new Object[0])), new Object[0]);
    }

    @Override
    public boolean isCompensate() {
        throw new GeneratorException(GeneratorException.ErrorCode.ERRCODE_USE_OBSOLETE_METHOD.getCode(), "this is a obsolete method !");
    }
}

