/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.generator.segment.db;

import kd.bos.coderule.handler.SyncHandler;
import kd.bos.coderule.handler.TransactionHandler;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.generator.Signer;
import kd.bos.generator.common.GeneratorException;
import kd.bos.generator.common.Result;
import kd.bos.generator.common.ResultUtil;
import kd.bos.generator.common.SegmentInfo;
import kd.bos.generator.segment.ConfigCache;
import kd.bos.generator.segment.SignerCache;
import kd.bos.generator.segment.db.ConfigDAO;
import kd.bos.generator.segment.db.ConfigDAOImpl;
import kd.bos.generator.segment.db.SignerDAO;
import kd.bos.generator.segment.db.SignerDAOImpl;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;

public class DBSigner
implements Signer {
    private static final Log log = LogFactory.getLog(DBSigner.class);
    private static final String LOCK_PREFIX = "SIGNER_CONFIG_INIT_DB_PREFIX_";
    private static SignerDAO signerDAO = new SignerDAOImpl();
    private static ConfigDAO configDAO = new ConfigDAOImpl();

    @Override
    public Result read(String key) {
        this.buildGeneratorInfo(key);
        Long curSeq = signerDAO.getCurSeq(key);
        return ResultUtil.success(curSeq);
    }

    private void buildGeneratorInfo(final String key) {
        if (signerDAO.isExist(key)) {
            return;
        }
        String dLockKey = LOCK_PREFIX + key;
        new SyncHandler(dLockKey){

            @Override
            protected void syncProcess() {
                DBSigner.this.transferGeneratorInfo(key);
            }

            @Override
            protected void beforeSyncProcess() {
                log.info("[CodeRule]\u83b7\u53d6\u9501\u5f00\u59cb\u4ece\u539f\u53f7\u6bb5\u4e2d\u540c\u6b65\u53d1\u53f7\u4fe1\u606f\uff0ckey\uff1a" + key);
            }

            @Override
            protected void afterSyncProcess() {
                log.info("[CodeRule]\u91ca\u653e\u9501\u7ed3\u675f\u540c\u6b65\u53d1\u53f7\u4fe1\u606f\uff0ckey\uff1a" + key);
            }
        }.process();
    }

    private void transferGeneratorInfo(final String key) {
        new TransactionHandler(String.format(ResManager.loadKDString((String)"\u540c\u6b65\u53d1\u53f7\u4fe1\u606f\u5931\u8d25\uff0ckey\uff1a%s", (String)"BOS_CODERULE_0", (String)"bos-coderule", (Object[])new Object[0]), key)){

            @Override
            protected void transactionProcess() {
                DynamicObject[] segmentInfos = BusinessDataServiceHelper.load((String)"bos_signer_segment", (String)"curseq,maxseq,segmentlength,version", (QFilter[])new QFilter("key", "=", (Object)key).toArray());
                if (segmentInfos == null || segmentInfos.length <= 0) {
                    signerDAO.init(key, 0L);
                    return;
                }
                Long[] initNumbers = new Long[]{SignerCache.getInstance().getCurSeq(key)};
                log.info("[CodeRule]\u540c\u6b65redis\u53d1\u53f7\u4fe1\u606f\uff0c\u83b7\u53d6\u5f53\u524d\u53f7\u4e3a\uff1a" + initNumbers[0]);
                if (null == initNumbers[0]) {
                    String sql = "select top 1 FCONSUMESEQ from t_signer_record where fkey = ? and fversion = ? order by FCONSUMESEQ desc";
                    DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[]{key, segmentInfos[0].getLong("version") - 1L}, rs -> {
                        if (rs.next()) {
                            initNumbers[0] = rs.getLong("FCONSUMESEQ");
                        }
                        return null;
                    });
                    log.info("[CodeRule]\u540c\u6b65\u53d1\u53f7\u8bb0\u5f55\u8868\u4fe1\u606f\uff0c\u83b7\u53d6\u5f53\u524d\u53f7\u4e3a\uff1a" + initNumbers[0]);
                }
                if (initNumbers[0] == null || initNumbers[0] < 0L) {
                    initNumbers[0] = segmentInfos[0].getLong("curseq");
                    log.info("[CodeRule]\u540c\u6b65\u53f7\u6bb5\u8bb0\u5f55\u4fe1\u606f\uff0c\u83b7\u53d6\u5f53\u524d\u53f7\u4e3a\uff1a" + initNumbers[0]);
                }
                signerDAO.init(key, initNumbers[0]);
                DBSigner.this.clearSignerSegmentInfo(key);
            }
        };
    }

    private void clearSignerSegmentInfo(String key) {
        int deleteSignerSegment = DeleteServiceHelper.delete((String)"bos_signer_segment", (QFilter[])new QFilter("key", "=", (Object)key).toArray());
        String sql = "delete from t_signer_record where fkey = ?";
        boolean execute = DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[]{key});
        log.info(String.format("[DBSigner]\u6e05\u9664\u5386\u53f2\u53f7\u6bb5\u6570\u636e\uff0ckey:%1$s\uff0c\u53f7\u6bb5\u8868\u72b6\u6001:%2$ss\uff0c\u6d88\u8d39\u8868\u72b6\u6001:%3$ss", key, deleteSignerSegment, execute));
        ConfigCache.getInstance().remove(key);
        SignerCache.getInstance().clearAll(key);
    }

    @Override
    public Result get(String key) {
        return this.getBy(key, 0);
    }

    @Override
    public Result getBy(String key, int reqSequence) {
        this.buildGeneratorInfo(key);
        if (reqSequence > 0) {
            Long curSeq = signerDAO.incrStep(key, reqSequence);
            return ResultUtil.success(curSeq);
        }
        int step = configDAO.getStep(key);
        if (step != 1) {
            Long curSeq = signerDAO.incrStep(key, step);
            return ResultUtil.success(curSeq);
        }
        Long curSeq = signerDAO.incr(key);
        return ResultUtil.success(curSeq);
    }

    @Override
    @Deprecated
    public Result sendMQ(String key, SegmentInfo segmentInfo) {
        throw new GeneratorException(GeneratorException.ErrorCode.ERRCODE_USE_OBSOLETE_METHOD.getCode(), "this is a obsolete method !");
    }
}

