/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ca;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import kd.bos.ca.itrus.Config;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.param.ParameterReader;
import kd.bos.session.SystemPropertyUtils;

public class CaConfigService {
    private static Log log = LogFactory.getLog(CaConfigService.class);
    private static final String CACONFIG_ID = "caconfig_id";
    private static final String CONFIGTAG = "config_tag";
    private static final String PROVIDERENTITYTYPE = "ca_config_provider";
    private static final String LINE = "line.separator";
    private static final char EQUALS = '=';
    private static final String URL = "URL";
    private static final String ACCOUNTHASH = "AccountHash";
    private static final String ACCOUNTHASHDOUBLE = "AccountHashDouble";
    private static final String AUTHWORD = "Password";
    private static final String LICENSE = "license";
    private static final String CACERT1 = "caCert1";
    private static final String CACERT = "caCert";
    private static final String CHECHREVOKE = "checkRevoke";
    private static final String BASEURL = "baseUrl";
    private static final String BASEURL1 = "baseUrl1";
    private static final String CAPROVIDER = "caProvider";
    private static final String CACONFIG = "caConfig";

    public static Map<String, Object> getCaConfigMerge() {
        HashMap<String, Object> caConfig = new HashMap<String, Object>();
        Config config = null;
        try {
            config = new Config();
        }
        catch (Exception e) {
            log.error("config \u521d\u59cb\u9519\u8bef\u3002", (Throwable)e);
        }
        String caConfigId = CaConfigService.getPublicParameter(CACONFIG_ID);
        if (!kd.bos.orm.util.StringUtils.isEmpty((Object)caConfigId) && !"0".equals(caConfigId)) {
            Map<String, Object> caParameter = CaConfigService.getCaParameter();
            config = CaConfigService.getConfig(config, caParameter);
        }
        if (StringUtils.isNotBlank((Object)config)) {
            caConfig.putAll(CaConfigService.ConfigToMap(config));
        }
        return caConfig;
    }

    public static Map<String, Object> getCaConfig() {
        String caConfigId;
        HashMap<String, Object> caConfig = new HashMap<String, Object>();
        String enableUseCA = SystemPropertyUtils.getProptyByTenant((String)"enableUseCA", (String)RequestContext.get().getTenantId());
        if ("false".equalsIgnoreCase(enableUseCA)) {
            return caConfig;
        }
        Map paramData = ParameterReader.loadPublicParameterFromCache();
        if (paramData.get("caconfig") == null) {
            caConfig.put("caSelect", false);
        }
        caConfig.put(CAPROVIDER, 0);
        if (!paramData.containsKey(CACONFIG_ID)) {
            caConfigId = "";
        } else {
            Object value = paramData.get(CACONFIG_ID);
            String string = caConfigId = kd.bos.orm.util.StringUtils.isEmpty(value) ? "" : String.valueOf(value);
        }
        if (!kd.bos.orm.util.StringUtils.isEmpty((Object)caConfigId) && !"0".equals(caConfigId)) {
            caConfig.putAll(CaConfigService.getTenentCaConfig());
            return caConfig;
        }
        if (!kd.bos.orm.util.StringUtils.isEmpty((Object)System.getProperty("bos.ca.license"))) {
            log.debug("zk license\u914d\u7f6e\u4e0d\u4e3a\u7a7a\uff0c\u53d6zk\u914d\u7f6e\u3002");
            caConfig.putAll(CaConfigService.getZKConfig());
            return caConfig;
        }
        caConfig.putAll(CaConfigService.getLocalCaConfig());
        return caConfig;
    }

    protected static Map<String, Object> getCaParameter() {
        HashMap<String, Object> caConfig = new HashMap<String, Object>();
        caConfig.put(CAPROVIDER, 0);
        String caConfigId = CaConfigService.getPublicParameter(CACONFIG_ID);
        if (kd.bos.orm.util.StringUtils.isEmpty((Object)caConfigId)) {
            log.debug("\u672a\u914d\u7f6e\u7cfb\u7edf\u53c2\u6570\uff0c\u4f9b\u5e94\u5546\u9ed8\u8ba4\u4e3a \uff1a0 \u5929\u5a01");
            return caConfig;
        }
        Map obj = BusinessDataReader.loadFromCache((Object[])new String[]{caConfigId}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)PROVIDERENTITYTYPE));
        caConfig.putAll(CaConfigService.convertParam(obj, caConfigId));
        int provider = caConfig.get(CAPROVIDER) == null ? 0 : (Integer)caConfig.get(CAPROVIDER);
        return caConfig;
    }

    private static Map<String, Object> convertParam(Map<Object, DynamicObject> obj, String configId) {
        String config;
        HashMap<String, Object> caConfig = new HashMap<String, Object>();
        DynamicObject dObject = obj.get(Long.parseLong(configId));
        int provider = dObject == null ? 0 : dObject.getInt("provider");
        caConfig.put(CAPROVIDER, provider);
        String string = config = dObject == null ? "" : dObject.getString(CONFIGTAG);
        if (kd.bos.orm.util.StringUtils.isEmpty((Object)config)) {
            return caConfig;
        }
        for (String propty : config.split("\\r?\\n")) {
            int index;
            if (kd.bos.orm.util.StringUtils.isEmpty((Object)propty) || (index = propty.indexOf(61)) == -1) continue;
            String name = propty.substring(0, index);
            String value = propty.substring(index + 1);
            value = value == null ? "" : value;
            value = value.replace("\\:", ":");
            value = value.replace("\\=", "=");
            caConfig.put(name, value);
        }
        return caConfig;
    }

    private static Map<String, Object> getTenentCaConfig() {
        int provider;
        HashMap<String, Object> caConfig = new HashMap<String, Object>();
        String caConfigId = CaConfigService.getPublicParameter(CACONFIG_ID);
        Map obj = BusinessDataReader.loadFromCache((Object[])new String[]{caConfigId}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)PROVIDERENTITYTYPE));
        DynamicObject dObject = (DynamicObject)obj.get(Long.parseLong(caConfigId));
        String config = dObject == null ? "" : dObject.getString(CONFIGTAG);
        int n = provider = dObject == null ? 0 : dObject.getInt("provider");
        if (provider == 1 && !config.contains("hashType=")) {
            config = config + "\nhashType=SHA-256";
        }
        caConfig.put(CAPROVIDER, provider);
        caConfig.put(CACONFIG, config);
        return caConfig;
    }

    private static Map<String, Object> getZKConfig() {
        HashMap<String, Object> caConfig = new HashMap<String, Object>();
        StringBuilder sb = new StringBuilder();
        String url = System.getProperty("bos.ca.URL");
        String accountHash = System.getProperty("bos.ca.AccountHash");
        String accountHashDouble = System.getProperty("bos.ca.AccountHashDouble");
        String password = System.getProperty("bos.ca.Password");
        String license = System.getProperty("bos.ca.license");
        String caCert = System.getProperty("bos.ca.caCert");
        String caCert1 = System.getProperty("bos.ca.caCert1");
        String checkRevoke = System.getProperty("bos.ca.checkRevoke");
        String baseUrl = System.getProperty("bos.ca.baseUrl");
        String baseUrl1 = System.getProperty("bos.ca.baseUrl1");
        String lineProperty = System.getProperty(LINE);
        if (!kd.bos.orm.util.StringUtils.isEmpty((Object)url)) {
            sb.append(URL).append('=').append(url).append(lineProperty);
        }
        if (!kd.bos.orm.util.StringUtils.isEmpty((Object)accountHash)) {
            sb.append(ACCOUNTHASH).append('=').append(accountHash).append(lineProperty);
        }
        if (!kd.bos.orm.util.StringUtils.isEmpty((Object)accountHashDouble)) {
            sb.append(ACCOUNTHASHDOUBLE).append('=').append(accountHashDouble).append(lineProperty);
        }
        if (!kd.bos.orm.util.StringUtils.isEmpty((Object)password)) {
            sb.append(AUTHWORD).append('=').append(password).append(lineProperty);
        }
        if (!kd.bos.orm.util.StringUtils.isEmpty((Object)license)) {
            sb.append(LICENSE).append('=').append(license).append(lineProperty);
        }
        if (!kd.bos.orm.util.StringUtils.isEmpty((Object)caCert)) {
            sb.append(CACERT).append('=').append(caCert).append(lineProperty);
        }
        if (!kd.bos.orm.util.StringUtils.isEmpty((Object)caCert1)) {
            sb.append(CACERT1).append('=').append(caCert1).append(lineProperty);
        }
        if (!kd.bos.orm.util.StringUtils.isEmpty((Object)checkRevoke)) {
            sb.append(CHECHREVOKE).append('=').append(checkRevoke).append(lineProperty);
        }
        if (!kd.bos.orm.util.StringUtils.isEmpty((Object)baseUrl)) {
            sb.append(BASEURL).append('=').append(baseUrl).append(lineProperty);
        }
        if (!kd.bos.orm.util.StringUtils.isEmpty((Object)baseUrl1)) {
            sb.append(BASEURL1).append('=').append(baseUrl1).append(lineProperty);
        }
        caConfig.put(CAPROVIDER, 0);
        caConfig.put(CACONFIG, sb.toString());
        return caConfig;
    }

    private static Map<String, Object> getLocalCaConfig() {
        HashMap<String, Object> caConfig = new HashMap<String, Object>();
        StringBuilder sb = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(Config.class.getResourceAsStream("/kd/bos/ca/config.properties")));){
            String lineText = null;
            while ((lineText = reader.readLine()) != null) {
                sb.append(lineText);
                sb.append(System.getProperty(LINE));
            }
        }
        catch (Exception e) {
            throw (KDException)e;
        }
        caConfig.put(CAPROVIDER, 0);
        caConfig.put(CACONFIG, sb.toString());
        return caConfig;
    }

    private static String getPublicParameter(String key) {
        Map paramData = ParameterReader.loadPublicParameterFromCache();
        if (!paramData.containsKey(key)) {
            return "";
        }
        Object value = paramData.get(key);
        return kd.bos.orm.util.StringUtils.isEmpty(value) ? "" : String.valueOf(value);
    }

    private static Map<String, Object> ConfigToMap(Config config) {
        HashMap<String, Object> caConfig = new HashMap<String, Object>();
        if (config == null) {
            return caConfig;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(URL).append('=').append(config.getURL()).append(System.getProperty(LINE));
        sb.append(ACCOUNTHASH).append('=').append(config.getAccountHash()).append(System.getProperty(LINE));
        sb.append(ACCOUNTHASHDOUBLE).append('=').append(config.getAccountHashDouble()).append(System.getProperty(LINE));
        sb.append(AUTHWORD).append('=').append(config.getPasswprd()).append(System.getProperty(LINE));
        sb.append(LICENSE).append('=').append(config.getLicense()).append(System.getProperty(LINE));
        sb.append(CACERT1).append('=').append(config.getCaCert1()).append(System.getProperty(LINE));
        sb.append(CACERT).append('=').append(config.getCaCert()).append(System.getProperty(LINE));
        sb.append(CHECHREVOKE).append('=').append(config.getCheckRevoke()).append(System.getProperty(LINE));
        sb.append(BASEURL).append('=').append(config.getBaseUrl()).append(System.getProperty(LINE));
        sb.append(BASEURL1).append('=').append(config.getBaseUrl1());
        caConfig.put(CAPROVIDER, 0);
        caConfig.put(CACONFIG, sb.toString());
        return caConfig;
    }

    private static Config getConfig(Config config, Map<String, Object> caConfig) {
        String baseUrl1;
        String license;
        String caCert1 = caConfig.get(CACERT1) == null ? "" : caConfig.get(CACERT1).toString();
        String string = license = caConfig.get(LICENSE) == null ? "" : caConfig.get(LICENSE).toString();
        if (!CaConfigService.isEmptyString(caCert1)) {
            config.setCaCert1(caCert1);
        }
        if (!CaConfigService.isEmptyString(license)) {
            config.setLicense(license);
        }
        String url = caConfig.get(URL) == null ? "" : caConfig.get(URL).toString();
        String accountHash = caConfig.get(ACCOUNTHASH) == null ? "" : caConfig.get(ACCOUNTHASH).toString();
        String accountHashDouble = caConfig.get(ACCOUNTHASHDOUBLE) == null ? "" : caConfig.get(ACCOUNTHASHDOUBLE).toString();
        String password = caConfig.get(AUTHWORD) == null ? "" : caConfig.get(AUTHWORD).toString();
        String caCert = caConfig.get(CACERT) == null ? "" : caConfig.get(CACERT).toString();
        String checkRevoke = caConfig.get(CHECHREVOKE) == null ? "" : caConfig.get(CHECHREVOKE).toString();
        String baseUrl = caConfig.get(BASEURL) == null ? "" : caConfig.get(BASEURL).toString();
        String string2 = baseUrl1 = caConfig.get(BASEURL1) == null ? "" : caConfig.get(BASEURL1).toString();
        if (!kd.bos.orm.util.StringUtils.isEmpty((Object)url)) {
            config.setURL(url);
        }
        if (!kd.bos.orm.util.StringUtils.isEmpty((Object)accountHash)) {
            config.setAccountHash(accountHash);
        }
        if (!kd.bos.orm.util.StringUtils.isEmpty((Object)accountHashDouble)) {
            config.setAccountHashDouble(accountHashDouble);
        }
        if (!kd.bos.orm.util.StringUtils.isEmpty((Object)password)) {
            config.setPasswprd(password);
        }
        if (!kd.bos.orm.util.StringUtils.isEmpty((Object)caCert)) {
            config.setCaCert(caCert);
        }
        if (!kd.bos.orm.util.StringUtils.isEmpty((Object)checkRevoke)) {
            config.setCheckRevoke(checkRevoke);
        }
        if (!kd.bos.orm.util.StringUtils.isEmpty((Object)baseUrl)) {
            config.setBaseUrl(baseUrl);
        }
        if (!kd.bos.orm.util.StringUtils.isEmpty((Object)baseUrl1)) {
            config.setBaseUrl1(baseUrl1);
        }
        config.setJson();
        return config;
    }

    private static boolean isEmptyString(Object v) {
        if (v == null) {
            return true;
        }
        String value = (String)v;
        if ("".equals(value) || value.length() == 0) {
            return true;
        }
        return value.length() < 100 && value.trim().length() == 0;
    }
}

