/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ca.operate;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.ca.operate.SignOperateService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.param.CustomParam;
import kd.bos.facade.FacadeResult;
import kd.bos.facade.form.IFormLifecycleFacade;
import kd.bos.form.IFormView;
import kd.bos.form.operate.FormOperate;
import kd.bos.servicehelper.ca.SignServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.svc.ca.CAModule;

public class SignFormOperateFacade
implements IFormLifecycleFacade {
    private final SignOperateService signOperateService = new SignOperateService();

    public FacadeResult beforeInvokeOperation(Map<String, Object> params) {
        FacadeResult facadeResult = new FacadeResult();
        FormOperate formOperate = (FormOperate)params.get("formOperate");
        boolean signCallback = Boolean.parseBoolean(formOperate.getOption().getVariableValue("signCallbackFlag", "false"));
        if (!signCallback) {
            boolean needSign = SignServiceHelper.needSign(String.valueOf(RequestContext.get().getOrgId()), formOperate.getEntityId(), formOperate.getOperateKey());
            if (needSign) {
                formOperate.getOption().setVariableValue("bos_skip_op_batch", "true");
                CustomParam customParam = new CustomParam();
                Map customParameter = SystemParamServiceHelper.loadCustomParameterFromCache((CustomParam)customParam);
                String maxSize = (String)customParameter.get("CA_BATCH_SIGN_MAX_SIZE");
                int maxBatchSize = 500;
                if (maxSize != null) {
                    try {
                        maxBatchSize = Integer.parseInt(maxSize);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                ListSelectedRowCollection listSelectedData = formOperate.getListSelectedData();
                int size = this.getOperateIds(listSelectedData).size();
                IFormView view = formOperate.getView();
                if (view != null && size > maxBatchSize) {
                    facadeResult.setCode(6);
                    facadeResult.setSuccess(true);
                    view.showTipNotification(String.format(ResManager.loadKDString((String)"\u6279\u91cf\u7b7e\u540d\u7684\u6570\u636e\u5df2\u8d85\u8fc7%s\u6761\uff0c\u8bf7\u5206\u6279\u64cd\u4f5c\u3002", (String)"SignFormOperateFacade_0", (String)CAModule.getModuleName(), (Object[])new Object[0]), maxBatchSize));
                    return facadeResult;
                }
            } else {
                formOperate.getOption().setVariableValue("bos_skip_op_batch", "false");
            }
        }
        facadeResult.setSuccess(true);
        facadeResult.setCode(3);
        return facadeResult;
    }

    private Set<Object> getOperateIds(ListSelectedRowCollection listSelectedData) {
        LinkedHashSet<Object> ids = new LinkedHashSet<Object>();
        if (listSelectedData == null || listSelectedData.isEmpty()) {
            return ids;
        }
        for (ListSelectedRow listSelectedRowValue : listSelectedData) {
            ids.add(listSelectedRowValue.getPrimaryKeyValue());
        }
        return ids;
    }

    public FacadeResult afterInvokeOperation(Map<String, Object> params) {
        return null;
    }

    public FacadeResult beforeAfterInvokeOperation(Map<String, Object> params) {
        FacadeResult facadeResult = new FacadeResult();
        FormOperate form = (FormOperate)params.get("formOperate");
        OperationResult operationResult = (OperationResult)params.get("operationResult");
        IFormView formView = form.getView();
        String operateKey = form.getOperateKey();
        OperateOption option = form.getOption();
        option.setVariableValue("operateName", form.getOperateName().getLocaleValue());
        facadeResult.setSuccess(true);
        boolean afterResult = this.signOperateService.afterSignOperation(formView, operateKey, operationResult, option);
        facadeResult.setCode(afterResult ? 3 : 7);
        return facadeResult;
    }
}

