/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cfca;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import kd.bos.dataentity.utils.StringUtils;

public class CFCAConfig {
    private String hosts;
    private String port;
    private String connectTimeout;
    private String receiveTimeout;
    private String logbackConfigPath;
    private static final String H = "hosts";
    private static final String CT = "connectTimeout";
    private static final String RT = "receiveTimeout";
    private static final String LCP = "logbackConfigPath";

    public CFCAConfig() throws IOException {
        Properties property = new Properties();
        try (InputStream in = CFCAConfig.class.getResourceAsStream("/resources/CFCAConfig.properties");){
            property.load(in);
            String h = property.getProperty(H);
            String p = property.getProperty("port");
            String ct = property.getProperty(CT);
            String rt = property.getProperty(RT);
            String lcp = property.getProperty(LCP);
            this.hosts = h;
            this.port = p;
            this.connectTimeout = ct;
            this.receiveTimeout = rt;
            this.logbackConfigPath = lcp;
        }
    }

    public CFCAConfig(Map<String, Object> caConfig) throws IOException {
        this();
        String lcp;
        String h = caConfig.get(H) == null ? "" : caConfig.get(H).toString();
        String p = caConfig.get("port") == null ? "" : caConfig.get("port").toString();
        String ct = caConfig.get(CT) == null ? "" : caConfig.get(CT).toString();
        String rt = caConfig.get(RT) == null ? "" : caConfig.get(RT).toString();
        String string = lcp = caConfig.get(LCP) == null ? "" : caConfig.get(LCP).toString();
        if (StringUtils.isNotBlank((CharSequence)h)) {
            this.hosts = h;
        }
        if (StringUtils.isNotBlank((CharSequence)p)) {
            this.port = p;
        }
        if (StringUtils.isNotBlank((CharSequence)ct)) {
            this.connectTimeout = ct;
        }
        if (StringUtils.isNotBlank((CharSequence)rt)) {
            this.receiveTimeout = rt;
        }
        if (StringUtils.isNotBlank((CharSequence)lcp)) {
            this.logbackConfigPath = lcp;
        }
    }

    public String getHosts() {
        return this.hosts;
    }

    public void setHosts(String hosts) {
        this.hosts = hosts;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(String connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public String getReceiveTimeout() {
        return this.receiveTimeout;
    }

    public void setReceiveTimeout(String receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    public String getLogbackConfigPath() {
        return this.logbackConfigPath;
    }

    public void setLogbackConfigPath(String logbackConfigPath) {
        this.logbackConfigPath = logbackConfigPath;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CFCAConfig) {
            return this.getHosts().equals(((CFCAConfig)obj).getHosts()) && this.getPort().equals(((CFCAConfig)obj).getPort()) && this.getConnectTimeout().equals(((CFCAConfig)obj).getConnectTimeout()) && this.getReceiveTimeout().equals(((CFCAConfig)obj).getReceiveTimeout()) && this.getLogbackConfigPath().equals(((CFCAConfig)obj).getLogbackConfigPath());
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }
}

