/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.ca;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.util.StringUtils;

public class SignOperateEditPlugin
extends AbstractFormPlugin {
    private static final String SIGN_ENTRY = "signentryentity";
    private static final String SELECT_OP = "selectop";
    private static final String BTN_OK = "btnok";
    private static final String CLEAR_PIN_N = "nclearpin";
    private static final String SIGN_OPERATE = "signoperate";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_OK, "btncancel"});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object customParam = this.getView().getFormShowParameter().getCustomParam(SIGN_OPERATE);
        if (!(customParam instanceof List)) {
            return;
        }
        List result = (List)customParam;
        this.renderRow(result);
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "selectop": {
                this.openSignOperate();
                break;
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "selectop": {
                this.openSignOperate();
                break;
            }
            case "btnok": {
                DynamicObjectCollection entryEntity = this.getView().getModel().getEntryEntity(SIGN_ENTRY);
                ArrayList returnData = new ArrayList(entryEntity.size());
                for (DynamicObject obj : entryEntity) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("OpCode", obj.getString("opcode"));
                    map.put("OpName", obj.getString("opname"));
                    map.put("ClearPin", !obj.getBoolean(CLEAR_PIN_N));
                    returnData.add(map);
                }
                HashMap map = new HashMap();
                map.put("Operations", returnData);
                this.getView().returnDataToParent(map);
                this.getView().close();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getReturnData() == null) {
            return;
        }
        String actionId = closedCallBackEvent.getActionId();
        Map data = (Map)closedCallBackEvent.getReturnData();
        if (SIGN_OPERATE.equalsIgnoreCase(actionId)) {
            if (StringUtils.isEmpty((Object)data)) {
                return;
            }
            List operations = (List)data.get("Operations");
            HashMap<String, Boolean> map = new HashMap<String, Boolean>();
            DynamicObjectCollection entryEntity = this.getView().getModel().getEntryEntity(SIGN_ENTRY);
            for (DynamicObject obj : entryEntity) {
                map.put(obj.getString("opcode"), !obj.getBoolean(CLEAR_PIN_N));
            }
            for (Map m : operations) {
                String opCode = (String)m.get("OpCode");
                m.put("ClearPin", map.getOrDefault(opCode, true));
            }
            this.renderRow(operations);
        }
    }

    private void renderRow(List<Map<String, Object>> operations) {
        this.getModel().deleteEntryData(SIGN_ENTRY);
        if (operations == null || operations.isEmpty()) {
            return;
        }
        this.getModel().batchCreateNewEntryRow(SIGN_ENTRY, operations.size());
        for (int i = 0; i < operations.size(); ++i) {
            Map<String, Object> option = operations.get(i);
            this.getModel().setValue("opcode", option.get("OpCode"), i);
            this.getModel().setValue("opname", option.get("OpName"), i);
            boolean clearPin = Boolean.parseBoolean(String.valueOf(option.get("ClearPin")));
            this.getModel().setValue(CLEAR_PIN_N, (Object)(!clearPin ? 1 : 0), i);
        }
    }

    private void openSignOperate() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("bd_signoperateselect");
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        parameter.setCustomParam("formNumber", customParams.get("formNumber"));
        DynamicObjectCollection entryEntity = this.getView().getModel().getEntryEntity(SIGN_ENTRY);
        StringBuilder operate = new StringBuilder();
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject obj = (DynamicObject)entryEntity.get(i);
            operate.append(obj.getString("opcode"));
            if (i == entryEntity.size() - 1) continue;
            operate.append(",");
        }
        parameter.setCustomParam("operates", (Object)operate.toString());
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SIGN_OPERATE));
        this.getView().showForm(parameter);
    }
}

