/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.ca.ISignOperateCallback;
import kd.bos.ca.KSign;
import kd.bos.ca.SignService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ca.CertInfo;
import kd.bos.entity.ca.SignScheme;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.param.CustomParam;
import kd.bos.form.ClientCallback;
import kd.bos.form.ClientCallbackListener;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.SignCallbackLisenter;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.svc.ca.CAModule;

public class SignOperateCallback
implements ISignOperateCallback {
    private static final String BOS_FORM_CORE = "bos-form-core";
    private IFormView view;
    private String entityId;
    private OperateOption option;
    private String key;
    private boolean IS_FIRSTSAVE;
    private ClientCallback.SignClientType type = ClientCallback.SignClientType.Standard;
    private SignCallbackLisenter invoker;
    private String plugins;
    private String callbackId;
    private Map<String, String> customParameter = new HashMap<String, String>();
    public static final String SignCallbackPlugin = "SignCallbackPlugin";
    public static final String SigncallbackId = "SigncallbackId";
    public static final String FORM_ID = "SignOperateFormId";
    public static final String OPERATE_KEY = "SignOperateOperateKey";

    public SignOperateCallback() {
    }

    public SignOperateCallback(IFormView view, SignCallbackLisenter invoker, OperateOption option, ClientCallback.SignClientType type, String callbackId) {
        this.view = view;
        this.invoker = invoker;
        this.option = option;
        this.callbackId = callbackId;
        this.type = type;
    }

    @Override
    public ISignOperateCallback beforeSign(IFormView view, SignCallbackLisenter invoker, OperateOption option, ClientCallback.SignClientType type, String callbackId) {
        this.view = view;
        this.invoker = invoker;
        this.option = option;
        this.callbackId = callbackId;
        this.type = type;
        return this;
    }

    @Override
    public OperationResult sign(OperationResult opResult) {
        boolean clearPin = true;
        if (this.getOption() == null) {
            return this.sign(opResult, clearPin);
        }
        String formId = this.option.getVariableValue(FORM_ID, "");
        String operateKey = this.option.getVariableValue(OPERATE_KEY, "");
        if (StringUtils.isNotBlank((CharSequence)formId) && StringUtils.isNotBlank((CharSequence)operateKey)) {
            SignScheme signScheme = SignService.getSignScheme(formId);
            if (signScheme != null) {
                String signOperate = signScheme.getSignOperate();
                List signOperateList = (List)SerializationUtils.fromJsonString((String)signOperate, List.class);
                for (Map map : signOperateList) {
                    if (!StringUtils.equals((CharSequence)String.valueOf(map.get("OpCode")), (CharSequence)operateKey)) continue;
                    clearPin = Boolean.parseBoolean(String.valueOf(map.get("ClearPin")));
                    break;
                }
            }
        } else if (this.getOption().containsVariable("clearPin")) {
            String clearPinStr = this.option.getVariableValue("clearPin");
            clearPin = Boolean.parseBoolean(clearPinStr);
        }
        return this.sign(opResult, clearPin);
    }

    @Override
    public OperationResult sign(OperationResult opResult, boolean clearPin) {
        int size;
        CustomParam customParam = new CustomParam();
        Map customParameter = SystemParamServiceHelper.loadCustomParameterFromCache((CustomParam)customParam);
        String maxSize = (String)customParameter.get("CA_BATCH_SIGN_MAX_SIZE");
        int maxBatchSize = 500;
        if (maxSize != null) {
            try {
                maxBatchSize = Integer.parseInt(maxSize);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((size = opResult.getBillCount()) > maxBatchSize) {
            opResult.setSuccess(false);
            opResult.setShowMessage(true);
            opResult.setMessage(String.format(ResManager.loadKDString((String)"\u6279\u91cf\u7b7e\u540d\u7684\u6570\u636e\u5df2\u8d85\u8fc7%s\u6761\uff0c\u8bf7\u5206\u6279\u64cd\u4f5c\u3002", (String)"SignFormOperateFacade_0", (String)CAModule.getModuleName(), (Object[])new Object[0]), maxBatchSize));
            return opResult;
        }
        Map clearTexts = (Map)SerializationUtils.fromJsonString((String)opResult.getClearText(), Map.class);
        if (clearTexts == null || clearTexts.isEmpty()) {
            opResult.setMessage(ResManager.loadKDString((String)"\u7b7e\u540d\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (String)"SignOperateCallback_0", (String)BOS_FORM_CORE, (Object[])new Object[0]));
            return opResult;
        }
        IPageCache cache = (IPageCache)this.getView().getService(IPageCache.class);
        HashMap<String, Object> args = new HashMap<String, Object>();
        if (StringUtils.isNotBlank(clearTexts.get("hasUnSignData"))) {
            opResult.setSuccess(false);
            opResult.setMessage((String)clearTexts.get("hasUnSignData"));
            return opResult;
        }
        Map<Object, Object> signText = null;
        try {
            signText = KSign.calculateSignTexts(clearTexts);
        }
        catch (Exception e) {
            opResult.setSuccess(false);
            opResult.setMessage(String.format(ResManager.loadKDString((String)"\u7b7e\u540d\u6570\u636e\u8ba1\u7b97\u52a0\u5bc6\u5931\u8d25%s", (String)"SignOperateCallback_1", (String)BOS_FORM_CORE, (Object[])new Object[0]), e.getMessage()));
        }
        CertInfo info = SignService.getCertInfo(RequestContext.get().getUserId());
        if (info.getSerialNumber() == null) {
            opResult.setSuccess(false);
            opResult.setMessage(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u7ed1\u5b9a\u8bc1\u4e66\uff01", (String)"SignOperateCallback_2", (String)BOS_FORM_CORE, (Object[])new Object[0]));
            return opResult;
        }
        if (info.getEnable() == 0) {
            opResult.setSuccess(false);
            opResult.setMessage(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u8bc1\u4e66\u5df2\u88ab\u7981\u7528\uff01", (String)"SignOperateCallback_3", (String)BOS_FORM_CORE, (Object[])new Object[0]));
            return opResult;
        }
        args.put("signText", signText);
        args.put("serialNumber", info.getSerialNumber());
        args.put("issue", info.getCertIssuer());
        args.put("clearPin", clearPin);
        cache.put("clearText", opResult.getClearText());
        ClientCallbackListener listener = new ClientCallbackListener();
        ArrayList<ClientCallback> list = new ArrayList<ClientCallback>();
        ClientCallback callback = new ClientCallback(this.getOperateKey());
        callback.setClearText(opResult.getClearText());
        callback.setCustomParameter(this.getCustomParameter());
        callback.setType(this.type);
        callback.setCallbackId(this.callbackId);
        list.add(callback);
        if (this.getOption() != null) {
            Map variables = this.getOption().getVariables();
            HashMap newVariables = new HashMap(variables);
            newVariables.remove("bos_skip_op_batch");
            listener.setOptionVariables(newVariables);
        }
        listener.setListCallBack(list);
        if (this.invoker != null) {
            listener.addSignCallbackLisenter(this.invoker);
        }
        if (!StringUtils.isBlank((CharSequence)this.plugins)) {
            listener.addSignCallbackLisenter(this.plugins);
        }
        this.getView().executeClientMethodCallback("sign", args, listener);
        opResult.setShowMessage(false);
        return opResult;
    }

    public IFormView getView() {
        return this.view;
    }

    public void setView(IFormView view) {
        this.view = view;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public OperateOption getOption() {
        return this.option;
    }

    public void setOption(OperateOption option) {
        this.option = option;
    }

    public String getOperateKey() {
        return this.key;
    }

    public void setOperateKey(String key) {
        this.key = key;
    }

    public boolean isFirstSave() {
        return this.IS_FIRSTSAVE;
    }

    public void setFirstSave(boolean isFirstSave) {
        this.IS_FIRSTSAVE = isFirstSave;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public ClientCallback.SignClientType getType() {
        return this.type;
    }

    public void setType(ClientCallback.SignClientType type) {
        this.type = type;
    }

    public SignCallbackLisenter getInvoker() {
        return this.invoker;
    }

    public void setInvoker(SignCallbackLisenter invoker) {
        this.invoker = invoker;
    }

    public String getCallbackId() {
        return this.callbackId;
    }

    public void setCallbackId(String callbackId) {
        this.callbackId = callbackId;
    }

    public Map<String, String> getCustomParameter() {
        return this.customParameter;
    }

    public void setCustomParameter(Map<String, String> customParameter) {
        this.customParameter = customParameter;
    }

    public String getPlugins() {
        return this.plugins;
    }

    public void setPlugins(String plugins) {
        this.plugins = plugins;
    }
}

