/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.ca.SignService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.function.FunctionManage;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.WithEntityEntryDistinctable;
import kd.bos.service.botp.track.getvaluemode.FieldVariable;
import kd.bos.service.filter.CAFormulaExecutor;

public class SignSchemeFilterService {
    private static Log log = LogFactory.getLog(SignSchemeFilterService.class);
    private static final String SCHEME_ENTITY = "sign_scheme";
    private static final String FILTERCONDITION = "filtercondition";

    public static DynamicObject[] getDataBySignFilter(MainEntityType entityType, String opKey, DynamicObject[] successObjs) {
        if (successObjs == null || successObjs.length == 0) {
            return successObjs;
        }
        DynamicObjectCollection cols = new DynamicObjectCollection();
        cols.addAll(Arrays.asList(successObjs));
        String formId = entityType.getName();
        Map<String, Boolean> signResult = SignService.getOpSignResult(formId, opKey, cols);
        boolean sign = signResult.get("sign");
        boolean verifySign = signResult.get("verifySign");
        if (sign || verifySign) {
            FilterBuilder filterBuilder = SignService.getSignSchemeFilter(formId);
            if (filterBuilder == null) {
                return successObjs;
            }
            String[] filterScripts = filterBuilder.buildFilterScript();
            String gridFilterString = filterScripts[0];
            if (StringUtils.isNotBlank((CharSequence)gridFilterString) && entityType instanceof BillEntityType) {
                FunctionManage func = FunctionManage.get();
                CAFormulaExecutor formulaExecute = new CAFormulaExecutor((BillEntityType)entityType, gridFilterString, func);
                ArrayList<DynamicObject> filterCols = new ArrayList<DynamicObject>();
                for (DynamicObject obj : successObjs) {
                    boolean isMatch = SignSchemeFilterService.buildDataInMemory(entityType, obj, formulaExecute);
                    if (!isMatch) continue;
                    filterCols.add(obj);
                }
                DynamicObject[] filterObjs = new DynamicObject[filterCols.size()];
                filterObjs = filterCols.toArray(filterObjs);
                return filterObjs;
            }
        }
        return successObjs;
    }

    public static DynamicObjectCollection getDataBySignFilter(MainEntityType entityType, DynamicObjectCollection successObjs, String formId) {
        FilterBuilder filterBuilder = SignService.getSignSchemeFilter(formId);
        if (filterBuilder == null) {
            return successObjs;
        }
        String[] filterScripts = filterBuilder.buildFilterScript();
        String gridFilterString = filterScripts[0];
        if (StringUtils.isNotBlank((CharSequence)gridFilterString) && entityType instanceof BillEntityType) {
            FunctionManage func = FunctionManage.get();
            CAFormulaExecutor formulaExecute = new CAFormulaExecutor((BillEntityType)entityType, gridFilterString, func);
            DynamicObjectCollection filterCols = new DynamicObjectCollection();
            for (DynamicObject obj : successObjs) {
                boolean isMatch = SignSchemeFilterService.buildDataInMemory(entityType, obj, formulaExecute);
                if (!isMatch) continue;
                filterCols.add((Object)obj);
            }
            return filterCols;
        }
        return successObjs;
    }

    private static boolean buildDataInMemory(MainEntityType entityType, DynamicObject successObj, CAFormulaExecutor formulaExecute) {
        Object value = formulaExecute.execute(successObj);
        if (value == null || !(value instanceof Boolean)) {
            return false;
        }
        return (Boolean)value;
    }

    public static List<String> getFilterFields(MainEntityType entityType) {
        FilterBuilder filterBuilder = SignService.getSignSchemeFilter(entityType.getName());
        ArrayList<String> filterFields = new ArrayList<String>();
        if (filterBuilder == null || !(entityType instanceof BillEntityType)) {
            return filterFields;
        }
        String[] filterScripts = filterBuilder.buildFilterScript();
        String gridFilterString = filterScripts[0];
        if (StringUtils.isNotBlank((CharSequence)gridFilterString)) {
            FunctionManage func = FunctionManage.get();
            CAFormulaExecutor formulaExecute = new CAFormulaExecutor((BillEntityType)entityType, gridFilterString, func);
            List<FieldVariable> vars = formulaExecute.getVars();
            for (FieldVariable var : vars) {
                filterFields.add(var.getVar());
            }
        }
        return filterFields;
    }

    public static List<DynamicObject> buildDataInDB(String formId, List<DynamicObject> cols, FilterBuilder filterBuilder) {
        if (cols == null || cols.isEmpty()) {
            return cols;
        }
        ArrayList<DynamicObject> filterCols = new ArrayList<DynamicObject>();
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)formId);
        String pk = dt.getPrimaryKey().getName();
        ArrayList<Object> pkIds = new ArrayList<Object>(cols.size());
        for (DynamicObject col : cols) {
            pkIds.add(col.getPkValue());
        }
        ArrayList<Object> filterIds = new ArrayList<Object>();
        filterBuilder.buildFilter(true);
        QFilter[] qFilters = new QFilter[]{filterBuilder.getQFilter(), new QFilter(pk, "in", pkIds)};
        filterIds.addAll(SignSchemeFilterService.getFilterData((DynamicObjectType)dt, qFilters));
        for (DynamicObject col : cols) {
            Object pkId = col.getPkValue();
            if (!filterIds.contains(pkId)) continue;
            filterCols.add(col);
        }
        return filterCols;
    }

    private static List<Object> getFilterData(DynamicObjectType type, QFilter[] filters) {
        ArrayList<Object> idList = new ArrayList<Object>();
        try (DataSet ds = ORM.create().queryDataSet("SignService", type.getName(), "id", filters, null, -1, (Distinctable)WithEntityEntryDistinctable.get());){
            ds.forEach(row -> idList.add(row.get(0)));
        }
        return idList;
    }
}

