/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.control.events.webOffice;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.WebOffice;
import kd.bos.form.control.events.webOffice.WebOfficeDataHandler;
import kd.bos.form.control.events.webOffice.handler.WebOfficeBookmarkCheckHandler;
import kd.bos.form.control.events.webOffice.handler.WebOfficeBookmarkValueHandler;
import kd.bos.form.control.events.webOffice.handler.WebOfficeCustomHandler;
import kd.bos.form.control.events.webOffice.handler.WebOfficeDocChangeHandler;
import kd.bos.form.control.events.webOffice.handler.WebOfficeGetAllBookmarkHandler;
import kd.bos.form.control.events.webOffice.handler.WebOfficeGetAllCheckBoxHandler;
import kd.bos.form.control.events.webOffice.handler.WebOfficeIsFieldReviseHandeler;
import kd.bos.form.control.events.webOffice.handler.WebOfficeOpenStatusHandeler;

public class WebOfficeEventDispatcher {
    private static final List<WebOfficeDataHandler> handlers = new ArrayList<WebOfficeDataHandler>();

    public static void dispatch(Map<String, Object> data, WebOffice webOffice) {
        String type = (String)data.get("type");
        if (StringUtils.isBlank((CharSequence)type)) {
            return;
        }
        for (WebOfficeDataHandler handler : handlers) {
            if (!handler.canHandle(type)) continue;
            handler.handle(webOffice, data);
        }
    }

    static {
        handlers.add(new WebOfficeDocChangeHandler());
        handlers.add(new WebOfficeBookmarkCheckHandler());
        handlers.add(new WebOfficeBookmarkValueHandler());
        handlers.add(new WebOfficeGetAllBookmarkHandler());
        handlers.add(new WebOfficeGetAllCheckBoxHandler());
        handlers.add(new WebOfficeIsFieldReviseHandeler());
        handlers.add(new WebOfficeOpenStatusHandeler());
        handlers.add(new WebOfficeCustomHandler());
    }
}

