/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.control.test;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.WebOffice;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.url.UrlService;

public class DocComparePlugIn
extends AbstractFormPlugin
implements RowClickEventListener {
    public void afterCreateNewData(EventObject e) {
        FormShowParameter param = this.getView().getFormShowParameter();
        Object id = param.getCustomParam("id");
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)id, (String)"test_wb_doc_templete");
        DynamicObjectCollection versions = object.getDynamicObjectCollection("entry_version");
        this.getModel().deleteEntryData("entryentity");
        this.getModel().batchCreateNewEntryRow("entryentity", versions.size());
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        DynamicObjectType dt = entryEntity.getDynamicObjectType();
        for (int i = 0; i < versions.size(); ++i) {
            DynamicObject version = (DynamicObject)versions.get(i);
            DynamicObject target = (DynamicObject)entryEntity.get(i);
            target.set((IDataEntityProperty)dt.getProperty("version_name"), version.get("version_name"));
            target.set((IDataEntityProperty)dt.getProperty("version_url"), version.get("version_url"));
            target.set((IDataEntityProperty)dt.getProperty("version"), version.get("version"));
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "baritemap1": {
                this.compare();
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
        Toolbar toolbar = (Toolbar)this.getControl("toolbarap");
        toolbar.addItemClickListener((ItemClickListener)this);
    }

    public static FormShowParameter show(String url1, String fileName1, String url2, String fileName2) {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("test_wb_compare");
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCustomParam("url1", (Object)url1);
        param.setCustomParam("fileName1", (Object)fileName1);
        param.setCustomParam("url2", (Object)url2);
        param.setCustomParam("fileName2", (Object)fileName2);
        return param;
    }

    private void compare() {
        EntryGrid versionGrid = (EntryGrid)this.getControl("entryentity");
        int[] rows = versionGrid.getSelectRows();
        if (null == rows || rows.length != 2) {
            this.getView().showErrorNotification("please compare two version");
            return;
        }
        String fileName1 = (String)this.getModel().getValue("version_name", rows[0]);
        String url1 = (String)this.getModel().getValue("version_url", rows[0]);
        url1 = UrlService.getAttachmentFullUrl((String)url1);
        String fileName2 = (String)this.getModel().getValue("version_name", rows[1]);
        String url2 = (String)this.getModel().getValue("version_url", rows[1]);
        url2 = UrlService.getAttachmentFullUrl((String)url2);
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        webOffice.compareFile(url1, fileName1, url2, fileName2);
    }
}

