/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.control.test;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.Map;
import java.util.UUID;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.WebOffice;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.control.events.webOffice.WebOfficeCloseListener;
import kd.bos.form.control.events.webOffice.WebOfficeDataListener;
import kd.bos.form.control.events.webOffice.event.WebOfficeAfterClosedEvent;
import kd.bos.form.control.events.webOffice.event.WebOfficeBookmarkCheckEvent;
import kd.bos.form.control.events.webOffice.event.WebOfficeBookmarkEvent;
import kd.bos.form.control.events.webOffice.event.WebOfficeBookmarkValueEvent;
import kd.bos.form.control.events.webOffice.event.WebOfficeCheckboxEvent;
import kd.bos.form.control.events.webOffice.event.WebOfficeDocChangeEvent;
import kd.bos.form.control.events.webOffice.event.WebOfficeIsFieldReviseEvent;
import kd.bos.form.control.events.webOffice.event.WebOfficeOpenStatusEvent;
import kd.bos.form.control.model.WebOfficeDocProtectionType;
import kd.bos.form.control.model.WebOfficeFileType;
import kd.bos.form.control.model.WebOfficeImage;
import kd.bos.form.control.model.WebOfficeImageStyle;
import kd.bos.form.control.model.WebOfficeMark;
import kd.bos.form.control.model.WebOfficeMergeType;
import kd.bos.form.control.model.WebOfficeTrackingType;
import kd.bos.form.control.model.WebofficeWaterMark;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.url.UrlService;

public class DocTplEditPlugIn
extends AbstractFormPlugin
implements UploadListener,
ListRowClickListener,
HyperLinkClickListener,
WebOfficeDataListener,
WebOfficeCloseListener {
    private static final Log log = LogFactory.getLog(DocTplEditPlugIn.class);

    public void afterCreateNewData(EventObject e) {
        WebOffice webOffice;
        FormShowParameter param = this.getView().getFormShowParameter();
        Object id = param.getCustomParam("id");
        String fileUrl = (String)param.getCustomParam("doc_url");
        String fileName = (String)param.getCustomParam("doc_name");
        this.getModel().setValue("id", id);
        this.getModel().setValue("file_name", (Object)fileName);
        this.getModel().setValue("file_url", (Object)fileUrl);
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)id, (String)"test_wb_doc_templete");
        String caption = (String)object.get("current_doc_caption");
        this.getPageCache().put("caption", caption);
        if ("".equals(caption)) {
            caption = "welcome" + RequestContext.get().getUserName() + "for use";
        }
        String docNumber = (String)param.getCustomParam("doc_number");
        this.initVariableGrid(docNumber);
        this.initDocGrid(id);
        String docUrl = (String)param.getCustomParam("doc_url");
        if (docUrl != null && docUrl.length() > 0) {
            String name = docUrl.substring(docUrl.lastIndexOf(47));
            String[] files = name.split("\\.");
            if (files[1].equals("doc")) {
                this.getPageCache().put("opentype", "word");
            } else if (files[1].equals("xls")) {
                this.getPageCache().put("opentype", "excel");
            } else {
                this.getPageCache().put("opentype", "ppt");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)docUrl)) {
            docUrl = UrlService.getAttachmentFullUrl((String)docUrl);
            webOffice = (WebOffice)this.getControl("webofficeap");
            webOffice.openAll(docUrl, fileName);
            webOffice.setCaption(caption);
            String userName = RequestContext.get().getUserName();
            webOffice.setTrackingMode(userName, WebOfficeTrackingType.NO_TRACE);
        } else {
            this.getPageCache().put("opentype", "word");
            webOffice = (WebOffice)this.getControl("webofficeap");
            webOffice.openNew(WebOfficeFileType.word);
            webOffice.setCaption(caption);
        }
    }

    private void initDocGrid(Object id) {
        DynamicObjectCollection perms;
        String markValue;
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)id, (String)"test_wb_doc_templete");
        DynamicObjectCollection list = object.getDynamicObjectCollection("entry_variable");
        if (null != list && !list.isEmpty()) {
            this.getModel().batchCreateNewEntryRow("entryentity_doc", list.size());
            for (int i = 0; i < list.size(); ++i) {
                DynamicObject obj = (DynamicObject)list.get(i);
                String name = obj.getString("variable_name");
                String markKey = obj.getString("variable_key");
                markValue = obj.getString("variable_value");
                String varaible = obj.getString("variable_map");
                this.getModel().setValue("doc_name", (Object)name, i);
                this.getModel().setValue("doc_variable", (Object)varaible, i);
                this.getModel().setValue("doc_key", (Object)markKey, i);
                this.getModel().setValue("doc_value", (Object)markValue, i);
                this.getModel().setValue("doc_del", (Object)"delete bookmark", i);
                this.getModel().setValue("doc_location", (Object)"location bookmark", i);
            }
        }
        if (null != (perms = object.getDynamicObjectCollection("entity_edit_perm")) && !perms.isEmpty()) {
            this.getModel().batchCreateNewEntryRow("entity_edit", perms.size());
            for (int i = 0; i < perms.size(); ++i) {
                DynamicObject obj = (DynamicObject)perms.get(i);
                DynamicObject editor = obj.getDynamicObject("edit_user");
                markValue = obj.getString("bookmark");
                this.getModel().setValue("editor", (Object)editor, i);
                this.getModel().setValue("edit_bookmark", (Object)markValue, i);
                this.getModel().setValue("edit_operation", (Object)"delete bookmark", i);
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        int rowIndex = hyperLinkClickEvent.getRowIndex();
        switch (fieldName) {
            case "operation": {
                this.insertVariable(rowIndex);
                break;
            }
            case "doc_del": {
                this.deleteMark(rowIndex);
                break;
            }
            case "doc_location": {
                this.locateMark(rowIndex);
                break;
            }
            case "edit_operation": {
                this.delEditMark(rowIndex);
            }
        }
    }

    private void delEditMark(int rowIndex) {
        String markKey = (String)this.getModel().getValue("edit_bookmark", rowIndex);
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        webOffice.deleteSelectedAreaEditBookmark(markKey);
        this.getModel().deleteEntryRow("entity_edit", rowIndex);
    }

    private void unProtectedDoc() {
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        webOffice.cancelProtectDoc("webofficeap");
    }

    private void protectDoc() {
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        webOffice.protectDoc(WebOfficeDocProtectionType.ONLY_COMMENT_ALLOWED, "webofficeap");
    }

    private void showCommentdialog() {
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        webOffice.showCommentDialog();
    }

    private void locateMark(int rowIndex) {
        String markKey = (String)this.getModel().getValue("doc_key", rowIndex);
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        webOffice.locateMark(markKey);
    }

    private void deleteMark(int rowIndex) {
        String markKey = (String)this.getModel().getValue("doc_key", rowIndex);
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        webOffice.deleteMarks(Collections.singletonList(markKey));
        this.getModel().deleteEntryRow("entryentity_doc", rowIndex);
    }

    private void insertVariable(int rowIndex) {
        String name = (String)this.getModel().getValue("name", rowIndex);
        String key = (String)this.getModel().getValue("key", rowIndex);
        int row = this.getModel().insertEntryRow("entryentity_doc", 0);
        String markKey = key + "_" + System.currentTimeMillis();
        String markValue = "\u3010" + name + "\u3011";
        this.getModel().setValue("doc_name", (Object)name, row);
        this.getModel().setValue("doc_variable", (Object)key, row);
        this.getModel().setValue("doc_key", (Object)markKey, row);
        this.getModel().setValue("doc_value", (Object)markValue, row);
        this.getModel().setValue("doc_del", (Object)"delete bookmark", row);
        this.getModel().setValue("doc_location", (Object)"location bookmark", row);
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        webOffice.addMarks(new WebOfficeMark(markKey, markValue));
    }

    private void initVariableGrid(String docNumber) {
        MainEntityType mainEntity = EntityMetadataCache.getDataEntityType((String)docNumber);
        Map dataMap = mainEntity.getFields();
        if (!dataMap.isEmpty()) {
            this.getModel().deleteEntryData("entryentity");
            this.getModel().batchCreateNewEntryRow("entryentity", dataMap.size());
            int i = 0;
            for (Map.Entry entry : dataMap.entrySet()) {
                String name = ((IDataEntityProperty)entry.getValue()).getDisplayName().toString();
                this.getModel().setValue("name", (Object)name, i);
                this.getModel().setValue("key", entry.getKey(), i);
                this.getModel().setValue("operation", (Object)"insert variable", i);
                ++i;
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"deletewatermark", "addwatermark", "insertimage", "btn_save", "btn_saveaspdf", "btn_insert_confirm", "btn_locate", "btn_compare", "btn_comment", "btn_protect", "btn_unprotect", "btn_limit_doc", "btn_unlimit_doc", "btn_edit_role", "btn_insert_table", "btn_insert_table_mark", "btn_show_trace", "btn_doc_change", "btn_get_all_bookmark", "btn_mark_check", "btn_get_all_checkbox", "btn_get_txt", "btn_checkbox_false", "btn_checkbox_true", "btn_add_tablecolumns", "btn_add_tablerows", "btn_set_text_style", "btn_set_selectionasfield", "btn_get_isfieldrevise", "btn_caption", "btn_set_toolbars", "btn_set_titlebar", "btn_set_menubar", "btn_set_docasfield", "btn_send_openstatus", "btn_opennew", "btn_opennew_excel", "btn_opennew_ppt", "btn_close", "btn_set_toolbars_t", "btn_set_titlebar_t", "btn_set_menubar_t", "btn_show_trace_false", "btn_show", "btn_show_false"});
        Button uploadButton = (Button)this.getControl("btn_upload");
        uploadButton.addUploadListener((UploadListener)this);
        Button mergedocs = (Button)this.getControl("btn_mergedocs");
        mergedocs.addUploadListener((UploadListener)this);
        EntryGrid grid = (EntryGrid)this.getControl("entryentity");
        grid.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid markGrid = (EntryGrid)this.getControl("entryentity_doc");
        markGrid.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid editGrid = (EntryGrid)this.getControl("entity_edit");
        editGrid.addHyperClickListener((HyperLinkClickListener)this);
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        webOffice.addUploadListener(this);
        webOffice.addDataListener(this);
        webOffice.addCloseListener(this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctrl = (Control)evt.getSource();
        switch (ctrl.getKey()) {
            case "insertimage": {
                this.insertImage();
                break;
            }
            case "btn_save": {
                this.saveDoc();
                break;
            }
            case "btn_saveaspdf": {
                this.saveAsPDF();
                break;
            }
            case "btn_insert_confirm": {
                this.insertValue();
                break;
            }
            case "btn_comment": {
                this.showCommentdialog();
                break;
            }
            case "btn_protect": {
                this.protectDoc();
                break;
            }
            case "btn_unprotect": {
                this.unProtectedDoc();
                break;
            }
            case "btn_limit_doc": {
                this.limitDoc();
                break;
            }
            case "btn_unlimit_doc": {
                this.unlimitDoc();
                break;
            }
            case "btn_edit_role": {
                this.setAreaEditRole();
                break;
            }
            case "btn_insert_table": {
                this.addTable("cursor");
                break;
            }
            case "btn_insert_table_mark": {
                this.addTable("bookmark");
                break;
            }
            case "btn_show": {
                this.show();
                break;
            }
            case "btn_show_false": {
                this.show_false();
                break;
            }
            case "btn_show_trace": {
                this.showTracking();
                break;
            }
            case "btn_show_trace_false": {
                this.showTracking_false();
                break;
            }
            case "btn_doc_change": {
                this.checkDocChange();
                break;
            }
            case "btn_get_all_bookmark": {
                this.getAllBookmarks();
                break;
            }
            case "btn_mark_check": {
                this.bookMarkCheck();
                break;
            }
            case "btn_get_txt": {
                this.getTxt();
                break;
            }
            case "btn_get_all_checkbox": {
                this.getAllCheckbox();
                break;
            }
            case "btn_checkbox_false": {
                this.setCheckBox(false);
                break;
            }
            case "btn_checkbox_true": {
                this.setCheckBox(true);
                break;
            }
            case "btn_add_tablecolumns": {
                this.addTableColumns();
                break;
            }
            case "btn_add_tablerows": {
                this.addTableRows();
                break;
            }
            case "btn_set_text_style": {
                this.setTextStyle();
                break;
            }
            case "btn_set_selectionasfield": {
                this.addBookmarkForSelection();
                break;
            }
            case "btn_get_isfieldrevise": {
                this.getFieldRevise();
                break;
            }
            case "btn_caption": {
                this.setCaption();
                break;
            }
            case "btn_set_toolbars": {
                this.setToolbars();
                break;
            }
            case "btn_set_titlebar": {
                this.setTitlebar();
                break;
            }
            case "btn_set_menubar": {
                this.setMenubar();
                break;
            }
            case "btn_set_docasfield": {
                this.setDocAsField();
                break;
            }
            case "btn_send_openstatus": {
                this.sendOpenStatus();
                break;
            }
            case "btn_opennew": {
                this.openNew();
                break;
            }
            case "btn_opennew_excel": {
                this.openNewEXCEL();
                break;
            }
            case "btn_opennew_ppt": {
                this.openNewPPT();
                break;
            }
            case "btn_close": {
                this.close();
                break;
            }
            case "btn_set_toolbars_t": {
                this.setToolbars_t();
                break;
            }
            case "btn_set_titlebar_t": {
                this.setTitlebar_t();
                break;
            }
            case "btn_set_menubar_t": {
                this.setMenubar_t();
                break;
            }
            case "addwatermark": {
                this.waterMark(null);
                break;
            }
            case "deletewatermark": {
                this.waterMark("deletewatermark");
                break;
            }
        }
    }

    private void waterMark(String key) {
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        if (key != null) {
            webOffice.delWaterMark();
        } else {
            WebofficeWaterMark waterMark = new WebofficeWaterMark();
            waterMark.setFontSize(100);
            waterMark.setFontFamily("SansSerif");
            waterMark.setLeft("center");
            waterMark.setTop("center");
            waterMark.setFontColor("red");
            waterMark.setText("test123");
            waterMark.setRotation(45);
            waterMark.setTransparency(0.5f);
            webOffice.addWaterMark(waterMark);
        }
    }

    private void insertImage() {
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        ArrayList<WebOfficeImage> list = new ArrayList<WebOfficeImage>();
        WebOfficeImage wi = new WebOfficeImage();
        wi.setImageUrl(UrlService.getDomainContextUrl() + "/images/pc/emotion/qgh.png");
        WebOfficeImageStyle s = new WebOfficeImageStyle();
        s.setHeight("20px");
        s.setWidth("20px");
        wi.setImageStyle(s);
        wi.setField("bookmark");
        WebOfficeImage wi1 = new WebOfficeImage();
        wi1.setImageUrl(UrlService.getDomainContextUrl() + "/images/pc/emotion/qgh.png");
        WebOfficeImageStyle s1 = new WebOfficeImageStyle();
        s1.setHeight("25");
        s1.setWidth("25");
        wi1.setImageStyle(s1);
        WebOfficeImage wi2 = new WebOfficeImage();
        wi2.setImageUrl(UrlService.getDomainContextUrl() + "/images/pc/emotion/qgh.png");
        WebOfficeImageStyle s2 = new WebOfficeImageStyle();
        s2.setHeight("50");
        s2.setWidth("50");
        wi2.setImageStyle(s2);
        wi2.setField("bookmark1");
        WebOfficeImage wi3 = new WebOfficeImage();
        wi3.setImageUrl(UrlService.getDomainContextUrl() + "/images/pc/emotion/qgh.png");
        WebOfficeImageStyle s3 = new WebOfficeImageStyle();
        s3.setHeight("5cm");
        s3.setWidth("5cm");
        wi3.setImageStyle(s3);
        wi3.setField("bookmark2");
        list.add(wi);
        list.add(wi1);
        list.add(wi2);
        list.add(wi3);
        webOffice.insertPictures(list);
    }

    private void saveAsPDF() {
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        webOffice.saveAsLocal();
    }

    private void show() {
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        webOffice.setTrackingMode(RequestContext.get().getUserName(), WebOfficeTrackingType.TRACKING_EDIT);
    }

    private void show_false() {
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        webOffice.setTrackingMode(RequestContext.get().getUserName(), WebOfficeTrackingType.NO_TRACE);
    }

    private void close() {
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        webOffice.close();
    }

    private void openNew() {
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        this.getPageCache().put("opentype", "word");
        webOffice.openNew(WebOfficeFileType.word);
    }

    private void openNewEXCEL() {
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        this.getPageCache().put("opentype", "excel");
        webOffice.openNew(WebOfficeFileType.excel);
    }

    private void openNewPPT() {
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        this.getPageCache().put("opentype", "ppt");
        webOffice.openNew(WebOfficeFileType.ppt);
    }

    private void openAll() {
        String currentPath;
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        String url = currentPath = this.getClass().getResource(".").getFile();
        url = url.substring(1);
        url = url.replace("webofficedemo/bin/main/com/kd/demo/weboffice/", "webofficedemo/src/main/resources/docsUrl.docx");
        url = url.replace("/", "//");
        webOffice.openAll(url, "xlsxUrl.xlsx");
    }

    private void sendOpenStatus() {
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        webOffice.sendOpenStatus();
    }

    private void setDocAsField() {
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        webOffice.setDocAsField("bookMark");
    }

    private void setToolbars() {
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        webOffice.setToolbars(false);
    }

    private void setTitlebar() {
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        webOffice.setTitlebar(false);
    }

    private void setMenubar() {
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        webOffice.setMenubar(false);
    }

    private void setToolbars_t() {
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        webOffice.setToolbars(true);
    }

    private void setTitlebar_t() {
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        webOffice.setTitlebar(true);
    }

    private void setMenubar_t() {
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        webOffice.setMenubar(true);
    }

    private void setCaption() {
        Object data = this.getModel().getValue("txt_msg");
        if (null == data) {
            return;
        }
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        String c = data.toString();
        webOffice.setCaption(c);
        this.getPageCache().put("caption", c);
    }

    private void mergeDocs() {
        String currentPath;
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        String[] docsUrl = new String[1];
        String url = currentPath = this.getClass().getResource(".").getFile();
        url = url.substring(1);
        url = url.replace("webofficedemo/bin/main/com/kd/demo/weboffice/", "webofficedemo/src/main/resources/docsUrl.docx");
        docsUrl[0] = url = url.replace("/", "//");
        webOffice.mergeDocs(WebOfficeMergeType.cursor, docsUrl);
    }

    private void setCheckBox(boolean flag) {
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        String checkboxId = (String)this.getModel().getValue("txt_checkboxid");
        if (StringUtils.isBlank((CharSequence)checkboxId)) {
            this.getView().showErrorNotification("please input 'checkbox Id' first");
            return;
        }
        webOffice.setCheckBoxChecked(flag, checkboxId);
    }

    private void getAllCheckbox() {
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        webOffice.getAllCheckBoxs();
    }

    private void getTxt() {
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        String mark = (String)this.getModel().getValue("txt_mark");
        if (StringUtils.isBlank((CharSequence)mark)) {
            this.getView().showErrorNotification("please input bookmark for insert into table");
            return;
        }
        webOffice.getTextByBookmark(mark);
    }

    private void getFieldRevise() {
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        String mark = (String)this.getModel().getValue("txt_mark");
        if (StringUtils.isBlank((CharSequence)mark)) {
            this.getView().showErrorNotification("please input bookmark for insert into table");
            return;
        }
        webOffice.sendIsFieldRevise(mark);
    }

    private void bookMarkCheck() {
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        String mark = (String)this.getModel().getValue("txt_mark");
        if (StringUtils.isBlank((CharSequence)mark)) {
            this.getView().showErrorNotification("please input bookmark for insert into table");
            return;
        }
        webOffice.checkBookmark(mark);
    }

    private void getAllBookmarks() {
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        webOffice.getAllBookmarks("this is test ID");
    }

    private void checkDocChange() {
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        webOffice.isDocChanged();
    }

    private void setTextStyle() {
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        String type = (String)this.getModel().getValue("type");
        if (type != null && type.length() > 0) {
            webOffice.setTextStyle("bookmark", type);
        } else {
            this.getView().showMessage("please choose title type");
        }
    }

    private void addBookmarkForSelection() {
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        webOffice.addBookmarkForSelection("bookmark");
        this.getView().showSuccessNotification("add bookmark success");
    }

    private void addTableColumns() {
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        String[][] tableDatas = new String[][]{{"gender", "man", "woman"}, {"tall", "177", "155"}};
        webOffice.addTableColumns("cursor", tableDatas);
    }

    private void addTableRows() {
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        String[][] tableDatas = new String[][]{{"4", "jordan", "18"}, {"5", "james", "18"}};
        webOffice.addTableRows("cursor", tableDatas);
    }

    private void showTracking() {
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        String userName = RequestContext.get().getUserName();
        webOffice.showTracesBy(userName, true);
    }

    private void showTracking_false() {
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        String userName = RequestContext.get().getUserName();
        webOffice.showTracesBy(userName, false);
    }

    private void addTable(String type) {
        String[][] tableDatas = new String[][]{{"number", "name", "age"}, {"1", "jordan", "18"}, {"2", "james", "20"}, {"3", "mike", "19"}};
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        if ("bookmark".equals(type)) {
            String mark = (String)this.getModel().getValue("txt_mark");
            if (StringUtils.isBlank((CharSequence)mark)) {
                this.getView().showErrorNotification("please input bookmark for insert into table");
                return;
            }
            webOffice.addTable(tableDatas);
        } else {
            webOffice.addTable(tableDatas);
        }
    }

    private void setAreaEditRole() {
        DynamicObject user = (DynamicObject)this.getModel().getValue("edit_user");
        if (null == user) {
            this.getView().showErrorNotification("please choose user");
            return;
        }
        Object id = user.getPkValue();
        String mark = "user_" + id + "_" + new SecureRandom().nextInt(10000);
        int row = this.getModel().insertEntryRow("entity_edit", 0);
        this.getModel().setValue("editor", id, row);
        this.getModel().setValue("edit_bookmark", (Object)mark, row);
        this.getModel().setValue("edit_operation", (Object)"delete bookmark", row);
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        webOffice.setSelectedAreaEditBookmark(mark);
    }

    private void limitDoc() {
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        webOffice.limitDoc("webofficeap");
    }

    private void unlimitDoc() {
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        webOffice.unLimitDoc("webofficeap");
    }

    private void saveDoc() {
        String caption = this.getPageCache().get("caption");
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        webOffice.save("name");
        this.getPageCache().put("caption", caption);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
    }

    private void insertValue() {
        Object data = this.getModel().getValue("txt_msg");
        if (null == data) {
            return;
        }
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        webOffice.insertValue(data.toString(), true);
    }

    public void afterUpload(UploadEvent evt) {
        String tExtend;
        String tFileName;
        String[] files;
        String name;
        String tUrl;
        WebOffice webOffice;
        String type = this.getPageCache().get("opentype");
        String caption = this.getPageCache().get("caption");
        Object[] urls = evt.getUrls();
        if (null == urls || urls.length == 0) {
            this.getView().showErrorNotification("please upload file");
            return;
        }
        Object urlData = urls[0];
        String filePath = "";
        String fileName = "";
        String url = "";
        if (urlData instanceof String) {
            filePath = urlData.toString();
            fileName = filePath.substring(filePath.lastIndexOf(47));
            String[] files2 = fileName.split("\\.");
            String tFileName2 = files2.length == 2 ? files2[0] : UUID.randomUUID().toString();
            try {
                tFileName2 = URLEncoder.encode(tFileName2, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                log.error(e.getMessage());
            }
            String tExtend2 = files2.length == 2 ? files2[1] : "doc";
            fileName = tFileName2 + "." + tExtend2;
            url = filePath;
        } else if (urlData instanceof Map) {
            filePath = ((Map)urlData).get("url").toString();
            fileName = UUID.randomUUID().toString();
            url = filePath;
        }
        if (url.contains("tempfile")) {
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            InputStream in = cache.getInputStream(url);
            FileService service = FileServiceFactory.getAttachmentFileService();
            String suffix = ".doc";
            if (type != null) {
                if (type.equals("excel")) {
                    suffix = ".xls";
                } else if (type.equals("word")) {
                    suffix = ".doc";
                } else if (type.equals("ppt")) {
                    suffix = ".ppt";
                }
            }
            this.getPageCache().remove("opentype");
            String path = "/webofficedemo_" + System.currentTimeMillis() + "/" + fileName + suffix;
            try {
                fileName = URLEncoder.encode(fileName, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                log.error(e.getMessage());
            }
            fileName = fileName + suffix;
            FileItem fileItem = new FileItem(fileName, path, in);
            fileItem.setCreateNewFileWhenExists(true);
            String turl = service.upload(fileItem);
            cache.remove(url);
            url = turl;
        }
        this.getModel().setValue("file_name", (Object)fileName);
        this.getModel().setValue("file_url", (Object)url);
        String key = evt.getCallbackKey();
        if ("btn_upload".equals(key)) {
            webOffice = (WebOffice)this.getControl("webofficeap");
            tUrl = UrlService.getAttachmentFullUrl((String)url);
            name = tUrl.substring(tUrl.lastIndexOf(47));
            files = name.split("\\.");
            tFileName = files.length == 2 ? files[0] : UUID.randomUUID().toString();
            try {
                tFileName = URLEncoder.encode(tFileName, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                log.error(e.getMessage());
            }
            tExtend = files.length == 2 ? files[1] : "doc";
            name = tFileName + "." + tExtend;
            tUrl = tUrl.substring(0, tUrl.lastIndexOf(47));
            tUrl = tUrl + name;
            webOffice.openAll(tUrl, name);
            String userName = RequestContext.get().getUserName();
            webOffice.setTrackingMode(userName, WebOfficeTrackingType.NO_TRACE);
        } else if ("btn_mergedocs".equals(key)) {
            webOffice = (WebOffice)this.getControl("webofficeap");
            tUrl = UrlService.getAttachmentFullUrl((String)url);
            name = tUrl.substring(tUrl.lastIndexOf(47));
            files = name.split("\\.");
            tFileName = files.length == 2 ? files[0] : UUID.randomUUID().toString();
            try {
                tFileName = URLEncoder.encode(tFileName, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                log.error(e.getMessage());
            }
            tExtend = files.length == 2 ? files[1] : "doc";
            name = tFileName + "." + tExtend;
            tUrl = tUrl.substring(0, tUrl.lastIndexOf(47));
            tUrl = tUrl + name;
            String[] docsUrl = new String[]{tUrl};
            webOffice.mergeDocs(WebOfficeMergeType.cursor, docsUrl);
            String userName = RequestContext.get().getUserName();
            webOffice.setTrackingMode(userName, WebOfficeTrackingType.NO_TRACE);
        } else if ("webofficeap".equals(key)) {
            int versionCode;
            DynamicObjectCollection bookMarks = this.getModel().getEntryEntity("entryentity_doc");
            Long id = (Long)this.getModel().getValue("id");
            DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)id, (String)"test_wb_doc_templete");
            object.set("current_doc_url", (Object)url);
            object.set("current_doc_name", (Object)fileName);
            object.set("current_doc_caption", (Object)caption);
            DynamicObjectCollection versions = object.getDynamicObjectCollection("entry_version");
            int n = versionCode = versions == null || versions.isEmpty() ? 1 : ((DynamicObject)versions.get(versions.size() - 1)).getInt("version") + 1;
            if (versions != null) {
                DynamicObject version = new DynamicObject(versions.getDynamicObjectType());
                version.set("version_name", (Object)fileName);
                version.set("version_url", (Object)url);
                version.set("version", (Object)versionCode);
                version.set("seq", (Object)versionCode);
                versions.add((Object)version);
            }
            DynamicObjectCollection list = object.getDynamicObjectCollection("entry_variable");
            list.clear();
            int index = 1;
            for (DynamicObject mark : bookMarks) {
                DynamicObject obj = new DynamicObject(list.getDynamicObjectType());
                obj.set("variable_name", mark.get("doc_name"));
                obj.set("variable_key", mark.get("doc_key"));
                obj.set("variable_value", mark.get("doc_value"));
                obj.set("variable_map", mark.get("doc_variable"));
                obj.set("seq", (Object)index++);
                list.add((Object)obj);
            }
            DynamicObjectCollection permMarks = this.getModel().getEntryEntity("entity_edit");
            DynamicObjectCollection perms = object.getDynamicObjectCollection("entity_edit_perm");
            perms.clear();
            index = 1;
            for (DynamicObject mark : permMarks) {
                DynamicObject obj = new DynamicObject(perms.getDynamicObjectType());
                obj.set("edit_user", mark.get("editor"));
                obj.set("bookmark", mark.get("edit_bookmark"));
                obj.set("seq", (Object)index++);
                perms.add((Object)obj);
            }
            BusinessDataWriter.save((IDataEntityType)object.getDynamicObjectType(), (Object[])new Object[]{object});
            this.getView().showSuccessNotification("save success");
        }
    }

    public static FormShowParameter show(Long id, String docNumber, String docUrl, String docName) {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("test_wb_tpl_edit");
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCustomParam("id", (Object)id);
        param.setCustomParam("doc_number", (Object)docNumber);
        param.setCustomParam("doc_url", (Object)docUrl);
        param.setCustomParam("doc_name", (Object)docName);
        return param;
    }

    @Override
    public void onGetDocChangeCheckResult(WebOfficeDocChangeEvent event) {
        this.getView().showSuccessNotification("received file change message, current status is:" + event.isChanged());
    }

    @Override
    public void onGetAllBookmarks(WebOfficeBookmarkEvent event) {
        this.getView().showSuccessNotification("received get all bookmark,current bookmark:" + SerializationUtils.toJsonString(event.getBookmarks()) + ",ID is\uff1a" + event.getId());
    }

    @Override
    public void onGetBookmarkCheckResult(WebOfficeBookmarkCheckEvent event) {
        this.getView().showSuccessNotification("received get bookmark check,current bookmark:" + event.getBookmark() + ",check result:" + event.isExist());
    }

    @Override
    public void onGetTextByBookmark(WebOfficeBookmarkValueEvent event) {
        this.getView().showSuccessNotification("received get bookmark text,current bookmark:" + event.getBookmark() + ",get result:" + event.getValue());
    }

    @Override
    public void onGetAllCheckBoxes(WebOfficeCheckboxEvent event) {
        this.getView().showMessage("received get all 'checkbox'\uff0ccurrent total:" + SerializationUtils.toJsonString(event.getCheckBoxes()));
    }

    @Override
    public void onIsFieldRevise(WebOfficeIsFieldReviseEvent event) {
        this.getView().showSuccessNotification("whether update:" + SerializationUtils.toJsonString((Object)event.isFieldRevise()));
    }

    @Override
    public void onSendOpenStatus(WebOfficeOpenStatusEvent event) {
        this.getView().showSuccessNotification("file status:" + event.isOpen());
    }

    @Override
    public void afterClosed(WebOfficeAfterClosedEvent arg0) {
        log.info("WebOffice intelligent window closed");
    }
}

