/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.control.test;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.test.DocComparePlugIn;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.mvc.form.helper.WebOfficeBrowserHelper;
import kd.bos.mvc.form.helper.WebOfficeBrowserParam;
import kd.bos.url.UrlService;

public class DocTplPlugIn
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_compare"});
        this.addClickListeners(new String[]{"btn_compare1"});
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctrl = (Control)evt.getSource();
        switch (ctrl.getKey()) {
            case "btn_compare": {
                this.compareDoc();
                break;
            }
            case "btn_compare1": {
                this.openCompareDoc();
                break;
            }
        }
    }

    private void openCompareDoc() {
        Long id = (Long)this.getModel().getValue("id");
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put("id", id);
        WebOfficeBrowserParam webOfficeBrowserParam = new WebOfficeBrowserParam("test_wb_compare");
        webOfficeBrowserParam.setParams(customParams);
        String url = WebOfficeBrowserHelper.buildUrl(webOfficeBrowserParam);
        this.getView().openUrl(url);
    }

    private void compareDoc() {
        EntryGrid versionGrid = (EntryGrid)this.getControl("entry_version");
        int[] rows = versionGrid.getSelectRows();
        if (null == rows || rows.length != 2) {
            this.getView().showErrorNotification("please compare two version");
            return;
        }
        String fileName1 = (String)this.getModel().getValue("version_name", rows[0]);
        String url1 = (String)this.getModel().getValue("version_url", rows[0]);
        url1 = UrlService.getAttachmentFullUrl((String)url1);
        String fileName2 = (String)this.getModel().getValue("version_name", rows[1]);
        String url2 = (String)this.getModel().getValue("version_url", rows[1]);
        url2 = UrlService.getAttachmentFullUrl((String)url2);
        FormShowParameter param = DocComparePlugIn.show(url1, fileName1, url2, fileName2);
        this.getView().showForm(param);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "btn_doc": {
                this.showDocEdit(false);
                break;
            }
            case "btn_doc_hideaddressbar": {
                this.showDocEdit(true);
            }
        }
    }

    private void showDocEdit(boolean isHideAddressBar) {
        String docNumber;
        Long id = (Long)this.getModel().getValue("id");
        if (null == id || 0L == id) {
            this.getView().showTipNotification("please save template data first");
            return;
        }
        Object doc = this.getModel().getValue("doc");
        String string = docNumber = doc == null ? "" : ((DynamicObject)doc).getString("number");
        if (StringUtils.isBlank((CharSequence)docNumber)) {
            this.getView().showTipNotification("please choose applicable contract");
            return;
        }
        String docUrl = (String)this.getModel().getValue("current_doc_url");
        String docName = (String)this.getModel().getValue("current_doc_name");
        EntryGrid entrygrid = (EntryGrid)this.getView().getControl("entry_version");
        int[] s = entrygrid.getEntryState().getSelectedRows();
        if (s.length == 1) {
            docName = (String)this.getModel().getValue("version_name", s[0]);
            docUrl = (String)this.getModel().getValue("version_url", s[0]);
        } else if (s.length == 0) {
            // empty if block
        }
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put("id", id);
        customParams.put("doc_number", docNumber);
        customParams.put("doc_url", docUrl);
        customParams.put("doc_name", docName);
        WebOfficeBrowserParam webOfficeBrowserParam = new WebOfficeBrowserParam("test_wb_tpl_edit");
        webOfficeBrowserParam.setParams(customParams);
        webOfficeBrowserParam.setHideAddressBar(isHideAddressBar);
        String url = WebOfficeBrowserHelper.buildUrl(webOfficeBrowserParam);
        this.getView().openUrl(url);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
    }
}

