/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mvc.form.helper;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.helper.WebOfficeBrowserParam;
import kd.bos.session.EncreptSessionUtils;
import kd.bos.url.UrlService;
import kd.bos.util.RevProxyUtil;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class WebOfficeBrowserHelper {
    private static final Log log = LogFactory.getLog(WebOfficeBrowserHelper.class);

    public static String buildUrl(WebOfficeBrowserParam param) {
        Map<String, Object> params;
        StringBuilder formUrl = new StringBuilder();
        formUrl.append("?formId=").append(param.getFormId());
        if (StringUtils.isNotBlank((CharSequence)param.getBillFormId())) {
            formUrl.append("&billFormId=").append(param.getBillFormId());
        }
        StringBuilder dFormUrl = new StringBuilder();
        dFormUrl.append("#/dform?formId=").append(param.getFormId());
        if (StringUtils.isNotBlank((CharSequence)param.getBillFormId())) {
            dFormUrl.append("&billFormId=").append(param.getBillFormId());
        }
        if (StringUtils.isNotBlank((CharSequence)param.getPkId())) {
            dFormUrl.append("&pkId=").append(param.getPkId());
        }
        if (param.getStatus() != null) {
            dFormUrl.append("&Status=").append(param.getStatus().getValue());
        }
        if (null != (params = param.getParams()) && !params.isEmpty()) {
            String customParams = "";
            try {
                customParams = URLEncoder.encode(SerializationUtils.toJsonString(params), "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                log.error((Throwable)e);
            }
            if (StringUtils.isNotBlank((CharSequence)customParams)) {
                dFormUrl.append("&customParams=").append(customParams);
            }
        }
        String protocol = param.getProtocol();
        String domainUrl = UrlService.getDomainContextUrl();
        domainUrl = RevProxyUtil.addSlash((String)domainUrl);
        StringBuilder url = new StringBuilder();
        url.append(protocol).append(domainUrl).append((CharSequence)formUrl);
        try {
            return dFormUrl.insert(0, EncreptSessionUtils.encryptTokenLoinSession((String)url.toString())).toString();
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }
}

