/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.log.business;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.id.ID;
import kd.bos.log.business.es.Strategy;
import kd.bos.log.business.es.StrategyContext;
import kd.bos.log.business.es.StrategyEnum;
import kd.bos.log.business.es.StrategyUtil;
import kd.bos.log.business.es.config.StrategyConfig;
import kd.bos.log.business.es.impl.CapacityStrategy;
import kd.bos.log.business.es.impl.CombineStrategy;
import kd.bos.log.business.es.impl.TimeStrategy;
import kd.bos.log.service.elasticsearch.ElasticsearchService;
import kd.bos.log.service.util.EsPropertiesUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;

public class IndexCreateTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(IndexCreateTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        logger.info("create index scheduled task start");
        try {
            StrategyEnum strategyEnum = StrategyUtil.getCurrentStrategy();
        }
        catch (Exception e) {
            logger.error("elasticsearch getCurrentStrategy error", (Throwable)e);
            throw new KDBizException("elasticsearch getCurrentStrategy error");
        }
        this.doCreateIndex(this.initConfig(), requestContext);
    }

    private Properties initConfig() {
        JSONObject properties = EsPropertiesUtils.getTenantEsProperties();
        Properties config = new Properties();
        config.put("hostname", properties.getString("host"));
        config.put("port", properties.getString("port"));
        config.put("userName", properties.getString("userName"));
        config.put("password", properties.getString("passwd"));
        config.put("scheme", properties.getString("schema"));
        return config;
    }

    private String buildCreateIndex(RequestContext requestContext, String currentIndex) {
        String indexTep = EsPropertiesUtils.getTenantEsIndexTep();
        if (indexTep == null) {
            logger.error("\u7d22\u5f15\u521b\u5efa\u5b9a\u65f6\u4efb\u52a1\uff0c\u7d22\u5f15\u6a21\u677f\u4e3a\u7a7a");
            throw new KDBizException(ResManager.loadKDString((String)"\u7d22\u5f15\u521b\u5efa\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25\uff0c\u7d22\u5f15\u6a21\u677f\u4e3a\u7a7a\u3002", (String)"IndexCreateTask_0", (String)"bos-log-business", (Object[])new Object[0]));
        }
        indexTep = indexTep.toLowerCase();
        LocalDate now = LocalDate.now();
        DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("yyyy-MM");
        String time = now.format(timeFormatter);
        String tenantId = requestContext.getTenantId().toLowerCase();
        String accountId = requestContext.getAccountId().toLowerCase();
        if (!indexTep.contains(tenantId) || !indexTep.contains(accountId)) {
            String msg = String.format(ResManager.loadKDString((String)"\u7d22\u5f15\u521b\u5efa\u5b9a\u65f6\u4efb\u52a1\uff0c\u64cd\u4f5c\u65e5\u5fd7ES\u914d\u7f6e\u7d22\u5f15\u6a21\u677f\u7684\u79df\u6237ID\u548c\u6570\u636e\u4e2d\u5fc3ID\u4e0e\u5f53\u524d\u73af\u5883\u4e0d\u4e00\u81f4\uff0cindexTep\uff1a%1$s\uff0c\u5f53\u524d\u79df\u6237ID\uff1a%2$s\uff0c\u5f53\u524d\u6570\u636e\u4e2d\u5fc3ID\uff1a%3$s\u3002", (String)"IndexCreateTask_1", (String)"bos-log-business", (Object[])new Object[0]), indexTep, tenantId, accountId);
            logger.error(msg);
            throw new KDBizException(msg);
        }
        ElasticsearchService service = ElasticsearchService.getInstance();
        Set indices = service.getAllIndexInElasticsearch();
        for (int i = 0; i < 3; ++i) {
            String createIndex = indexTep.replace("*", time) + "-" + ID.genLongId();
            if (indices.contains(createIndex)) continue;
            return createIndex;
        }
        return indexTep.replace("*", time) + "-" + ID.genLongId();
    }

    public void doCreateIndex(Properties config, RequestContext requestContext) {
        block28: {
            ElasticsearchService service = ElasticsearchService.getInstance();
            String sql = "select top 1,0  fid,fname,fcreatetime  from t_log_index order by fcreatetime desc";
            try (DataSet dataSet = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.log, (String)sql);){
                if (dataSet != null && !dataSet.isEmpty()) {
                    try {
                        Row row = (Row)dataSet.iterator().next();
                        Long fid = row.getLong(0);
                        String index = row.getString(1);
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                        String lastTime = sdf.format(row.get(2));
                        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                        LocalDate lastDate = LocalDate.parse(lastTime, dateTimeFormatter);
                        Tuple<StrategyEnum, StrategyConfig> tuple = StrategyUtil.buildStrategy(lastDate, service, index, this.buildCreateIndex(requestContext, index));
                        if (tuple != null && tuple.item1 != StrategyEnum.NO_ONE) {
                            StrategyContext context;
                            boolean result;
                            Strategy strategyActual = null;
                            if (StrategyEnum.TIME == tuple.item1) {
                                strategyActual = new TimeStrategy();
                            } else if (StrategyEnum.CAPACITY == tuple.item1) {
                                strategyActual = new CapacityStrategy();
                            } else if (StrategyEnum.TIMEWITHCAPACITY == tuple.item1) {
                                strategyActual = new CombineStrategy();
                            }
                            if (strategyActual != null && (result = (context = new StrategyContext(strategyActual, (StrategyConfig)tuple.item2)).create(3))) {
                                long id = ID.genLongId();
                                String insertSql = "insert into t_log_index (fid,fname,fcreatetime,fstatus,fstrategy) values (?,?,?,?,?)";
                                Object[] record = new Object[]{id, ((StrategyConfig)tuple.item2).getCreateIndex(), new Date(System.currentTimeMillis()), "1", StrategyUtil.getCurrentStrategy().getValue()};
                                DB.execute((DBRoute)DBRoute.log, (String)insertSql, (Object[])record);
                                this.updateLastIndexCapAndDocs(fid, index, service);
                            }
                        }
                        break block28;
                    }
                    catch (Exception e) {
                        logger.error("\u7d22\u5f15\u521b\u5efa\u5b9a\u65f6\u4efb\u52a1\uff0c\u7d22\u5f15\u521b\u5efa\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                        throw new KDBizException(ResManager.loadKDString((String)"\u7d22\u5f15\u521b\u5efa\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25\uff0c\u7d22\u5f15\u521b\u5efa\u5f02\u5e38\u3002", (String)"IndexCreateTask_2", (String)"bos-log-business", (Object[])new Object[0]));
                    }
                }
                logger.error("\u7d22\u5f15\u521b\u5efa\u5b9a\u65f6\u4efb\u52a1\uff0c\u6570\u636e\u5e93\u4e2d\u67e5\u8be2\u7d22\u5f15\u4e0d\u5b58\u5728");
                for (int i = 0; i < 5; ++i) {
                    boolean result = false;
                    try {
                        result = this.createFirstIndex();
                    }
                    catch (Exception e) {
                        logger.error("\u7d22\u5f15\u521b\u5efa\u5b9a\u65f6\u4efb\u52a1\uff0c\u9996\u4e2a\u7d22\u5f15\u521b\u5efa\u5931\u8d25", (Throwable)e);
                        try {
                            Thread.sleep(3000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (result) {
                        break;
                    }
                    logger.error("\u7d22\u5f15\u521b\u5efa\u5b9a\u65f6\u4efb\u52a1\uff0c\u9996\u4e2a\u521b\u5efa\u7d22\u5f15\u5931\u8d25\uff0c\u8fdb\u884c\u7b2c" + i + "\u6b21\u91cd\u8bd5");
                }
            }
        }
    }

    private void updateLastIndexCapAndDocs(Long fid, String indexName, ElasticsearchService service) {
        Map info = service.getIndexStats(indexName);
        if (info != null && info.size() > 0) {
            Map all = (Map)info.get("_all");
            Map total = (Map)all.get("total");
            Map store = (Map)total.get("store");
            long capacity = Long.parseLong(String.valueOf(store.get("size_in_bytes")));
            Map docs = (Map)total.get("docs");
            long docsCount = Long.parseLong(String.valueOf(docs.get("count")));
            BigDecimal a = new BigDecimal(capacity);
            BigDecimal b = new BigDecimal(1024);
            double size = a.divide(b, 2, 4).doubleValue();
            String capacityStr = size + "KB";
            String sql = "update t_log_index set fcapacity=?,fdocs=? where fid=?";
            ArrayList<SqlParameter> params = new ArrayList<SqlParameter>(10);
            params.add(new SqlParameter("FCAPACITY", 12, (Object)capacityStr));
            params.add(new SqlParameter("FDOCS", -5, (Object)docsCount));
            params.add(new SqlParameter("FID", -5, (Object)fid));
            DB.update((DBRoute)DBRoute.log, (String)sql, (Object[])params.toArray(new SqlParameter[params.size()]));
        }
    }

    private boolean createFirstIndex() throws IOException {
        JSONObject properties = EsPropertiesUtils.getTenantEsProperties();
        if (properties == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u811a\u672c\u5347\u7ea7\u6267\u884c\u521b\u5efa\u64cd\u4f5c\u65e5\u5fd7ES\u7d22\u5f15\uff0c\u64cd\u4f5c\u65e5\u5fd7ES\u914d\u7f6e\u4e3a\u7a7a\u3002", (String)"EsUpgradeServicePlugin_2", (String)"bos-log-business", (Object[])new Object[0]));
        }
        String indexTep = properties.getString("indexTep").toLowerCase();
        LocalDate now = LocalDate.now();
        DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("yyyy-MM");
        String time = now.format(timeFormatter);
        String tenantId = RequestContext.get().getTenantId().toLowerCase();
        String accountId = RequestContext.get().getAccountId().toLowerCase();
        if (!indexTep.contains(tenantId) || !indexTep.contains(accountId)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u811a\u672c\u5347\u7ea7\u64cd\u4f5c\u65e5\u5fd7ES\u914d\u7f6e\u7d22\u5f15\u6a21\u677f\u7684\u79df\u6237ID\u548c\u6570\u636e\u4e2d\u5fc3ID\u4e0e\u5f53\u524d\u73af\u5883\u4e0d\u4e00\u81f4\uff0cindexTep\uff1a%1$s\uff0c\u5f53\u524d\u79df\u6237ID\uff1a%2$s\uff0c\u5f53\u524d\u6570\u636e\u4e2d\u5fc3ID\uff1a%3$s\u3002", (String)"EsUpgradeServicePlugin_3", (String)"bos-log-business", (Object[])new Object[0]), indexTep, tenantId, accountId));
        }
        ElasticsearchService service = ElasticsearchService.getInstance();
        Set indices = service.getAllIndexInElasticsearch();
        String createIndex = indexTep.replace("*", time) + "-1";
        for (int i = 0; i < 3 && indices.contains(createIndex = indexTep.replace("*", time) + "-" + ID.genLongId()); ++i) {
        }
        logger.info("\u811a\u672c\u5347\u7ea7\u4e0a\u673a\u64cd\u4f5c\u65e5\u5fd7ES\u7d22\u5f15\u521b\u5efa\u5347\u7ea7\uff0c\u521b\u5efa\u7d22\u5f15\u4e3a\uff1a" + createIndex);
        boolean result = service.createIndex(createIndex);
        if (!result) {
            String msg = String.format(ResManager.loadKDString((String)"\u811a\u672c\u5347\u7ea7\u6267\u884c\u4e0a\u673a\u65e5\u5fd7ES\u7d22\u5f15\u521b\u5efa\u5347\u7ea7,\u7d22\u5f15:%1$s\u521b\u5efa\u5931\u8d25", (String)"EsUpgradeServicePlugin_4", (String)"bos-log-business", (Object[])new Object[0]), createIndex);
            throw new KDBizException(msg);
        }
        long id = ID.genLongId();
        String sql = "insert into t_log_index (fid,fname,fcreatetime,fstatus,fstrategy) values (?,?,?,?,?)";
        Object[] record = new Object[]{id, createIndex, new Date(System.currentTimeMillis()), "1", StrategyUtil.getCurrentStrategy().getValue()};
        DB.execute((DBRoute)DBRoute.log, (String)sql, (Object[])record);
        return true;
    }
}

