/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.log.business;

import com.alibaba.fastjson.JSON;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDException;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.service.rabbitmq.MQPublishService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;

public class LogRetrySendTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(LogRetrySendTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        this.doSend();
    }

    private void doSend() {
        String sql = "SELECT FID,FMESSAGE,FNEXTRETRYTIME,FRETRYTIMES FROM T_LOG_FAILRECORD WHERE FRETRYTIMES <3";
        try (DataSet dataSet = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.log, (String)sql);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                long id = row.getLong(0);
                String message = row.getString(1);
                List appLogInfoList = JSON.parseArray((String)message, AppLogInfo.class);
                Long nextTime = row.getLong(2);
                int retryTime = row.getInteger(3);
                if (nextTime != null && nextTime != 0L && Long.parseLong(String.valueOf(nextTime)) > System.currentTimeMillis()) continue;
                boolean result = MQPublishService.getInstance().sendForResult((Object)appLogInfoList);
                if (result) {
                    this.clearRecord(id);
                    continue;
                }
                this.updateRecord(id, retryTime);
            }
        }
        catch (Exception e) {
            logger.error("rabbitmq \u64cd\u4f5c\u65e5\u5fd7\u91cd\u8bd5\u6295\u9012\u4efb\u52a1\u8fd0\u884c\u5f02\u5e38 ", (Throwable)e);
        }
    }

    private void updateRecord(long id, int retryTime) {
        long nextRetryTime = System.currentTimeMillis();
        if (0 == retryTime) {
            nextRetryTime += 300000L;
        } else if (1 == retryTime) {
            nextRetryTime += 600000L;
        } else if (2 == retryTime) {
            nextRetryTime += 900000L;
        }
        String sql = "UPDATE T_LOG_FAILRECORD SET FRETRYTIMES=" + (retryTime + 1) + ',' + "FNEXTRETRYTIME=" + nextRetryTime + " WHERE FID=" + id;
        try {
            DB.execute((DBRoute)DBRoute.log, (String)sql);
        }
        catch (Exception e) {
            logger.error("rabbitmq \u64cd\u4f5c\u65e5\u5fd7\u91cd\u8bd5\u6295\u9012\u4efb\u52a1\u66f4\u65b0\u8bb0\u5f55\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    private void clearRecord(long id) {
        try {
            String sql = "DELETE FROM T_LOG_FAILRECORD WHERE FID=" + id;
            DB.execute((DBRoute)DBRoute.log, (String)sql);
        }
        catch (Exception e) {
            logger.error("rabbitmq \u64cd\u4f5c\u65e5\u5fd7\u91cd\u8bd5\u6295\u9012\u4efb\u52a1\u6e05\u9664\u53d1\u9001\u6210\u529f\u8bb0\u5f55\u5931\u8d25", (Throwable)e);
        }
    }
}

