/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.log.business.es.impl;

import java.io.IOException;
import java.time.LocalDate;
import kd.bos.log.business.es.Strategy;
import kd.bos.log.business.es.StrategyContext;
import kd.bos.log.business.es.StrategyUtil;
import kd.bos.log.business.es.config.CombineConfig;

public class CombineStrategy
implements Strategy {
    @Override
    public boolean create(StrategyContext context) throws IOException {
        CombineConfig config = (CombineConfig)context.getConfig();
        boolean needCreate = false;
        if (config.getCapacityConfig() != null && StrategyUtil.checkCapacity(config.getService(), config.getCurrentIndex(), config.getCapacityConfig().getCapacity())) {
            needCreate = true;
        }
        if (needCreate) {
            return config.getService().createIndex(config.getCreateIndex());
        }
        if (config.getTimeConfig() != null && StrategyUtil.compareDate(config.getTimeConfig().getLastDate(), LocalDate.now(), config.getTimeConfig().getInterval())) {
            needCreate = true;
        }
        if (needCreate) {
            return config.getService().createIndex(config.getCreateIndex());
        }
        return false;
    }
}

