/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.log.business.etl;

import java.text.SimpleDateFormat;
import java.util.Date;
import kd.bos.log.service.ArchiveLogSettingService;
import kd.bos.log.service.dto.LogSetting;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import org.apache.commons.lang3.time.DateUtils;

public class EtlService {
    public Long getCountByTime(Date time) {
        ORM orm = ORM.create();
        ArchiveLogSettingService archiveLogSettingService = new ArchiveLogSettingService();
        LogSetting logSetting = archiveLogSettingService.getLogSetting();
        QFilter endDateFilter = new QFilter("optime", "<", (Object)this.getArchiveDateTime(time, logSetting));
        QFilter[] filters = new QFilter[]{endDateFilter};
        int count = orm.count(this.getClass().getName(), "bos_log_operation_v3", filters);
        return count;
    }

    public Date getArchiveDateTime(Date date, LogSetting logSetting) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String datestr = format.format(date);
        int i = logSetting.getDay() * -1;
        try {
            date = format.parse(datestr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Date startDate = DateUtils.addDays((Date)date, (int)i);
        return startDate;
    }
}

