/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.log.business.historylog;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.log.business.historylog.HistoryLogUpgradeUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class HistoryLogUpgradeHelpService {
    private static final Log logger = LogFactory.getLog(HistoryLogUpgradeHelpService.class);

    private HistoryLogUpgradeHelpService() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Long getHeartBeatTime() {
        String sql = "SELECT FID,FHEARTBEATTIME FROM T_LOG_APPSETTING";
        try (DataSet dataSet = DB.queryDataSet((String)HistoryLogUpgradeHelpService.class.getName(), (DBRoute)DBRoute.log, (String)sql);){
            Long statusUpdateTime = null;
            if (!dataSet.isEmpty()) {
                Row row = dataSet.next();
                statusUpdateTime = row.getLong(1);
            }
            Long l = statusUpdateTime;
            return l;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return null;
        }
    }

    public static void updateHeartBeatTime() {
        String id = null;
        String sql = "SELECT FID FROM T_LOG_APPSETTING";
        try (DataSet dataSet = DB.queryDataSet((String)HistoryLogUpgradeHelpService.class.getName(), (DBRoute)DBRoute.log, (String)sql);){
            if (!dataSet.isEmpty()) {
                Row row = dataSet.next();
                id = row.getString(0);
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        if (null != id) {
            sql = "UPDATE T_LOG_APPSETTING SET FHEARTBEATTIME=? WHERE FID=?";
            ArrayList<SqlParameter> params = new ArrayList<SqlParameter>(10);
            params.add(new SqlParameter("FHEARTBEATTIME", -5, (Object)(System.currentTimeMillis() / 1000L)));
            params.add(new SqlParameter("FID", 12, (Object)id));
            DB.update((DBRoute)DBRoute.log, (String)sql, (Object[])params.toArray(new SqlParameter[params.size()]));
        }
    }

    public static String getUpgradeCurrentStep() {
        String sql = "SELECT FID,FCURRENTSTEP FROM T_LOG_APPSETTING";
        String currentStep = null;
        try (DataSet dataSet = DB.queryDataSet((String)HistoryLogUpgradeHelpService.class.getName(), (DBRoute)DBRoute.log, (String)sql);){
            if (!dataSet.isEmpty()) {
                Row row = dataSet.next();
                currentStep = row.getString(1);
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return currentStep;
    }

    public static void saveUpgradeCurrentStep(String currentStep) {
        String id = null;
        String sql = "SELECT FID FROM T_LOG_APPSETTING";
        try (DataSet dataSet = DB.queryDataSet((String)HistoryLogUpgradeHelpService.class.getName(), (DBRoute)DBRoute.log, (String)sql);){
            if (!dataSet.isEmpty()) {
                Row row = dataSet.next();
                id = row.getString(0);
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        if (null != id) {
            sql = "UPDATE T_LOG_APPSETTING SET FCURRENTSTEP=? WHERE FID=?";
            ArrayList<SqlParameter> params = new ArrayList<SqlParameter>(10);
            params.add(new SqlParameter("FCURRENTSTEP", 12, (Object)currentStep));
            params.add(new SqlParameter("FID", 12, (Object)id));
            DB.update((DBRoute)DBRoute.log, (String)sql, (Object[])params.toArray(new SqlParameter[params.size()]));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Long getDataSearchStartTime(String timeColumn) {
        String sql = "SELECT FID,%s FROM T_LOG_APPSETTING";
        Long startTime = 0L;
        try (DataSet dataSet = DB.queryDataSet((String)HistoryLogUpgradeHelpService.class.getName(), (DBRoute)DBRoute.log, (String)String.format(sql, timeColumn));){
            if (!dataSet.isEmpty()) {
                Row row = dataSet.next();
                startTime = row.getLong(1);
                if (startTime != null) {
                    if (startTime > 0L) return startTime;
                }
                Long l = HistoryLogUpgradeHelpService.getUpgradeStartTime();
                return l;
            }
            startTime = System.currentTimeMillis() / 1000L;
            return startTime;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return startTime;
    }

    public static void saveDataSearchStartTime(long searchStartTime, String timeColumn) {
        String id = null;
        String sql = "SELECT FID FROM T_LOG_APPSETTING";
        try (DataSet dataSet = DB.queryDataSet((String)HistoryLogUpgradeHelpService.class.getName(), (DBRoute)DBRoute.log, (String)sql);){
            if (!dataSet.isEmpty()) {
                Row row = dataSet.next();
                id = row.getString(0);
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        if (null != id) {
            sql = String.format("UPDATE T_LOG_APPSETTING SET %s=? WHERE FID=?", timeColumn);
            ArrayList<SqlParameter> params = new ArrayList<SqlParameter>(10);
            params.add(new SqlParameter(timeColumn, -5, (Object)searchStartTime));
            params.add(new SqlParameter("FID", 12, (Object)id));
            DB.update((DBRoute)DBRoute.log, (String)sql, (Object[])params.toArray(new SqlParameter[params.size()]));
        }
    }

    public static void saveUpgradeStartTime() {
        long startTime = System.currentTimeMillis() / 1000L;
        String id = null;
        Long lastTime = null;
        String sql = "SELECT FID,FDUMPEDCOUNT FROM T_LOG_APPSETTING";
        try (DataSet dataSet = DB.queryDataSet((String)HistoryLogUpgradeHelpService.class.getName(), (DBRoute)DBRoute.log, (String)sql);){
            if (!dataSet.isEmpty()) {
                Row row = dataSet.next();
                id = row.getString(0);
                lastTime = row.getLong(1);
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        if (null != id) {
            if (lastTime == null || lastTime <= 0L) {
                String updateSql = "UPDATE T_LOG_APPSETTING SET FDUMPEDCOUNT=" + startTime + " WHERE FID='" + id + "'";
                DB.execute((DBRoute)DBRoute.log, (String)updateSql);
            }
        } else {
            DynamicObject setObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_log_appsetting");
            setObj.set("dumpedcount", (Object)startTime);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{setObj});
        }
    }

    public static Long getUpgradeStartTime() {
        String sql = "SELECT FID,FDUMPEDCOUNT FROM T_LOG_APPSETTING";
        Long startTime = 0L;
        try (DataSet dataSet = DB.queryDataSet((String)HistoryLogUpgradeHelpService.class.getName(), (DBRoute)DBRoute.log, (String)sql);){
            if (!dataSet.isEmpty()) {
                Row row = dataSet.next();
                startTime = row.getLong(1);
            } else {
                startTime = System.currentTimeMillis() / 1000L;
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return startTime;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getUpgradeStatus() {
        String sql = "SELECT FUPGRADESTATUS FROM T_LOG_APPSETTING";
        try (DataSet dataSet = DB.queryDataSet((String)HistoryLogUpgradeHelpService.class.getName(), (DBRoute)DBRoute.log, (String)sql);){
            if (!dataSet.isEmpty()) {
                String status;
                Row row = dataSet.next();
                String string2 = status = row.getString(0);
                return string2;
            }
            String string = null;
            return string;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return null;
        }
    }

    public static void saveUpgradeFinalStatus(String status) {
        try (DataSet dataSet = DB.queryDataSet((String)HistoryLogUpgradeHelpService.class.getName(), (DBRoute)DBRoute.log, (String)"SELECT FID FROM T_LOG_APPSETTING");){
            if (!dataSet.isEmpty()) {
                Object id = dataSet.next().get("FID");
                if (id != null) {
                    String updateSql = "UPDATE T_LOG_APPSETTING SET FUPGRADESTATUS='" + status + "'" + " WHERE FID='" + id + "'";
                    DB.execute((DBRoute)DBRoute.log, (String)updateSql);
                }
            } else {
                DynamicObject setObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_log_appsetting");
                setObj.set("upgradestatus", (Object)status);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{setObj});
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    public static Map<Integer, Object> getUserMap() {
        Map<Integer, Object> userMap = HistoryLogUpgradeHelpService.dataSetToMap("SELECT G.FId \"user.id\", CASE WHEN B.ftruename IS NULL THEN G.ftruename WHEN B.ftruename = '' THEN G.ftruename WHEN B.ftruename = ' ' THEN G.ftruename ELSE B.ftruename END \"user.name\" ,B.FLOCALEID \"localeid\" FROM t_SEC_User G LEFT JOIN t_SEC_User_L B ON B.FId=G.FId", DBRoute.base);
        return userMap;
    }

    public static Map<Integer, Object> getOrgMap() {
        Map<Integer, Object> orgMap = HistoryLogUpgradeHelpService.dataSetToMap("SELECT H.FId \"org.id\", CASE WHEN E.FName IS NULL THEN H.FName WHEN E.FName = '' THEN H.FName WHEN E.FName = ' ' THEN H.FName ELSE E.FName END \"org.name\",E.FLOCALEID FROM t_ORG_ORG H LEFT JOIN t_ORG_ORG_L E ON E.FId=H.FId", DBRoute.base);
        return orgMap;
    }

    public static Map<Integer, Object> getAppMap() {
        Map<Integer, Object> appMap = HistoryLogUpgradeHelpService.dataSetToMap("SELECT C.FId \"bizapp.id\", C.fname \"bizapp.name\",C.FLOCALEID FROM t_meta_bizapp_L C", DBRoute.meta);
        return appMap;
    }

    public static Map<Integer, Object> getObjMap() {
        Map<Integer, Object> objMap = HistoryLogUpgradeHelpService.dataSetToMap("SELECT D.FNumber \"bizobj.id\", D.fname \"bizobj.name\",D.FLOCALEID FROM t_meta_formdesign_L D", DBRoute.meta);
        return objMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<Integer, Object> dataSetToMap(String sql, DBRoute dbRoute) {
        try (DataSet ds = DB.queryDataSet((String)HistoryLogUpgradeHelpService.class.getName(), (DBRoute)dbRoute, (String)sql);){
            if (ds.isEmpty()) return null;
            HashMap<Integer, Object> map = new HashMap<Integer, Object>(16);
            while (ds.hasNext()) {
                Row row = ds.next();
                Object id = row.get(0);
                Object name = row.get(1);
                Object localeId = row.get(2);
                int key = HistoryLogUpgradeUtils.getKey(id, localeId);
                map.put(key, name);
            }
            HashMap<Integer, Object> hashMap = map;
            return hashMap;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return null;
    }
}

