/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kws.login.impl;

import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.mc.tenant.AccountType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.exception.LoginErrorCode;
import kd.bos.kws.AccessTokenResult;
import kd.bos.kws.AppTokenResult;
import kd.bos.kws.login.ILogin;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.CacheLoginData;
import kd.bos.login.LoginClientEnum;
import kd.bos.login.api.APILoginError;
import kd.bos.login.api.LoginAPI;
import kd.bos.login.lang.LoginLangUtils;
import kd.bos.login.model.UserOrgsInfo;
import kd.bos.login.thirdauth.UserAccount;
import kd.bos.login.thirdauth.UserAuthResult;
import kd.bos.login.thirdauth.UserProperType;
import kd.bos.login.thirdauth.impl.SelfCreateAuth;
import kd.bos.login.user.LoginUserService;
import kd.bos.login.utils.APIUtils;
import kd.bos.login.utils.HttpUtils;
import kd.bos.login.utils.JSONUtils;
import kd.bos.login.utils.LoginUtils;
import kd.bos.login.utils.SessionUtils;
import kd.bos.login.utils.ThirdAPIAPPUtils;
import kd.bos.login.utils.account.LoginAccountFactory;
import kd.bos.util.NetAddressUtils;
import kd.bos.util.StringUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;

public class LoginImpl
implements ILogin {
    private static final String BOS_LOGIN = "bos-login";
    private static Log logger = LogFactory.getLog(LoginImpl.class);

    @Override
    public AppTokenResult getAppToken(String accountId, String tenantId, String language, String appId, String appSecuret) {
        AppTokenResult result = new AppTokenResult();
        result.setSuccess(false);
        try {
            Lang lang = LoginLangUtils.getLang(language);
            if (StringUtils.isEmpty((String)tenantId)) {
                throw new Exception(ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef:tenantId\u4e0d\u80fd\u83b7\u53d6\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"LoginImpl_0", (String)BOS_LOGIN, (Object[])new Object[0]));
            }
            Message message = PhaseInterceptorChain.getCurrentMessage();
            HttpServletRequest servletRequest = (HttpServletRequest)message.get((Object)"HTTP.REQUEST");
            Account currentCenter = LoginAccountFactory.createInstanceByCustom(accountId, servletRequest).getAccount();
            String appToken = ThirdAPIAPPUtils.getAppToken(currentCenter, lang.name(), appId, appSecuret);
            result.setAppToken(appToken);
            result.setSuccess(true);
        }
        catch (KDException e) {
            logger.debug("WEB Service\u8bf7\u6c42\u767b\u5f55\u5931\u8d25:" + e.getMessage());
            result.setErrorCode(e.getErrorCode().getCode());
            result.setErrorDescription(e.getMessage());
        }
        catch (Exception ex) {
            logger.error("getAppToken error:" + ex.getMessage());
            result.setErrorCode("8");
            result.setErrorDescription(ex.getMessage());
        }
        return result;
    }

    @Override
    public AccessTokenResult getAccessToken(String accountId, String tenantId, String language, String appToken, String loginType, String userType, String user, String password) {
        AccessTokenResult result = new AccessTokenResult();
        result.setSuccess(false);
        try {
            if (StringUtils.isEmpty((String)tenantId)) {
                throw new KDException(APILoginError.API_REQUEST_INVALID_PARAMETERS, new Object[]{ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef:\u53c2\u6570\u79df\u6237ID\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LoginImpl_1", (String)BOS_LOGIN, (Object[])new Object[0])});
            }
            Lang lang = LoginLangUtils.getLang(language);
            boolean isNew = StringUtils.isNotEmpty((String)appToken);
            if (!isNew) {
                throw new KDException(APILoginError.API_REQUEST_INVALID_PARAMETERS, new Object[]{ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef:appToken\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LoginImpl_2", (String)BOS_LOGIN, (Object[])new Object[0])});
            }
            if (StringUtils.isEmpty((String)user)) {
                throw new KDException(APILoginError.API_REQUEST_INVALID_PARAMETERS, new Object[]{ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef:\u53c2\u6570user\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"LoginImpl_3", (String)BOS_LOGIN, (Object[])new Object[0])});
            }
            Message message = PhaseInterceptorChain.getCurrentMessage();
            HttpServletRequest servletRequest = (HttpServletRequest)message.get((Object)"HTTP.REQUEST");
            Account currentCenter = LoginAccountFactory.createInstanceByCustom(accountId, servletRequest).getAccount();
            if (!ThirdAPIAPPUtils.checkAppTokenValidation(currentCenter, lang.name(), appToken)) {
                throw new KDException(APILoginError.API_REQUEST_INVALID_PARAMETERS, new Object[]{ResManager.loadKDString((String)"appToken\u65e0\u6548\u6216\u5df2\u7ecf\u8fc7\u671f\u3002", (String)"LoginImpl_4", (String)BOS_LOGIN, (Object[])new Object[0])});
            }
            if (StringUtils.isNotEmpty((String)appToken)) {
                String appID = ThirdAPIAPPUtils.getAppIdByAppToken(currentCenter, appToken);
                ThirdAPIAPPUtils.createApiContext(appID, currentCenter);
            }
            Map<String, String> userInfo = null;
            userInfo = StringUtils.isNotEmpty((String)password) ? this.getPasswordResult(currentCenter, lang, user, password, loginType) : this.getUserInfoByUserType(userType, user, lang, currentCenter);
            if (userInfo != null) {
                this.checkUserInfo(userInfo);
                String sessionid = "";
                sessionid = SessionUtils.createNewSession4WS(currentCenter, lang, NetAddressUtils.getRemoteHost((HttpServletRequest)servletRequest), userInfo, LoginClientEnum.WEBSERVICE, ThirdAPIAPPUtils.getTokenTimeout(currentCenter.getTenantId()));
                ThirdAPIAPPUtils.setAccessAndAppTokenCach(currentCenter, sessionid, appToken);
                result.setAccessToken(sessionid);
            }
            result.setSuccess(true);
        }
        catch (KDException e) {
            logger.debug("WEB Service\u8bf7\u6c42\u767b\u5f55\u5931\u8d25:" + e.getMessage());
            result.setErrorCode(e.getErrorCode().getCode());
            result.setErrorDescription(e.getMessage());
        }
        catch (Exception ex) {
            logger.error("getAccessToken error:" + ex.getMessage());
            result.setErrorCode("8");
            result.setErrorDescription(ex.getMessage());
        }
        return result;
    }

    private void checkUserInfo(Map<String, String> userInfo) {
        String userId = userInfo.get("fid");
        if (StringUtils.isEmpty((String)userId)) {
            throw new KDException(APILoginError.API_REQUEST_INVALID_PARAMETERS, new Object[]{ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0c\u76f8\u5e94\u7684\u7528\u6237\u4e0d\u5b58\u5728\u3002", (String)"LoginImpl_5", (String)BOS_LOGIN, (Object[])new Object[0])});
        }
    }

    private Map<String, String> getUserInfoByUserType(String userType, String user, Lang lang, Account currentCenter) {
        Map<String, String> userInfo = null;
        if (StringUtils.isEmpty((String)userType)) {
            userType = "Mobile";
        }
        UserProperType aType = UserProperType.getUserProperTypeByString(userType);
        switch (aType) {
            case Mobile: {
                userInfo = LoginUserService.getErpUserInfoByPhone(currentCenter, user, lang.name());
                break;
            }
            case Email: {
                userInfo = LoginUserService.getErpUserInfoByEmail(currentCenter, user, lang.name());
                break;
            }
            case UserName: {
                userInfo = LoginUserService.getErpUserInfoByUserName(currentCenter, user, lang.name());
                break;
            }
        }
        return userInfo;
    }

    private Map<String, String> getPasswordResult(Account currentCenter, Lang lang, String user, String password, String loginType) throws IOException {
        try {
            Map<String, String> userInfo = null;
            if (StringUtils.isNotEmpty((String)user) && StringUtils.isNotEmpty((String)password)) {
                AccountType aType = AccountType.getTypeByString((String)loginType, (AccountType)AccountType.YzjPublicCloud);
                switch (aType) {
                    case YzjPublicCloud: {
                        userInfo = this.getByUserInfo(currentCenter, lang, user, password);
                        break;
                    }
                    case SelfCreate: {
                        userInfo = this.getByJDYun(currentCenter, lang, user, password);
                        break;
                    }
                    default: {
                        userInfo = this.getByJDYun(currentCenter, lang, user, password);
                    }
                }
            }
            if (userInfo == null) {
                throw new KDException(APILoginError.API_REQUEST_INVALID_PARAMETERS, new Object[]{ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef:\u5f62\u5f0f\u5e94\u8be5\u4e3a \u7528\u6237\u8d26\u53f7\u3001\u5bc6\u7801\u3001\u767b\u5f55\u7c7b\u578b\u548caccountId\u3002", (String)"LoginImpl_8", (String)BOS_LOGIN, (Object[])new Object[0])});
            }
            return userInfo;
        }
        catch (KDException e) {
            logger.debug("WS API\u8bf7\u6c42\u767b\u5f55\u5931\u8d25:" + e.getMessage());
            throw e;
        }
        catch (Exception ex) {
            logger.error("getPasswordResult error:" + ex.getMessage());
            throw ex;
        }
    }

    private Map<String, String> getByUserInfo(Account currentCenter, Lang lang, String user, String password) throws IOException {
        try {
            if (StringUtils.isEmpty((String)user) || StringUtils.isEmpty((String)password)) {
                throw new KDException(APILoginError.API_REQUEST_INVALID_PARAMETERS, new Object[]{ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0c\u9700\u8981\u6307\u5b9a\u7684\u7528\u6237\u8d26\u53f7\u3001\u5bc6\u7801\u3002", (String)"LoginImpl_9", (String)BOS_LOGIN, (Object[])new Object[0])});
            }
            Map<String, Object> mpYTXZ = LoginAPI.getYTXZAccessToken(user, password);
            if (!((Boolean)mpYTXZ.get("success")).booleanValue()) {
                logger.error(mpYTXZ.toString());
                throw new KDException(APILoginError.API_REQUEST_INVALID_PARAMETERS, new Object[]{ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u4e91\u901a\u884c\u8bc1,\u8fd4\u56de\u7684Map\u4e3a\u7a7a\u3002", (String)"LoginImpl_10", (String)BOS_LOGIN, (Object[])new Object[0])});
            }
            String sAccessToken = mpYTXZ.get("access_token").toString();
            long userid = Long.parseLong(mpYTXZ.get("uid").toString());
            Map<String, String> mpUserLogininfo = this.getNewUserLoginInfo(sAccessToken, userid, currentCenter, lang.name());
            return mpUserLogininfo;
        }
        catch (KDException e) {
            logger.debug("getByUserInfo:" + e.getMessage());
            ErrorCode code = e.getErrorCode();
            throw e;
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
            throw ex;
        }
    }

    private Map<String, String> getNewUserLoginInfo(String accessToken, long userID, Account currentCenter, String language) throws IOException {
        Map<String, String> mpErpUser;
        String ytxzHost = System.getProperty("YTXZHost");
        String sURL = ytxzHost + "/" + "passport/user/orgs" + "?access_token=" + accessToken;
        String jsonTxzUserOrgs = HttpUtils.request(sURL, "GET", null);
        if (StringUtils.isBlank((String)jsonTxzUserOrgs)) {
            throw new KDException(new ErrorCode("5", ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u7528\u6237\u52a0\u5165\u7684\u4e91\u4e4b\u5bb6\u5de5\u4f5c\u5708\u3002", (String)"LoginImpl_11", (String)BOS_LOGIN, (Object[])new Object[0])), new Object[0]);
        }
        UserOrgsInfo orgsInfo = JSONUtils.cast(jsonTxzUserOrgs, UserOrgsInfo.class, true);
        if (orgsInfo == null || orgsInfo.getData() == null || orgsInfo.getErrcode() != 0) {
            throw new KDException(new ErrorCode("5", ResManager.loadKDString((String)"\u83b7\u53d6\u767b\u5f55\u7528\u6237\u52a0\u5165\u7684\u4e91\u4e4b\u5bb6\u5de5\u4f5c\u5708\u5931\u8d25\u3002", (String)"LoginImpl_12", (String)BOS_LOGIN, (Object[])new Object[0])), new Object[0]);
        }
        if (orgsInfo.getData().size() > 0) {
            logger.info("\u83b7\u53d6\u767b\u9646\u7528\u6237\u7684\u4e91\u4e4b\u5bb6\u5de5\u4f5c\u5708\u6210\u529f\uff0c\u7b49\u5f85\u83b7\u53d6\u6307\u5b9a\u79df\u6237\u7684\u7528\u6237\u4fe1\u606f\u3002");
        }
        if ((mpErpUser = LoginUserService.getErpUserInfo(currentCenter, userID, language)) == null || mpErpUser.size() == 0) {
            throw new KDException(new ErrorCode("6", ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u5f97\u6307\u5b9a\u79df\u6237\u4e2d\u7684\u7528\u6237\u4fe1\u606f\u3002", (String)"LoginImpl_13", (String)BOS_LOGIN, (Object[])new Object[0])), new Object[0]);
        }
        if (!"1".equalsIgnoreCase(mpErpUser.get("success"))) {
            throw new KDException(new ErrorCode("6", ResManager.loadKDString((String)"\u83b7\u53d6\u767b\u5f55\u7528\u6237\u7684\u4e91\u4e4b\u5bb6\u5de5\u4f5c\u5708\u6210\u529f\uff0c\u4f46\u662f\u65e0\u6cd5\u83b7\u5f97\u79df\u6237\u4e2d\u7528\u6237\u7684\u5b8c\u6574\u4fe1\u606f\u3002", (String)"LoginImpl_14", (String)BOS_LOGIN, (Object[])new Object[0])), new Object[0]);
        }
        return mpErpUser;
    }

    private Map<String, String> getByJDYun(Account currentCenter, Lang lang, String user, String password) {
        try {
            if (StringUtils.isEmpty((String)user) || StringUtils.isEmpty((String)password)) {
                throw new KDException(new ErrorCode("1", ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0c\u53c2\u6570\u9700\u8981\u4ee5JSON\u683c\u5f0f\u4f20\u5165\uff0c\u4e14\u5305\u62ec\u7528\u6237\u540d\u3001\u5bc6\u7801\u3002", (String)"LoginImpl_15", (String)BOS_LOGIN, (Object[])new Object[0])), new Object[0]);
            }
            StringBuilder key = new StringBuilder();
            key.append(currentCenter.getAccountId()).append("_").append(user);
            String lockNum = CacheLoginData.getAttribute((String)"lock_user", (String)key.toString());
            if (StringUtils.isNotEmpty((String)lockNum) && Integer.parseInt(lockNum) >= APIUtils.MAX_ERROR_COUNT) {
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u8d26\u53f7\u5df2\u9501\u5b9a\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"LoginImpl_22", (String)BOS_LOGIN, (Object[])new Object[0])});
            }
            UserAccount userAccount = new UserAccount(user, password);
            UserAuthResult uar = SelfCreateAuth.loginByUserAndPassword(userAccount, currentCenter);
            if (uar == null || uar.getUserType() == UserProperType.Unknown || !uar.isSucess()) {
                String resp = ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u65e0\u6cd5\u9a8c\u8bc1\u60a8\u7684\u8d26\u53f7\u4fe1\u606f\u3002", (String)"LoginImpl_16", (String)BOS_LOGIN, (Object[])new Object[0]);
                if (uar != null && !StringUtils.isEmpty((String)uar.getErrDesc())) {
                    resp = uar.getErrDesc();
                }
                if (APIUtils.lockUser(key.toString()).booleanValue()) {
                    resp = ResManager.loadKDString((String)"\u7528\u6237\u540d\u5bc6\u7801\u9519\u8bef\uff0c\u8d26\u53f7\u5df2\u9501\u5b9a\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"LoginImpl_23", (String)BOS_LOGIN, (Object[])new Object[0]);
                }
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{resp});
            }
            CacheLoginData.setAttribute((String)"lock_user", (String)key.toString(), (String)"0", (int)APIUtils.LOCK_TIME_OUT);
            String userObj = String.valueOf(uar.getUser());
            logger.info(String.format("\u7528\u6237%s\u767b\u5f55\u9ed8\u8ba4\u79df\u6237\u3002", user));
            Map<String, String> userInfo = LoginUtils.getUserInfoByUserResult(lang, currentCenter, uar, user);
            return userInfo;
        }
        catch (KDException e) {
            logger.info("getByJDYun:" + e.getMessage());
            ErrorCode code = e.getErrorCode();
            throw e;
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
            throw ex;
        }
    }
}

