/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.actions;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.actiondispatcher.ActionUtil;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dc.api.model.Account;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.exception.LoginErrorCode;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileItemParser;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.CacheLoginData;
import kd.bos.login.LoginClientEnum;
import kd.bos.login.ai.model.CollectImgModel;
import kd.bos.login.ai.service.FaceLoginService;
import kd.bos.login.lang.LoginLangUtils;
import kd.bos.login.model.AIResponseModel;
import kd.bos.login.model.UserScore;
import kd.bos.login.model.VoiceprintRecResultModel;
import kd.bos.login.user.LoginUserService;
import kd.bos.login.utils.AiUtils;
import kd.bos.login.utils.LoginUtils;
import kd.bos.login.utils.SecurityUtils;
import kd.bos.login.utils.SessionUtils;
import kd.bos.login.utils.StringUtils;
import kd.bos.login.utils.account.LoginAccountFactory;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.JSONUtils;
import kd.bos.util.NetAddressUtils;
import kd.bos.util.RevProxyUtil;

public class AILoginAction {
    private static final String HCODE_TOKEN = "token";
    private static final String HCODE_USERNAME = "username";
    private static final String SAYING = "saying";
    private static final String ACCOUNT_ID = "accountId";
    private static final String SUCCESS = "success";
    private static final String BOS_LOGIN = "bos-login";
    private static Log logger = LogFactory.getLog(AILoginAction.class);
    private static final String KEY_SHOWTENANT_NUMBER = "Show_Tenant_No";

    public void getVoiceToken(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        String path = servletRequest.getRequestURI();
        if (logger.isDebugEnabled()) {
            logger.debug("getVoice path=" + path);
        }
        HashMap<String, String> mpData = new HashMap<String, String>();
        String token = this.getRandomString(6);
        mpData.put(HCODE_TOKEN, token);
        AiUtils.addVoiceToken(token);
        String sJson = JSONUtils.toString(mpData);
        ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)sJson);
    }

    private String getRandomString(int length) {
        String base = "0123456789";
        SecureRandom random = null;
        try {
            random = SecureRandom.getInstanceStrong();
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Throwable)e);
        }
        StringBuilder sb = new StringBuilder();
        if (random == null) {
            return sb.toString();
        }
        int formerNum = 0;
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(base.length());
            if (i > 0) {
                while (number == formerNum) {
                    number = random.nextInt(base.length());
                }
            }
            sb.append(base.charAt(number));
            formerNum = number;
        }
        return sb.toString();
    }

    public void AILoginPoll(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        String token = servletRequest.getParameter(HCODE_TOKEN);
        if (kd.bos.util.StringUtils.isEmpty((String)token)) {
            return;
        }
        try {
            Account currentCenter;
            Map<String, String> userInfo;
            Lang lang = LoginLangUtils.getLoginLanguage(servletRequest);
            String cacheType = CacheLoginData.getType4AILogin((String)token);
            Map mpVoiceLogin = CacheLoginData.getCache((String)cacheType);
            String userId = (String)mpVoiceLogin.get("userId");
            if (kd.bos.util.StringUtils.isEmpty((String)userId)) {
                return;
            }
            CacheLoginData.remove((String)cacheType);
            String accountIdParameter = (String)mpVoiceLogin.get(ACCOUNT_ID);
            String tenantId = RevProxyUtil.getTenantCode((HttpServletRequest)servletRequest);
            String pollType = servletRequest.getParameter("pollType");
            if ("face".equals(pollType)) {
                accountIdParameter = LoginAccountFactory.createInstanceByHttpRequest(servletRequest, Optional.empty()).getAccountId();
            }
            if ("1".equalsIgnoreCase((userInfo = LoginUserService.getErpUserInfo(currentCenter = LoginAccountFactory.createInstanceByCustom(accountIdParameter, servletRequest).getAccount(), userId, lang.name())).get(SUCCESS))) {
                String userInterId = StringUtils.getStringValue(userInfo.get("fid"), "");
                String userName = StringUtils.getStringValue("ftruename", "");
                String userOpenId = StringUtils.getStringValue(userInfo.get("fopenid"), "");
                String userorgId = StringUtils.getStringValue(userInfo.get("forgid"), "");
                String avartar = StringUtils.getStringValue(userInfo.get("favatar"), "");
                String sessionId = SessionUtils.createNewSession(servletRequest, servletResponse, currentCenter, LoginLangUtils.getLoginLanguage(servletRequest), NetAddressUtils.getRemoteHost((HttpServletRequest)servletRequest), userInfo, LoginClientEnum.WEB);
                if (!kd.bos.util.StringUtils.isEmpty((String)sessionId)) {
                    HashMap<String, String> tokenSession = new HashMap<String, String>();
                    tokenSession.put("sessionid", sessionId);
                    String type = CacheLoginData.getType4AILoginSession((String)token);
                    CacheLoginData.setAttributes((String)type, tokenSession);
                    AiUtils.cacheSessionId(userOpenId, sessionId);
                    String formId = servletRequest.getParameter("formId");
                    if (kd.bos.util.StringUtils.isEmpty((String)formId)) {
                        formId = "pc_main_console";
                    }
                    HashMap<String, String> mpData = new HashMap<String, String>();
                    mpData.put("status", "1");
                    mpData.put("URL", String.format("index.html#/dform?formId=%s", formId));
                    mpData.put(HCODE_USERNAME, userName);
                    mpData.put("avatar", avartar);
                    String sJson = JSONUtils.toString(mpData);
                    ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)sJson);
                }
            } else {
                logger.info(String.format("@AI....\u524d\u7aef\u8f6e\u8be2\u5931\u8d25\uff0c\u627e\u4e0d\u5230\u7528\u6237,user:%s", userId));
                HashMap<String, String> mpData = new HashMap<String, String>();
                mpData.put("status", "0");
                mpData.put("URL", "");
                mpData.put(HCODE_USERNAME, "");
                String sJson = JSONUtils.toString(mpData);
                ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)sJson);
            }
        }
        catch (KDException ex) {
            logger.error((Throwable)ex);
            ErrorCode code = ex.getErrorCode();
            String resp = LoginUtils.getLoginResponse(String.valueOf(code.getCode()), ex.getMessage());
            ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)resp);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            String resp = LoginUtils.getLoginResponse("1", ResManager.loadKDString((String)"\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\n", (String)"AILoginAction_1", (String)BOS_LOGIN, (Object[])new Object[0]));
            ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)resp);
        }
    }

    public void AICallbackByDarwin(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        String userId = servletRequest.getParameter("userid");
        String token = servletRequest.getParameter(HCODE_TOKEN);
        String loginType = servletRequest.getParameter("loginType");
        Map<String, Object> mpData = this.AICallbackByDarwin(userId, token, loginType);
        String sJson = JSONUtils.toString(mpData);
        ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)sJson);
    }

    private Map<String, Object> AICallbackByDarwin(String userId, String token, String loginType) {
        HashMap<String, Object> mpData = new HashMap<String, Object>();
        if (kd.bos.util.StringUtils.isEmpty((String)userId) || kd.bos.util.StringUtils.isEmpty((String)token)) {
            mpData.put(SUCCESS, false);
            String msg = kd.bos.util.StringUtils.isEmpty((String)userId) ? "userId is empty." : "token is empty.";
            mpData.put("msg", msg);
            return mpData;
        }
        HashMap<String, String> mpVoiceCache = new HashMap<String, String>();
        mpVoiceCache.put("userId", userId);
        String cacheType = CacheLoginData.getType4AILogin((String)token);
        CacheLoginData.setAttributes((String)cacheType, mpVoiceCache);
        if ("voice".equals(loginType)) {
            boolean isSuccess = AiUtils.isEffectiveToken(token);
            mpData.put(SUCCESS, isSuccess);
            if (!isSuccess) {
                mpData.put("msg", "token " + token + " is invalid.");
            }
        } else {
            mpData.put(SUCCESS, true);
        }
        return mpData;
    }

    public void toVoiceLogin(HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        try {
            Lang lang = LoginLangUtils.getLoginLanguage(servletRequest);
            LoginLangUtils.setLang(lang);
            servletRequest.setCharacterEncoding("UTF-8");
            String groupId = servletRequest.getParameter("groupId");
            FileItem fileItem = FileItemParser.parseHttpRequest((HttpServletRequest)servletRequest);
            if (!AiUtils.isLegalAudioFile(fileItem.getFileName())) {
                AIResponseModel result = new AIResponseModel(false, "File " + fileItem.getFileName() + " is illegal. Only audio file is permitted.");
                String sJson = JSONUtils.toString((Object)result);
                ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)sJson);
                return;
            }
            ArrayList<HttpClientUtils.FormDataEntity> formDatas = new ArrayList<HttpClientUtils.FormDataEntity>();
            formDatas.add(new HttpClientUtils.FormDataEntity("file", fileItem.getInputStream(), fileItem.getFileName()));
            formDatas.add(new HttpClientUtils.FormDataEntity("groupId", groupId));
            formDatas.add(new HttpClientUtils.FormDataEntity("realtime", "no"));
            AIResponseModel openIdResult = this.voiceprintRecognize(formDatas);
            if (!openIdResult.isSuccess()) {
                String sJson = JSONUtils.toString((Object)openIdResult);
                ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)sJson);
                return;
            }
            String openId = (String)openIdResult.getData();
            String token = servletRequest.getParameter(HCODE_TOKEN);
            String tenantNo = System.getProperty(KEY_SHOWTENANT_NUMBER);
            Account currentCenter = LoginAccountFactory.createInstanceByHttpRequest(servletRequest, Optional.of(tenantNo)).getAccount();
            AIResponseModel voiceLoginResult = this.toVoiceLogin(currentCenter, openId, token, lang.name());
            String sJson = JSONUtils.toString((Object)voiceLoginResult);
            ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)sJson);
        }
        catch (KDException ex) {
            logger.error((Throwable)ex);
            ErrorCode code = ex.getErrorCode();
            try {
                String resp = LoginUtils.getLoginResponse(String.valueOf(code.getCode()), ex.getMessage());
                ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)resp);
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            KDException kd = new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"LoginAction_0", (String)BOS_LOGIN, (Object[])new Object[0])});
            try {
                String resp = LoginUtils.getLoginResponse(String.valueOf(kd.getErrorCode().getCode()), kd.getMessage());
                ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)resp);
            }
            catch (IOException ex) {
                logger.error((Throwable)ex);
            }
        }
    }

    private AIResponseModel toVoiceLogin(Account currentCenter, String openId, String token, String language) throws IOException, KDException {
        AIResponseModel sessionResult = this.generateSessionId(openId, token);
        if (!sessionResult.isSuccess()) {
            return sessionResult;
        }
        String sSessionId = (String)sessionResult.getData();
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("sessionid", sSessionId);
        try {
            Map<String, String> userInfo = LoginUserService.getErpUserInfo(currentCenter, openId, language);
            result.put(HCODE_USERNAME, userInfo.get("ftruename"));
            result.put("userid", openId);
        }
        catch (KDException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        return new AIResponseModel(true, result);
    }

    private AIResponseModel generateSessionId(String userId, String token) {
        Map<String, Object> resultMap = this.AICallbackByDarwin(userId, token, "voice");
        boolean isValid = (Boolean)resultMap.get(SUCCESS);
        if (!isValid) {
            return new AIResponseModel(false, resultMap.get("msg"));
        }
        String sSessionId = "";
        long iLoginTimeOut = 4000L;
        long waitTime = 500L;
        long timeStart = System.currentTimeMillis();
        while (true) {
            long timeEnd;
            if ((timeEnd = System.currentTimeMillis()) - timeStart > iLoginTimeOut) {
                return new AIResponseModel(false, "login time out, waiting time is " + iLoginTimeOut + " ms");
            }
            sSessionId = AiUtils.getTokenSessionId(token);
            if (sSessionId != null && !sSessionId.isEmpty()) break;
            try {
                Thread.sleep(waitTime);
            }
            catch (InterruptedException e) {
                logger.error("voiceprint login occur an InterruptedException!", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
        return new AIResponseModel(true, sSessionId);
    }

    private AIResponseModel voiceprintRecognize(List<HttpClientUtils.FormDataEntity> formDatas) throws IOException {
        String result;
        VoiceprintRecResultModel model;
        String voiceprintRecUrl = System.getProperty("AI.voiceprint.rec.url");
        if (voiceprintRecUrl == null || voiceprintRecUrl.isEmpty()) {
            voiceprintRecUrl = "http://ai.kingdee.com:8888/rest/api/voiceprint/identifyFile";
        }
        if ((model = (VoiceprintRecResultModel)JSONUtils.cast((String)(result = HttpClientUtils.postFormData((String)voiceprintRecUrl, null, formDatas)), VoiceprintRecResultModel.class)).getResultList() == null || model.getResultList().isEmpty()) {
            return new AIResponseModel(false, "voiceprint is not found.");
        }
        List<UserScore> userScores = model.getResultList();
        Collections.sort(userScores);
        for (int i = 0; i < userScores.size(); ++i) {
            String userId = userScores.get(i).getUserId();
            if (userId == null || userId.isEmpty()) continue;
            return new AIResponseModel(true, userId);
        }
        return new AIResponseModel(false, "voiceprint is not found.");
    }

    public void getVoiceSayingFlag(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        String cacheType = CacheLoginData.getType4VoiceSayingFlag();
        Map mpStatus = CacheLoginData.getCache((String)cacheType);
        if (mpStatus != null) {
            String sayingFlag = (String)mpStatus.get(SAYING);
            HashMap<String, String> mpData = new HashMap<String, String>();
            if (kd.bos.util.StringUtils.isEmpty((String)sayingFlag)) {
                mpData.put(SAYING, "0");
            } else {
                mpData.put(SAYING, sayingFlag);
            }
            String sJson = JSONUtils.toString(mpData);
            ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)sJson);
        }
    }

    public void setVoiceSayingFlag(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        String sayingFlag = servletRequest.getParameter(SAYING);
        if (kd.bos.util.StringUtils.isEmpty((String)sayingFlag)) {
            return;
        }
        HashMap<String, String> mpVoiceCache = new HashMap<String, String>();
        mpVoiceCache.put(SAYING, sayingFlag);
        String cacheType = CacheLoginData.getType4VoiceSayingFlag();
        CacheLoginData.setAttributes((String)cacheType, mpVoiceCache);
    }

    public void collectFaceImg(HttpServletRequest request, HttpServletResponse response) throws IOException {
        CollectImgModel paramModel;
        String token = request.getParameter(HCODE_TOKEN);
        String img = request.getParameter("img");
        if (token != null && img != null) {
            paramModel = new CollectImgModel();
            paramModel.setToken(token);
            paramModel.setImg(request.getParameter("img"));
        } else {
            Map<String, String> params = this.getAllParameterMap(request);
            String body = params.get("request.body");
            paramModel = (CollectImgModel)JSONUtils.cast((String)body, CollectImgModel.class);
        }
        FaceLoginService domain = new FaceLoginService();
        Map<String, Object> result = domain.collectFaceImg(paramModel);
        response.setHeader("Content-Type", "application/json;charset=UTF-8");
        try (ServletOutputStream outputStream = response.getOutputStream();){
            if (outputStream != null) {
                outputStream.write(SecurityUtils.htmlEncode(JSONUtils.toString(result)).getBytes());
                outputStream.flush();
            }
        }
    }

    private Map<String, String> getAllParameterMap(HttpServletRequest request) {
        Map<String, String> params = this.getParameterMap(request);
        String reqBody = this.getRequestBody(request);
        if (reqBody == null || reqBody.isEmpty()) {
            reqBody = params.get("redirectParamsAtBody");
        }
        params.put("request.body", reqBody);
        return params;
    }

    private Map<String, String> getParameterMap(HttpServletRequest request) {
        HashMap<String, String> reqParamMap = new HashMap<String, String>();
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String[] values = request.getParameterValues(name);
            if (values == null || values.length <= 0) continue;
            reqParamMap.put(name, values[0]);
        }
        return reqParamMap;
    }

    private String getRequestBody(HttpServletRequest request) {
        StringBuilder bodyStr = new StringBuilder();
        String line = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream()));){
            while ((line = reader.readLine()) != null) {
                bodyStr.append(line);
            }
        }
        catch (Exception e) {
            bodyStr.append(e.getMessage());
        }
        return bodyStr.toString();
    }
}

