/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.actions;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.Key;
import java.security.PrivateKey;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.actiondispatcher.ActionUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.exception.LoginErrorCode;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.CacheLoginData;
import kd.bos.login.LoginClientEnum;
import kd.bos.login.PrivateCloudModel;
import kd.bos.login.emun.AccountType;
import kd.bos.login.emun.TipTypeEnum;
import kd.bos.login.lang.LoginLangUtils;
import kd.bos.login.model.LoginAuthResult;
import kd.bos.login.service.ILoginAuthenticationService;
import kd.bos.login.service.apps.ThirdAppsService;
import kd.bos.login.service.apps.impl.ThirdAppsServiceImpl;
import kd.bos.login.service.impl.LoginAuthenticationServiceImpl;
import kd.bos.login.service.session.SessionService;
import kd.bos.login.service.session.SessionServiceFactory;
import kd.bos.login.service.session.dto.SessionParams;
import kd.bos.login.thirdauth.LoginUserAuth;
import kd.bos.login.thirdauth.UserAccount;
import kd.bos.login.thirdauth.UserAuthResult;
import kd.bos.login.thirdauth.UserProperType;
import kd.bos.login.thirdauth.app.qrcode.ScanEnum;
import kd.bos.login.thirdauth.app.qrcode.ScanStrategy;
import kd.bos.login.thirdauth.app.qrcode.ScanStrategyContext;
import kd.bos.login.thirdauth.app.qrcode.factory.ScanStrategyFactory;
import kd.bos.login.thirdauth.app.qrcode.service.WxWorkConfigService;
import kd.bos.login.thirdauth.app.tencent.WxqyhUtils;
import kd.bos.login.thirdauth.impl.LdapLoginAuth;
import kd.bos.login.thirdauth.impl.MCLoginAuth;
import kd.bos.login.thirdauth.impl.SelfCreateAuth;
import kd.bos.login.thirdauth.impl.YzjPrvCloudAuth;
import kd.bos.login.thirdauth.impl.YzjPubCloudAuth;
import kd.bos.login.user.DefaultParameterService;
import kd.bos.login.user.IpControlService;
import kd.bos.login.user.LoginUserService;
import kd.bos.login.user.MCLoginUserService;
import kd.bos.login.user.PrivacyPolicyService;
import kd.bos.login.user.PswStrategyService;
import kd.bos.login.utils.APIUtils;
import kd.bos.login.utils.AdminUtils;
import kd.bos.login.utils.AgentUtil;
import kd.bos.login.utils.BeanUtils;
import kd.bos.login.utils.Constants;
import kd.bos.login.utils.HttpClientUtils;
import kd.bos.login.utils.JSONUtils;
import kd.bos.login.utils.LocalCacheUtils;
import kd.bos.login.utils.LoginUtils;
import kd.bos.login.utils.ParametersUtils;
import kd.bos.login.utils.PswStrategyUtils;
import kd.bos.login.utils.SecurityUtils;
import kd.bos.login.utils.SessionUtils;
import kd.bos.login.utils.StrategeUtils;
import kd.bos.login.utils.URLUtils;
import kd.bos.login.utils.account.LoginAccount;
import kd.bos.login.utils.account.LoginAccountFactory;
import kd.bos.login.utils.log.LoginLogUtils;
import kd.bos.login.yunzhijia.YZJSpecialUtils;
import kd.bos.login.yunzhijia.YunzhijiaAppContext;
import kd.bos.login.yunzhijia.lightapp.YunzhijiaTicketService;
import kd.bos.login.yunzhijia.qrcode.YzjQRCodeService;
import kd.bos.session.SessionDAO;
import kd.bos.session.SessionDAOFactory;
import kd.bos.tenant.TenantInfo;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.url.UrlService;
import kd.bos.util.DisCardUtil;
import kd.bos.util.EncryptUtils;
import kd.bos.util.NetAddressUtils;
import kd.bos.util.RevProxyUtil;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;

public class LoginAction {
    private static final String HCODE_TOKEN = "token";
    private static final String UTF_8 = "UTF-8";
    private static final String ACCOUNT_ID = "accountId";
    private static final String BOS_LOGIN = "bos-login";
    private static final String LOGIN_ACTION_0 = "LoginAction_0";
    private static final String FORGID = "forgid";
    private static final String ERRORCODE = "errorcode";
    private static final String SUCCESS = "success";
    private static final String MESSAGE = "message";
    private static final String FTRUENAME = "ftruename";
    private static final String INDEX_HTML = "index.html";
    private static final String TICKET = "ticket";
    private static final String KEY_DATA = "KeyData";
    private static final String FORM_ID = "formId";
    private static final String SCANTYPE = "scantype";
    private static final String USERNAME = "username";
    private static final String DESCRIPTION = "description";
    private static final String QR_REDIRECT_URL = "QR_redirect_url";
    private static ThreadPool pool = ThreadPools.newCachedThreadPool((String)"loginAction_login", (int)1, (int)5);
    private static Log logger = LogFactory.getLog(LoginAction.class);
    private static final String PLUGIN_YUNZHIJIA = YzjPubCloudAuth.class.getName();
    private static final String PLUGIN_YUNZHIJIA_PRIVATE = YzjPrvCloudAuth.class.getName();
    private static final String PLUGIN_SELF = SelfCreateAuth.class.getName();
    private static final String PLUGIN_MC = MCLoginAuth.class.getName();
    private static final String PLUGIN_LDAP = LdapLoginAuth.class.getName();
    private static final String keyword_tenantCode = "{tenantCode}";
    private final ThirdAppsService thirdAppsService = new ThirdAppsServiceImpl();
    private ILoginAuthenticationService loginAuthenticationService = new LoginAuthenticationServiceImpl();
    private static int EXPIRE_TIME = 60;
    private static String YES = "1";
    private static String NO = "0";
    private static final String DB_NO = "0";
    private static final String DB_YES = "1";
    private static final String KICKED_OUT_KEY = "isKickedOut";
    private static final int KICKED_OUT_EXPIRE_TIME = 30;
    private SessionService sessionService = SessionServiceFactory.createSessionService();

    private PrivateCloudModel getPrivateConfig(String tenant) {
        PrivateCloudModel model = null;
        model = new PrivateCloudModel();
        model.setMid(System.getProperty(tenant + "_mid"));
        model.setAppId(System.getProperty(tenant + "_appid"));
        model.setSecuret(System.getProperty(tenant + "_securet"));
        model.setXtHost(System.getProperty(tenant + "_XtHost"));
        model.setWbHost(System.getProperty(tenant + "_WBHost"));
        return model;
    }

    public void getQRCode(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String mid = "";
        String appId = "";
        String token = request.getParameter(HCODE_TOKEN);
        if (!kd.bos.login.utils.StringUtils.isEmpty(token)) {
            String tenantAlias = RevProxyUtil.getTenantCode((HttpServletRequest)request);
            if (kd.bos.login.utils.StringUtils.isEmpty(tenantAlias)) {
                return;
            }
            PrivateCloudModel model = this.getPrivateConfig(tenantAlias);
            mid = model.getMid();
            appId = model.getAppId();
            StringBuilder urlBF = this.getPrefix(request);
            urlBF.append("auth/updateLoginStatus.do?mid=").append(mid).append("&appid=").append(appId).append("&token=").append(token);
            if (logger.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder("urlBF=");
                sb.append((CharSequence)urlBF);
                logger.debug(sb.toString());
            }
            Hashtable<EncodeHintType, String> hints = new Hashtable<EncodeHintType, String>();
            hints.put(EncodeHintType.CHARACTER_SET, UTF_8);
            hints.put(EncodeHintType.MARGIN, DB_NO);
            BitMatrix matrix = null;
            try {
                matrix = new MultiFormatWriter().encode(urlBF.toString(), BarcodeFormat.QR_CODE, 200, 200, hints);
            }
            catch (WriterException e) {
                logger.error((Throwable)e);
            }
            MatrixToImageWriter.writeToStream(matrix, (String)"png", (OutputStream)response.getOutputStream());
        }
    }

    public void getQRURL(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Lang lang = LoginLangUtils.getLoginLanguage(request);
        LoginLangUtils.setLang(lang);
        String token = request.getParameter(HCODE_TOKEN);
        try {
            if (!kd.bos.login.utils.StringUtils.isEmpty(token)) {
                String scanType = request.getParameter(SCANTYPE);
                if (ScanEnum.isExist(scanType)) {
                    this.setRedirectCache(token, request.getParameter("QRcodeRedirect"));
                }
                if (ScanEnum.WEIXIN_WORK.getValue().equals(scanType)) {
                    String redirectUrl = this.getThirdAppScanCodeUrl(request);
                    HashMap<String, String> result = new HashMap<String, String>(16);
                    if (kd.bos.util.StringUtils.isNotEmpty((String)redirectUrl)) {
                        result.put("redirectUrl", redirectUrl);
                    } else {
                        result.put("description_cn", ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u4f01\u4e1a\u5fae\u4fe1\u626b\u7801\u767b\u5f55\u914d\u7f6e\u3002", (String)"LoginAction_52", (String)BOS_LOGIN, (Object[])new Object[0]));
                        result.put(DESCRIPTION, ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u4f01\u4e1a\u5fae\u4fe1\u626b\u7801\u767b\u5f55\u914d\u7f6e\u3002", (String)"LoginAction_52", (String)BOS_LOGIN, (Object[])new Object[0]));
                        result.put(ERRORCODE, DB_YES);
                    }
                    ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)JSONUtils.toString(result));
                } else if (ScanEnum.CLOUD_HUB.getValue().equals(scanType)) {
                    LoginAccount loginAccount = LoginAccountFactory.createInstanceByHttpRequest(request, Optional.empty());
                    String accountIdParameter = loginAccount.getAccountId();
                    StringBuilder urlBF = this.getPrefix(request);
                    urlBF.append("auth/updateLoginStatus.do?").append("token=").append(token);
                    String language = request.getParameter("language");
                    urlBF.append("&language=").append(language);
                    if (kd.bos.login.utils.StringUtils.isNotEmpty(accountIdParameter)) {
                        urlBF.append("&accountId=").append(accountIdParameter);
                    }
                    if (logger.isDebugEnabled()) {
                        StringBuilder sb = new StringBuilder("urlBF=");
                        sb.append((CharSequence)urlBF);
                        logger.debug(sb.toString());
                    }
                    HashMap<String, String> returnMap = new HashMap<String, String>();
                    Account currentCenter = loginAccount.getAccount();
                    StringBuilder sb = new StringBuilder();
                    if (LoginUtils.hasPrevilige(AccountType.YzjPrivateCloud.toString(), currentCenter.getAllSourceTypes())) {
                        sb.append(YunzhijiaTicketService.getQRCodeURL(loginAccount.getTenantId(), false));
                    } else {
                        sb.append(YunzhijiaTicketService.getQRCodeURL(loginAccount.getTenantId()));
                    }
                    sb.append("&state=STATE");
                    sb.append("&redirect_uri=").append(URLEncoder.encode(urlBF.toString(), UTF_8));
                    sb.append("&lang=").append(language);
                    returnMap.put("redirectUrl", sb.toString());
                    String sJson = JSONUtils.toString(returnMap);
                    ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)sJson);
                }
            }
        }
        catch (KDException ex) {
            ErrorCode code = ex.getErrorCode();
            String resp = LoginUtils.getLoginResponse(String.valueOf(code.getCode()), ex.getMessage());
            logger.info(resp);
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)resp);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            KDException kd = new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)LOGIN_ACTION_0, (String)BOS_LOGIN, (Object[])new Object[0])});
            String resp = LoginUtils.getLoginResponse(String.valueOf(kd.getErrorCode().getCode()), kd.getMessage());
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)resp);
        }
    }

    private void setRedirectCache(String key, String url) {
        if (kd.bos.login.utils.StringUtils.isEmpty(key) || kd.bos.login.utils.StringUtils.isEmpty(url)) {
            logger.info(String.format("setRedirectCache, key:%s, url:%s", key, url));
            return;
        }
        try {
            url = URLDecoder.decode(url, UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Throwable)e);
        }
        CacheLoginData.setAttribute((String)QR_REDIRECT_URL, (String)key, (String)url, (int)600);
    }

    public void getFileServerUrl(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String fileServerUrl = UrlService.getImageFullUrl((String)"");
        HashMap<String, String> responseResult = new HashMap<String, String>();
        responseResult.put("fileServerUrl", fileServerUrl);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)JSONUtils.toString(responseResult));
    }

    public void getVerifyCode(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LoginUtils.getVerifyCode(request, response);
    }

    private String getConfigureAccountId() {
        return System.getProperty("mc.accountid");
    }

    private void loginByMC(HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        Lang lang = LoginLangUtils.getLoginLanguage(servletRequest);
        LoginLangUtils.setLang(lang);
        try {
            LoginUtils.forcePOSTSubmitCheck(servletRequest);
            String userName = servletRequest.getParameter(Constants.LOGIN_USER_KEY);
            LoginUserAuth lua = null;
            UserAuthResult uar = null;
            boolean needResetInitialPassword = false;
            String accountId = this.getConfigureAccountId();
            Account currentCenter = LoginAccountFactory.createInstanceByCustom(accountId, servletRequest).getAccount();
            String userPassword = LoginUtils.getDecryptedPassword(servletRequest, currentCenter.getAccountId());
            UserAccount user = new UserAccount(userName, userPassword);
            if (LoginUtils.hasPrevilige(AccountType.ThridParty.toString(), currentCenter.getAllSourceTypes())) {
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5df2\u5f00\u542f\u5355\u70b9\u767b\u5f55\u6a21\u5f0f\uff0c\u65e0\u6cd5\u901a\u8fc7\u8d26\u5bc6\u767b\u5f55\u3002", (String)"LoginAction_1", (String)BOS_LOGIN, (Object[])new Object[0]), currentCenter.getTenantId())});
            }
            StringBuilder key = new StringBuilder();
            key.append(currentCenter.getAccountId()).append("_MC_").append(userName);
            String locktime = APIUtils.getLockTime(key.toString());
            if (kd.bos.login.utils.StringUtils.isNotEmpty(locktime)) {
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u8d26\u53f7\u5df2\u9501\u5b9a\uff0c\u8bf7\u5230%s\u4e4b\u540e\u518d\u91cd\u65b0\u767b\u5f55\u3002", (String)"LoginImpl_20", (String)BOS_LOGIN, (Object[])new Object[]{locktime})});
            }
            lua = (LoginUserAuth)BeanUtils.getBean(PLUGIN_MC);
            if (lua == null) {
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{String.format(ResManager.loadKDString((String)"\u7528\u6237\u767b\u5f55\u65b9\u5f0f\u6ca1\u6709\u6b63\u786e\u9009\u62e9\uff0c\u65e0\u6cd5\u63d0\u4f9b\u7528\u6237\u9a8c\u8bc1\u670d\u52a1\u3002", (String)"LoginAction_2", (String)BOS_LOGIN, (Object[])new Object[0]), new Object[0])});
            }
            uar = lua.userAuthrize(user, currentCenter);
            Map<String, String> userInfo = MCLoginUserService.getUserInfo(currentCenter, user.getAccount());
            if (uar == null || uar.getUserType() == UserProperType.Unknown || !uar.isSucess()) {
                String resp = ResManager.loadKDString((String)"\u7cfb\u7edf\u65e0\u6cd5\u9a8c\u8bc1\u8d26\u53f7\u4fe1\u606f\u3002", (String)"LoginAction_3", (String)BOS_LOGIN, (Object[])new Object[0]);
                if (uar != null && !kd.bos.util.StringUtils.isEmpty((String)uar.getErrDesc())) {
                    resp = uar.getErrDesc();
                }
                if (userInfo == null) {
                    throw new KDException(LoginErrorCode.loginBizException, new Object[]{resp});
                }
                StrategeUtils.addOne4PasswordErrorTimes(user.getAccount(), currentCenter);
                if (APIUtils.lockUserAndWriteLockTime(key.toString()).booleanValue()) {
                    String time = APIUtils.getLockTime(key.toString());
                    resp = ResManager.loadKDString((String)"\u8d26\u53f7\u5df2\u9501\u5b9a\uff0c\u8bf7\u5230%s\u4e4b\u540e\u518d\u91cd\u65b0\u767b\u5f55\u3002", (String)"LoginImpl_20", (String)BOS_LOGIN, (Object[])new Object[]{time});
                } else {
                    String nums = APIUtils.getLockTimes(key.toString());
                    if (kd.bos.login.utils.StringUtils.isNotEmpty(nums)) {
                        int times = APIUtils.MAX_ERROR_COUNT - Integer.parseInt(nums);
                        if (times > 0) {
                            resp = ResManager.loadKDString((String)"%1$s,\u60a8\u8fd8\u6709%2$s\u6b21\u91cd\u8bd5\u673a\u4f1a", (String)"LoginAction_56", (String)BOS_LOGIN, (Object[])new Object[]{resp, times + ""});
                        } else {
                            String time = APIUtils.getLockTime(key.toString());
                            resp = ResManager.loadKDString((String)"\u8d26\u53f7\u5df2\u9501\u5b9a\uff0c\u8bf7\u5230%s\u4e4b\u540e\u518d\u91cd\u65b0\u767b\u5f55\u3002", (String)"LoginImpl_20", (String)BOS_LOGIN, (Object[])new Object[]{time});
                        }
                    }
                }
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{resp});
            }
            if (userInfo != null) {
                String userorgId = userInfo.containsKey(FORGID) ? userInfo.get(FORGID) : DB_NO;
                userInfo.put(FORGID, userorgId);
                SessionUtils.createNewSession(servletRequest, servletResponse, currentCenter, lang, NetAddressUtils.getRemoteHost((HttpServletRequest)servletRequest), userInfo, LoginClientEnum.WEB);
                String redirect = servletRequest.getParameter("redirect");
                redirect = kd.bos.login.utils.StringUtils.isEmpty(redirect) ? "index.html?&formId=mc_main_console#/dform?formId=mc_main_console" : (!LoginUtils.isSelfEnvironment(redirect, servletRequest, servletResponse) ? "index.html?&formId=mc_main_console" : redirect.replaceAll("pc_main_console", "mc_main_console"));
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put(ERRORCODE, 0);
                map.put("RedirectURL", redirect);
                map.put(USERNAME, userName);
                String result = JSONUtils.toString(map);
                ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)result);
            }
        }
        catch (KDException ex) {
            logger.info(ex.getMessage());
            ErrorCode code = ex.getErrorCode();
            try {
                String resp = LoginUtils.getLoginResponse(String.valueOf(code.getCode()), ex.getMessage());
                ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)resp);
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            KDException kd = new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002%s", (String)"LoginAction_50", (String)BOS_LOGIN, (Object[])new Object[]{e.getMessage()})});
            try {
                String resp = LoginUtils.getLoginResponse(String.valueOf(kd.getErrorCode().getCode()), kd.getMessage());
                ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)resp);
            }
            catch (IOException ex) {
                logger.error((Throwable)ex);
            }
        }
    }

    public void login(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        try {
            boolean needCheckUserType;
            String msg;
            Lang lang = LoginLangUtils.getLoginLanguage(servletRequest);
            LoginLangUtils.setLang(lang);
            String systemType = servletRequest.getParameter("systemType");
            if ("mc".equals(systemType)) {
                this.loginByMC(servletRequest, servletResponse);
                return;
            }
            LoginUtils.forcePOSTSubmitCheck(servletRequest);
            LoginAccount loginAccount = LoginAccountFactory.createInstanceByHttpRequest(servletRequest, Optional.empty());
            Account currentCenter = loginAccount.getAccount();
            String tenantId = loginAccount.getTenantId();
            String isKickedOut = servletRequest.getParameter(KICKED_OUT_KEY);
            String userName = servletRequest.getParameter(Constants.LOGIN_USER_KEY);
            if (this.continueToLogin(servletRequest, servletResponse, currentCenter, userName, isKickedOut, lang)) {
                return;
            }
            if (this.isForbidLoginUnderSSO(currentCenter, userName)) {
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u5f53\u524d\u5df2\u5f00\u542f\u5355\u70b9\u767b\u5f55\u6a21\u5f0f\uff0c\u65e0\u6cd5\u901a\u8fc7\u8d26\u5bc6\u767b\u5f55\u3002", (String)"LoginAction_1", (String)BOS_LOGIN, (Object[])new Object[0])});
            }
            boolean isMobile = DB_YES.equals(servletRequest.getParameter("loginType"));
            if (isMobile && StringUtil.isNotEmpty((CharSequence)(msg = this.verifyPhoneNumber(userName)))) {
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{msg});
            }
            Map<String, Object> userMap = StrategeUtils.getUserId(servletRequest, userName);
            if (userMap.get("userId") == null) {
                if (isMobile) {
                    DynamicObject[] ids = LoginUserService.getUserList(userName, UserProperType.Mobile, "id", true);
                    if (ids != null && ids.length > 0) {
                        throw new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u7528\u6237\u5df2\u7981\u7528\uff0c\u65e0\u6cd5\u767b\u5f55\u3002", (String)"LoginUtils_18", (String)BOS_LOGIN, (Object[])new Object[0])});
                    }
                } else {
                    LoginUtils.checkUserEnable(currentCenter, userName);
                }
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef\u3002", (String)"LoginAction_10", (String)BOS_LOGIN, (Object[])new Object[0])});
            }
            String userId = (String)userMap.get("userId");
            Map<String, Object> verifyIpResult = IpControlService.verifyIp(currentCenter, Long.parseLong(userId), NetAddressUtils.getRemoteHost((HttpServletRequest)servletRequest));
            if (null != verifyIpResult && null != verifyIpResult.get(SUCCESS) && !((Boolean)verifyIpResult.get(SUCCESS)).booleanValue()) {
                SessionParams params = new SessionParams();
                params.setClientEnum(AgentUtil.isMobile(servletRequest) ? LoginClientEnum.MOBILE : LoginClientEnum.WEB);
                params.setIP(NetAddressUtils.getRemoteHost((HttpServletRequest)servletRequest));
                LoginLogUtils.addLog(currentCenter, LoginLogUtils.initLoginLogInfo(userId, userMap.get("deptId") != null ? String.valueOf(userMap.get("deptId")) : DB_NO, params, "IPControl"));
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{String.format(ResManager.loadKDString((String)"\u767b\u5f55\u5931\u8d25\uff0c\u5f53\u524d\u7528\u6237\u53d7IP\u7ba1\u63a7\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"LoginAction_21", (String)BOS_LOGIN, (Object[])new Object[0]), "")});
            }
            Map<String, Object> passwordStrategy = PswStrategyService.getPasswordStrategyByUserId(currentCenter, userMap);
            Map<String, Object> lockedMap = PswStrategyService.isLocked(currentCenter, passwordStrategy, Long.parseLong(userId));
            boolean isLocked = (Boolean)lockedMap.get("isLocked");
            String msg2 = (String)lockedMap.get(MESSAGE);
            if (isLocked) {
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{msg2});
            }
            boolean isNeedFactor = LoginUtils.getIsNeedFactor(currentCenter, servletRequest, userMap);
            if (!(isNeedFactor && !this.isCodeEmpty(servletRequest) || LoginUtils.proveVerifyCode(servletRequest, servletResponse))) {
                return;
            }
            if (isNeedFactor) {
                this.checkLoginFactor(currentCenter, servletRequest, userMap, userName);
            }
            String userSourceType = servletRequest.getParameter("userSourceType");
            AccountType aType = AccountType.getTypeByString(userSourceType);
            boolean needCheckOriginPassword = true;
            boolean isAdmin = AdminUtils.getAdminList().contains(userName);
            if (isAdmin) {
                aType = AccountType.SelfCreate;
            }
            if (!LoginUtils.hasPrevilige(aType.toString(), currentCenter.getAllSourceTypes())) {
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u6ca1\u6709\u4f7f\u7528\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"LoginAction_8", (String)BOS_LOGIN, (Object[])new Object[0])});
            }
            if (!isAdmin && LoginUtils.isSupportLDAP(currentCenter) && (!(needCheckUserType = LoginUtils.needCheckUserType(currentCenter)) || LoginUtils.isClerk(LoginUserService.checkUserType(currentCenter, userName)))) {
                aType = AccountType.LDAP;
                needCheckOriginPassword = false;
            }
            String userPassword = servletRequest.getParameter(Constants.LOGIN_PASSWORD_KEY);
            Map<String, Object> paramMap = ParametersUtils.getCommonParameters(currentCenter);
            if (paramMap != null) {
                Object closePwdEncrypt = paramMap.get("close_login_encrypt");
                if (ObjectUtils.isEmpty((Object)closePwdEncrypt) || !Boolean.parseBoolean(closePwdEncrypt.toString())) {
                    userPassword = LoginUtils.getDecryptedPassword(servletRequest, currentCenter.getAccountId());
                }
            } else {
                userPassword = LoginUtils.getDecryptedPassword(servletRequest, currentCenter.getAccountId());
            }
            UserAccount user = new UserAccount(userName, userPassword);
            user.setLoginType(servletRequest.getParameter("loginType"));
            LoginUserAuth lua = this.getLoginUserAuth(aType);
            UserAuthResult uar = lua.userAuthrize(user, currentCenter);
            logger.info(String.format("\u6839\u636e\u79df\u6237\u6620\u5c04\u83b7\u53d6\u7684\u9ed8\u8ba4\u79df\u6237\u4fe1\u606f:eid=%s,tid=%s .", currentCenter.getEid(), tenantId));
            if (uar == null || uar.getUserType() == UserProperType.Unknown || !uar.isSucess()) {
                String deptId = null;
                if (userMap != null && null != userMap.get("deptId")) {
                    deptId = userMap.get("deptId").toString();
                }
                SessionParams params = new SessionParams();
                params.setClientEnum(AgentUtil.isMobile(servletRequest) ? LoginClientEnum.MOBILE : LoginClientEnum.WEB);
                params.setIP(NetAddressUtils.getRemoteHost((HttpServletRequest)servletRequest));
                LoginLogUtils.addLog(currentCenter, LoginLogUtils.initLoginLogInfo(userId, deptId, params, "passwordError"));
                StrategeUtils.addPasswordWrongTimes(currentCenter, userId, LoginClientEnum.WEB.toString());
                msg2 = PswStrategyService.handleAfterLogon(currentCenter, Long.parseLong(userId), false, NetAddressUtils.getRemoteHost((HttpServletRequest)servletRequest), userName);
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{msg2});
            }
            if (StrategeUtils.getPasswordWrongTimes(currentCenter, userId, LoginClientEnum.WEB.toString()) > 0) {
                PswStrategyService.handleAfterLogon(currentCenter, Long.parseLong(userId), true, NetAddressUtils.getRemoteHost((HttpServletRequest)servletRequest));
                StrategeUtils.clearPasswordErrorTimes(userId, currentCenter);
            }
            boolean needResetInitialPassword = this.needResetPassword(tenantId, userPassword, needCheckOriginPassword);
            this.customLoginAuth(servletRequest, currentCenter, userId);
            HashMap<String, Object> verifyPSWStrategyResult = new HashMap(8);
            if (aType == AccountType.SelfCreate && !needResetInitialPassword && this.beforeLoginCheck(servletRequest, servletResponse, currentCenter, uar, userId, verifyPSWStrategyResult = PswStrategyService.verifyPSWStrategy(currentCenter, userMap, userPassword), isKickedOut, lang)) {
                return;
            }
            this.loginFromDefaultTenant(servletRequest, servletResponse, lang, currentCenter, uar, needResetInitialPassword, verifyPSWStrategyResult, aType);
            logger.info("\u767b\u5f55\u6210\u529f");
        }
        catch (KDException ex) {
            ErrorCode code = ex.getErrorCode();
            String resp = LoginUtils.getLoginResponse(String.valueOf(code.getCode()), ex.getMessage());
            logger.info(resp);
            ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)resp);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            KDException kd = new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002%s", (String)"LoginAction_50", (String)BOS_LOGIN, (Object[])new Object[]{e.getMessage()})});
            String resp = LoginUtils.getLoginResponse(String.valueOf(kd.getErrorCode().getCode()), kd.getMessage());
            ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)resp);
        }
    }

    private LoginUserAuth getLoginUserAuth(AccountType aType) {
        LoginUserAuth lua = null;
        switch (aType) {
            case YzjPublicCloud: {
                lua = (LoginUserAuth)BeanUtils.getBean(PLUGIN_YUNZHIJIA);
                break;
            }
            case YzjPrivateCloud: {
                lua = (LoginUserAuth)BeanUtils.getBean(PLUGIN_YUNZHIJIA_PRIVATE);
                break;
            }
            case SelfCreate: {
                lua = (LoginUserAuth)BeanUtils.getBean(PLUGIN_SELF);
                break;
            }
            case LDAP: {
                lua = (LoginUserAuth)BeanUtils.getBean(PLUGIN_LDAP);
                break;
            }
        }
        if (lua == null) {
            throw new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u7528\u6237\u767b\u5f55\u65b9\u5f0f\u6ca1\u6709\u6b63\u786e\u9009\u62e9\uff0c\u65e0\u6cd5\u63d0\u4f9b\u7528\u6237\u9a8c\u8bc1\u670d\u52a1\u3002", (String)"LoginAction_2", (String)BOS_LOGIN, (Object[])new Object[0])});
        }
        return lua;
    }

    private boolean isCodeEmpty(HttpServletRequest servletRequest) {
        return kd.bos.login.utils.StringUtils.isEmpty(servletRequest.getParameter("smsCode")) && kd.bos.login.utils.StringUtils.isEmpty(servletRequest.getParameter("emailCode"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkLoginFactor(Account currentCenter, HttpServletRequest servletRequest, Map<String, Object> userMap, String userName) {
        boolean isOk;
        String tenantId = currentCenter.getTenantId();
        String accountId = currentCenter.getAccountId();
        if (!AdminUtils.getAdminList().contains(userName) && !(isOk = LoginUserService.checkUserExisting(tenantId, accountId, userName))) {
            throw new KDException(LoginErrorCode.loginBizException, new Object[]{String.format(ResManager.loadKDString((String)"\u7528\u6237\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"LoginAction_4", (String)BOS_LOGIN, (Object[])new Object[0]), userName)});
        }
        Map<String, Object> passwordStrategy1 = PswStrategyService.getPasswordStrategyByUserId(currentCenter, userMap);
        if (null != passwordStrategy1.get("floginoptions") && "4".equals(passwordStrategy1.get("floginoptions"))) {
            String code = CacheLoginData.getAttribute((String)"emailLogin", (String)(accountId + userName));
            String emailCode = servletRequest.getParameter("emailCode");
            if (!kd.bos.login.utils.StringUtils.isNotEmpty(code)) throw new KDException(LoginErrorCode.loginBizException, new Object[]{String.format(ResManager.loadKDString((String)"\u90ae\u7bb1\u9a8c\u8bc1\u7801\u9519\u8bef\u6216\u5df2\u8fc7\u671f\u3002", (String)"LoginAction_25", (String)BOS_LOGIN, (Object[])new Object[0]), userName)});
            if (code.equals(emailCode)) return;
            throw new KDException(LoginErrorCode.loginBizException, new Object[]{String.format(ResManager.loadKDString((String)"\u90ae\u7bb1\u9a8c\u8bc1\u7801\u9519\u8bef\u6216\u5df2\u8fc7\u671f\u3002", (String)"LoginAction_25", (String)BOS_LOGIN, (Object[])new Object[0]), userName)});
        }
        String code = CacheLoginData.getAttribute((String)"smsLogin", (String)(accountId + userName));
        String mobileCode = servletRequest.getParameter("smsCode");
        if (!kd.bos.login.utils.StringUtils.isNotEmpty(code)) throw new KDException(LoginErrorCode.loginBizException, new Object[]{String.format(ResManager.loadKDString((String)"\u624b\u673a\u9a8c\u8bc1\u7801\u9519\u8bef\u6216\u5df2\u8fc7\u671f\u3002", (String)"LoginAction_6", (String)BOS_LOGIN, (Object[])new Object[0]), userName)});
        if (code.equals(mobileCode)) return;
        throw new KDException(LoginErrorCode.loginBizException, new Object[]{String.format(ResManager.loadKDString((String)"\u624b\u673a\u9a8c\u8bc1\u7801\u9519\u8bef\u6216\u5df2\u8fc7\u671f\u3002", (String)"LoginAction_5", (String)BOS_LOGIN, (Object[])new Object[0]), userName)});
    }

    private void showExtMessage(HttpServletResponse servletResponse, Map<String, Object> map, String randomCode) throws IOException {
        JSONObject object = new JSONObject();
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        HashMap<String, String> childrenParams = new HashMap<String, String>(4);
        params.put("type", 0);
        childrenParams.put("2", ResManager.loadKDString((String)"\u53d6\u6d88", (String)"LoginAction_33", (String)BOS_LOGIN, (Object[])new Object[0]));
        if (map.get("temporaryLogin") != null && ((Boolean)map.get("temporaryLogin")).booleanValue()) {
            params.put("type", 1);
            childrenParams.put("6", ResManager.loadKDString((String)"\u4e34\u65f6\u767b\u5f55", (String)"LoginAction_32", (String)BOS_LOGIN, (Object[])new Object[0]));
        }
        params.put("btnNames", childrenParams);
        params.put("content", map.get("errormsg"));
        params.put("title", ResManager.loadKDString((String)"\u7ed1\u5b9a\u5931\u8d25", (String)"LoginAction_31", (String)BOS_LOGIN, (Object[])new Object[0]));
        object.put(ERRORCODE, (Object)"307");
        object.put("errorData", params);
        object.put("randomCode", (Object)randomCode);
        ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)object.toString());
    }

    private boolean needResetPassword(String tenantId, String userPassword, boolean needCheckOriginPassword) {
        String defaultPwd = DefaultParameterService.getDefaultValueByKey("default_pwd");
        boolean defaultB = needCheckOriginPassword && kd.bos.login.utils.StringUtils.isNotEmpty(defaultPwd) && defaultPwd.equals(userPassword);
        String mcDefaultPwd = PswStrategyUtils.getUserDefaultPsw(tenantId);
        boolean defaultM = needCheckOriginPassword && kd.bos.login.utils.StringUtils.isNotEmpty(mcDefaultPwd) && mcDefaultPwd.equals(userPassword);
        return defaultB || defaultM;
    }

    private void loginByPasswordWarning(HttpServletRequest servletRequest, HttpServletResponse servletResponse, Account currentCenter, String userName) throws IOException {
        Lang lang = LoginLangUtils.getLoginLanguage(servletRequest);
        UserAuthResult uar = new UserAuthResult();
        String loginUserInfo = CacheLoginData.getAttribute((String)"passwordWarning", (String)(currentCenter.getAccountId() + "-" + userName));
        if (kd.bos.login.utils.StringUtils.isEmpty(loginUserInfo)) {
            throw new KDException(LoginErrorCode.loginBizException, new Object[]{String.format(ResManager.loadKDString((String)"\u767b\u5f55\u8d85\u65f6\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55\u3002", (String)"LoginAction_23", (String)BOS_LOGIN, (Object[])new Object[0]), new Object[0])});
        }
        uar.setUserType(UserProperType.valueOf(loginUserInfo.split(",")[2]));
        uar.setUser(loginUserInfo.split(",")[1]);
        Map<String, Object> checkSessionResult = this.checkSessionLimit(servletRequest, servletResponse, currentCenter, loginUserInfo.split(",")[3], lang, uar, loginUserInfo.split(",")[4]);
        if (null != checkSessionResult && "310".equals(checkSessionResult.get(ERRORCODE))) {
            String resp = JSONUtils.toString(checkSessionResult);
            ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)resp);
            return;
        }
        this.directLogin(servletRequest, servletResponse, lang, currentCenter, "passwordWarning");
    }

    private void directLogin(HttpServletRequest servletRequest, HttpServletResponse servletResponse, Lang lang, Account currentCenter, String cacheType) throws IOException {
        String userName = servletRequest.getParameter(Constants.LOGIN_USER_KEY);
        String randomCode = servletRequest.getParameter("randomCode");
        UserAuthResult uar = new UserAuthResult();
        String loginUserInfo = CacheLoginData.getAttribute((String)cacheType, (String)(currentCenter.getAccountId() + "-" + userName));
        if (kd.bos.login.utils.StringUtils.isNotEmpty(loginUserInfo)) {
            Map<String, Object> userMap;
            String userId;
            String[] loginUserInfoArray = loginUserInfo.split(",");
            String cacheRandomCode = loginUserInfoArray[4];
            if (!randomCode.equalsIgnoreCase(cacheRandomCode)) {
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{String.format(ResManager.loadKDString((String)"\u7981\u6b62\u6b64\u64cd\u4f5c\u767b\u5f55\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55\u3002", (String)"LoginAction_24", (String)BOS_LOGIN, (Object[])new Object[0]), new Object[0])});
            }
            uar = new UserAuthResult();
            uar.setUserType(UserProperType.valueOf(loginUserInfoArray[2]));
            uar.setUser(loginUserInfoArray[1]);
            if ("third_app_login_success".equals(cacheType)) {
                uar.setTemporaryLogin(true);
            }
            String string = userId = (userMap = StrategeUtils.getUserId(servletRequest, userName)) != null && !ObjectUtils.isEmpty((Object)userMap.get("userId")) ? userMap.get("userId").toString() : null;
            if (KICKED_OUT_KEY.equals(cacheType)) {
                Map<String, Object> respResult = PrivacyPolicyService.checkNeedSignPrivacy(servletRequest, servletResponse, currentCenter, userId, lang, uar, randomCode);
                if (TipTypeEnum.SIGNPRIVACY.getCode().equals(respResult.get(ERRORCODE))) {
                    String resp = JSONUtils.toString(respResult);
                    ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)resp);
                    return;
                }
            } else if ("privacy_policy".equals(cacheType)) {
                PrivacyPolicyService.reSignPrivacyPolicy(servletRequest, userId);
            }
            this.loginFromDefaultTenant(servletRequest, servletResponse, lang, currentCenter, uar, false);
            CacheLoginData.remove((String)cacheType, (String)(currentCenter.getAccountId() + "-" + userName));
            return;
        }
        throw new KDException(LoginErrorCode.loginBizException, new Object[]{String.format(ResManager.loadKDString((String)"\u767b\u5f55\u8d85\u65f6\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55\u3002", (String)"LoginAction_23", (String)BOS_LOGIN, (Object[])new Object[0]), new Object[0])});
    }

    @Deprecated
    public static String getDefaultTenant(String headerTenantId) {
        return headerTenantId;
    }

    private void loginFromDefaultTenant(HttpServletRequest request, HttpServletResponse response, Lang lang, Account currentCenter, UserAuthResult uar, boolean needResetInitialPassword) throws IOException {
        this.loginFromDefaultTenant(request, response, lang, currentCenter, uar, false, null, AccountType.SelfCreate);
    }

    private void loginFromDefaultTenant(HttpServletRequest request, HttpServletResponse response, Lang lang, Account currentCenter, UserAuthResult uar, boolean needResetInitialPassword, Map<String, Object> verifyPSWStrategyResult, AccountType accountType) throws IOException {
        Object result;
        String redirect;
        Map<String, String> userInfo = null;
        String user = String.valueOf(uar.getUser());
        logger.info(String.format("\u7528\u6237%s\u767b\u5f55\u9ed8\u8ba4\u79df\u6237\u3002", user));
        boolean needResetPassword = false;
        if (null != verifyPSWStrategyResult && null != verifyPSWStrategyResult.get(SUCCESS) && !((Boolean)verifyPSWStrategyResult.get(SUCCESS)).booleanValue()) {
            needResetPassword = true;
        }
        switch (uar.getUserType()) {
            case YunzhijiaUId: {
                userInfo = LoginUserService.getErpUserInfo(currentCenter, Long.parseLong(user), lang.name());
                break;
            }
            case Mobile: {
                userInfo = LoginUserService.getErpUserInfoByPhone(currentCenter, user, lang.name());
                break;
            }
            case Email: {
                userInfo = LoginUserService.getErpUserInfoByEmail(currentCenter, user, lang.name());
                break;
            }
            case WorkerNumber: {
                userInfo = LoginUserService.getErpUserInfoByPhone(currentCenter, user, lang.name());
                break;
            }
            case UserName: {
                userInfo = LoginUserService.getErpUserInfoByUserName(currentCenter, user, lang.name());
                break;
            }
            default: {
                userInfo = null;
            }
        }
        if (!LoginUserService.isValidUserInfo(userInfo)) {
            throw new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u60a8\u7684\u8d26\u53f7\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"LoginAction_11", (String)BOS_LOGIN, (Object[])new Object[0])});
        }
        String userName = userInfo.get(FTRUENAME);
        String userorgId = userInfo.containsKey(FORGID) ? userInfo.get(FORGID) : DB_NO;
        userInfo.put(FTRUENAME, userName);
        userInfo.put(FORGID, userorgId);
        boolean isOK = true;
        boolean needResetPassExpiredPassword = false;
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        long userId = Long.parseLong(userInfo.get("fid"));
        if (isOK && accountType != AccountType.LDAP) {
            if (!kd.bos.util.StringUtils.isNumericString((String)userInfo.get("fid"))) {
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{String.format(ResManager.loadKDString((String)"\u4e0d\u6b63\u786e\u7684\u6570\u636e\u5e93\u7528\u6237\u6570\u636e\uff0c%s,\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"LoginAction_13", (String)BOS_LOGIN, (Object[])new Object[0]), userInfo.get("fid"))});
            }
            Boolean passExpired = PswStrategyService.isPassExpired(currentCenter, userId);
            if (passExpired.booleanValue()) {
                needResetPassExpiredPassword = true;
                map.put(MESSAGE, String.format(ResManager.loadKDString((String)"\u5bc6\u7801\u5df2\u8fc7\u671f\uff0c\u8bf7\u4fee\u6539\u5bc6\u7801\u3002", (String)"LoginAction_14", (String)BOS_LOGIN, (Object[])new Object[0]), new Object[0]));
            }
        }
        if (needResetPassExpiredPassword || needResetInitialPassword || needResetPassword) {
            isOK = false;
        }
        String sessionId = null;
        if (isOK) {
            LoginUtils.chekLoginIP(request, currentCenter, userInfo);
            SessionParams sessionParams = new SessionParams();
            sessionParams.setMpUser(userInfo);
            sessionParams.setLang(lang);
            sessionParams.setIP(NetAddressUtils.getRemoteHost((HttpServletRequest)request));
            sessionParams.setCopyToClient(true);
            sessionParams.setTimeOut(SessionDAO.getSessionTimeout((String)currentCenter.getTenantId()));
            sessionParams.setTemporaryLogin(uar.getTemporaryLogin());
            if (AgentUtil.isMobile(request)) {
                sessionParams.setClientEnum(LoginClientEnum.MOBILE);
            } else {
                sessionParams.setClientEnum(LoginClientEnum.WEB);
            }
            if (request.getHeader("USER-AGENT") != null && request.getHeader("USER-AGENT").toLowerCase(Locale.ENGLISH).contains("kingdee-plm-design-center")) {
                sessionParams.setAppType("kd-plm");
            }
            sessionId = this.sessionService.createNewSession(request, response, currentCenter, sessionParams);
            if (LoginUtils.isSupportLoginUnderSSO(currentCenter) && LoginUtils.hasPrevilige(AccountType.ThridParty.toString(), currentCenter.getAllSourceTypes())) {
                CacheLoginData.setAttribute((String)"", (String)LoginUtils.getSSOSupportCachkey(sessionId, currentCenter.getAccountId()), (String)sessionId, (int)(SessionDAO.getSessionTimeout((String)currentCenter.getTenantId()) * 3));
            }
            logger.info("\u5ba2\u6237 \u7aef\u7c7b\u578b  :" + AgentUtil.getClienyId(request) + ",\u7528\u6237\u540d:" + request.getRemoteHost() + ",\u8bbf\u95ee\u5730\u5740:" + request.getRemoteAddr());
            LoginUtils.setCachkeyData(currentCenter);
            LoginUtils.clearSmsSendTimes(currentCenter.getAccountId(), user);
        }
        if (kd.bos.login.utils.StringUtils.isEmpty(redirect = request.getParameter("redirect"))) {
            redirect = INDEX_HTML;
        } else if (!LoginUtils.isSelfEnvironmentNew(redirect, request, response) || SecurityUtils.checkXss(redirect)) {
            redirect = kd.bos.login.utils.StringUtils.isNotEmpty(request.getParameter("isMobile")) ? "mobile.html" : INDEX_HTML;
        } else {
            String qs = request.getQueryString();
            if (qs != null) {
                redirect = qs.replace("redirect=", "");
            }
        }
        map.put(ERRORCODE, 0);
        boolean isAdmin = "administrator".equals(user);
        if (LoginUtils.isYZJSpecialVersion(currentCenter) && !isAdmin) {
            String openId = userInfo.get("fopenid");
            if (kd.bos.login.utils.StringUtils.isEmpty(openId)) {
                throw new KDException(Constants.KD_WEB_EXCEPTION, new Object[]{ResManager.loadKDString((String)"\u4eba\u5458\u7684openid\u4e3a\u7a7a\uff0c\u8bf7\u5148\u540c\u6b65\u4e91\u4e4b\u5bb6\u7ec4\u7ec7\u4eba\u5458\u3002", (String)"LoginAction_12", (String)BOS_LOGIN, (Object[])new Object[0])});
            }
            String eid = YZJSpecialUtils.getYZJEid(currentCenter);
            String lkToken = YZJSpecialUtils.getWebLoginToken(currentCenter, eid, openId);
            String yzjUrl = YZJSpecialUtils.getYZJHost(currentCenter) + "snsapi/oauth/login?lgtk=" + lkToken + "&to=/yzj-layout/cosmic/";
            LoginUtils.setYZJLKCache(userInfo.get("fid"), lkToken, 60);
            redirect = yzjUrl = "portal";
        }
        if (accountType != AccountType.LDAP) {
            if (needResetInitialPassword) {
                map.put("needChangeInitialPwd", 1);
                map.put(MESSAGE, String.format(ResManager.loadKDString((String)"\u4e3a\u4fdd\u969c\u8d26\u53f7\u5b89\u5168\uff0c\u8bf7\u5b8c\u6210\u8d26\u53f7\u9a8c\u8bc1\u5e76\u4fee\u6539\u521d\u59cb\u5bc6\u7801\u3002", (String)"LoginAction_16", (String)BOS_LOGIN, (Object[])new Object[0]), new Object[0]));
            }
            if (needResetPassExpiredPassword) {
                map.put("needChangePwd", 1);
            }
            if (needResetPassword) {
                map.put("needChangePwd", 1);
                map.put(MESSAGE, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5bc6\u7801\u4e0d\u7b26\u5408\u6700\u65b0\u5bc6\u7801\u7b56\u7565\uff0c\u8bf7\u4fee\u6539\u5bc6\u7801\u540e\u91cd\u65b0\u767b\u5f55\u3002", (String)"LoginAction_26", (String)BOS_LOGIN, (Object[])new Object[0]), new Object[0]));
            }
            if (needResetPassExpiredPassword || needResetPassword) {
                String randomCode = kd.bos.login.utils.StringUtils.randomWord(8);
                StringBuilder key = new StringBuilder();
                key.append(currentCenter.getAccountId()).append("-").append(user).append("-verifyCode");
                map.put("randomCode", randomCode);
                if (verifyPSWStrategyResult == null || verifyPSWStrategyResult.isEmpty()) {
                    verifyPSWStrategyResult = PswStrategyService.getPasswordStrategyByUserId(currentCenter, userInfo);
                }
                map.put("needverifycode", verifyPSWStrategyResult == null || verifyPSWStrategyResult.get("fneedverifycode") == null ? DB_YES : verifyPSWStrategyResult.get("fneedverifycode"));
                CacheLoginData.setAttribute((String)"passwordWarning", (String)key.toString(), (String)(userId + "," + randomCode), (int)300);
            }
        }
        redirect = URLUtils.securityFilterRedirectUrl(redirect);
        if (this.isNeedGetAuthCode(request.getParameter("redirect")) && (result = this.loginAuthenticationService.generateRedirectURL(request, currentCenter, sessionId)) != null && DB_NO.equals(result.get("errorCode"))) {
            redirect = result.get("redirectUri") != null ? result.get("redirectUri").toString() : redirect;
        }
        map.put("RedirectURL", redirect);
        map.put(USERNAME, userName);
        map.put("userId", userInfo.get("fid"));
        result = JSONUtils.toString(map);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)result);
    }

    public void yzjQRlogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Lang lang = LoginLangUtils.getLoginLanguage(request);
        LoginLangUtils.setLang(lang);
        logger.info("@QR_\u5f00\u59cb\u83b7\u53d6\u767b\u9646\u7528\u6237\u7684\u4e91\u4e4b\u5bb6\u4e8c\u7ef4\u7801\u3002");
        LoginAccount loginAccount = LoginAccountFactory.createInstanceByHttpRequest(request, Optional.empty());
        String tenantAlias = loginAccount.getTenantId();
        if (kd.bos.login.utils.StringUtils.isEmpty(tenantAlias)) {
            return;
        }
        Account currentCenter = loginAccount.getAccount();
        logger.info(String.format("LoginAction.login(accountIdParameter=%s)", currentCenter.getAccountId()));
        if (LoginUtils.hasPrevilige(AccountType.YzjPrivateCloud.toString(), currentCenter.getAllSourceTypes())) {
            this.privateQRLogin(request, response, tenantAlias);
        } else if (LoginUtils.hasPrevilige(AccountType.YzjPublicCloud.toString(), currentCenter.getAllSourceTypes())) {
            this.publicQRLogin(response, tenantAlias);
        }
    }

    private void privateQRLogin(HttpServletRequest servletRequest, HttpServletResponse servletResponse, String tenantAlias) throws IOException {
        String token = UUID.randomUUID().toString();
        String cacheType = CacheLoginData.getType4YzjpcdQR();
        CacheLoginData.setAttribute((String)cacheType, (String)token, (String)NO, (int)EXPIRE_TIME);
        StringBuilder urlBF = this.getPrefix(servletRequest);
        urlBF.append("auth/getQRCode.do?token=").append(token);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(HCODE_TOKEN, token);
        map.put("interval", EXPIRE_TIME);
        map.put("url", urlBF.toString());
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put(SUCCESS, YES);
        dataMap.put("data", map);
        String result = kd.bos.util.JSONUtils.toString(dataMap);
        ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)result);
    }

    private StringBuilder getPrefix(HttpServletRequest servletRequest) {
        return new StringBuilder(RevProxyUtil.getURLContextPath((HttpServletRequest)servletRequest));
    }

    public void updateLoginStatus(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String scanType = request.getParameter(SCANTYPE);
        logger.info(String.format("LoginAction.updateLoginStatus(scanType=%s)", scanType));
        ScanEnum scanEnum = ScanEnum.getScanEnmuByType(scanType);
        scanEnum = scanEnum == null ? ScanEnum.CLOUD_HUB : scanEnum;
        ScanStrategy scanStrategy = ScanStrategyFactory.getScanStrategy(scanEnum);
        ScanStrategyContext strategyContext = new ScanStrategyContext(scanStrategy);
        strategyContext.handleCallback(request, response);
    }

    private void publicQRLogin(HttpServletResponse servletResponse, String tenantAlias) throws IOException {
        String sYZJQRCallbackURL = System.getProperty("YZJQRCallbackURL");
        if (tenantAlias != null && sYZJQRCallbackURL.contains(keyword_tenantCode)) {
            sYZJQRCallbackURL = sYZJQRCallbackURL.replace(keyword_tenantCode, tenantAlias);
            logger.info(String.format("@QR_\u7ecf\u8fc7\u89e3\u6790tenantCode\u540e\u7684\u4e8c\u7ef4\u7801\u56de\u8c03\u5730\u5740\u4e3a:%s", sYZJQRCallbackURL));
        }
        String jsonQR = YzjQRCodeService.getQRCodeInfo(sYZJQRCallbackURL);
        logger.info("@QR_\u83b7\u53d6\u767b\u9646\u7528\u6237\u7684\u4e91\u4e4b\u5bb6\u4e8c\u7ef4\u7801\u5b8c\u6210\u3002");
        ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)jsonQR);
    }

    @Deprecated
    public void yzjQRloginPoll(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Lang lang = LoginLangUtils.getLoginLanguage(request);
        LoginLangUtils.setLang(lang);
        String sToken = request.getParameter(HCODE_TOKEN);
        if (kd.bos.login.utils.StringUtils.isEmpty(sToken)) {
            return;
        }
        LoginAccount loginAccount = LoginAccountFactory.createInstanceByHttpRequest(request, Optional.empty());
        String tenantAlias = loginAccount.getTenantId();
        if (kd.bos.login.utils.StringUtils.isEmpty(tenantAlias)) {
            return;
        }
        Account currentCenter = loginAccount.getAccount();
        logger.info(String.format("LoginAction.yzjQRloginPoll(accountIdParameter=%s)", currentCenter.getAccountId()));
        if (LoginUtils.hasPrevilige(AccountType.YzjPrivateCloud.toString(), currentCenter.getAllSourceTypes())) {
            this.publicCloudLoginPoll(request, response, sToken, tenantAlias, false);
        } else if (LoginUtils.hasPrevilige(AccountType.YzjPublicCloud.toString(), currentCenter.getAllSourceTypes())) {
            this.publicCloudLoginPoll(request, response, sToken, tenantAlias, true);
        }
    }

    public String getOpenId(String ticket, PrivateCloudModel model, String tenantId) {
        if (model == null) {
            return null;
        }
        String XT_SERVERNAME = model.getXtHost();
        String url = XT_SERVERNAME + "/openauth2/api/token?grant_type=client_credential&appid=" + model.getAppId() + "&secret=" + model.getSecuret();
        try {
            JSONObject tokenJson;
            String rs = HttpClientUtils.post(url, null, null);
            if (null != rs && rs.trim().length() > 0 && (tokenJson = JSONObject.parseObject((String)rs)).containsKey((Object)"access_token")) {
                String token = tokenJson.getString("access_token");
                String personUrl = XT_SERVERNAME + "/openauth2/api/getcontext?ticket=" + ticket + "&access_token=" + token;
                String perStr = HttpClientUtils.post(personUrl, null, null);
                if (null != perStr && perStr.trim().length() > 0) {
                    JSONObject perJson = JSONObject.parseObject((String)perStr);
                    return (String)perJson.get((Object)"openid");
                }
            }
        }
        catch (Exception e) {
            logger.error("getOpenId\u5f02\u5e38:", (Throwable)e);
        }
        return null;
    }

    @Deprecated
    private void publicCloudLoginPoll(HttpServletRequest servletRequest, HttpServletResponse servletResponse, String sToken, String tenantAlias, boolean isYzjPublicCloud) throws IOException {
        if (kd.bos.login.utils.StringUtils.isEmpty(sToken)) {
            return;
        }
        String cacheType = CacheLoginData.getType4YzjQR((String)sToken);
        Map mpQRLogin = CacheLoginData.getCache((String)cacheType);
        String sTicket = (String)mpQRLogin.get(TICKET);
        String sURL = (String)mpQRLogin.get("URL");
        sURL = URLUtils.checkRedirectUrl(servletRequest, sURL);
        if (kd.bos.login.utils.StringUtils.isEmpty(sTicket)) {
            return;
        }
        CacheLoginData.remove((String)cacheType);
        boolean iLoginStatus = false;
        String sMsg = "";
        String userName = "";
        try {
            Lang lang = LoginLangUtils.getLoginLanguage(servletRequest);
            YunzhijiaAppContext qrCtx = YunzhijiaTicketService.getContextByTicket(sTicket, isYzjPublicCloud);
            if (qrCtx != null) {
                List tenantList = AccountUtils.getTenantInfoByEid((String)qrCtx.getEid());
                TenantInfo lstTenant = this.getTenantIfExist(tenantList, servletRequest);
                if (lstTenant != null) {
                    String tenantId = lstTenant.getId();
                    Account currentCenter = LoginAccountFactory.createInstanceByHttpRequest(servletRequest, Optional.of(tenantId)).getAccount();
                    Map<String, String> mpUser = LoginUserService.getErpUserInfo(currentCenter, qrCtx.getOpenid(), lang.name());
                    if (DB_YES.equalsIgnoreCase(mpUser.get(SUCCESS))) {
                        iLoginStatus = true;
                        userName = mpUser.get(FTRUENAME);
                        SessionUtils.createNewSession(servletRequest, servletResponse, currentCenter, LoginLangUtils.getLoginLanguage(servletRequest), NetAddressUtils.getRemoteHost((HttpServletRequest)servletRequest), mpUser, LoginClientEnum.WEB);
                        logger.info("\u4e8c\u7ef4\u7801\u626b\u63cf\u767b\u9646\u4e0a\u4e0b\u6587\u751f\u6210\u6210\u529f\u3002");
                    } else {
                        sMsg = ResManager.loadKDString((String)"\u8d26\u53f7\u672a\u540c\u6b65\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u8d26\u53f7\u540c\u6b65\u3002", (String)"LoginAction_17", (String)BOS_LOGIN, (Object[])new Object[0]);
                        logger.info("\u4e8c\u7ef4\u7801\u626b\u63cf\u767b\u9646\u4e0a\u4e0b\u6587\u751f\u6210\u6210\u529f\uff0c\u4f46\u662f\u7528\u6237\u6ca1\u6709\u88ab\u540c\u6b65\u3002");
                    }
                } else {
                    sMsg = ResManager.loadKDString((String)"\u767b\u5f55\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"LoginAction_18", (String)BOS_LOGIN, (Object[])new Object[0]);
                }
            }
            if (kd.bos.login.utils.StringUtils.isNotEmpty(sMsg)) {
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{sMsg});
            }
            servletResponse.sendRedirect(sURL);
        }
        catch (KDException ex) {
            logger.error((Throwable)ex);
            ErrorCode code = ex.getErrorCode();
            String resp = ex.getMessage();
            ActionUtil.writeResponseResult((ServletResponse)servletResponse, (CharSequence)resp);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            KDException kd = new KDException(LoginErrorCode.loginBizException, new Object[]{"Failed to scan QR code for login, reason:" + e.getMessage()});
            String resp = kd.getMessage();
            ActionUtil.writeResponseResult((ServletResponse)servletResponse, (CharSequence)resp);
        }
    }

    private TenantInfo getTenantIfExist(List<TenantInfo> tenantList, HttpServletRequest request) {
        TenantInfo returnValue = null;
        if (tenantList != null) {
            String tenantCode = RevProxyUtil.getTenantCode((HttpServletRequest)request);
            for (TenantInfo tenantInfo : tenantList) {
                if (!tenantInfo.getId().equals(tenantCode)) continue;
                returnValue = tenantInfo;
                break;
            }
        }
        return returnValue;
    }

    @Deprecated
    public void getIMSecData(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        try {
            Map<String, String> mpEidKey = this.getCurrrentInfoMap(servletRequest);
            String sEid = mpEidKey.get("Eid");
            String sKeyData = mpEidKey.get(KEY_DATA);
            String tenantId = mpEidKey.get("tenantId");
            String userId = mpEidKey.get("userId");
            String accountId = mpEidKey.get(ACCOUNT_ID);
            String cacheType = CacheLoginData.getType4YzjEKey((String)accountId);
            HashMap<String, String> mpYzjEidKeyData = new HashMap<String, String>();
            mpYzjEidKeyData.put("Eid", sEid);
            mpYzjEidKeyData.put(KEY_DATA, sKeyData);
            CacheLoginData.setAttributes((String)cacheType, mpYzjEidKeyData);
            byte[] keyByte = Base64.decodeBase64((String)sKeyData);
            String sIMSdkKey = "";
            PrivateKey privateKey = null;
            String sYzjPara = String.format("{\"privatevalue\":%s,\"flag\":\"0\",\"bizNo\":\"NEXTCLOUDERP\"}", mpEidKey.get("userOpenId"));
            try {
                privateKey = EncryptUtils.restorePrivateKey((byte[])keyByte);
                sIMSdkKey = EncryptUtils.encryptWithEncodeBase64UTF8((String)sYzjPara, (Key)privateKey);
            }
            catch (Exception e) {
                logger.error("\u83b7\u53d6\u7528\u79df\u6237\u7684KeyFile\u5931\u8d25\uff0c\u5bfc\u81f4\u65e0\u6cd5\u65e0\u6cd5\u8c03\u7528\u4e91\u4e4b\u5bb6\u5373\u65f6\u901a\u8baf\u7ec4\u4ef6\u3002");
                return;
            }
            String ctKeyData = CacheLoginData.getType4UserImsdkKeyData((String)tenantId, (String)userId);
            HashMap<String, String> mp = new HashMap<String, String>();
            mp.put("Eid", sEid);
            mp.put(KEY_DATA, sIMSdkKey);
            CacheLoginData.setAttributes((String)ctKeyData, mp);
            String sResult = String.format("{\"errorcode\":0,\"eid\":\"%s\",\"key\":\"%s\"}", sEid, sIMSdkKey);
            ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)sResult);
            logger.info("\u83b7\u53d6\u79df\u6237\u7684KeyFile\u6210\u529f,\u5e76\u6210\u529f\u7f13\u5b58\u3002");
        }
        catch (KDException ex) {
            ErrorCode code = ex.getErrorCode();
            String resp = LoginUtils.getLoginResponse(String.valueOf(code.getCode()), ex.getMessage());
            ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)resp);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            KDException kd = new KDException(LoginErrorCode.loginBizException, new Object[]{"Failed to acquire KeyFile of tenant and cache, reason:" + e.getMessage()});
            String resp = LoginUtils.getLoginResponse(String.valueOf(kd.getErrorCode().getCode()), kd.getMessage());
            ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)resp);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void yzjShareOpen(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        Lang lang = LoginLangUtils.getLoginLanguage(servletRequest);
        LoginLangUtils.setLang(lang);
        String requestUrl = servletRequest.getRequestURL().toString();
        if (!kd.bos.login.utils.StringUtils.isEmpty(requestUrl) && DB_YES.equalsIgnoreCase(servletRequest.getHeader("https")) && requestUrl.startsWith("http://")) {
            requestUrl = requestUrl.replaceFirst("http:", "https:");
        }
        StringBuilder redirectUri = new StringBuilder();
        if (servletRequest.getHeader("User-Agent").startsWith("Qing")) {
            String redirect = this.getEncodedUrl(servletRequest, true);
            if (!LoginUtils.isSelfEnvironment(redirect = redirect + "&device=mob", servletRequest, servletResponse)) return;
            servletResponse.sendRedirect(redirect);
            return;
        }
        if (!kd.bos.login.utils.StringUtils.isNotEmpty(requestUrl)) return;
        int segFrom = requestUrl.indexOf("/mobile.html");
        boolean bMobileTest = requestUrl.endsWith("mobile.html");
        if (segFrom > 0 && !bMobileTest) {
            String dform = requestUrl.substring(0, segFrom);
            requestUrl = dform + "/index.html?";
            if (AgentUtil.getLoginIsByPhone(servletRequest)) {
                requestUrl = requestUrl + "&source=phone";
            }
            servletResponse.sendRedirect(redirectUri.toString());
            return;
        }
        String src = servletRequest.getParameter("src");
        String device = servletRequest.getParameter("device");
        if ("mob".equals(device) || "mobile".equals(device)) {
            String redirect = this.getEncodedUrl(servletRequest, true);
            if (!LoginUtils.isSelfEnvironment(redirect, servletRequest, servletResponse)) return;
            servletResponse.sendRedirect(redirect);
            return;
        }
        if (!"wf".equals(src)) {
            String redirect = this.getEncodedUrl(servletRequest, false);
            if (!LoginUtils.isSelfEnvironment(redirect = redirect + "&device=pc", servletRequest, servletResponse)) return;
            servletResponse.sendRedirect(redirect);
            return;
        }
        String redirect = "";
        redirect = AgentUtil.isMobile(servletRequest) ? this.getEncodedUrl(servletRequest, true) + "&device=mob" : this.getEncodedUrl(servletRequest, false) + "&device=pc";
        if (!LoginUtils.isSelfEnvironment(redirect, servletRequest, servletResponse)) return;
        servletResponse.sendRedirect(redirect);
    }

    private String getEncodedUrl(HttpServletRequest servletRequest, boolean mobile) throws UnsupportedEncodingException {
        Map<String, String> encodedParameters = this.getEncodedParameters(servletRequest);
        boolean debug = "true".equals(servletRequest.getParameter("kdweb_debug"));
        String debugcdnUrl = LoginUtils.getKDWebCDN(servletRequest);
        String appendParame = "";
        if (debug) {
            appendParame = "?kdweb_debug=true";
        }
        if (!kd.bos.login.utils.StringUtils.isEmpty(debugcdnUrl)) {
            String cdnUrlParame = "kdweb_cdn=" + debugcdnUrl;
            appendParame = !kd.bos.login.utils.StringUtils.isEmpty(appendParame) ? appendParame + "&" + cdnUrlParame : "?" + cdnUrlParame;
        }
        String redirect = RevProxyUtil.getURLContextPath((HttpServletRequest)servletRequest);
        String cFlag = "&";
        if (kd.bos.login.utils.StringUtils.isEmpty(appendParame) || !appendParame.contains("?")) {
            cFlag = "?";
        }
        String mobileType = encodedParameters.get("mb_type");
        if (mobile) {
            String moblieFormId = encodedParameters.get("mb_formId");
            if (kd.bos.login.utils.StringUtils.isEmpty(moblieFormId)) {
                moblieFormId = encodedParameters.get(FORM_ID);
            }
            if (moblieFormId != null) {
                redirect = redirect + "mobile.html" + appendParame + cFlag + "form=" + moblieFormId + "&";
            }
        } else {
            String formId = encodedParameters.get(FORM_ID);
            if (formId != null) {
                redirect = redirect + INDEX_HTML + appendParame + cFlag + "formId=" + formId + "&";
            }
        }
        if (AgentUtil.getLoginIsByPhone(servletRequest)) {
            redirect = redirect + "&source=phone&";
        }
        StringBuilder stringBuilder = new StringBuilder(redirect);
        for (Map.Entry<String, String> entry : encodedParameters.entrySet()) {
            String key = entry.getKey();
            if ("mb_formId".equals(key) || FORM_ID.equals(key)) continue;
            if ("type".equals(key) && mobile && kd.bos.login.utils.StringUtils.isNotEmpty(mobileType)) {
                stringBuilder.append(key).append("=").append(mobileType).append("&");
                continue;
            }
            stringBuilder.append(key).append("=").append(encodedParameters.get(key)).append("&");
        }
        redirect = stringBuilder.toString();
        redirect = redirect.substring(0, redirect.length() - 1);
        return redirect;
    }

    private Map<String, String> getEncodedParameters(HttpServletRequest servletRequest) throws UnsupportedEncodingException {
        HashMap<String, String> encodedParameters = new HashMap<String, String>();
        Map parms = servletRequest.getParameterMap();
        for (Map.Entry entry : parms.entrySet()) {
            String[] parm;
            String key = (String)entry.getKey();
            if (kd.bos.login.utils.StringUtils.isNull(key) || (parm = (String[])entry.getValue()).length <= 0) continue;
            encodedParameters.put(key, this.encode(parm[0]));
        }
        return encodedParameters;
    }

    protected String encode(String stringToEncode) throws UnsupportedEncodingException {
        return URLEncoder.encode(stringToEncode, UTF_8);
    }

    private Map<String, String> getCurrrentInfoMap(HttpServletRequest servletRequest) {
        HashMap<String, String> mpEidKey = new HashMap<String, String>();
        String globalSessionId = LoginUtils.getKDCookieValue(servletRequest);
        if (globalSessionId != null) {
            SessionDAO sessionDAO = SessionDAOFactory.getSessionDAO((String)globalSessionId);
            Map sessionInfo = sessionDAO.getAttributesAsMap(new String[]{ACCOUNT_ID, "userOpenId", "userName", "userId", "tenantId"});
            String userOpenId = (String)sessionInfo.get("userOpenId");
            String userId = (String)sessionInfo.get("userId");
            mpEidKey.put("userOpenId", userOpenId);
            mpEidKey.put("userId", userId);
            Account currentAccount = LoginAccountFactory.createInstanceBySession(sessionInfo, Optional.empty()).getAccount();
            mpEidKey.put(KEY_DATA, currentAccount.getKeyFile());
            mpEidKey.put("Eid", currentAccount.getEid());
            mpEidKey.put(ACCOUNT_ID, currentAccount.getAccountId());
            mpEidKey.put("tenantId", currentAccount.getTenantId());
        }
        return mpEidKey;
    }

    private Map<String, Object> checkSessionLimit(HttpServletRequest servletRequest, HttpServletResponse servletResponse, Account currentCenter, String userId, Lang lang, UserAuthResult uar, String randomCode) throws IOException {
        String userName = servletRequest.getParameter(Constants.LOGIN_USER_KEY);
        Map<String, Object> checkSessionResult = SessionUtils.checkSessionLimit(servletRequest, currentCenter, userId, lang);
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        result.put(ERRORCODE, DB_NO);
        if (null != checkSessionResult && null != checkSessionResult.get(SUCCESS) && !((Boolean)checkSessionResult.get(SUCCESS)).booleanValue()) {
            result.put(ERRORCODE, "310");
            result.put(DESCRIPTION, ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u591a\u4e2a\u8bbe\u5907\u540c\u65f6\u767b\u5f55\u540c\u4e00\u8d26\u53f7\u3002", (String)"LoginAction_22", (String)BOS_LOGIN, (Object[])new Object[0]));
            result.put("randomCode", randomCode);
            String resp = JSONUtils.toString(result);
            CacheLoginData.setAttribute((String)KICKED_OUT_KEY, (String)(currentCenter.getAccountId() + "-" + userName), (String)(userName + "," + uar.getUser() + "," + uar.getUserType().toString() + "," + userId + "," + randomCode), (int)30);
        }
        return result;
    }

    private String getThirdAppScanCodeUrl(HttpServletRequest request) throws IOException {
        String scanType = request.getParameter(SCANTYPE);
        LoginAccount loginAccount = LoginAccountFactory.createInstanceByHttpRequest(request, Optional.empty());
        String accountId = loginAccount.getAccountId();
        String token = request.getParameter(HCODE_TOKEN);
        String language = request.getParameter("language");
        StringBuilder redirectUrl = this.getPrefix(request);
        redirectUrl.append("auth/updateLoginStatus.do?").append("token=").append(token).append("&language=").append(language).append("&scantype=").append(scanType);
        if (kd.bos.login.utils.StringUtils.isNotEmpty(accountId)) {
            redirectUrl.append("&accountid=").append(accountId);
        }
        String qrCodeUrl = null;
        if (ScanEnum.WEIXIN_WORK.getValue().equals(scanType)) {
            String tenantAlias = RevProxyUtil.getTenantCode((HttpServletRequest)request);
            if (kd.bos.login.utils.StringUtils.isEmpty(tenantAlias)) {
                logger.error("\u83b7\u53d6\u7b2c\u4e09\u65b9\u626b\u7801\u767b\u5f55\u4e8c\u7ef4\u7801\u94fe\u63a5\u5730\u5740\u5f02\u5e38\uff0ctenant\u4e3a\u7a7a");
                return null;
            }
            Map<String, String> config = WxWorkConfigService.getWorkWxConfig(loginAccount.getAccount());
            if (config != null) {
                String lang = "zh_CN".equals(language) ? "zh" : "en";
                qrCodeUrl = WxqyhUtils.getWxWorkOPHost() + "wwopen/sso/qrConnect?" + "state=STATE" + "&appid=" + config.get("corpId") + "&agentid=" + config.get("agentId") + "&lang=" + lang + "&redirect_uri=" + URLEncoder.encode(redirectUrl.toString(), UTF_8);
            }
        }
        return qrCodeUrl;
    }

    private boolean continueToLogin(HttpServletRequest servletRequest, HttpServletResponse servletResponse, Account currentCenter, String userName, String isKickedOut, Lang lang) throws Exception {
        if (kd.bos.login.utils.StringUtils.isNotEmpty(isKickedOut) && isKickedOut.equals(DB_YES)) {
            this.directLogin(servletRequest, servletResponse, lang, currentCenter, KICKED_OUT_KEY);
            return true;
        }
        if (kd.bos.login.utils.StringUtils.isNotEmpty(isKickedOut) && isKickedOut.equals("2")) {
            this.loginByPasswordWarning(servletRequest, servletResponse, currentCenter, userName);
            return true;
        }
        if (kd.bos.login.utils.StringUtils.isNotEmpty(isKickedOut) && isKickedOut.equals("3")) {
            this.directLogin(servletRequest, servletResponse, lang, currentCenter, "privacy_policy");
            return true;
        }
        if (kd.bos.login.utils.StringUtils.isNotEmpty(servletRequest.getParameter("temporaryLogin"))) {
            this.directLogin(servletRequest, servletResponse, lang, currentCenter, "third_app_login_success");
            return true;
        }
        return false;
    }

    private boolean beforeLoginCheck(HttpServletRequest servletRequest, HttpServletResponse servletResponse, Account currentCenter, UserAuthResult uar, String userId, Map<String, Object> verifyPSWStrategyResult, String isKickedOut, Lang lang) throws IOException {
        Map<String, Object> respResult;
        String isMobile = servletRequest.getParameter("isMobile");
        String userName = servletRequest.getParameter(Constants.LOGIN_USER_KEY);
        String randomCode = kd.bos.login.utils.StringUtils.randomWord(8);
        if (kd.bos.login.utils.StringUtils.isEmpty(isKickedOut) && kd.bos.login.utils.StringUtils.isEmpty(isMobile)) {
            Map<String, Object> respResult2 = new HashMap<String, String>(8);
            respResult2.put(ERRORCODE, DB_NO);
            if (null != verifyPSWStrategyResult && null != verifyPSWStrategyResult.get(SUCCESS) && ((Boolean)verifyPSWStrategyResult.get(SUCCESS)).booleanValue()) {
                respResult2 = PswStrategyService.checkPasswordWarning(servletRequest, servletResponse, currentCenter, userId, uar, randomCode);
            }
            if ("305".equals(respResult2.get(ERRORCODE))) {
                String resp = JSONUtils.toString(respResult2);
                ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)resp);
                return true;
            }
        }
        boolean isMultiClientUserId = SessionUtils.isMultiClientUserId(RevProxyUtil.getTenantId((HttpServletRequest)servletRequest), userId);
        if ((kd.bos.login.utils.StringUtils.isEmpty(isKickedOut) || !isKickedOut.equals(DB_YES)) && kd.bos.login.utils.StringUtils.isEmpty(isMobile) && !isMultiClientUserId && "310".equals((respResult = this.checkSessionLimit(servletRequest, servletResponse, currentCenter, userId, lang, uar, randomCode)).get(ERRORCODE))) {
            String resp = JSONUtils.toString(respResult);
            ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)resp);
            return true;
        }
        String isStandard = servletRequest.getParameter("isStandard");
        if ("true".equals(isStandard) && kd.bos.login.utils.StringUtils.isEmpty(isKickedOut) && kd.bos.login.utils.StringUtils.isEmpty(isMobile)) {
            Map<String, Object> respResult3 = PrivacyPolicyService.checkNeedSignPrivacy(servletRequest, servletResponse, currentCenter, userId, lang, uar, randomCode);
            if (TipTypeEnum.SIGNPRIVACY.getCode().equals(respResult3.get(ERRORCODE))) {
                String resp = JSONUtils.toString(respResult3);
                ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)resp);
                return true;
            }
        }
        if (kd.bos.login.utils.StringUtils.isEmpty(servletRequest.getParameter("temporaryLogin"))) {
            CacheLoginData.setAttribute((String)"third_app_login_success", (String)(currentCenter.getAccountId() + "-" + uar.getUser()), (String)(userName + "," + uar.getUser() + "," + uar.getUserType().toString() + "," + userId + "," + randomCode), (int)300);
            Map<String, Object> map = this.thirdAppsService.checkExtPlugin(servletRequest, Long.parseLong(userId));
            if (map != null && map.get(SUCCESS) instanceof Boolean && !((Boolean)map.get(SUCCESS)).booleanValue()) {
                this.showExtMessage(servletResponse, map, randomCode);
                return true;
            }
        }
        return false;
    }

    private void customLoginAuth(HttpServletRequest servletRequest, Account currentCenter, String userId) {
        LoginAuthResult costomUserAuthResult;
        ILoginAuthenticationService loginAuthenticationService = null;
        try {
            String key = currentCenter.getAccountId() + "custom_dynamiccode_login_class";
            Object customLoginClass = LocalCacheUtils.get(key);
            if (ObjectUtils.isEmpty((Object)customLoginClass)) {
                customLoginClass = DefaultParameterService.getDefaultParamsConfig(currentCenter, "custom_dynamiccode_login_class");
            }
            if (!ObjectUtils.isEmpty((Object)customLoginClass)) {
                loginAuthenticationService = (ILoginAuthenticationService)BeanUtils.getBean(customLoginClass.toString());
                LocalCacheUtils.put(key, customLoginClass);
            }
        }
        catch (Exception e) {
            DisCardUtil.discard();
        }
        if (loginAuthenticationService != null && (costomUserAuthResult = loginAuthenticationService.customLoginAuth(servletRequest, currentCenter, Long.parseLong(userId))) != null && !costomUserAuthResult.getSucess()) {
            throw new KDException(LoginErrorCode.loginBizException, new Object[]{costomUserAuthResult.getMessage()});
        }
    }

    private static void updateUserLoginIpByUserId(final HttpServletRequest request, final Account currentCenter, final long userId) {
        pool.execute(new Runnable(){

            @Override
            public void run() {
                LoginUserService.updateUserLoginIpByUserId(request, currentCenter, userId);
            }
        });
    }

    private boolean isForbidLoginUnderSSO(Account currentCenter, String userName) {
        if (AdminUtils.getAdminList().contains(userName)) {
            return false;
        }
        return LoginUtils.hasPrevilige(AccountType.ThridParty.toString(), currentCenter.getAllSourceTypes()) && !LoginUtils.isSupportLoginUnderSSO(currentCenter);
    }

    public void authorize(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws Exception {
        Map<Object, Object> result = new HashMap<String, String>(8);
        String redirectUri = servletRequest.getParameter("redirect_uri");
        String appId = servletRequest.getParameter("app_client_id");
        if (StringUtils.isBlank((CharSequence)appId)) {
            result.put(MESSAGE, "app_client_id is null");
            ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)JSONUtils.toString(result));
            return;
        }
        if (StringUtils.isBlank((CharSequence)redirectUri)) {
            result.put(MESSAGE, "redirectUri is null");
            ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)JSONUtils.toString(result));
            return;
        }
        LoginAccount loginAccount = LoginAccountFactory.createInstanceByHttpRequest(servletRequest, Optional.empty());
        Account currentCenter = loginAccount.getAccount();
        String sessionId = LoginUtils.getKDCookieValue(servletRequest);
        if (StringUtils.isBlank((CharSequence)sessionId)) {
            result.put(MESSAGE, "session is invalid");
            ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)JSONUtils.toString(result));
            return;
        }
        LoginAuthenticationServiceImpl loginAuthenticationService = new LoginAuthenticationServiceImpl();
        result = loginAuthenticationService.generateRedirectURL(servletRequest, currentCenter, sessionId);
        if (result != null && !DB_NO.equals(result.get("errorCode"))) {
            ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)JSONUtils.toString(result));
            return;
        }
        if (result != null && result.get("redirectUri") != null) {
            redirectUri = result.get("redirectUri").toString();
        }
        servletResponse.sendRedirect(redirectUri);
    }

    private boolean isNeedGetAuthCode(String redirect) {
        try {
            redirect = URLDecoder.decode(redirect, UTF_8);
            if (kd.bos.login.utils.StringUtils.isNotBlank(redirect) && redirect.contains("response_code=code")) {
                return true;
            }
        }
        catch (Exception e) {
            DisCardUtil.discard();
        }
        return false;
    }

    public void verifyPhoneNumber(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        String phone = servletRequest.getParameter(Constants.LOGIN_USER_KEY);
        String msg = this.verifyPhoneNumber(phone);
        String resp = LoginUtils.getLoginResponse(StringUtil.isNotEmpty((CharSequence)msg) ? DB_YES : DB_NO, msg);
        ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)resp);
    }

    private String verifyPhoneNumber(String phone) {
        if (phone != null && !phone.contains("-")) {
            phone = "86-" + phone;
        }
        return LoginUtils.verifyPhoneNumber(phone);
    }

    public void getCountryAreaCodes(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        Map<String, Object> countryAreaCodes = LoginUtils.getCountryAreaCodes();
        String data = JSON.toJSONString(countryAreaCodes);
        ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)data);
    }
}

