/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.actions;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.actiondispatcher.ActionUtil;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dc.api.model.Account;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.LoginClientEnum;
import kd.bos.login.api.APILoginError;
import kd.bos.login.lang.LoginLangUtils;
import kd.bos.login.sso.LtpaTokenManager;
import kd.bos.login.user.LoginUserService;
import kd.bos.login.utils.JSONUtils;
import kd.bos.login.utils.SessionUtils;
import kd.bos.login.utils.account.LoginAccountFactory;
import kd.bos.util.NetAddressUtils;
import kd.bos.util.RevProxyUtil;
import kd.bos.util.StringUtils;

public class LtpaTokenSSOAction {
    private static final String BOS_LOGIN = "bos-login";
    private static Log logger = LogFactory.getLog(LtpaTokenSSOAction.class);
    private static final String LTPALOGINERR_NO_USER = "1";
    private static final String LTPALOGINERR_TOKEN_UNVALID = "2";
    private static final String LTPALOGINERR_PARA_UNVALID = "3";

    public void ltpaTokenLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Lang lang = LoginLangUtils.getLoginLanguage(request);
        LoginLangUtils.setLang(lang);
        String token = request.getParameter("token");
        String redirect = request.getParameter("redirect");
        String user = request.getParameter("user");
        String tenantId = RevProxyUtil.getTenantCode((HttpServletRequest)request);
        try {
            if (StringUtils.isEmpty((String)token) || StringUtils.isBlank((String)redirect) || StringUtils.isEmpty((String)user) || StringUtils.isBlank((String)tenantId)) {
                throw new KDException(new ErrorCode("LTPALOGINERR_PARA_UNVALID", ResManager.loadKDString((String)"Http\u8bf7\u6c42\u7684\u53c2\u6570\u65e0\u6548\u3002", (String)"LtpaTokenSSOAction_0", (String)BOS_LOGIN, (Object[])new Object[0])), new Object[0]);
            }
            Account currentCenter = LoginAccountFactory.createInstanceByHttpRequest(request, Optional.empty()).getAccount();
            boolean tokenOK = LtpaTokenManager.verifyToken(currentCenter, token, user);
            if (!tokenOK) {
                response.sendRedirect(redirect);
                return;
            }
            Map<String, String> userInfo = LoginUserService.getErpUserInfoByPhone(currentCenter, user, lang.name());
            if (userInfo.size() > 0) {
                String userId = userInfo.get("fid");
                if (StringUtils.isEmpty((String)userId)) {
                    throw new KDException(APILoginError.API_REQUEST_INVALID_PARAMETERS, new Object[]{ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0c\u7528\u6237\u4e0d\u5b58\u5728\u3002", (String)"LtpaTokenSSOAction_2", (String)BOS_LOGIN, (Object[])new Object[0])});
                }
            } else {
                throw new KDException(APILoginError.API_REQUEST_INVALID_PARAMETERS, new Object[]{ResManager.loadKDString((String)"\u7528\u6237\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u8fdb\u884c\u4eba\u5458\u540c\u6b65\u3002", (String)"LtpaTokenSSOAction_5", (String)BOS_LOGIN, (Object[])new Object[0])});
            }
            SessionUtils.createNewSession(request, response, currentCenter, LoginLangUtils.getLoginLanguage(request), NetAddressUtils.getRemoteHost((HttpServletRequest)request), userInfo, LoginClientEnum.API);
            response.sendRedirect(redirect);
        }
        catch (KDException ex) {
            logger.error((Throwable)ex);
            ErrorCode code = ex.getErrorCode();
            String resp = LtpaTokenSSOAction.getLptaResponse(false, String.valueOf(code.getCode()), ex.getMessage());
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)resp);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            String resp = LtpaTokenSSOAction.getLptaResponse(false, LTPALOGINERR_TOKEN_UNVALID, ResManager.loadKDString((String)"\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\n", (String)"LtpaTokenSSOAction_6", (String)BOS_LOGIN, (Object[])new Object[0]));
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)resp);
        }
    }

    private static String getLptaResponse(boolean success, String errCode, String msg) throws IOException {
        HashMap<String, Object> lptaEx = new HashMap<String, Object>();
        lptaEx.put("success", success);
        lptaEx.put("error_code", errCode);
        lptaEx.put("error_desc", msg);
        return JSONUtils.toString(lptaEx);
    }
}

