/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.ai.service;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.CacheLoginData;
import kd.bos.login.ai.model.CollectImgModel;
import kd.bos.login.model.AIResponseModel;
import kd.bos.login.utils.JSONUtils;
import kd.bos.login.utils.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class FaceLoginService {
    private static final String SUCCESS = "success";
    private static final String BOS_LOGIN = "bos-login";
    private static Log logger = LogFactory.getLog(FaceLoginService.class);

    public Map<String, Object> collectFaceImg(CollectImgModel paramModel) {
        boolean isSuccess = false;
        String msg = null;
        HashMap<String, Object> result = new HashMap<String, Object>();
        String token = paramModel.getToken();
        String imgBase64 = paramModel.getImg();
        String[] base64Values = imgBase64.split(",");
        String imgBase64Data = base64Values.length > 1 ? base64Values[1] : imgBase64;
        byte[] imgBytes = Base64.getDecoder().decode(imgBase64Data);
        if (imgBytes.length < 2048) {
            result.put(SUCCESS, false);
            result.put("msg", ResManager.loadKDString((String)"\u56fe\u7247\u8d28\u91cf\u4e0d\u4f73\uff0c\u65e0\u6cd5\u8bc6\u522b\u3002", (String)"FaceLoginService_0", (String)BOS_LOGIN, (Object[])new Object[0]));
            return result;
        }
        try {
            String originalResult = this.faceRecognize(imgBytes, token + ".png");
            String openId = this.fetchOpenId(originalResult);
            if (openId != null && !openId.isEmpty()) {
                AIResponseModel resultModel = this.sendAiLogin(openId, token);
                isSuccess = resultModel.isSuccess();
                if (!isSuccess) {
                    msg = ResManager.loadKDString((String)"\u767b\u5f55\u63a5\u53e3\u83b7\u53d6OpenID\u5931\u8d25\u3002", (String)"FaceLoginService_1", (String)BOS_LOGIN, (Object[])new Object[0]);
                }
                result.put(SUCCESS, resultModel.isSuccess());
            } else {
                msg = ResManager.loadKDString((String)"\u4eba\u8138\u8bc6\u522b\u5931\u8d25\uff0c\u8fd4\u56de\u7684OpenId\u4e3a\u7a7a\u3002", (String)"FaceLoginService_2", (String)BOS_LOGIN, (Object[])new Object[0]);
            }
            result.put("openId", openId);
            result.put("originalResult", originalResult);
        }
        catch (Exception e) {
            logger.error("asimov collectFaceImg() occur an exception ", (Throwable)e);
            isSuccess = false;
            msg = e.getMessage();
        }
        result.put(SUCCESS, isSuccess);
        if (msg != null) {
            result.put("msg", msg);
        }
        return result;
    }

    private AIResponseModel sendAiLogin(String userId, String token) {
        return this.AICallbackByDarwin(userId, token, "");
    }

    private static boolean isEffectiveToken(String token) {
        return CacheLoginData.isEffectiveToken((String)token);
    }

    public AIResponseModel AICallbackByDarwin(String userId, String token, String loginType) {
        if (StringUtils.isEmpty(userId) || StringUtils.isEmpty(token)) {
            String msg = StringUtils.isEmpty(userId) ? "userId is empty." : "token is empty.";
            return new AIResponseModel(false, msg);
        }
        HashMap<String, String> mpVoiceCache = new HashMap<String, String>();
        mpVoiceCache.put("userId", userId);
        String cacheType = CacheLoginData.getType4AILogin((String)token);
        CacheLoginData.setAttributes((String)cacheType, mpVoiceCache);
        if ("voice".equals(loginType)) {
            boolean isSuccess;
            return new AIResponseModel(isSuccess, (isSuccess = FaceLoginService.isEffectiveToken(token)) ? null : "token " + token + " is invalid.");
        }
        return new AIResponseModel(true, null);
    }

    private String faceRecognize(byte[] imgBytes, String fileName) throws KDException {
        HashMap<String, ContentBody> params = new HashMap<String, ContentBody>();
        params.put("file", (ContentBody)new InputStreamBody((InputStream)new ByteArrayInputStream(imgBytes), fileName));
        try {
            String responseString = this.sendMultipartFormData(this.getFaceRegServerUrl(), params);
            return responseString;
        }
        catch (ClientProtocolException e) {
            this.throwAIException(e, "face recognize add StringBody occur ClientProtocolException");
        }
        catch (IOException e) {
            this.throwAIException(e, "face recognize add StringBody occur IOException");
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String sendMultipartFormData(String url, Map<String, ContentBody> params) throws ClientProtocolException, IOException {
        MultipartEntity multipartEntity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE, "----------ThIs_Is_tHe_bouNdaRY_$", Charset.defaultCharset());
        if (params != null) {
            for (Map.Entry<String, ContentBody> entry : params.entrySet()) {
                multipartEntity.addPart(entry.getKey(), entry.getValue());
            }
        }
        HttpPost request = new HttpPost(url);
        request.setEntity((HttpEntity)multipartEntity);
        request.addHeader("Content-Type", "multipart/form-data; boundary=----------ThIs_Is_tHe_bouNdaRY_$");
        request.setHeader("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36");
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        try (BufferedReader in = null;){
            String line;
            HttpResponse response = httpClient.execute((HttpUriRequest)request);
            InputStream is = response.getEntity().getContent();
            in = new BufferedReader(new InputStreamReader(is));
            StringBuilder buffer = new StringBuilder();
            while ((line = in.readLine()) != null) {
                buffer.append(line);
            }
            String string = buffer.toString();
            return string;
        }
    }

    private String getFaceRegServerUrl() {
        String key = "AI.face.rec.url";
        String value = System.getProperty(key);
        if (value == null || value.isEmpty()) {
            value = "http://kiot.kingdee.com/face";
        }
        return value;
    }

    private String fetchOpenId(String response) {
        try {
            HashMap result = JSONUtils.cast(response, HashMap.class);
            return (String)result.get("uid");
        }
        catch (IOException e) {
            this.throwAIException(e, "fetchOpenId occur IOException");
            return null;
        }
    }

    private void throwAIException(String msg) throws KDException {
        throw new KDException((Throwable)new RuntimeException(), new ErrorCode("###", msg), new Object[0]);
    }

    private void throwAIException(Throwable cause, String msg) throws KDException {
        throw new KDException(cause, new ErrorCode("###", msg), new Object[0]);
    }
}

