/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.api.impl;

import java.util.HashMap;
import java.util.Map;
import kd.bos.api.ApiRequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.exception.KDException;
import kd.bos.lang.Lang;
import kd.bos.login.api.APIHandler;
import kd.bos.login.api.APILoginError;
import kd.bos.login.lang.LoginLangUtils;
import kd.bos.login.user.LoginUserService;
import kd.bos.login.utils.LoginUtils;
import kd.bos.session.EncreptSessionUtils;
import kd.bos.session.SessionInfo;

public class APITicketHandler
implements APIHandler {
    @Override
    public boolean doHanleDonotNeedAuthtication(ApiRequestContext ctx) {
        Map mapReq;
        String ticket;
        boolean isHandled = false;
        if (ctx != null && StringUtils.isNotEmpty((CharSequence)(ticket = (String)(mapReq = (Map)ctx.getPostData(HashMap.class)).get("KDTicket")))) {
            HashMap<String, Object> mpERPLogin;
            String sessionId = EncreptSessionUtils.getSessionIDByTicket((String)ticket);
            if (StringUtils.isNotEmpty((CharSequence)sessionId)) {
                SessionInfo sessionInfo = LoginUtils.getSessinInfoBySessionId(sessionId);
                if (sessionInfo == null || StringUtils.isEmpty((CharSequence)sessionInfo.getUserId())) {
                    throw new KDException(APILoginError.API_REQUEST_INVALID_PARAMETERS, new Object[]{ResManager.loadKDString((String)"\u8be5ticket\u5df2\u7ecf\u8fc7\u671f\u3002", (String)"LoginAPI_30", (String)"bos-login", (Object[])new Object[0])});
                }
                Lang lang = LoginLangUtils.getLang((String)mapReq.get("language"));
                Account currentCenter = AccountUtils.getCorrectAccount((String)sessionInfo.getAccountId(), (String)sessionInfo.getTenantId());
                Map<String, String> mpErpUser = LoginUserService.getErpUserInfoByUserId(currentCenter, sessionInfo.getUserId(), lang.name());
                mpERPLogin = new HashMap<String, Object>();
                mpERPLogin.put("success", true);
                mpERPLogin.put("error_code", "0");
                mpERPLogin.put("error_desc", "");
                mpERPLogin.put("accountId", currentCenter.getAccountId());
                mpERPLogin.put("mobile", mpErpUser.get("fphone"));
                mpERPLogin.put("email", mpErpUser.get("femail"));
                mpERPLogin.put("username", mpErpUser.get("fusername"));
                mpERPLogin.put("userid", mpErpUser.get("fid"));
                String needBinding = (String)mapReq.get("needbinding");
                if (StringUtils.isNotEmpty((CharSequence)needBinding) && "true".equalsIgnoreCase(needBinding.trim())) {
                    mpERPLogin.put("bindingflag", EncreptSessionUtils.getBindingFlag((String)sessionId));
                }
            } else {
                throw new KDException(APILoginError.API_REQUEST_INVALID_PARAMETERS, new Object[]{ResManager.loadKDString((String)"\u8be5ticket\u5df2\u7ecf\u8fc7\u671f\u3002", (String)"LoginAPI_30", (String)"bos-login", (Object[])new Object[0])});
            }
            ctx.writeSuccess(mpERPLogin);
            isHandled = true;
        }
        return isHandled;
    }
}

