/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.api.service;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.dc.utils.MCDBUtil;
import kd.bos.dc.utils.SQLUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.api.model.Detail;
import kd.bos.login.api.model.Schema;
import kd.bos.login.utils.ErrorCodeUtils;
import kd.bos.login.utils.LoginUtils;
import kd.bos.login.utils.account.LoginAccountFactory;

public class SchemaService {
    private static final String F_ENTRY_ID = "FEntryId";
    private static final String FFILECONTENT = "ffilecontent";
    private static final String FFILENAME = "ffilename";
    private static final String FFILETYPE = "ffiletype";
    private static final String FFILEFULLPATH = "ffilefullpath";
    private static Log logger = LogFactory.getLog(SchemaService.class);

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<Detail> getAllDetails(String tenantId, String accountId, String schemeId) {
        ArrayList<Detail> returnList = new ArrayList<Detail>();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            Account currentAccount = LoginAccountFactory.createInstanceByCustom(accountId, tenantId).getAccount();
            Properties dataBaseProperties = AccountUtils.getTenantDBInfo((Account)currentAccount);
            if (dataBaseProperties == null) {
                throw new KDException(BosErrorCode.configNotFound, new Object[]{ErrorCodeUtils.getDBGetError()});
            }
            conn = MCDBUtil.getConnection((Account)currentAccount, (Properties)dataBaseProperties);
            String sql = "select t.FID,t.FEntryId,t.FSeq,t.ffilecontent,t.ffilecontent_tag,t.ffiletype,t.ffilename,t.ffilefullpath from  t_meta_ctlschemadetail t,t_meta_ctlschema s where t.fid=s.fid and fschemaid=?";
            stmt = conn.prepareStatement(sql);
            int index = 1;
            stmt.setString(index++, schemeId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                Detail detail = new Detail();
                detail.setEntryId(rs.getString(F_ENTRY_ID));
                detail.setSeq(rs.getInt("FSeq"));
                detail.setFileContent(rs.getString(FFILECONTENT));
                detail.setFileName(rs.getString(FFILENAME));
                detail.setFileType(rs.getString(FFILETYPE));
                detail.setfID(rs.getString("FID"));
                detail.setFileFullPath(rs.getString(FFILEFULLPATH));
                returnList.add(detail);
            }
        }
        catch (SQLException e) {
            try {
                throw new KDException((Throwable)e, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + LoginUtils.SPLIT_SIGN + e.getMessage()});
                catch (Exception e2) {
                    throw new KDException((Throwable)e2, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + LoginUtils.SPLIT_SIGN + e2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return returnList;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Detail getDetailByID(String tenantId, String accountId, String schemeId, String entryId) {
        Detail detail = null;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            Account currentAccount = LoginAccountFactory.createInstanceByCustom(accountId, tenantId).getAccount();
            Properties dataBaseProperties = AccountUtils.getTenantDBInfo((Account)currentAccount);
            if (dataBaseProperties == null) {
                throw new KDException(BosErrorCode.configNotFound, new Object[]{ErrorCodeUtils.getDBGetError()});
            }
            conn = MCDBUtil.getConnection((Account)currentAccount, (Properties)dataBaseProperties);
            String sql = "select t.FID,t.FEntryId,t.FSeq,t.ffilecontent,t.ffilecontent_tag,t.ffiletype,t.ffilename,t.ffilefullpath from  t_meta_ctlschemadetail t,t_meta_ctlschema s where t.fid=s.fid and fschemaid=? and t.FEntryId=?";
            stmt = conn.prepareStatement(sql);
            int index = 1;
            stmt.setString(index++, schemeId);
            stmt.setString(index++, entryId);
            rs = stmt.executeQuery();
            if (rs.next()) {
                detail = new Detail();
                detail.setEntryId(rs.getString(F_ENTRY_ID));
                detail.setSeq(rs.getInt("FSeq"));
                detail.setFileContent(rs.getString(FFILECONTENT));
                detail.setFileName(rs.getString(FFILENAME));
                detail.setFileType(rs.getString(FFILETYPE));
                detail.setfID(rs.getString("FID"));
                detail.setFileFullPath(rs.getString(FFILEFULLPATH));
            }
        }
        catch (SQLException e) {
            try {
                throw new KDException((Throwable)e, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + LoginUtils.SPLIT_SIGN + e.getMessage()});
                catch (Exception e2) {
                    throw new KDException((Throwable)e2, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + LoginUtils.SPLIT_SIGN + e2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return detail;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Detail getDetailByPath(String accountId, String templateId, String fullPath) {
        Detail detail = null;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        InputStream is = null;
        try {
            Account currentAccount = LoginAccountFactory.createInstanceByCustom(accountId).getAccount();
            Properties dataBaseProperties = AccountUtils.getTenantDBInfo((Account)currentAccount);
            if (dataBaseProperties == null) {
                throw new KDException(BosErrorCode.configNotFound, new Object[]{ErrorCodeUtils.getDBGetError()});
            }
            conn = MCDBUtil.getConnection((Account)currentAccount, (Properties)dataBaseProperties);
            String sql = "select t.FID,t.FEntryId,t.FSeq,t.ffilecontent,t.ffilecontent_tag,t.ffiletype,t.ffilename,t.ffilefullpath from  t_meta_ctlschemadetail t,t_meta_ctlschema s where t.fid=s.fid and fschemaid=? and  t.ffilefullpath=? ";
            stmt = conn.prepareStatement(sql);
            int index = 1;
            stmt.setString(index++, templateId);
            stmt.setString(index++, fullPath);
            rs = stmt.executeQuery();
            if (rs.next()) {
                detail = new Detail();
                detail.setEntryId(rs.getString(F_ENTRY_ID));
                detail.setSeq(rs.getInt("FSeq"));
                Blob content = rs.getBlob(FFILECONTENT);
                if (content != null && (is = content.getBinaryStream()) != null) {
                    byte[] binaryArray = new byte[is.available()];
                    is.read(binaryArray);
                    detail.setFileBinary(binaryArray);
                }
                detail.setFileName(rs.getString(FFILENAME));
                detail.setFileType(rs.getString(FFILETYPE));
                detail.setfID(rs.getString("FID"));
                detail.setFileFullPath(rs.getString(FFILEFULLPATH));
            }
        }
        catch (SQLException e) {
            try {
                throw new KDException((Throwable)e, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + LoginUtils.SPLIT_SIGN + e.getMessage()});
                catch (Exception e2) {
                    throw new KDException((Throwable)e2, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + LoginUtils.SPLIT_SIGN + e2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, conn);
                if (is == null) throw throwable;
                try {
                    is.close();
                    throw throwable;
                }
                catch (IOException e3) {
                    logger.error("cleanup error", (Throwable)e3);
                }
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        if (is == null) return detail;
        try {
            is.close();
            return detail;
        }
        catch (IOException e) {
            logger.error("cleanup error", (Throwable)e);
            return detail;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Schema getPKIByPath(String accountId, String templateId) {
        Schema schema = null;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            Account currentAccount = LoginAccountFactory.createInstanceByCustom(accountId).getAccount();
            Properties dataBaseProperties = AccountUtils.getTenantDBInfo((Account)currentAccount);
            if (dataBaseProperties == null) {
                throw new KDException(BosErrorCode.configNotFound, new Object[]{ErrorCodeUtils.getDBGetError()});
            }
            conn = MCDBUtil.getConnection((Account)currentAccount, (Properties)dataBaseProperties);
            String sql = "select fid,fschemaid,fversion,fpreviewimg from t_meta_ctlschema where fschemaid=?";
            stmt = conn.prepareStatement(sql);
            int index = 1;
            stmt.setString(index++, templateId);
            rs = stmt.executeQuery();
            if (rs.next()) {
                schema = new Schema();
                schema.setSchemaId(rs.getString("fschemaid"));
                schema.setVersion(rs.getString("fversion"));
                schema.setfID(rs.getString("FID"));
                schema.setPictureField(rs.getString("fpreviewimg"));
            }
        }
        catch (SQLException e) {
            try {
                throw new KDException((Throwable)e, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + LoginUtils.SPLIT_SIGN + e.getMessage()});
                catch (Exception e2) {
                    throw new KDException((Throwable)e2, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + LoginUtils.SPLIT_SIGN + e2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return schema;
    }
}

