/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.filter;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.actiondispatcher.ActionUtil;
import kd.bos.api.ApiRequestContext;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.context.api.ApiContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.mc.tenant.AccountType;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.exception.LoginErrorCode;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.CacheLoginData;
import kd.bos.login.LoginClientEnum;
import kd.bos.login.LoginType;
import kd.bos.login.actions.ApiInterfaceAction;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.login.cache.LoginCacheService;
import kd.bos.login.filter.HandleResult;
import kd.bos.login.filter.LoginManage;
import kd.bos.login.filter.MediaHandler;
import kd.bos.login.handler.LoginAccountHandler;
import kd.bos.login.handler.NewLoginFilter;
import kd.bos.login.http.KDFlyHttpServletRequestWrapper;
import kd.bos.login.http.KDHttpServletRequestWrapper;
import kd.bos.login.lang.LoginLangUtils;
import kd.bos.login.route.ShareRouteService;
import kd.bos.login.service.DispatchServiceHelper;
import kd.bos.login.service.apps.ThirdAppsService;
import kd.bos.login.service.apps.impl.ThirdAppsServiceImpl;
import kd.bos.login.service.impl.FormRouteServiceImpl;
import kd.bos.login.service.openapi.TokenErrorCode;
import kd.bos.login.spi.OpenApiServiceManager;
import kd.bos.login.sso.SSOAuth;
import kd.bos.login.sso.SSOAuthResult;
import kd.bos.login.sso.SSOErrorCode;
import kd.bos.login.thirdapps.AppsService;
import kd.bos.login.thirdauth.AllSSOHandler;
import kd.bos.login.thirdauth.ThirdSSOAuthHandler;
import kd.bos.login.user.DefaultParameterService;
import kd.bos.login.user.LoginUserService;
import kd.bos.login.utils.AgentUtil;
import kd.bos.login.utils.BeanUtils;
import kd.bos.login.utils.Constants;
import kd.bos.login.utils.HtmlUtils;
import kd.bos.login.utils.HttpUtils;
import kd.bos.login.utils.LoginUtils;
import kd.bos.login.utils.OnlineUserUtil;
import kd.bos.login.utils.SecurityUtils;
import kd.bos.login.utils.SessionUtils;
import kd.bos.login.utils.SystemPropertyUtils;
import kd.bos.login.utils.ThirdAPIAPPUtils;
import kd.bos.login.utils.URLUtils;
import kd.bos.login.utils.account.LoginAccountFactory;
import kd.bos.login.yunzhijia.lightapp.LingappVerifier;
import kd.bos.param.service.IParameterReaderService;
import kd.bos.service.ServiceSvcFactory;
import kd.bos.service.authorize.http.KDSignHttpServletRequestWrapper;
import kd.bos.service.authorize.model.ApiCommonResult;
import kd.bos.service.authorize.model.AuthResult;
import kd.bos.session.EncreptSessionUtils;
import kd.bos.session.GuestUtiils;
import kd.bos.session.SessionDAO;
import kd.bos.session.SessionDAOFactory;
import kd.bos.session.SessionInfo;
import kd.bos.session.SessionManager;
import kd.bos.url.UrlService;
import kd.bos.util.JSONUtils;
import kd.bos.util.NetAddressUtils;
import kd.bos.util.RevProxyUtil;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class LoginFilter
implements Filter {
    private static final String REDIRECT = "redirect";
    private static final String HCODE_TICKET = "ticket";
    private static final String QING_LAPP_ENTRANCE_DO = "/qing/lappEntrance.do";
    private static final String BOS_LOGIN = "bos-login";
    private static final String SUCCESS = "success";
    private static final String ERROR_CODE = "error_code";
    private static final String ERROR_DESC = "error_desc";
    private static final String APP_SYS = "sys";
    private static final String WSDL_WHITE_LIST = "bos.svc.login.wsdl.white";
    private static final String WSDL_WHITE_PATTERN = "bos.svc.login.wsdl.pattern";
    private static final String KEY_REQUEST_REDIRECT = "redirect";
    private static final String AI_LOGIN_TYPE_FACE = "face";
    private static final String AI_LOGIN_TYPE_ACCOPUNT = "account";
    private static final String AI_LOGIN_TYPE_VOICE = "voice";
    private static final String XML_HTTP_REQUEST = "XMLHttpRequest";
    private static final String AJAX_HEADER = "ajax";
    public static final String GLOBAL_COOKIE_ACCESS_TOKEN_KEY = "access_token";
    private static final String ACCOUNT_ID = "accountId";
    private static final String KD_AUTH_CODE_MAP = "kd_auth_code_map";
    private static final String KD_AUTH_CODE = "kd_auth_code";
    private static Log logger = LogFactory.getLog(LoginFilter.class);
    private LoginType initloginType = LoginType.YUNZHIJIA;
    private final ThirdAppsService thirdAppsService = new ThirdAppsServiceImpl();
    private final LoginCacheService cacheService = new LoginCacheService();
    private LoginManage loginManage = new LoginManage();

    public void init(FilterConfig paramFilterConfig) throws ServletException {
        String loginType = System.getProperty("login.type");
        if (loginType != null && "STANDALONE".equalsIgnoreCase(loginType)) {
            this.initloginType = LoginType.STANDALONE;
        }
    }

    public void doFilter(ServletRequest servletRequestOld, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        try {
            String token;
            boolean needGuest;
            String tempSessionId;
            boolean isAvailable;
            String thirdSessionId;
            String shareIdCache;
            LoginAccountHandler loginAccountHandler;
            HttpServletRequest handleRequest;
            String globalSessionId;
            boolean bAPI;
            boolean bAjax;
            boolean isWebService;
            boolean needWsdl;
            LoginType loginType;
            String sYzjSharePathKey;
            String appId;
            String ticket;
            boolean isDownloadPlugin;
            String path;
            HttpServletResponse response;
            ServletRequest servletRequest;
            HttpServletRequest request;
            block119: {
                OperationContext oc = new OperationContext();
                oc.setAppId(APP_SYS);
                OperationContext.set((OperationContext)oc);
                request = (HttpServletRequest)servletRequestOld;
                ServletRequest requestWrapper = null;
                servletRequest = servletRequestOld;
                if ("post".equalsIgnoreCase(request.getMethod()) && !LoginUtils.isMultipart(request)) {
                    try {
                        request.getParameter(ACCOUNT_ID);
                    }
                    catch (Exception e) {
                        logger.error((Throwable)e);
                    }
                    requestWrapper = this.getRequestWrapper(request);
                }
                if (requestWrapper != null) {
                    servletRequestOld = servletRequest = requestWrapper;
                    request = (HttpServletRequest)servletRequestOld;
                }
                response = (HttpServletResponse)servletResponse;
                request.setAttribute("LoginType", (Object)this.initloginType);
                request.setCharacterEncoding("UTF-8");
                String newLoginFilterDo = SystemPropertyUtils.getProptyByTenant("old_login_filter_do", RevProxyUtil.getTenantId((HttpServletRequest)request));
                if (kd.bos.login.utils.StringUtils.isNotEmpty(newLoginFilterDo)) {
                    new NewLoginFilter().doFilter(servletRequestOld, servletResponse, filterChain);
                    return;
                }
                path = request.getRequestURI();
                isDownloadPlugin = LoginUtils.isDownloadPlugin(request, path);
                if (!isDownloadPlugin && (path.endsWith(".js") || path.endsWith(".css") || LoginUtils.isRootPathPage(request, new String[]{"zhuanqu.html"}) || path.endsWith(".jsx"))) {
                    filterChain.doFilter(servletRequest, servletResponse);
                    return;
                }
                boolean isMC = LoginUtils.isHandledByMCFilter(request, response, filterChain);
                if (isMC) {
                    return;
                }
                if (!path.endsWith("/kws/")) {
                    ApiRequestContext.initThreadLocal((HttpServletRequest)request, (HttpServletResponse)response);
                }
                LoginUtils.handleGenernal(request, response);
                ticket = request.getParameter(HCODE_TICKET);
                appId = this.getAPPId(request);
                sYzjSharePathKey = request.getParameter("ierpanchor");
                loginType = this.initloginType;
                if ((path.toLowerCase(Locale.ENGLISH).contains("/mobile.html") || path.contains(QING_LAPP_ENTRANCE_DO) || kd.bos.login.utils.StringUtils.isNotEmpty(appId)) && !kd.bos.login.utils.StringUtils.isEmpty(ticket)) {
                    loginType = LoginType.MOBILE;
                }
                if (path.contains("/auth/logout.do")) {
                    this.doLogout(request, response);
                    return;
                }
                needWsdl = LoginUtils.isNeedWsdl(path, request);
                isWebService = request.getServletPath().contains("/kws");
                if (path.contains("/auth/") || path.contains("/api/login.do") || path.contains("/api/getAppToken.do") || path.contains("/api/logout.do") || path.contains("/api/upgradeLogin.do") || path.contains("/api/tripsi/") || path.contains("login-mc.html") || path.contains("/kws/loginService") && !needWsdl || path.contains("/api/login/getUserLanguage.do") || path.contains("/privacyPolicy/document.html") || path.contains("/nocode/getAccessToken.do")) {
                    filterChain.doFilter(servletRequest, servletResponse);
                    return;
                }
                if (LoginUtils.isRootLoginPage(request)) {
                    if (path.contains("login.html")) {
                        LoginUtils.outputString(response, LoginUtils.getLoginPage(request));
                        return;
                    }
                    if (path.contains("login-mobile.html")) {
                        LoginUtils.outputString(response, LoginUtils.getLoginMobilePage(request));
                        return;
                    }
                }
                if (path.endsWith("nocode/shareExpired.html")) {
                    LoginUtils.outputString(response, HtmlUtils.getShareExpiredPage(request));
                    return;
                }
                bAjax = this.isAjax(request);
                bAPI = LoginUtils.isAPI(request);
                String contextPath = servletRequestOld.getServletContext().getContextPath();
                String realUrl = request.getRequestURI().substring(contextPath.length());
                if (realUrl.startsWith("/kapi/oauth2/")) {
                    filterChain.doFilter(servletRequestOld, servletResponse);
                    return;
                }
                if (this.tryRedirectNewAccessToken(filterChain, request, response, realUrl)) {
                    return;
                }
                globalSessionId = null;
                if (request.getRequestURI().contains("/share/")) {
                    try {
                        ShareRouteService routeService = new ShareRouteService();
                        globalSessionId = routeService.route(request, response);
                    }
                    catch (Exception ex) {
                        if (!(ex instanceof RuntimeException)) break block119;
                        response.sendRedirect(UrlService.getDomainContextUrl() + "/nocode/shareExpired.html");
                        return;
                    }
                }
            }
            if ((handleRequest = (loginAccountHandler = new LoginAccountHandler()).handle(request, response)) != request) {
                if (response.getStatus() == 40401) {
                    return;
                }
                request = handleRequest;
                servletRequest = handleRequest;
            }
            SessionDAO sessionDAO = null;
            if (globalSessionId == null && LoginUtils.isAllowAcessToken(RevProxyUtil.getTenantCode((HttpServletRequest)request))) {
                String newUserid;
                String accessTokenId = LoginUtils.getParameterAccessToken(request);
                globalSessionId = LoginUtils.getKDCookieValue(request);
                String oldUserId = LoginUtils.getUserIdFromSession(globalSessionId, true);
                if (kd.bos.login.utils.StringUtils.isNotEmpty(accessTokenId) && kd.bos.login.utils.StringUtils.isNotEmpty(newUserid = LoginUtils.getUserIdFromSession(accessTokenId, true)) && !newUserid.equals(oldUserId)) {
                    globalSessionId = accessTokenId;
                    bAPI = true;
                }
            }
            if (bAPI) {
                String sHeaderAccess_Token = this.getHeaderAccessToken(request);
                if (sHeaderAccess_Token != null) {
                    globalSessionId = sHeaderAccess_Token;
                }
                if (request.getParameter("redirect") != null) {
                    SessionManager.copySession((HttpServletRequest)request, (HttpServletResponse)response, (String)globalSessionId);
                }
            }
            if (globalSessionId == null) {
                globalSessionId = LoginUtils.getKDCookieValue(request);
            }
            if (!SessionUtils.verifyCookieSession(request, globalSessionId)) {
                globalSessionId = null;
            }
            if (globalSessionId != null && !request.getRequestURI().contains("/share/") && (shareIdCache = CacheLoginData.getAttribute((String)"nocode_share", (String)globalSessionId)) != null && this.checkNoCodeShare(request)) {
                globalSessionId = null;
            }
            Map sessionInfo = null;
            boolean needThirdAuthtication = this.thirdAppsService.isNeedThirdAppHandle(request);
            Map<String, String> userInfo = new HashMap<String, String>(4);
            if (globalSessionId != null && needThirdAuthtication) {
                String oldUserId;
                String accountIdParameter = request.getParameter(ACCOUNT_ID);
                if (kd.bos.login.utils.StringUtils.isNotEmpty(accountIdParameter) && !accountIdParameter.equals((sessionInfo = (sessionDAO = SessionDAOFactory.getSessionDAO((String)globalSessionId)).getAttributesAsMap(new String[]{"tenantId", "sandboxId", "language", "userId", "userName", "userOpenId", "orgId", "userType", "yzjAppId", "yzjAppTicket", ACCOUNT_ID, "uid", "loginOrg", "client"})).get(ACCOUNT_ID))) {
                    globalSessionId = null;
                    sessionDAO = null;
                }
                if (globalSessionId != null && kd.bos.login.utils.StringUtils.isNotEmpty(oldUserId = LoginUtils.getUserIdFromSession(sessionDAO, globalSessionId)) && (userInfo = this.thirdAppsService.getThirdAppUserInfo(request)) != null && oldUserId.equals(userInfo.get("fid"))) {
                    needThirdAuthtication = false;
                }
            }
            if (needThirdAuthtication && kd.bos.login.utils.StringUtils.isNotEmpty(thirdSessionId = this.thirdAppsService.getThirdSessionId(request, response, userInfo))) {
                globalSessionId = thirdSessionId;
                logger.info("@@\u7b2c\u4e09\u65b9\u8f7b\u5e94\u7528\u7684\u767b\u5f55\u6210\u529f\u3002");
            }
            if (globalSessionId != null && !(isAvailable = ThirdAPIAPPUtils.touchAppToken(sessionDAO, sessionInfo, globalSessionId))) {
                globalSessionId = null;
            }
            if (globalSessionId == null && "-1".equalsIgnoreCase(globalSessionId = EncreptSessionUtils.decryptSessionId((HttpServletRequest)request))) {
                globalSessionId = null;
                String sMsg = ResManager.loadKDString((String)"\u65e0\u6548\u7684\u6587\u4ef6\u8bbf\u95ee\u3002", (String)"LoginFilter_0", (String)BOS_LOGIN, (Object[])new Object[0]);
                HttpUtils.webAlert(response, sMsg);
                return;
            }
            if (globalSessionId == null && kd.bos.login.utils.StringUtils.isNotBlank(request.getParameter(KD_AUTH_CODE)) && (tempSessionId = this.getSessionIdFromCode(request, response)) != null && kd.bos.login.utils.StringUtils.isNotBlank(tempSessionId)) {
                globalSessionId = tempSessionId;
            }
            if (globalSessionId == null && LoginUtils.isSupportedKDEMessage()) {
                globalSessionId = EncreptSessionUtils.decryptMessageLoginSessionId((HttpServletRequest)request);
                if ("-1".equalsIgnoreCase(globalSessionId)) {
                    globalSessionId = null;
                    String sMsg = ResManager.loadKDString((String)"\u65e0\u6548\u7684\u77ed\u4fe1\u8bbf\u95ee\u3002", (String)"LoginFilter_1", (String)BOS_LOGIN, (Object[])new Object[0]);
                    HttpUtils.webAlert(response, sMsg);
                    return;
                }
                if (!kd.bos.util.StringUtils.isEmpty((String)globalSessionId)) {
                    SessionManager.copySession((HttpServletRequest)request, (HttpServletResponse)response, (String)globalSessionId);
                }
            }
            if (globalSessionId == null && kd.bos.util.StringUtils.isNotEmpty((String)(globalSessionId = EncreptSessionUtils.decryptTokenSessionId((HttpServletRequest)request)))) {
                SessionManager.copySession((HttpServletRequest)request, (HttpServletResponse)response, (String)globalSessionId);
            }
            boolean isGuestPerm = false;
            if (globalSessionId == null && needWsdl) {
                isGuestPerm = true;
            }
            boolean isGuestUser = LoginUtils.isGuestUser(sessionDAO, globalSessionId);
            if (globalSessionId == null && !isGuestPerm) {
                isGuestPerm = LoginUtils.isAPIByGuestUser(servletRequest, response, sessionDAO, globalSessionId);
            } else if (bAPI) {
                boolean isGuestApi = LoginUtils.isAPIByGuestUser(servletRequest, response, sessionDAO, globalSessionId);
                if (isGuestUser && !isGuestApi) {
                    globalSessionId = null;
                }
            }
            AllSSOHandler.handleLogoutLogic(request);
            boolean isDo = request.getRequestURI().contains(".do");
            if (!(globalSessionId != null || isGuestPerm || bAPI || isDo)) {
                globalSessionId = LoginUtils.loginByGuestUser(request, response);
                isGuestPerm = LoginUtils.isLoginByGuestUser(request, response);
            }
            if (!isGuestPerm) {
                globalSessionId = this.tryCreateSessionForSSO(request, response, globalSessionId);
            }
            if (this.wpsFilterHandler(request)) {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
            if (MediaHandler.executeHandler(request, response, filterChain, globalSessionId)) {
                return;
            }
            if (bAPI && globalSessionId == null && !isGuestPerm) {
                String sLoginJson = this.getUnauthorizedData(request);
                ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)sLoginJson);
                return;
            }
            boolean bl = needGuest = isGuestUser || isGuestPerm;
            if (this.judgeGuestFormPermission(request, response, needGuest, sessionDAO, globalSessionId)) {
                return;
            }
            if (isWebService && !needGuest) {
                if (LoginUtils.getIgnoreWS()) {
                    if (globalSessionId == null) {
                        isGuestPerm = true;
                    }
                } else {
                    boolean isAvailable2;
                    String queryString = request.getQueryString();
                    if (!needWsdl && !(isAvailable2 = ThirdAPIAPPUtils.touchAppToken(sessionDAO, sessionInfo, globalSessionId = LoginUtils.getWebServiceAccessToken(request)))) {
                        globalSessionId = null;
                    }
                }
            }
            String tenantId = null;
            String sandboxId = null;
            long orgId = 0L;
            boolean isAllowAccess = true;
            if (globalSessionId != null && !isGuestPerm) {
                if (!kd.bos.login.utils.StringUtils.isEmpty(sYzjSharePathKey)) {
                    String redirectMe = URLUtils.buildRedirectUrl((ServletRequest)request);
                    String encodedUrl = response.encodeRedirectURL(response.encodeRedirectURL(redirectMe));
                    response.sendRedirect(encodedUrl);
                    return;
                }
                if (AI_LOGIN_TYPE_FACE.equalsIgnoreCase(request.getParameter("aiLoginType"))) {
                    String formId = SecurityUtils.htmlEncode(request.getParameter("formId"));
                    response.sendRedirect(String.format("index.html#/dform?formId=%s", formId));
                    return;
                }
                sessionDAO = SessionDAOFactory.getSessionDAO((String)globalSessionId);
                sessionInfo = sessionDAO.getAttributesAsMap(new String[]{"tenantId", "sandboxId", "language", "userId", "userName", "userOpenId", "orgId", "userType", "yzjAppId", "yzjAppTicket", "kdCsrfToken", ACCOUNT_ID, "uid", "loginIP", "loginOrg", "client", "accCompanyId", "api3rdAppId", "bizPartnerId"});
                isAllowAccess = this.isAllowAccess(sessionInfo, path, request);
                if (sessionInfo != null && sessionInfo.size() > 0 && isAllowAccess) {
                    tenantId = (String)sessionInfo.get("tenantId");
                    sandboxId = (String)sessionInfo.get("sandboxId");
                    String userId = (String)sessionInfo.get("userId");
                    if (!kd.bos.login.utils.StringUtils.isEmpty((String)sessionInfo.get("orgId"))) {
                        orgId = Long.parseLong((String)sessionInfo.get("orgId"));
                    }
                    if (tenantId != null && userId != null) {
                        String appNumber;
                        String lang = (String)sessionInfo.get("language");
                        String userName = (String)sessionInfo.get("userName");
                        String userOpenId = (String)sessionInfo.get("userOpenId");
                        String userType = (String)sessionInfo.get("userType");
                        String yzjAppId = (String)sessionInfo.get("yzjAppId");
                        String yzjAppTicket = (String)sessionInfo.get("yzjAppTicket");
                        String uId = (String)sessionInfo.get("uid");
                        String loginOrg = (String)sessionInfo.get("loginOrg");
                        String client = (String)sessionInfo.get("client");
                        String api3rdAppId = (String)sessionInfo.get("api3rdAppId");
                        String accCompany = (String)sessionInfo.get("accCompanyId");
                        String accountId = "";
                        if (sessionInfo.get(ACCOUNT_ID) != null) {
                            accountId = (String)sessionInfo.get(ACCOUNT_ID);
                        }
                        if (LoginType.MOBILE == loginType) {
                            if (appId != null && !appId.equals(yzjAppId)) {
                                SessionManager.editSessionValue((String)globalSessionId, (String)"yzjAppId", (String)appId);
                                yzjAppId = appId;
                            }
                            if (ticket != null && !ticket.equals(yzjAppTicket)) {
                                SessionManager.editSessionValue((String)globalSessionId, (String)"yzjAppTicket", (String)ticket);
                                yzjAppTicket = ticket;
                            }
                        }
                        if (this.isNeedCheck(isWebService, bAPI, needGuest, userId) && !LoginUtils.chekCSRF(request, (String)sessionInfo.get("kdCsrfToken"))) {
                            SecurityUtils.checkCsrf(request, response, ResManager.loadKDString((String)"\u7cfb\u7edf\u68c0\u6d4b\u5230CSRF\u653b\u51fb\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55\u7cfb\u7edf\u3002", (String)"LoginFilter_31", (String)BOS_LOGIN, (Object[])new Object[0]));
                            return;
                        }
                        if (this.isNeedCheck(isWebService, bAPI, needGuest, userId) && !isWebService && !LoginUtils.chekIP(request, (String)sessionInfo.get("loginIP"))) {
                            SecurityUtils.checkCsrf(request, response, ResManager.loadKDString((String)"\u7cfb\u7edf\u68c0\u6d4b\u5230\u60a8\u7684IP\u5730\u5740\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55\u7cfb\u7edf\u3002", (String)"LoginFilter_30", (String)BOS_LOGIN, (Object[])new Object[0]));
                            return;
                        }
                        SessionInfo si = new SessionInfo();
                        si.setTenantId(tenantId);
                        si.setSandboxId(sandboxId);
                        si.setOrgId(String.valueOf(orgId));
                        si.setUserId(userId);
                        si.setUserName(userName);
                        si.setUserOpenId(userOpenId);
                        si.setUserType(userType);
                        si.setYzjAppId(yzjAppId);
                        si.setYzjAppTicket(yzjAppTicket);
                        si.setLanguage(lang);
                        si.setUid(uId);
                        si.setAccCompany(accCompany);
                        si.setAccountId(accountId);
                        si.setClient(client);
                        if (LoginClientEnum.API.getDesc().equalsIgnoreCase(client)) {
                            si.setApi3rdAppId(api3rdAppId);
                        }
                        if (loginOrg != null) {
                            si.setLoginOrg(loginOrg);
                        }
                        if (kd.bos.util.StringUtils.isNotEmpty((String)((String)sessionInfo.get("bizPartnerId")))) {
                            si.setBizPartnerId((String)sessionInfo.get("bizPartnerId"));
                        }
                        if (LoginUtils.isNeedAddOperation(request)) {
                            si.setOperationType("MA");
                        }
                        if (kd.bos.login.utils.StringUtils.isNotEmpty(appNumber = request.getParameter("appNumber")) && "true".equalsIgnoreCase(kd.bos.session.SystemPropertyUtils.getProptyByTenant((String)"login_app_number_enable", (String)tenantId)) && LingappVerifier.verifyAll(request, response, yzjAppId, yzjAppTicket, accountId, sandboxId, userOpenId)) {
                            return;
                        }
                        RequestContextCreator.create((HttpServletRequest)request, (String)globalSessionId, (SessionInfo)si);
                        FormRouteServiceImpl formRouteService = new FormRouteServiceImpl();
                        if (formRouteService.isJumpRoute(request, response, globalSessionId)) {
                            return;
                        }
                        if (isDownloadPlugin) {
                            ApiInterfaceAction.getDetailByPath(request, response);
                        } else {
                            boolean isHideTicket = this.hideTicket(request, response, accountId);
                            if (isHideTicket) {
                                return;
                            }
                            if (LoginUtils.isPortal(request)) {
                                LoginUtils.outputPortalString(request, response);
                            }
                            if (LoginUtils.isIndexHTML(request)) {
                                LoginUtils.outputString(response, LoginUtils.getIndexHtml(request));
                            } else if (path.contains("/nocode.html") || path.contains("/nocodedebug.html")) {
                                LoginUtils.outputString(response, LoginUtils.getNoceIndexHtml(request));
                            } else if (!LoginUtils.isHandledUrlMap(request, response)) {
                                filterChain.doFilter(servletRequest, servletResponse);
                            }
                        }
                        return;
                    }
                    if (bAjax) {
                        this.outputAjaxSessionError(servletResponse);
                        return;
                    }
                    if (bAPI) {
                        this.outputAPISessionErroror(servletResponse);
                        return;
                    }
                    if (isWebService) {
                        this.loginManage.outputWebServiceSessionErroror(servletResponse);
                        return;
                    }
                }
            }
            if (isGuestPerm) {
                SessionInfo si = this.getGuestSessionData(request, sandboxId);
                if (!LoginUtils.isGuestSessionId(globalSessionId)) {
                    globalSessionId = LoginUtils.getGuestGloalSessionId(request, response, bAPI);
                }
                RequestContextCreator.create((HttpServletRequest)request, (String)globalSessionId, (SessionInfo)si);
                if (LoginUtils.isIndexHTML(request)) {
                    LoginUtils.outputString(response, LoginUtils.getIndexHtml(request));
                } else if (!LoginUtils.isHandledUrlMap(request, response)) {
                    filterChain.doFilter(servletRequest, servletResponse);
                }
                return;
            }
            if (path.contains("/asimov/")) {
                try {
                    this.loginManage.doYunzhijiaPubacc(request, response);
                }
                catch (Exception e) {
                    throw new ServletException(e.getMessage());
                }
                return;
            }
            if (LoginType.STANDALONE == loginType) {
                this.loginManage.redirectToStandaloneLogin(request, response);
                return;
            }
            if (LoginType.MOBILE == loginType) {
                if (!LoginManage.enableYzjApps(tenantId)) {
                    this.loginManage.loginByLightAppId(request, response, appId, ticket);
                    return;
                }
            }
            if (kd.bos.login.utils.StringUtils.isNotEmpty(token = request.getParameter("token")) && kd.bos.login.utils.StringUtils.isNotEmpty(ticket)) {
                HashMap<String, String> mpQR = new HashMap<String, String>();
                mpQR.put(HCODE_TICKET, ticket);
                mpQR.put("URL", String.format("%sindex.html", RevProxyUtil.getURLContextPath((HttpServletRequest)request)));
                String cacheType = CacheLoginData.getType4YzjQR((String)token);
                CacheLoginData.setAttributes((String)cacheType, mpQR);
                return;
            }
            if (isAllowAccess && bAjax) {
                this.loginManage.outputAjaxTimeoutError(servletResponse);
                return;
            }
            if (isAllowAccess && bAPI) {
                this.loginManage.outputAPITimeoutErroror(servletResponse);
                return;
            }
            if (isAllowAccess && isWebService) {
                this.loginManage.outputWebServiceSessionErroror(servletResponse);
                return;
            }
            if (!kd.bos.login.utils.StringUtils.isEmpty(appId) && !kd.bos.login.utils.StringUtils.isEmpty(ticket)) {
                if (!LoginManage.enableYzjApps(tenantId)) {
                    this.loginManage.loginByLightAppId(request, response, appId, ticket);
                    return;
                }
            }
            if (Pattern.matches(".*/login.*.html", path.toLowerCase(Locale.ENGLISH))) {
                filterChain.doFilter(servletRequest, servletResponse);
            } else if (path.contains("yzjChatCallbackAction.do")) {
                filterChain.doFilter(servletRequest, servletResponse);
            } else if (needThirdAuthtication) {
                this.thirdAppsService.toSendLogin(request, response);
            } else {
                this.loginManage.showLoginPage(request, response);
            }
            return;
        }
        catch (KDException ex) {
            ErrorCode code = ex.getErrorCode();
            if (Constants.KD_WEB_EXCEPTION.equals((Object)code)) {
                String resp = LoginUtils.getErrorPageString(ex.getMessage());
                ActionUtil.writeResponseResult((ServletResponse)servletResponse, (CharSequence)resp);
            } else {
                String resp = LoginUtils.getLoginResponse(String.valueOf(code.getCode()), ex.getMessage());
                ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)resp);
            }
        }
        catch (Throwable e) {
            logger.error(e);
            KDException kd = new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002%s", (String)"LoginFilter_3", (String)BOS_LOGIN, (Object[])new Object[]{e.getMessage()})});
            String resp = LoginUtils.getLoginResponse(String.valueOf(kd.getErrorCode().getCode()), kd.getMessage());
            try {
                ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)resp);
            }
            catch (Exception ex) {
                try {
                    throw e;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    private boolean wpsFilterHandler(HttpServletRequest request) {
        if (request.getRequestURI().contains("/attachment/v1/3rd/file/onlyoffice") || request.getRequestURI().contains("/attachment/v3/3rd/")) {
            String accountIdByWps;
            logger.info("getAccountId=>" + RequestContext.get().getAccountId());
            if (request.getRequestURI().contains("/attachment/v3/3rd/") && StringUtils.isNotBlank((CharSequence)(accountIdByWps = LoginFilter.getIdentifyParam(request))) && !RequestContext.get().getAccountId().equals(accountIdByWps)) {
                logger.info("accountIdByWps=>" + accountIdByWps);
                Account account = LoginAccountFactory.createInstanceByCustom(accountIdByWps, request).getAccount();
                LoginUtils.createGuestRequestContext(request, account);
            }
            logger.info("getAccountId after=>" + RequestContext.get().getAccountId());
            Map params = ((IParameterReaderService)ServiceSvcFactory.getService(IParameterReaderService.class)).loadPublicParameterFromCache("bos_fileserverconfig");
            String wpsv3serveraddress = (String)params.get("wpsv3serveraddress");
            String onlyofficedeployaddress = (String)params.get("onlyofficedeployaddress");
            String remoteHost = NetAddressUtils.getRemoteHost((HttpServletRequest)request);
            String[] ips = remoteHost.split(",");
            List<String> ipList = Arrays.asList(ips);
            if (this.isForWpsV3(wpsv3serveraddress, ipList)) {
                return true;
            }
            if (this.isForOnlyoffice(onlyofficedeployaddress, ipList)) {
                return true;
            }
        }
        return false;
    }

    private static String getIdentifyParam(HttpServletRequest request) {
        String identifyParam = request.getHeader("X-User-Query");
        logger.info("wps v3 get custom param is:" + identifyParam);
        String accountId = "";
        if (kd.bos.login.utils.StringUtils.isNotEmpty(identifyParam)) {
            String[] params;
            for (String param : params = identifyParam.split("&")) {
                String[] kv = param.split("=");
                if (kv.length != 2 || !kv[0].equals(ACCOUNT_ID)) continue;
                accountId = kv[1];
            }
        }
        return accountId;
    }

    private boolean isForOnlyoffice(String onlyofficedeployaddress, List<String> ips) {
        return this.ipHandleFilter(onlyofficedeployaddress, ips);
    }

    private boolean isForWpsV3(String wpsv3serveraddress, List<String> ips) {
        return this.ipHandleFilter(wpsv3serveraddress, ips);
    }

    private boolean ipHandleFilter(String address, List<String> ips) {
        if (StringUtils.isBlank((CharSequence)address)) {
            return false;
        }
        for (String ip : address.split(",")) {
            if (!ips.contains(ip)) continue;
            return true;
        }
        return false;
    }

    private ServletRequest getRequestWrapper(HttpServletRequest request) throws IOException {
        return "original".equalsIgnoreCase(request.getHeader("kd-transfer-encoding")) ? new KDFlyHttpServletRequestWrapper(request) : new KDHttpServletRequestWrapper(request);
    }

    protected boolean tryRedirectNewAccessToken(FilterChain filterChain, HttpServletRequest request, HttpServletResponse response, String realUrl) throws IOException, ServletException {
        if (!realUrl.startsWith("/kapi/")) {
            return false;
        }
        KDSignHttpServletRequestWrapper requestWrapperNew = new KDSignHttpServletRequestWrapper(request);
        ApiCommonResult apiAuthResult = OpenApiServiceManager.getApiAuthorizeService().auth((HttpServletRequest)requestWrapperNew, response, filterChain);
        if (!apiAuthResult.getStatus().booleanValue() && TokenErrorCode.OLD_VALIDWAY.getCode().equalsIgnoreCase(apiAuthResult.getErrorCode())) {
            return false;
        }
        if (!apiAuthResult.getStatus().booleanValue()) {
            return true;
        }
        HandleResult result = new HandleResult();
        result.setAccountId(((AuthResult)apiAuthResult.getData()).getAccountId());
        Account currentCenter = LoginAccountFactory.createInstanceByCustom(((AuthResult)apiAuthResult.getData()).getAccountId()).getAccount();
        Long agentUserId = ((AuthResult)apiAuthResult.getData()).getAgentUserId();
        Map<String, String> userInfo = ((AuthResult)apiAuthResult.getData()).getUserInfo();
        if (agentUserId == null && MapUtils.isEmpty((Map)userInfo)) {
            throw new KDException(new ErrorCode(TokenErrorCode.API_REQUEST_INVALID_PARAMETERS.getCode(), ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0c\u7528\u6237\u4e0d\u5b58\u5728\u3002", (String)"LoginAPI_8", (String)BOS_LOGIN, (Object[])new Object[0])), new Object[0]);
        }
        if (agentUserId != null) {
            Lang lang = LoginLangUtils.getLoginLanguage(request);
            userInfo = LoginUserService.getErpUserInfoByUserId(currentCenter, agentUserId.toString(), lang.name());
        }
        if (MapUtils.isEmpty((Map)userInfo)) {
            throw new KDException(new ErrorCode(TokenErrorCode.API_REQUEST_INVALID_PARAMETERS.getCode(), ResManager.loadKDString((String)"\u60a8\u7684\u8d26\u53f7\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"LoginFilter_10", (String)BOS_LOGIN, (Object[])new Object[0])), new Object[0]);
        }
        result.setUserInfo(userInfo);
        String globalSessionId = ((AuthResult)apiAuthResult.getData()).getAccessToken();
        this.createRequestForLoadSession(request, (ApiCommonResult<AuthResult>)apiAuthResult, result, currentCenter, userInfo, globalSessionId);
        filterChain.doFilter((ServletRequest)requestWrapperNew, (ServletResponse)response);
        return true;
    }

    private void createRequestForLoadSession(HttpServletRequest request, ApiCommonResult<AuthResult> apiAuthResult, HandleResult result, Account currentCenter, Map<String, String> userInfo, String globalSessionId) {
        if (kd.bos.login.utils.StringUtils.isNotEmpty(globalSessionId)) {
            SessionInfo sessionInfo = SessionUtils.getSessinInfoBySessionId(globalSessionId);
            RequestContextCreator.create((HttpServletRequest)request, (String)globalSessionId, (SessionInfo)sessionInfo, (boolean)false);
        } else {
            ApiContext context = ApiContext.create();
            context.setAppNum(((AuthResult)apiAuthResult.getData()).getThirdAppNumber());
            context.setAppId(((AuthResult)apiAuthResult.getData()).getThirdId());
            ApiContext.set((ApiContext)context);
            SessionInfo si = new SessionInfo();
            if (currentCenter != null) {
                si.setTenantId(currentCenter.getTenantId());
            }
            si.setOrgId(userInfo.get("forgid"));
            si.setUserId(userInfo.get("fid"));
            si.setUserName(userInfo.get("ftruename"));
            si.setUserOpenId(userInfo.get("fopenid"));
            si.setUserType(userInfo.get("userType"));
            si.setLoginIP(NetAddressUtils.getRemoteHost((HttpServletRequest)request));
            if (result.getLanguage() != null) {
                si.setLanguage(result.getLanguage().toString());
            }
            si.setUid(userInfo.get("fuid"));
            si.setClient(LoginClientEnum.API.getDesc());
            si.setAccountId(currentCenter.getAccountId());
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            si.setLoginTime(df.format(new Date()));
            si.setAuthType(result.getAuthType());
            if (kd.bos.login.utils.StringUtils.isNotBlank(((AuthResult)apiAuthResult.getData()).getAuthType())) {
                si.setAuthType(((AuthResult)apiAuthResult.getData()).getAuthType());
            }
            si.setApi3rdAppId(((AuthResult)apiAuthResult.getData()).getThirdId() + "");
            si.setApi3rdAppNum(((AuthResult)apiAuthResult.getData()).getThirdAppNumber());
            RequestContextCreator.create((HttpServletRequest)request, (String)"-1", (SessionInfo)si, (boolean)false);
        }
    }

    private boolean hideTicket(HttpServletRequest request, HttpServletResponse response, String accountId) {
        boolean isHideTicket = false;
        String ticket = request.getParameter(HCODE_TICKET);
        if (kd.bos.login.utils.StringUtils.isNotEmpty(ticket)) {
            try {
                String queryS = request.getQueryString();
                String path = request.getRequestURI();
                String ticketCache = CacheLoginData.getAttribute((String)accountId, (String)ticket);
                if (kd.bos.login.utils.StringUtils.isNotEmpty(ticketCache)) {
                    isHideTicket = true;
                    queryS = queryS.replace("ticket=", "").replace(ticket, "");
                    StringBuilder builder = new StringBuilder(RevProxyUtil.getURLContextPath((HttpServletRequest)request));
                    if (path.contains("/mobile.html")) {
                        builder.append("mobile.html");
                    } else if (path.contains("/index.html")) {
                        builder.append("index.html");
                    } else if (path.contains("/integration/yzjShareOpen.do")) {
                        builder.append("integration/yzjShareOpen.do");
                    } else {
                        isHideTicket = false;
                    }
                    if (isHideTicket) {
                        builder.append("?").append(queryS);
                        response.sendRedirect(builder.toString());
                    }
                }
            }
            catch (Exception e) {
                logger.info(e.getMessage());
            }
        }
        return isHideTicket;
    }

    private boolean isNeedWsdl(String path, HttpServletRequest request) {
        String queryS = request.getQueryString();
        if (kd.bos.login.utils.StringUtils.isNotEmpty(queryS) && (queryS.equals("wsdl") || queryS.contains("wsdl="))) {
            String wsdlWitheListStr = kd.bos.session.SystemPropertyUtils.getProptyByTenant((String)WSDL_WHITE_LIST, (String)RevProxyUtil.getTenantId((HttpServletRequest)request));
            String wsdlWhitePattern = kd.bos.session.SystemPropertyUtils.getProptyByTenant((String)WSDL_WHITE_PATTERN, (String)RevProxyUtil.getTenantId((HttpServletRequest)request));
            if ("get".equalsIgnoreCase(request.getMethod()) && (path.contains("/kws/") || path.contains("/kapi/v2/")) && queryS.startsWith("wsdl")) {
                return true;
            }
            if (kd.bos.login.utils.StringUtils.isNotEmpty(wsdlWitheListStr)) {
                List<String> wsdlWitheList = SerializationUtils.fromJsonStringToList(wsdlWitheListStr, String.class);
                for (String wsdlWitheName : wsdlWitheList) {
                    if (!path.contains(wsdlWitheName)) continue;
                    return true;
                }
                return path.equals(wsdlWitheListStr);
            }
            if (kd.bos.login.utils.StringUtils.isNotEmpty(wsdlWhitePattern)) {
                return Pattern.matches(wsdlWhitePattern, path);
            }
        }
        return path.endsWith("/kws/");
    }

    private boolean judgeGuestFormPermission(HttpServletRequest request, HttpServletResponse response, boolean isGuestUser, SessionDAO sessionDAO, String globalSessionId) throws IOException {
        boolean isHandle = false;
        String form = request.getParameter("form");
        if (kd.bos.login.utils.StringUtils.isEmpty(form)) {
            form = request.getParameter("formId");
        }
        String billFormId = request.getParameter("billFormId");
        if (kd.bos.login.utils.StringUtils.isEmpty(form) && LoginUtils.isRootPage(request) && !LoginUtils.isIincludePageId(request)) {
            form = "pc_main_console";
        }
        if (kd.bos.login.utils.StringUtils.isNotEmpty(form) && isGuestUser) {
            boolean hasRight = false;
            try {
                SessionInfo si = LoginUtils.getSessionInfoBySessionId(request, globalSessionId);
                if (si != null) {
                    RequestContextCreator.create((HttpServletRequest)request, (String)globalSessionId, (SessionInfo)si);
                    Object formObject = DispatchServiceHelper.invokeBOSService("FormService", "checkGuestAccess", form);
                    if (formObject instanceof Boolean) {
                        hasRight = (Boolean)formObject;
                    }
                    if (kd.bos.login.utils.StringUtils.isNotEmpty(billFormId) && (formObject = DispatchServiceHelper.invokeBOSService("FormService", "checkGuestAccess", billFormId)) instanceof Boolean) {
                        hasRight = (Boolean)formObject;
                    }
                }
            }
            catch (Exception e) {
                logger.error("\u8c03\u7528FormService\u3002checkGuestAccess \u5931\u8d25 ", (Throwable)e);
                hasRight = false;
            }
            if (!hasRight) {
                String url = "";
                url = this.isMobile(request) ? "mobile.html" : "index.html";
                url = RevProxyUtil.getURLContextPath((HttpServletRequest)request) + url;
                String params = request.getQueryString();
                if (kd.bos.login.utils.StringUtils.isNotEmpty(params)) {
                    url = url + "?" + params;
                }
                String tenantId = RevProxyUtil.getTenantId((HttpServletRequest)request);
                Account currentCenter = LoginAccountFactory.createInstanceBySession(globalSessionId, Optional.of(tenantId)).getAccount();
                String plugin = currentCenter.getSsoPlugin();
                if (LoginUtils.hasPrevilige(AccountType.ThridParty.toString(), currentCenter.getAllSourceTypes()) && kd.bos.login.utils.StringUtils.isNotEmpty(plugin)) {
                    this.loginManage.showLoginPage(request, response, url);
                } else {
                    this.loginManage.redirectToYZJLogin(request, response, url);
                }
                isHandle = true;
            }
        }
        return isHandle;
    }

    private SessionInfo getGuestSessionData(HttpServletRequest request, String sandboxId) {
        SessionInfo si = new SessionInfo();
        String tenantId = RevProxyUtil.getTenantCode((HttpServletRequest)request);
        si.setTenantId(tenantId);
        si.setSandboxId(sandboxId);
        si.setUserId("-1");
        si.setUserName("Guest");
        si.setUserOpenId("");
        si.setUserType("1");
        si.setYzjAppId("");
        si.setYzjAppTicket("");
        si.setLanguage(LoginLangUtils.getLoginLanguage(request).toString());
        si.setUid("-1");
        Account currentCenter = LoginAccountFactory.createInstanceByHttpRequest(request, Optional.empty()).getAccount();
        si.setAccountId(currentCenter.getAccountId());
        String loginType = request.getParameter("logintype");
        String lType = LoginClientEnum.WEB.getDesc();
        if ("mobile".equalsIgnoreCase(loginType)) {
            lType = LoginClientEnum.MOBILE.getDesc();
        }
        si.setClient(lType);
        si.setLoginOrg("0");
        return si;
    }

    public String getAPPId(HttpServletRequest request) {
        String appId = request.getParameter("client_id");
        if (kd.bos.login.utils.StringUtils.isEmpty(appId) && kd.bos.login.utils.StringUtils.isEmpty(appId = request.getParameter("appid"))) {
            appId = request.getParameter("appId");
        }
        return appId;
    }

    public String getHeaderAccessToken(HttpServletRequest request) {
        String sHeaderAccess_Token = request.getHeader("accessToken");
        if (kd.bos.login.utils.StringUtils.isEmpty(sHeaderAccess_Token)) {
            sHeaderAccess_Token = request.getHeader(GLOBAL_COOKIE_ACCESS_TOKEN_KEY);
        }
        return sHeaderAccess_Token;
    }

    private void outputAPISessionErroror(ServletResponse servletResponse) throws IOException {
        HashMap<String, Object> mpErr = new HashMap<String, Object>();
        mpErr.put(SUCCESS, false);
        mpErr.put(ERROR_CODE, 1);
        mpErr.put(ERROR_DESC, ResManager.loadKDString((String)"session\u6570\u636e\u4e0d\u6b63\u786e\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002 ", (String)"LoginFilter_5", (String)BOS_LOGIN, (Object[])new Object[0]));
        String sLoginJson = JSONUtils.toString(mpErr);
        ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)sLoginJson);
    }

    private void outputAjaxSessionError(ServletResponse servletResponse) throws IOException {
        HashMap<String, Object> mpErr = new HashMap<String, Object>();
        mpErr.put(SUCCESS, false);
        mpErr.put(ERROR_CODE, 100);
        mpErr.put(ERROR_DESC, ResManager.loadKDString((String)"Ajax session\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002 ", (String)"LoginFilter_14", (String)BOS_LOGIN, (Object[])new Object[0]));
        String sLoginJson = JSONUtils.toString(mpErr);
        ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)sLoginJson);
    }

    private boolean isAjax(HttpServletRequest request) {
        boolean returnAjax = false;
        String requestType = request.getHeader("x-requested-with");
        String isAjax = request.getHeader(AJAX_HEADER);
        if (XML_HTTP_REQUEST.equalsIgnoreCase(requestType) || "true".equalsIgnoreCase(isAjax)) {
            returnAjax = true;
        }
        return returnAjax;
    }

    private String tryCreateSessionForSSO(HttpServletRequest request, HttpServletResponse response, String globalSessionId) {
        SSOAuthResult ssoAuthResult = this.loginSSOInterceptor(request, response, globalSessionId);
        if (ssoAuthResult.getType() == SSOAuthResult.SSOSessionType.DONOTHING) {
            return globalSessionId;
        }
        if (ssoAuthResult.getType() == SSOAuthResult.SSOSessionType.SET) {
            return ssoAuthResult.getSessionId();
        }
        if (ssoAuthResult.getType() == SSOAuthResult.SSOSessionType.RESET) {
            this.loginoutForSession(request, response);
            return null;
        }
        throw new KDException(LoginErrorCode.systemError, new Object[0]);
    }

    private SSOAuthResult loginSSOInterceptor(HttpServletRequest request, HttpServletResponse response, String globalSessionId) {
        try {
            SSOAuth ssoAuth = new SSOAuth(request, response);
            if (globalSessionId != null) {
                return ssoAuth.retryAuth(globalSessionId);
            }
            return ssoAuth.auth();
        }
        catch (KDException e) {
            if (SSOErrorCode.match(e.getErrorCode())) {
                return SSOAuthResult.donothing();
            }
            throw e;
        }
    }

    private void doLogout(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.loginoutForSession(request, response)) {
            return;
        }
        String mainWebSite = RevProxyUtil.getURLContextPath((HttpServletRequest)request);
        String redirectPage = request.getParameter("redirect");
        redirectPage = URLUtils.checkRedirectUrl(request, redirectPage);
        if (this.isStandLone()) {
            response.sendRedirect(String.format("%s", mainWebSite));
        } else if (AgentUtil.isMobile(request)) {
            String redirect = request.getParameter("redirect");
            redirect = URLUtils.checkRedirectUrl(request, redirect);
            String url = String.format("%slogin-mobile.html", mainWebSite);
            if (kd.bos.login.utils.StringUtils.isNotEmpty(redirect)) {
                url = url + "?redirect=" + redirect;
            }
            response.sendRedirect(url);
        } else if (LoginUtils.isMCSystem()) {
            if (kd.bos.util.StringUtils.isEmpty((String)redirectPage)) {
                response.sendRedirect(String.format("%slogin-mc.html", mainWebSite));
            } else {
                response.sendRedirect(String.format("%s%s", mainWebSite, redirectPage));
            }
        } else if (kd.bos.util.StringUtils.isEmpty((String)redirectPage)) {
            response.sendRedirect(String.format("%slogin.html", mainWebSite));
        } else {
            response.sendRedirect(String.format("%s%s", mainWebSite, redirectPage));
        }
    }

    private boolean loginoutForSession(HttpServletRequest request, HttpServletResponse response) {
        String globalSessionId = LoginUtils.getKDCookieValue(request);
        SessionDAO sessionDAO = SessionDAOFactory.getSessionDAO((String)globalSessionId);
        Map attributes = sessionDAO.getAttributesAsMap(new String[]{"apptype", "client"});
        attributes.put("sessionId", globalSessionId);
        String accountId = "";
        String tenantId = RevProxyUtil.getTenantCode((HttpServletRequest)request);
        accountId = new LoginManage().removeSessionId(request, response, globalSessionId, accountId, tenantId);
        this.onlineUserLogout(attributes);
        Account currentCenter = LoginAccountFactory.createInstanceByCustom(accountId, request).getAccount();
        String plugin = currentCenter.getSsoPlugin();
        if (LoginUtils.hasPrevilige(AccountType.ThridParty.toString(), currentCenter.getAllSourceTypes()) && kd.bos.login.utils.StringUtils.isNotEmpty(plugin)) {
            String cacheValue;
            boolean needExe = true;
            if (LoginUtils.isSupportLoginUnderSSO(currentCenter) && kd.bos.login.utils.StringUtils.isNotEmpty(cacheValue = CacheLoginData.getAttribute((String)"", (String)LoginUtils.getSSOSupportCachkey(globalSessionId, currentCenter.getAccountId())))) {
                needExe = false;
            }
            if (needExe) {
                ThirdSSOAuthHandler sso = (ThirdSSOAuthHandler)BeanUtils.getBean(plugin);
                String site = sso.getERPCallback(request, tenantId, currentCenter.getAccountId());
                sso.callTrdSSOLogin(request, response, site);
                return true;
            }
        }
        return false;
    }

    private void onlineUserLogout(Map<String, String> attributes) {
        try {
            OnlineUserUtil.logout(attributes);
        }
        catch (Exception e) {
            logger.error("onlineUser===>" + e.getMessage());
        }
    }

    private boolean isStandLone() {
        return LoginType.STANDALONE == this.initloginType;
    }

    public void destroy() {
    }

    private boolean isMobile(HttpServletRequest request) {
        boolean isMobile;
        String path = request.getRequestURI();
        boolean bl = isMobile = path.contains("/integration/yzjShareOpen.do") && "mob".equals(request.getParameter("device")) || path.contains(QING_LAPP_ENTRANCE_DO);
        if (Pattern.matches(".*/mobile.html.*", request.getServletPath().toLowerCase(Locale.ENGLISH))) {
            isMobile = true;
        }
        return isMobile;
    }

    private String getUnauthorizedData(HttpServletRequest request) throws IOException {
        HashMap<String, Object> mpErr = new HashMap<String, Object>(8);
        mpErr.put("errorCode", "401");
        mpErr.put("status", false);
        mpErr.put("message", ResManager.loadKDString((String)"\u672a\u7ecf\u6388\u6743\u7684\u8bbf\u95ee\u3002 ", (String)"LoginFilter_2", (String)BOS_LOGIN, (Object[])new Object[0]));
        mpErr.put(SUCCESS, false);
        mpErr.put(ERROR_CODE, 1);
        mpErr.put(ERROR_DESC, ResManager.loadKDString((String)"\u672a\u7ecf\u6388\u6743\u7684\u8bbf\u95ee\u3002 ", (String)"LoginFilter_2", (String)BOS_LOGIN, (Object[])new Object[0]));
        return JSONUtils.toString(mpErr);
    }

    private boolean isNeedCheck(boolean isWebService, boolean bAPI, boolean needGuest, String userId) {
        return !"-1".equals(userId) && !bAPI && !isWebService && !needGuest;
    }

    private boolean checkNoCodeShare(HttpServletRequest request) {
        String noCodeShareId = request.getHeader("noCodeShareId");
        if (kd.bos.login.utils.StringUtils.isEmpty(noCodeShareId)) {
            noCodeShareId = request.getParameter("noCodeShareId");
        }
        return kd.bos.login.utils.StringUtils.isEmpty(noCodeShareId);
    }

    private boolean isAllowAccess(Map<String, String> sessionInfo, String path, HttpServletRequest request) {
        try {
            String allowAccessData = DefaultParameterService.getDefaultValueByKey("bos_svc_allow_token_access");
            String allowAccess = kd.bos.session.SystemPropertyUtils.getProptyByTenant((String)"bos_svc_allow_token_access", (String)RevProxyUtil.getTenantCode((HttpServletRequest)request));
            if ((kd.bos.login.utils.StringUtils.isEmpty(allowAccess) || "true".equals(allowAccess)) && (kd.bos.login.utils.StringUtils.isEmpty(allowAccessData) || "true".equals(allowAccessData))) {
                return true;
            }
            if (sessionInfo == null || sessionInfo.size() <= 0) {
                return true;
            }
            String client = sessionInfo.get("client");
            if (!"webservice".equals(client) && !"api".equals(client)) {
                return true;
            }
            if (path.endsWith("/kws/")) {
                return true;
            }
            if (!(path.endsWith("/") || path.endsWith("/index.html") || path.endsWith("/mobile.html") || path.endsWith("/form/batchInvokeAction.do") || path.endsWith("/form/getConfig.do"))) {
                return true;
            }
            String api3rdAppId = sessionInfo.get("api3rdAppId");
            String accountId = "";
            if (sessionInfo.get(ACCOUNT_ID) != null) {
                accountId = sessionInfo.get(ACCOUNT_ID);
            }
            if (kd.bos.login.utils.StringUtils.isNotEmpty(api3rdAppId)) {
                return AppsService.checkUserPermByAppId(AccountUtils.getCorrectAccount((String)accountId, (String)RevProxyUtil.getTenantCode((HttpServletRequest)request)), Long.parseLong(api3rdAppId), sessionInfo.get("userId"));
            }
        }
        catch (Exception e) {
            logger.info("LoginFilter#isAllowAccess", (Object)e);
        }
        return true;
    }

    private String getSessionIdFromCode(HttpServletRequest request, HttpServletResponse response) {
        String sessionId = null;
        try {
            String code = request.getParameter(KD_AUTH_CODE);
            if (kd.bos.login.utils.StringUtils.isEmpty(code)) {
                return null;
            }
            sessionId = this.getOldGuestSession(code, request);
            if (kd.bos.login.utils.StringUtils.isNotBlank(sessionId)) {
                return sessionId;
            }
            return this.getGuestSession(code, request);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return sessionId;
        }
    }

    private String getOldGuestSession(String code, HttpServletRequest request) {
        String value = CacheLoginData.getAttribute((String)KD_AUTH_CODE, (String)code);
        if (kd.bos.login.utils.StringUtils.isEmpty(value)) {
            return null;
        }
        String[] values = value.split(",");
        if (values.length < 3) {
            return null;
        }
        String paramName = values[0];
        String paramValue = values[1];
        String times = values[2];
        if (kd.bos.login.utils.StringUtils.isEmpty(paramValue) || !paramValue.equals(request.getParameter(paramName))) {
            return null;
        }
        Integer allowUseTimes = Integer.parseInt(times) - 1;
        if (allowUseTimes <= 0) {
            CacheLoginData.remove((String)KD_AUTH_CODE, (String)code);
        } else {
            CacheLoginData.setAttribute((String)KD_AUTH_CODE, (String)code, (String)(paramName + "," + paramValue + "," + allowUseTimes), (int)120);
        }
        String guestSessionId = "";
        RequestContext context = RequestContext.get();
        if (context != null && !kd.bos.util.StringUtils.isEmpty((String)context.getAccountId())) {
            String accountId = context.getAccountId();
            guestSessionId = CacheLoginData.getAttribute((String)"kdedcbagetGuestSessionId", (String)accountId);
            if (kd.bos.util.StringUtils.isEmpty((String)guestSessionId)) {
                guestSessionId = GuestUtiils.getGuestUserSessionId();
                CacheLoginData.setAttribute((String)"kdedcbagetGuestSessionId", (String)accountId, (String)guestSessionId, (int)600);
            }
        } else {
            guestSessionId = GuestUtiils.getGuestUserSessionId();
        }
        return guestSessionId;
    }

    private String getGuestSession(String code, HttpServletRequest request) throws UnsupportedEncodingException {
        Map map = CacheLoginData.getAttributes((String)KD_AUTH_CODE_MAP, (String)code);
        if (MapUtils.isEmpty((Map)map)) {
            return null;
        }
        String paramName = (String)map.get("paramName");
        String paramValue = (String)map.get("paramValue");
        String times = (String)map.get("allowUseTimes");
        String requestParamValue = request.getParameter(paramName);
        if (kd.bos.login.utils.StringUtils.isEmpty(paramValue) || !paramValue.equals(requestParamValue) && !URLDecoder.decode(paramValue, "UTF-8").equals(requestParamValue)) {
            return null;
        }
        Integer allowUseTimes = Integer.parseInt(times) - 1;
        if (allowUseTimes <= 0) {
            CacheLoginData.remove((String)KD_AUTH_CODE_MAP, (String)code);
        } else {
            long temp;
            int expireTime = 120;
            String expireTimeStamp = (String)map.get("expireTimeStamp");
            if (kd.bos.login.utils.StringUtils.isNotBlank(expireTimeStamp) && (temp = Long.parseLong(expireTimeStamp) - System.currentTimeMillis()) > 1000L) {
                expireTime = (int)temp / 1000;
            }
            map.put("allowUseTimes", allowUseTimes + "");
            if (expireTime > 0) {
                CacheLoginData.setAttributes((String)KD_AUTH_CODE_MAP, (String)code, (Map)map, (int)expireTime);
            }
        }
        String guestSessionId = "";
        RequestContext context = RequestContext.get();
        if (context != null && !kd.bos.util.StringUtils.isEmpty((String)context.getAccountId())) {
            String accountId = context.getAccountId();
            guestSessionId = CacheLoginData.getAttribute((String)"kdedcbagetGuestSessionId", (String)accountId);
            if (kd.bos.util.StringUtils.isEmpty((String)guestSessionId)) {
                guestSessionId = GuestUtiils.getGuestUserSessionId();
                CacheLoginData.setAttribute((String)"kdedcbagetGuestSessionId", (String)accountId, (String)guestSessionId, (int)600);
            }
        } else {
            guestSessionId = GuestUtiils.getGuestUserSessionId();
        }
        return guestSessionId;
    }
}

