/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.filter;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.actiondispatcher.ActionUtil;
import kd.bos.context.RequestContextCreator;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.mc.tenant.AccountType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.framework.lifecycle.services.sessionmanager.SessionManagerListener;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.CacheLoginData;
import kd.bos.login.LoginClientEnum;
import kd.bos.login.handler.LoginHandlerContext;
import kd.bos.login.handler.LoginHandlerResult;
import kd.bos.login.lang.LoginLangUtils;
import kd.bos.login.service.apps.ThirdAppsService;
import kd.bos.login.service.apps.impl.ThirdAppsServiceImpl;
import kd.bos.login.service.session.dto.SessionParams;
import kd.bos.login.service.session.impl.SessionServiceImpl;
import kd.bos.login.sso.SSOAuth;
import kd.bos.login.sso.SSOErrorCode;
import kd.bos.login.user.LoginUserService;
import kd.bos.login.util.cache.CacheLoginUtils;
import kd.bos.login.utils.AgentUtil;
import kd.bos.login.utils.HttpUtils;
import kd.bos.login.utils.LoginUtils;
import kd.bos.login.utils.SecurityUtils;
import kd.bos.login.utils.SessionUtils;
import kd.bos.login.utils.URLUtils;
import kd.bos.login.utils.account.LoginAccount;
import kd.bos.login.utils.account.LoginAccountFactory;
import kd.bos.login.utils.log.LoginLogUtils;
import kd.bos.login.yunzhijia.LightAppLogin;
import kd.bos.login.yunzhijia.lightapp.impl.YunzhijiaLightAppLoginImpl;
import kd.bos.login.yzjprivate.lightapp.impl.YzjpcdLightAppLoginImpl;
import kd.bos.session.SessionDAO;
import kd.bos.session.SessionDAOFactory;
import kd.bos.session.SessionInfo;
import kd.bos.session.SessionManager;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.util.JSONUtils;
import kd.bos.util.NetAddressUtils;
import kd.bos.util.RevProxyUtil;
import org.apache.commons.lang3.StringUtils;

public class LoginManage {
    private static Log logger = LogFactory.getLog(LoginManage.class);
    private final ThirdAppsService thirdAppsService = new ThirdAppsServiceImpl();

    public void redirectToStandaloneLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String redirectMe = null;
        String requestType = request.getHeader("x-requested-with");
        String isAjax = request.getHeader("ajax");
        redirectMe = "XMLHttpRequest".equals(requestType) || "true".equals(isAjax) ? "/ierp/index.html" : URLUtils.buildRedirectUrl((ServletRequest)request);
        String encodedUrl = response.encodeRedirectURL(response.encodeRedirectURL(redirectMe));
        String contextPath = request.getContextPath();
        String redirectTo = contextPath + "/auth/login.do?redirect=" + encodedUrl;
        HttpUtils.sendRedirect(request, response, redirectTo);
    }

    public static boolean enableYzjApps(String tenantId) {
        String enableYzjApps = SystemPropertyUtils.getProptyByTenant((String)"enable_yzj_apps", (String)tenantId);
        return "true".equals(enableYzjApps);
    }

    public void loginByLightAppId(HttpServletRequest request, HttpServletResponse response, String appId, String ticket) {
        LoginAccount loginAccount = LoginAccountFactory.createInstanceByHttpRequest(request, Optional.empty());
        Account currentCenter = loginAccount.getAccount();
        LightAppLogin login = LoginUtils.hasPrevilige(AccountType.YzjPrivateCloud.toString(), currentCenter.getAllSourceTypes()) ? new YzjpcdLightAppLoginImpl() : new YunzhijiaLightAppLoginImpl();
        login.lightAppLogin(request, response, loginAccount.getTenantId(), appId, ticket);
    }

    public void outputAjaxTimeoutError(ServletResponse servletResponse) throws IOException {
        HashMap<String, Object> mpErr = new HashMap<String, Object>();
        mpErr.put("success", false);
        mpErr.put("error_code", 100);
        mpErr.put("error_desc", ResManager.loadKDString((String)"\u4f1a\u8bdd\u7f13\u5b58\u4e22\u5931\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55\u3002", (String)"LoginFilter_13", (String)"bos-login", (Object[])new Object[0]));
        String sLoginJson = JSONUtils.toString(mpErr);
        ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)sLoginJson);
    }

    public void outputAPITimeoutErroror(ServletResponse servletResponse) throws IOException {
        HashMap<String, Object> mpErr = new HashMap<String, Object>();
        mpErr.put("success", false);
        mpErr.put("error_code", 1);
        mpErr.put("error_desc", ResManager.loadKDString((String)"\u4f1a\u8bdd\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55\u3002", (String)"LoginFilter_4", (String)"bos-login", (Object[])new Object[0]));
        String sLoginJson = JSONUtils.toString(mpErr);
        ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)sLoginJson);
    }

    public void outputWebServiceSessionErroror(ServletResponse servletResponse) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\">");
        sb.append("    <soap:Body>");
        sb.append("        <soap:Fault>");
        sb.append("            <faultcode>soap:Server</faultcode>");
        sb.append("            <faultstring>%s</faultstring>");
        sb.append("        </soap:Fault>");
        sb.append("    </soap:Body>");
        sb.append("</soap:Envelope>");
        ActionUtil.writeResponseXml((ServletResponse)servletResponse, (CharSequence)String.format(sb.toString(), ResManager.loadKDString((String)"webService\u6ca1\u6709\u8bbf\u95ee\u6743\u9650\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55\u3002", (String)"LoginFilter_20", (String)"bos-login", (Object[])new Object[0])));
    }

    public void doYunzhijiaPubacc(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            Lang lang = LoginLangUtils.getLoginLanguage(request);
            String requestBody = LoginUtils.getRequestBody(request);
            if ((requestBody == null || requestBody.isEmpty()) && ((requestBody = request.getParameter("redirectParamsAtBody")) == null || requestBody.isEmpty())) {
                String errorMsg = ResManager.loadKDString((String)"\u53c2\u6570\u5f02\u5e38\uff0crequestBody\u4e3anull.requestBody\u5fc5\u987b\u662fjson\u5b57\u7b26\u4e32", (String)"LoginFilter_15", (String)"bos-login", (Object[])new Object[0]);
                logger.debug(errorMsg);
                HashMap<String, Object> errorResult = new HashMap<String, Object>();
                errorResult.put("msg", errorMsg);
                errorResult.put("success", false);
                this.writeJsonResponse(response, JSONUtils.toString(errorResult));
                return;
            }
            Map bodyMap = (Map)JSONUtils.cast((String)requestBody, HashMap.class);
            if (bodyMap == null || bodyMap.isEmpty()) {
                throw new RuntimeException(ResManager.loadKDString((String)"\u4e91\u4e4b\u5bb6\u516c\u5171\u53f7json\u89e3\u6790\u5f02\u5e38\u3002", (String)"LoginFilter_16", (String)"bos-login", (Object[])new Object[0]));
            }
            Object eidValue = bodyMap.get("Eid");
            Object userNameValue = bodyMap.get("FromUserName");
            if (eidValue == null || userNameValue == null) {
                String errorMsg = ResManager.loadKDString((String)"\u8bf7\u767b\u5f55\u3002", (String)"LoginFilter_17", (String)"bos-login", (Object[])new Object[0]);
                logger.info("AI robot\u8fd8\u6ca1\u767b\u5f55");
                HashMap<String, Object> errorResult = new HashMap<String, Object>();
                errorResult.put("msg", errorMsg);
                errorResult.put("toLogin", true);
                errorResult.put("success", false);
                this.writeJsonResponse(response, JSONUtils.toString(errorResult));
                return;
            }
            String eid = eidValue.toString();
            String userOpenID = bodyMap.get("FromUserName").toString();
            Account currentCenter = LoginAccountFactory.createInstanceByEid(eid).getAccount();
            if (currentCenter != null) {
                Map<String, String> mpUser = LoginUserService.getErpUserInfo(currentCenter, userOpenID, lang.name());
                if ("1".equalsIgnoreCase(mpUser.get("success"))) {
                    LoginClientEnum loginClientType = AgentUtil.getLoginClientEnumType(request);
                    SessionUtils.createNewSession(request, response, currentCenter, lang, NetAddressUtils.getRemoteHost((HttpServletRequest)request), mpUser, loginClientType);
                    try {
                        String redirectMe = URLUtils.buildRedirectUrl((ServletRequest)request);
                        if (!redirectMe.contains("?")) {
                            redirectMe = redirectMe + "?";
                        }
                        String encodedUrl = response.encodeRedirectURL(response.encodeRedirectURL(redirectMe)) + "&redirectParamsAtBody=" + URLEncoder.encode(requestBody, "utf-8");
                        response.sendRedirect(encodedUrl);
                    }
                    catch (IOException e) {
                        logger.debug("\u516c\u5171\u53f7\u4e0a\u4e0b\u6587\u751f\u6210\u5931\u8d25\u3002");
                    }
                } else {
                    String sMsg = ResManager.loadKDString((String)"\u8d26\u53f7\u672a\u540c\u6b65\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u8d26\u53f7\u540c\u6b65\u3002", (String)"LoginFilter_18", (String)"bos-login", (Object[])new Object[0]);
                    HttpUtils.webAlert(response, sMsg);
                    logger.info("\u516c\u5171\u53f7\u4e0a\u4e0b\u6587\u751f\u6210\u6210\u529f\uff0c\u4f46\u662f\u7528\u6237\u6ca1\u6709\u88ab\u540c\u6b65\u3002");
                }
            }
        }
        catch (KDException ex) {
            ErrorCode code = ex.getErrorCode();
            String resp = LoginUtils.getLoginResponse(String.valueOf(code.getCode()), ex.getMessage());
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)resp);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            String resp = LoginUtils.getLoginResponse("1", ResManager.loadKDString((String)"\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002%s", (String)"LoginFilter_19", (String)"bos-login", (Object[])new Object[]{e.getMessage()}));
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)resp);
        }
    }

    private void writeJsonResponse(HttpServletResponse response, String jsonString) throws IOException {
        if (response != null) {
            response.setContentType("application/json;charset=UTF-8");
            PrintWriter pw = response.getWriter();
            if (pw != null) {
                pw.write(jsonString);
                pw.flush();
            }
        }
    }

    public void showLoginPage(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.showLoginPage(request, response, "");
    }

    public void showThirdAppLoginPage(HttpServletRequest request, HttpServletResponse response, String redirectUrl) throws IOException {
        if (LoginManage.redirectForSso(request, response, "")) {
            return;
        }
        response.sendRedirect(redirectUrl);
    }

    public void showLoginPage(HttpServletRequest request, HttpServletResponse response, String redirectUrl) throws IOException {
        if (LoginManage.redirectForSso(request, response, redirectUrl)) {
            return;
        }
        this.redirectToStandardLogin(request, response);
    }

    private static boolean redirectForSso(HttpServletRequest request, HttpServletResponse response, String redirectUrl) {
        try {
            SSOAuth ssoIntel = new SSOAuth(request, response);
            ssoIntel.callSSOLogin(redirectUrl);
            return true;
        }
        catch (KDException e) {
            if (!SSOErrorCode.match(e.getErrorCode())) {
                throw e;
            }
            return false;
        }
    }

    public void redirectToStandardLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String reRedirectUrl = this.getRedirectUrl(request);
        this.redirectToYZJLogin(request, response, reRedirectUrl);
    }

    private String getRedirectUrl(HttpServletRequest request) {
        String returnValue = "";
        if (request != null) {
            String olUrl = request.getRequestURI();
            if (StringUtils.isNotBlank((CharSequence)request.getQueryString()) && !SecurityUtils.checkXss(request.getQueryString())) {
                olUrl = olUrl + "?" + request.getQueryString();
            }
            String newUrl = olUrl.replace(request.getContextPath() + "/", "");
            returnValue = RevProxyUtil.getURLContextPath((HttpServletRequest)request) + newUrl;
        }
        return returnValue;
    }

    public void redirectToYZJLogin(HttpServletRequest request, HttpServletResponse response, String reRedirectUrl) throws IOException {
        boolean isMobile;
        String mainWebSite = RevProxyUtil.getURLContextPath((HttpServletRequest)request);
        String path = request.getRequestURI();
        boolean bl = isMobile = path.contains("/integration/yzjShareOpen.do") && "mob".equals(request.getParameter("device")) || path.contains("/qing/lappEntrance.do");
        if (Pattern.matches(".*/mobile.html.*", request.getServletPath().toLowerCase(Locale.ENGLISH)) || isMobile) {
            String redirectUrl = String.format("%slogin-mobile.html?redirect=%s", mainWebSite, URLEncoder.encode(reRedirectUrl));
            response.sendRedirect(redirectUrl);
        } else {
            String redirectUrl = "index.html";
            String newUrl = URLEncoder.encode(reRedirectUrl);
            String loginType = request.getParameter("aiLoginType");
            if ("face".equalsIgnoreCase(loginType)) {
                redirectUrl = String.format("%slogin-face.html?redirect=%s", mainWebSite, newUrl);
            } else if ("voice".equalsIgnoreCase(loginType)) {
                redirectUrl = String.format("%slogin-voice.html?redirect=%s", mainWebSite, newUrl);
            } else if ("account".equalsIgnoreCase(loginType)) {
                redirectUrl = String.format("%slogin-account.html?redirect=%s", mainWebSite, newUrl);
            } else {
                redirectUrl = String.format("%slogin.html?redirect=%s", mainWebSite, newUrl);
                if (LoginUtils.isMCSystem()) {
                    redirectUrl = String.format("%slogin-mc.html?redirect=%s", mainWebSite, newUrl);
                }
            }
            response.sendRedirect(redirectUrl);
        }
    }

    public String removeSessionId(HttpServletRequest request, HttpServletResponse response, String globalSessionId, String accountId, String tenantId) {
        try {
            if (StringUtils.isNotBlank((CharSequence)globalSessionId)) {
                SessionInfo si = LoginUtils.getSessinInfoBySessionId(globalSessionId);
                if (StringUtils.isNotEmpty((CharSequence)si.getLanguage())) {
                    LoginLangUtils.setLang(LoginLangUtils.getLang(si.getLanguage()));
                }
                LoginClientEnum client = LoginClientEnum.getLoginClientByValue(si.getClient());
                LoginManage.removeCacheValue(globalSessionId);
                if (si != null) {
                    accountId = si.getAccountId();
                    Account currentCenter = LoginAccountFactory.createInstanceByCustom(accountId, tenantId).getAccount();
                    SessionDAO sessionDAO = SessionDAOFactory.getSessionDAO((String)globalSessionId);
                    String apptype = sessionDAO.getAttribute("apptype");
                    SessionParams params = new SessionParams();
                    params.setAppType(apptype);
                    params.setClientEnum(client);
                    params.setIP(si.getLoginIP());
                    LoginLogUtils.addLog(currentCenter, LoginLogUtils.initLoginLogInfo(si, params, "logout"));
                    RequestContextCreator.createForOnlySesssion((String)globalSessionId, (SessionInfo)si, null);
                    SessionManagerListener.destory((String)globalSessionId);
                    this.smsCacheRemove(currentCenter, si, request);
                }
                SessionManager.removeSession((HttpServletRequest)request, (HttpServletResponse)response, (String)globalSessionId);
                this.removeSessionKey(si.getUserId(), si.getTenantId(), si.getAccountId(), globalSessionId);
            } else {
                SessionManager.copySession((HttpServletRequest)request, (HttpServletResponse)response, (String)"");
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return accountId;
    }

    private static void removeCacheValue(String globalSessionId) {
        CacheLoginData.remove((String)"user_id", (String)globalSessionId);
    }

    private void smsCacheRemove(Account currentCenter, SessionInfo si, HttpServletRequest request) {
        try {
            Map<String, String> info = LoginUserService.getErpUserInfoByUserId(currentCenter, si.getUserId(), LoginLangUtils.getLoginLanguage(request).name());
            String limitKey = currentCenter.getAccountId() + info.get("fphone") + "limit";
            CacheLoginData.remove((String)"smsLogin", (String)limitKey);
            CacheLoginData.remove((String)"smsLogin", (String)(currentCenter.getAccountId() + info.get("fphone")));
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    private void removeSessionKey(String userId, String tenantId, String accountId, String sessionId) {
        try {
            String cacheKey = SessionServiceImpl.getCacheKeyByClient(userId, tenantId, accountId);
            String[] list = CacheLoginUtils.getList((String)cacheKey);
            for (int i = 0; i < list.length; ++i) {
                String userInfo = list[i];
                Map cast = (Map)JSONUtils.cast((String)userInfo, Map.class);
                String s = (String)cast.get("sessionId");
                if (!sessionId.equals(s)) continue;
                CacheLoginUtils.removeListObject((String)cacheKey, (int)i);
                break;
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    public void authFailProcess(HttpServletRequest request, HttpServletResponse response, LoginHandlerContext context, LoginHandlerResult handlerResult) throws IOException, ServletException {
        String token = request.getParameter("token");
        if (this.yzjScanFail(request, context, token)) {
            return;
        }
        if (context.isAjax()) {
            this.outputAjaxTimeoutError((ServletResponse)response);
            return;
        }
        if (context.isAPI()) {
            this.outputAPITimeoutErroror((ServletResponse)response);
            return;
        }
        if (context.isWebService()) {
            this.outputWebServiceSessionErroror((ServletResponse)response);
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)context.getAppId()) && StringUtils.isNotBlank((CharSequence)context.getCloudTicket()) && !LoginManage.enableYzjApps(context.getTenantId())) {
            this.loginByLightAppId(request, response, context.getAppId(), context.getCloudTicket());
            return;
        }
        if (Pattern.matches(".*/login.*.html", context.getRequestURI().toLowerCase(Locale.ENGLISH))) {
            context.doFilter();
        } else if (context.getRequestURI().contains("yzjChatCallbackAction.do")) {
            context.doFilter();
        } else if ("thirdApp".equals(handlerResult.getRedirectParams())) {
            this.thirdAppsService.toSendLogin(request, response);
        } else {
            this.showLoginPage(request, response);
        }
    }

    @Deprecated
    private boolean yzjScanFail(HttpServletRequest request, LoginHandlerContext context, String token) {
        if (StringUtils.isNotBlank((CharSequence)token) && StringUtils.isNotBlank((CharSequence)context.getCloudTicket())) {
            HashMap<String, String> mpQR = new HashMap<String, String>();
            mpQR.put("ticket", context.getCloudTicket());
            mpQR.put("URL", String.format("%sindex.html", RevProxyUtil.getURLContextPath((HttpServletRequest)request)));
            String cacheType = CacheLoginData.getType4YzjQR((String)token);
            CacheLoginData.setAttributes((String)cacheType, mpQR);
            return true;
        }
        return false;
    }
}

