/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.filter.impl;

import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dc.api.model.Account;
import kd.bos.exception.KDException;
import kd.bos.exception.LoginErrorCode;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.LoginClientEnum;
import kd.bos.login.api.APILoginError;
import kd.bos.login.filter.HandleFilter;
import kd.bos.login.filter.HandleResult;
import kd.bos.login.lang.LoginLangUtils;
import kd.bos.login.spi.OpenApiServiceManager;
import kd.bos.login.thirdauth.UserProperType;
import kd.bos.login.utils.APIUtils;
import kd.bos.login.utils.LoginUtils;
import kd.bos.login.utils.ThirdAPIAPPUtils;
import kd.bos.login.utils.account.LoginAccountFactory;
import kd.bos.service.authorize.model.AuthInfo;
import kd.bos.service.authorize.model.AuthResult;
import kd.bos.service.authorize.model.AuthTypeEnum;
import kd.bos.service.authorize.model.SignInfo;
import kd.bos.session.SessionInfo;
import kd.bos.util.ExceptionUtils;

public class APIHandlerFilter
implements HandleFilter {
    private static final String BOS_LOGIN = "bos-login";
    private static final String API_HANDLER_FILTER_0 = "APIHandlerFilter_0";
    private static final String HCODE_USERTYPE = "usertype";
    private static final String COSMIC_LOCAL_APPLIST = "cosmic_local_applist";
    @Deprecated
    public static final String SIGNATURE_NAME = "signature";
    private static final Log logger = LogFactory.getLog(APIHandlerFilter.class);

    @Override
    public HandleResult doFilter(HttpServletRequest request, HttpServletResponse response, String glableSessoionId) throws IOException, ServletException {
        HandleResult result;
        block28: {
            result = new HandleResult();
            String authType = LoginUtils.getParamerter(request, "OpenApiAuth");
            if (StringUtils.isNotEmpty((CharSequence)authType)) {
                return result;
            }
            String path = request.getRequestURI();
            boolean bAPI = Boolean.parseBoolean(request.getHeader("api")) || path.contains("/api/") || path.contains("/kapi");
            try {
                String appId = request.getHeader("appId");
                String signature = request.getHeader(SIGNATURE_NAME);
                String getSigature = request.getParameter(SIGNATURE_NAME);
                String datetimeString = request.getHeader("timestamp");
                String signatureNonce = request.getHeader("signatureNonce");
                boolean isNeedHande = false;
                boolean isPass = false;
                String userType = "Mobile";
                String user = "";
                Lang lang = Lang.defaultLang();
                Account currentCenter = null;
                if (bAPI && "POST".equalsIgnoreCase(request.getMethod()) && kd.bos.login.utils.StringUtils.isNotEmpty(signature) && kd.bos.login.utils.StringUtils.isNotEmpty(appId)) {
                    isNeedHande = true;
                    if (kd.bos.login.utils.StringUtils.isEmpty(appId)) {
                        throw new KDException(APILoginError.API_REQUEST_INVALID_PARAMETERS, new Object[]{ResManager.loadKDString((String)"\u7b2c\u4e09\u65b9\u5e94\u7528ID\u9519\u8bef\uff0c\u6216\u5e94\u7528\u5bc6\u94a5\u672a\u914d\u7f6e\u3002", (String)"APIHandlerFilter_6", (String)BOS_LOGIN, (Object[])new Object[0])});
                    }
                    if ("application/json".equalsIgnoreCase(request.getContentType()) && kd.bos.login.utils.StringUtils.isNotEmpty(appId)) {
                        user = request.getHeader("user");
                        String userTypePost = request.getHeader(HCODE_USERTYPE);
                        if (kd.bos.login.utils.StringUtils.isNotEmpty(userTypePost)) {
                            userType = userTypePost;
                        }
                        lang = LoginLangUtils.getLang(APIUtils.getParameter4Post(request, response, "language"));
                        currentCenter = LoginAccountFactory.createInstanceByHttpRequest(request, Optional.empty()).getAccount();
                        if (currentCenter == null) {
                            throw new KDException(APILoginError.API_REQUEST_INVALID_PARAMETERS, new Object[]{ResManager.loadKDString((String)"\u83b7\u53d6\u6570\u636e\u4e2d\u5fc3\u9519\u8bef\u3002", (String)"ThirdAPIAPPUtils_3", (String)BOS_LOGIN, (Object[])new Object[0])});
                        }
                        ThirdAPIAPPUtils.checkDateTimeAndSigature(datetimeString, signatureNonce, currentCenter.getTenantId(), currentCenter.getAccountId());
                        String body = LoginUtils.getRequestBody(request);
                        AuthResult authResult = this.checkAuthBySign(appId, datetimeString, currentCenter.getAccountId(), currentCenter.getTenantId(), signatureNonce, body, signature, user, userType, lang.toString());
                        isPass = authResult.isStatus();
                        if (!isPass) {
                            if ("invalidAppId".equalsIgnoreCase(authResult.getMessage())) {
                                throw new KDException(APILoginError.API_REQUEST_INVALID_PARAMETERS, new Object[]{ResManager.loadKDString((String)"\u7b2c\u4e09\u65b9\u5e94\u7528ID\u9519\u8bef\uff0c\u6216\u5e94\u7528\u5bc6\u94a5\u672a\u914d\u7f6e\u3002", (String)"APIHandlerFilter_6", (String)BOS_LOGIN, (Object[])new Object[0])});
                            }
                            throw new KDException(APILoginError.API_REQUEST_INVALID_PARAMETERS, new Object[]{ResManager.loadKDString((String)"\u8ba4\u8bc1\u4e0d\u901a\u8fc7\uff0c\u8ba4\u8bc1\u4fe1\u606f\u6709\u8bef\u3002", (String)API_HANDLER_FILTER_0, (String)BOS_LOGIN, (Object[])new Object[0])});
                        }
                        ThirdAPIAPPUtils.createApiContext(appId, currentCenter);
                    }
                } else if (bAPI && "GET".equalsIgnoreCase(request.getMethod()) && kd.bos.login.utils.StringUtils.isNotEmpty(getSigature) && kd.bos.login.utils.StringUtils.isNotEmpty(request.getParameter("appId"))) {
                    isNeedHande = true;
                    appId = request.getParameter("appId");
                    if (kd.bos.login.utils.StringUtils.isEmpty(appId)) {
                        throw new KDException(APILoginError.API_REQUEST_INVALID_PARAMETERS, new Object[]{ResManager.loadKDString((String)"\u7b2c\u4e09\u65b9\u5e94\u7528ID\u9519\u8bef\uff0c\u6216\u5e94\u7528\u5bc6\u94a5\u672a\u914d\u7f6e\u3002", (String)"APIHandlerFilter_6", (String)BOS_LOGIN, (Object[])new Object[0])});
                    }
                    datetimeString = request.getParameter("timestamp");
                    signatureNonce = request.getParameter("signatureNonce");
                    currentCenter = LoginAccountFactory.createInstanceByHttpRequest(request, Optional.empty()).getAccount();
                    if (currentCenter == null) {
                        throw new KDException(APILoginError.API_REQUEST_INVALID_PARAMETERS, new Object[]{ResManager.loadKDString((String)"\u83b7\u53d6\u6570\u636e\u4e2d\u5fc3\u9519\u8bef\u3002", (String)"ThirdAPIAPPUtils_3", (String)BOS_LOGIN, (Object[])new Object[0])});
                    }
                    ThirdAPIAPPUtils.checkDateTimeAndSigature(datetimeString, signatureNonce, currentCenter.getTenantId(), currentCenter.getAccountId());
                    String parameters = request.getParameter("parameters");
                    user = request.getParameter("user");
                    lang = LoginLangUtils.getLoginLanguage(request);
                    if (kd.bos.login.utils.StringUtils.isNotEmpty(request.getParameter(HCODE_USERTYPE))) {
                        userType = request.getParameter(HCODE_USERTYPE);
                    }
                    if (kd.bos.login.utils.StringUtils.isNotEmpty(parameters)) {
                        String[] parameterArray = parameters.split(",");
                        StringBuilder sb = new StringBuilder();
                        for (int i = 0; i < parameterArray.length; ++i) {
                            String value = kd.bos.login.utils.StringUtils.getStringValue(request.getParameter(parameterArray[i]));
                            if (i == 0) {
                                sb.append(parameterArray[i]).append("=").append(value);
                                continue;
                            }
                            sb.append("&").append(parameterArray[i]).append("=").append(value);
                        }
                        AuthResult authResult = this.checkAuthBySign(appId, datetimeString, currentCenter.getAccountId(), currentCenter.getTenantId(), signatureNonce, sb.toString(), getSigature, user, userType, lang.toString());
                        isPass = authResult.isStatus();
                        if (!isPass) {
                            if ("invalidAppId".equalsIgnoreCase(authResult.getMessage())) {
                                throw new KDException(APILoginError.API_REQUEST_INVALID_PARAMETERS, new Object[]{ResManager.loadKDString((String)"\u7b2c\u4e09\u65b9\u5e94\u7528ID\u9519\u8bef\uff0c\u6216\u5e94\u7528\u5bc6\u94a5\u672a\u914d\u7f6e\u3002", (String)"APIHandlerFilter_6", (String)BOS_LOGIN, (Object[])new Object[0])});
                            }
                            throw new KDException(APILoginError.API_REQUEST_INVALID_PARAMETERS, new Object[]{ResManager.loadKDString((String)"\u8ba4\u8bc1\u4e0d\u901a\u8fc7\uff0c\u8ba4\u8bc1\u4fe1\u606f\u6709\u8bef\u3002", (String)API_HANDLER_FILTER_0, (String)BOS_LOGIN, (Object[])new Object[0])});
                        }
                    } else {
                        throw new KDException(APILoginError.API_REQUEST_INVALID_PARAMETERS, new Object[]{ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff1a\u7f3a\u5c11parameters\u53c2\u6570\u3002", (String)"APIHandlerFilter_5", (String)BOS_LOGIN, (Object[])new Object[0])});
                    }
                    ThirdAPIAPPUtils.createApiContext(appId, currentCenter);
                }
                if (!isNeedHande) break block28;
                result.setHandled(true);
                if (isPass) {
                    SessionInfo si;
                    Map<String, String> userInfo = null;
                    logger.info(String.format("sessionid=%s", glableSessoionId));
                    if (kd.bos.login.utils.StringUtils.isNotEmpty(glableSessoionId) && kd.bos.login.utils.StringUtils.isEmpty(user) && (si = LoginUtils.getSessinInfoBySessionId(glableSessoionId)) != null) {
                        result.setUser(si.getUserId());
                        result.setUserType(UserProperType.UserId);
                    }
                    if (kd.bos.login.utils.StringUtils.isEmpty(result.getUser())) {
                        if (kd.bos.login.utils.StringUtils.isEmpty(user)) {
                            throw new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u60a8\u7684\u8d26\u53f7\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"LoginFilter_10", (String)BOS_LOGIN, (Object[])new Object[0])});
                        }
                        UserProperType aType = UserProperType.getUserProperTypeByString(userType);
                        if (aType == null) {
                            throw new KDException(APILoginError.API_REQUEST_INVALID_PARAMETERS, new Object[]{ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef:usertype\u53c2\u6570\u4e0d\u6b63\u786e\u3002", (String)"APIHandlerFilter_7", (String)BOS_LOGIN, (Object[])new Object[0])});
                        }
                        result.setUserType(aType);
                        result.setUser(user);
                    }
                    result.setNeedCreateContext(true);
                    if (currentCenter != null) {
                        result.setAccountId(currentCenter.getAccountId());
                    }
                    result.setLoginClient(LoginClientEnum.API);
                    result.setLanguage(lang);
                    userInfo = LoginUtils.getUserInfoByAPIUserType(currentCenter, result.getUser(), result.getUserType().name(), result.getLanguage());
                    LoginUtils.checkAPIUserInfo(userInfo);
                    result.setNeedGetUserInfo(false);
                    result.setUserInfo(userInfo);
                    result.setAuthType("2");
                    break block28;
                }
                throw new KDException(APILoginError.API_INVALID_TOKEN, new Object[]{ResManager.loadKDString((String)"\u8ba4\u8bc1\u4e0d\u901a\u8fc7\uff0c\u8ba4\u8bc1\u4fe1\u606f\u6709\u8bef\u3002", (String)API_HANDLER_FILTER_0, (String)BOS_LOGIN, (Object[])new Object[0])});
            }
            catch (KDException e) {
                logger.info(e.getMessage());
                APIUtils.outputAPIErrorMessage(response, e.getErrorCode().getCode(), e.getMessage());
            }
            catch (Exception ex) {
                logger.error((Throwable)ex);
                APIUtils.outputAPIErrorMessage(response, "8", String.format(ResManager.loadKDString((String)"\u672a\u77e5\u9519\u8bef\uff1a%s\u3002", (String)"LoginAPI_3", (String)BOS_LOGIN, (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)ex)));
            }
        }
        return result;
    }

    private AuthResult checkAuthBySign(String appId, String datetimeString, String accountIdParameter, String tenantId, String signatureNonce, String requestParams, String signature, String user, String userType, String language) {
        SignInfo signInfo = SignInfo.of((String)appId, (String)accountIdParameter, (String)tenantId);
        signInfo.setDateTime(datetimeString);
        signInfo.setContent(requestParams);
        signInfo.setSignatureNonce(signatureNonce);
        signInfo.setSignature(signature);
        signInfo.setAuthType(AuthTypeEnum.AUTH_DIGEST.getId());
        AuthInfo authInfo = new AuthInfo();
        authInfo.setSignInfo(signInfo);
        authInfo.setUser(user);
        authInfo.setUserType(userType);
        authInfo.setLanguage(language);
        authInfo.setAuthType(signInfo.getAuthType());
        AuthResult result = OpenApiServiceManager.getApiAuthService().auth(authInfo);
        return result;
    }
}

