/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.filter.impl;

import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dc.api.model.Account;
import kd.bos.exception.KDException;
import kd.bos.exception.LoginErrorCode;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.LoginClientEnum;
import kd.bos.login.filter.HandleFilter;
import kd.bos.login.filter.HandleResult;
import kd.bos.login.lang.LoginLangUtils;
import kd.bos.login.spi.OpenApiServiceManager;
import kd.bos.login.utils.APIUtils;
import kd.bos.login.utils.LoginUtils;
import kd.bos.login.utils.StringUtils;
import kd.bos.login.utils.ThirdAPIAPPUtils;
import kd.bos.login.utils.account.LoginAccountFactory;
import kd.bos.service.authorize.model.AuthInfo;
import kd.bos.service.authorize.model.AuthResult;
import kd.bos.service.authorize.model.JwtInfo;
import kd.bos.util.ExceptionUtils;

public class JWTFilter
implements HandleFilter {
    private static final Log logger = LogFactory.getLog(JWTFilter.class);

    @Override
    public HandleResult doFilter(HttpServletRequest request, HttpServletResponse response, String glableSessoionId) throws IOException, ServletException {
        HandleResult result = new HandleResult();
        String authType = LoginUtils.getParamerter(request, "OpenApiAuth");
        if (StringUtils.isNotEmpty(authType)) {
            return result;
        }
        String path = request.getRequestURI();
        boolean bAPI = Boolean.parseBoolean(request.getHeader("api")) || path.contains("/api/") || path.contains("/kapi");
        try {
            String appId = request.getHeader("appId");
            boolean isNeedHande = false;
            Lang lang = LoginLangUtils.getLoginLanguage(request);
            Account currentCenter = null;
            Map<String, String> cUserInfo = null;
            if (bAPI && "POST".equalsIgnoreCase(request.getMethod())) {
                String jwtString = request.getHeader("jwt");
                if (StringUtils.isNotEmpty(jwtString)) {
                    currentCenter = LoginAccountFactory.createInstanceByHttpRequest(request, Optional.empty()).getAccount();
                    ThirdAPIAPPUtils.createApiContext(appId, currentCenter);
                    isNeedHande = true;
                    cUserInfo = this.versifyJWTToken(appId, currentCenter.getAccountId(), jwtString);
                    result.setAccountId(currentCenter.getAccountId());
                }
            } else if (bAPI && "GET".equalsIgnoreCase(request.getMethod())) {
                appId = request.getParameter("appId");
                String jwtString = request.getParameter("jwt");
                if (StringUtils.isNotEmpty(jwtString)) {
                    isNeedHande = true;
                    currentCenter = LoginAccountFactory.createInstanceByHttpRequest(request, Optional.empty()).getAccount();
                    cUserInfo = this.versifyJWTToken(appId, currentCenter.getAccountId(), jwtString);
                    result.setAccountId(currentCenter.getAccountId());
                }
                ThirdAPIAPPUtils.createApiContext(appId, currentCenter);
            }
            if (isNeedHande) {
                result.setHandled(true);
                if (cUserInfo == null || cUserInfo.size() < 1) {
                    throw new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u8ba4\u8bc1\u4e0d\u901a\u8fc7\uff0c\u8ba4\u8bc1\u4fe1\u606f\u6709\u8bef\u3002", (String)"APIHandlerFilter_0", (String)"bos-login", (Object[])new Object[0])});
                }
                result.setUserInfo(cUserInfo);
                result.setNeedGetUserInfo(false);
                result.setLanguage(lang);
                result.setNeedCreateContext(true);
                result.setLoginClient(LoginClientEnum.API);
                result.setAuthType("3");
            }
        }
        catch (KDException e) {
            logger.error((Throwable)e);
            APIUtils.outputErrorMessage(response, e.getErrorCode().getCode(), e.getMessage());
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
            APIUtils.outputErrorMessage(response, "8", String.format(ResManager.loadKDString((String)"\u8ba4\u8bc1\u4e0d\u901a\u8fc7\uff0c\u8ba4\u8bc1\u4fe1\u606f\u6709\u8bef\u3002", (String)"APIHandlerFilter_0", (String)"bos-login", (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)ex)));
        }
        return result;
    }

    private Map<String, String> versifyJWTToken(String appId, String accountIdParameter, String jwtString) {
        JwtInfo jwtInfo = new JwtInfo();
        jwtInfo.setThirdAppNumber(appId);
        jwtInfo.setAccountId(accountIdParameter);
        jwtInfo.setJwt(jwtString);
        AuthInfo authInfo = new AuthInfo();
        authInfo.setJwtInfo(jwtInfo);
        authInfo.setThirdAppNumber(appId);
        authInfo.setAuthType("3");
        AuthResult result = OpenApiServiceManager.getApiAuthService().auth(authInfo);
        if (!result.isStatus()) {
            throw new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u8ba4\u8bc1\u4e0d\u901a\u8fc7\uff0c\u8ba4\u8bc1\u4fe1\u606f\u6709\u8bef\u3002", (String)"APIHandlerFilter_0", (String)"bos-login", (Object[])new Object[0])});
        }
        return result.getUserInfo();
    }
}

