/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.handler;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.login.LoginType;
import kd.bos.login.handler.ILoginHandler;
import kd.bos.login.handler.LoginHandlerResult;
import kd.bos.login.handler.RequestWrapperAnalysis;
import kd.bos.login.utils.LoginUtils;
import kd.bos.login.utils.SessionUtils;
import kd.bos.login.utils.ThirdAPIAPPUtils;
import kd.bos.session.SessionDAO;
import kd.bos.session.SessionDAOFactory;
import kd.bos.session.SessionManager;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.util.RevProxyUtil;
import org.apache.commons.lang3.StringUtils;

public final class LoginHandlerContext {
    private ILoginHandler loginHandler;
    private LoginHandlerResult handlerResult;
    private FilterChain filterChain;
    private HttpServletRequest requestWrapper;
    private HttpServletResponse responseWrapper;
    private String tenantId;
    private RequestParam param;
    private String cookie;
    private boolean cookieValid;
    private String accessToken;
    private boolean accessTokenValid = true;
    private boolean guestUser;

    public void init(FilterChain filterChain, HttpServletRequest requestWrapper, HttpServletResponse responseWrapper, LoginHandlerResult handlerResult) {
        this.filterChain = filterChain;
        this.requestWrapper = requestWrapper;
        this.responseWrapper = responseWrapper;
        this.tenantId = RevProxyUtil.getTenantCode((HttpServletRequest)requestWrapper);
        this.handlerResult = handlerResult;
        this.param = new RequestParam();
        this.cookie = LoginUtils.getKDCookieValue(requestWrapper);
        if (SessionUtils.verifyCookieSession(requestWrapper, this.cookie)) {
            this.cookieValid = true;
        }
        this.analysisAccessTokenFromParam();
        this.analysisAccessTokenFromHeadKeepAlive();
        this.verifyAppTokenFromAccessToken();
        if (handlerResult.validClientSession()) {
            this.guestUser = LoginUtils.isGuestUser(null, handlerResult.getClientSession());
        }
    }

    private void analysisAccessTokenFromParam() {
        String newUserid;
        if (!LoginUtils.isAllowAcessToken(this.tenantId)) {
            return;
        }
        String accessName = SystemPropertyUtils.getProptyByTenant((String)"user_access_token_name", (String)this.tenantId);
        if (StringUtils.isBlank((CharSequence)accessName)) {
            accessName = "access_token";
        }
        String accessTokenId = this.requestWrapper.getParameter(accessName);
        String oldUserId = LoginUtils.getUserIdFromSession(this.cookie, true);
        if (StringUtils.isNotBlank((CharSequence)accessTokenId) && StringUtils.isNotBlank((CharSequence)(newUserid = LoginUtils.getUserIdFromSession(accessTokenId, true))) && !newUserid.equals(oldUserId)) {
            this.accessToken = accessTokenId;
            this.param.isAPI = true;
        }
    }

    private void analysisAccessTokenFromHeadKeepAlive() {
        if (!this.isAPI()) {
            return;
        }
        String sHeaderAccess_Token = this.requestWrapper.getHeader("accessToken");
        if (StringUtils.isBlank((CharSequence)sHeaderAccess_Token)) {
            sHeaderAccess_Token = this.requestWrapper.getHeader("access_token");
        }
        if (sHeaderAccess_Token != null) {
            this.accessToken = sHeaderAccess_Token;
        }
        if (this.requestWrapper.getParameter("redirect") != null) {
            SessionManager.copySession((HttpServletRequest)this.requestWrapper, (HttpServletResponse)this.responseWrapper, (String)this.accessToken);
        }
    }

    private void verifyAppTokenFromAccessToken() {
        if (!this.validAccessToken()) {
            return;
        }
        SessionDAO sessionDAO = SessionDAOFactory.getSessionDAO((String)this.accessToken);
        boolean isAvailable = ThirdAPIAPPUtils.touchAppToken(sessionDAO, null, this.accessToken);
        if (!isAvailable) {
            this.accessTokenValid = false;
        }
        if (this.accessTokenValid && !SessionUtils.verifyCookieSession(this.requestWrapper, this.accessToken)) {
            this.accessTokenValid = false;
        }
    }

    public boolean validCookie() {
        return StringUtils.isNotBlank((CharSequence)this.cookie) && this.cookieValid;
    }

    public boolean validAccessToken() {
        return StringUtils.isNotBlank((CharSequence)this.accessToken) && this.accessTokenValid;
    }

    public final void doFilter() throws IOException, ServletException {
        this.doFilter(null);
    }

    public final void doFilter(HttpServletRequest requestWrapper) throws IOException, ServletException {
        this.filterChain.doFilter((ServletRequest)(requestWrapper != null ? requestWrapper : this.requestWrapper), (ServletResponse)this.responseWrapper);
    }

    public final FilterChain getFilterChain() {
        return this.filterChain;
    }

    public final HttpServletRequest getRequestWrapper() {
        return this.requestWrapper;
    }

    public final HttpServletResponse getResponseWrapper() {
        return this.responseWrapper;
    }

    public final String getContextPath() {
        return this.param.contextPath;
    }

    public final String getRealUrl() {
        return this.param.realUrl;
    }

    public final String getCloudTicket() {
        return this.param.cloudTicket;
    }

    public final String getAppId() {
        return this.param.appId;
    }

    public final String getYzjSharePathKey() {
        return this.param.yzjSharePathKey;
    }

    public final String getAiLoginType() {
        return this.param.aiLoginType;
    }

    public final LoginType getLoginType() {
        return this.param.loginType;
    }

    public final String getRequestURI() {
        return this.param.requestURI;
    }

    public final boolean isNeedWsdl() {
        return this.param.isNeedWsdl;
    }

    public final boolean isWebService() {
        return this.param.isWebService;
    }

    public final boolean isAjax() {
        return this.param.isAjax;
    }

    public final boolean isAPI() {
        return this.param.isAPI;
    }

    public final boolean isDo() {
        return this.param.isDo;
    }

    public final String getTenantId() {
        return this.tenantId;
    }

    public final void changeLoginHandler(ILoginHandler loginHandler) {
        this.loginHandler = loginHandler;
    }

    public final void clearLoginHandler() {
        this.loginHandler = null;
    }

    public final boolean isGuestUser() {
        return this.guestUser;
    }

    public final boolean isDownloadPlugin() {
        return this.param.isDownloadPlugin;
    }

    public final ILoginHandler getLoginHandler() {
        return this.loginHandler;
    }

    public final String getAccessToken() {
        return this.accessToken;
    }

    public final String getCookie() {
        return this.cookie;
    }

    public LoginHandlerResult getHandlerResult() {
        return this.handlerResult;
    }

    class RequestParam {
        private RequestWrapperAnalysis analysis;
        private String contextPath;
        private String realUrl;
        private String requestURI;
        private String cloudTicket;
        private String appId;
        private String yzjSharePathKey;
        private String aiLoginType;
        private LoginType loginType;
        private boolean isNeedWsdl;
        private boolean isWebService;
        private boolean isAjax;
        private boolean isAPI;
        private boolean isDo;
        private boolean isDownloadPlugin;

        public RequestParam() {
            this.analysis = RequestWrapperAnalysis.getInstance(LoginHandlerContext.this.requestWrapper);
            this.initParam();
        }

        private void initParam() {
            this.contextPath = this.analysis.getContextPath();
            this.realUrl = this.analysis.getRealUrl();
            this.requestURI = this.analysis.getRequestURI();
            this.cloudTicket = this.analysis.getCloudTicket();
            this.appId = this.analysis.getAPPId();
            this.yzjSharePathKey = this.analysis.getYzjSharePathKey();
            this.aiLoginType = this.analysis.getAiLoginType();
            this.loginType = this.analysis.getLoginType();
            this.isNeedWsdl = this.analysis.isNeedWsdl();
            this.isWebService = this.analysis.isWebService();
            this.isAjax = this.analysis.isAjax();
            this.isAPI = LoginUtils.isAPI(LoginHandlerContext.this.requestWrapper);
            this.isDo = this.analysis.isDo();
            this.isDownloadPlugin = LoginUtils.isDownloadPlugin(LoginHandlerContext.this.requestWrapper, this.requestURI);
        }
    }
}

