/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.handler;

import java.util.LinkedList;
import java.util.List;
import kd.bos.login.emun.MultiLangEnmu;
import kd.bos.login.handler.impl.common.RequestContextHandler;

public class LoginHandlerLog {
    private String path;
    private String cookie;
    private String accessToken;
    private String lastSession;
    private String handlerName4lastSession;
    private List<HandlerStatus> handlerStatuses = new LinkedList<HandlerStatus>();

    public void setPath(String path) {
        this.path = path;
    }

    public void setCookie(String cookie) {
        this.cookie = cookie;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public void setLastSession(String lastSession) {
        this.lastSession = lastSession;
    }

    public void setHandlerName4lastSession(String handlerName4lastSession) {
        this.handlerName4lastSession = handlerName4lastSession;
    }

    public void addHandlers(HandlerStatus handlerStatus) {
        this.handlerStatuses.add(handlerStatus);
    }

    public String toString() {
        return "LoginHandlerLog{path='" + this.path + '\'' + ", handlerName4lastSession='" + this.handlerName4lastSession + '\'' + ", handlers=" + this.toHandlers() + '}';
    }

    private String toHandlers() {
        StringBuilder stringBuilder = new StringBuilder();
        for (HandlerStatus handler : this.handlerStatuses) {
            if (!handler.match || RequestContextHandler.class.getSimpleName().equals(handler.handlerName)) continue;
            stringBuilder.append(handler.toString()).append(';');
        }
        return "{" + stringBuilder.toString() + "}";
    }

    public static enum ProcessEnum {
        NONE(1, new MultiLangEnmu("\u4e0d\u5904\u7406", "ProcessEnum_0", "bos-login")),
        FORWARD(2, new MultiLangEnmu("\u8f6c\u53d1", "ProcessEnum_1", "bos-login")),
        RESPONSE(3, new MultiLangEnmu("\u54cd\u5e94", "ProcessEnum_2", "bos-login")),
        SUCCESS(4, new MultiLangEnmu("\u6210\u529f", "ProcessEnum_3", "bos-login")),
        FAIL(5, new MultiLangEnmu("\u5931\u8d25", "ProcessEnum_4", "bos-login")),
        GUEST_VISIT(6, new MultiLangEnmu("GUEST\u8bbf\u95ee", "ProcessEnum_5", "bos-login")),
        GUEST_VISIT_STANDARD_REQUESTCONTEXT(7, new MultiLangEnmu("GUEST\u8bbf\u95ee-\u6784\u5efa\u6807\u51c6\u4e0a\u4e0b\u6587", "ProcessEnum_6", "bos-login"));

        private int type;
        private MultiLangEnmu desc;

        private ProcessEnum(int type, MultiLangEnmu desc) {
            this.type = type;
            this.desc = desc;
        }

        public int getType() {
            return this.type;
        }

        public String getDesc() {
            return this.desc.loadKDString();
        }
    }

    public static class HandlerStatus {
        protected String handlerName;
        protected boolean match;
        protected ProcessEnum processType = ProcessEnum.NONE;
        protected String customLog;

        public void setHandlerName(String handlerName) {
            this.handlerName = handlerName;
        }

        public void setMatch(boolean match) {
            this.match = match;
        }

        public ProcessEnum getProcessType() {
            return this.processType;
        }

        public void setProcessType(ProcessEnum processType) {
            this.processType = processType;
        }

        public void setCustomLog(String customLog) {
            this.customLog = customLog;
        }

        public String toString() {
            return "HandlerStatus{handlerName='" + this.handlerName + '\'' + ", match=" + this.match + ", processType=" + (Object)((Object)this.processType) + ", customLog=" + this.customLog + '}';
        }
    }
}

