/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.handler;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.handler.ILoginHandler;
import kd.bos.login.handler.LoginHandlerContext;
import kd.bos.login.handler.LoginHandlerLog;
import kd.bos.login.handler.requestcontext.RequestContextManager;
import org.apache.commons.lang3.StringUtils;

public final class LoginHandlerResult {
    private static Log logger = LogFactory.getLog(LoginHandlerResult.class);
    private LoginHandlerContext context;
    private LoginHandlerLog handlerLog;
    private RequestContextManager requestContextManager;
    private String sessionId;
    private boolean interrupt;
    private boolean success;
    private Map<String, String> devCustomParams;
    @Deprecated
    private String loginUserId;
    private Map<String, String> loginUser = new HashMap<String, String>(4);
    private String redirectParams;
    private final List<ILoginHandler> clientSessionFails = new LinkedList<ILoginHandler>();

    public Map<String, String> getLoginUser() {
        return this.loginUser;
    }

    public void setLoginUser(Map<String, String> loginUser) {
        this.loginUser = loginUser;
    }

    public LoginHandlerResult(LoginHandlerContext context) {
        this.context = context;
        this.handlerLog = new LoginHandlerLog();
        this.requestContextManager = new RequestContextManager(context);
        this.devCustomParams = new HashMap<String, String>(8);
    }

    public final void addClientSessionFails() {
        this.clientSessionFails.add(this.context.getLoginHandler());
    }

    public final boolean validClientSession() {
        if (StringUtils.isNotBlank((CharSequence)this.context.getAccessToken())) {
            return this.context.validAccessToken() && this.clientSessionFails.isEmpty();
        }
        return this.context.validCookie() && this.clientSessionFails.isEmpty();
    }

    public final String getClientSession() {
        if (!this.validClientSession()) {
            return "";
        }
        if (this.context.validAccessToken()) {
            return this.context.getAccessToken();
        }
        return this.context.getCookie();
    }

    public void createRequestContext(boolean isGuest) throws Exception {
        this.requestContextManager.createRequestContext(this.sessionId, isGuest);
    }

    public void createGuestRequestContext() throws Exception {
        this.requestContextManager.createGuestRequestContext(this.sessionId);
    }

    public LoginHandlerLog getHandlerLog() {
        return this.handlerLog;
    }

    public void toLog() {
        this.handlerLog.setAccessToken(this.context.getAccessToken());
        this.handlerLog.setCookie(this.context.getCookie());
        this.handlerLog.setPath(this.context.getRequestURI());
        logger.info("NewLoginFilter-Message: " + this.handlerLog.toString());
    }

    public void setInterrupt(boolean interrupt) {
        this.interrupt = interrupt;
    }

    public boolean isInterrupt() {
        return this.interrupt;
    }

    public void changeSessionId(String sessionId) {
        if (StringUtils.isNotBlank((CharSequence)sessionId)) {
            this.handlerLog.setLastSession(sessionId);
            this.handlerLog.setHandlerName4lastSession(this.context.getLoginHandler().getClass().getSimpleName());
            this.sessionId = sessionId;
        }
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    @Deprecated
    public String getLoginUserId() {
        return this.loginUserId;
    }

    @Deprecated
    public void setLoginUserId(String loginUserId) {
        this.loginUserId = loginUserId;
    }

    public String getRedirectParams() {
        return this.redirectParams;
    }

    public void setRedirectParams(String redirectParams) {
        this.redirectParams = redirectParams;
    }
}

